/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ase.sdcadmin.util;

import com.sybase.ase.sdcadmin.config.ClusterConfigException;
import com.sybase.ase.sdcadmin.config.ClusterConfigFactory;
import com.sybase.ase.sdcadmin.config.ICluster;
import com.sybase.ase.sdcadmin.config.IServer;
import com.sybase.ase.sdcadmin.config.impl.EntryBase;
import com.sybase.ase.sdcadmin.util.FileUtil;
import com.sybase.ua.util.jdom.JDomUtil;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;

public class XMLCluster {
    private static Log log = LogFactory.getLog(XMLCluster.class);
    private static final int CURRENT_VERSION = 6;
    private static final String XML_VERSION = "version";
    private static final String XML_TYPE = "type";
    private static final String XML_VALUE = "value";
    private static final String XML_ID = "id";
    private static final String XML_NAME = "name";
    private static final String XML_SIZE = "size";
    private static final String XML_UNITS = "units";
    private static final String XML_STATUS = "status";
    private static final String XML_UID = "uid";
    private static final String XML_MODE = "mode";
    private static final String XML_BOOTUID = "bootUid";
    private static final String XML_CONFIGUID = "configurationid";
    private static final String XML_ROOT = "sybase";
    private static final String XML_ASE_SDC = "ase_sdc";
    private static final String XML_NODES = "nodes";
    private static final String XML_PUBLIC_ADDRESS = "public_address";
    private static final String XML_NODE = "node";
    private static final String XML_PRIMARY_PROTOCOL = "primary_protocol";
    private static final String XML_PRIMARY_ADDRESS = "primary_address";
    private static final String XML_PRIMARY_SPEC = "primary_spec";
    private static final String XML_UAF_PORT = "uaf_port";
    private static final String XML_BACKUPSERVER = "backupserver";
    private static final String XML_XPSERVER = "xpserver";
    private static final String XML_MONITORSERVER = "monitorserver";
    private static final String XML_LDAP = "usesLDAP";
    private static final String XML_SECONDARY_PROTOCOL = "secondary_protocol";
    private static final String XML_SECONDARY_ADDRESS = "secondary_address";
    private static final String XML_SECONDARY_SPEC = "secondary_spec";
    private static final String XML_FIRST_PORT = "first_port";
    private static final String XML_PROTOCOL_SPEC = "protocol_spec";
    private static final String XML_PORT_START = "port_start";
    private static final String XML_SYBASE_HOME = "sybase_home";
    private static final String XML_ASE_HOME = "ase_home";
    private static final String XML_OLD_SYBASE_HOME = "old_sybase_home";
    private static final String XML_OLD_ASE_HOME = "old_ase_home";
    private static final String XML_OLD_OCS_HOME = "old_ocs_home";
    private static final String XML_CONFIG_PATH = "config_path";
    private static final String XML_INTERFACES_PATH = "interfaces_path";
    private static final String XML_ENV_SHELL_PATH = "env_shell_path";
    private static final String XML_PORT = "port";
    private static final String XML_TRANSPORT = "transport";
    private static final String XML_DEVICE = "device";
    private static final String XML_INSTANCE = "instance";
    private static final String XML_INTERFACE = "interface";
    private static final String XML_DATABASE = "database";
    private static final String XML_LOGFILE = "logfile";
    private static final String XML_PATH = "path";
    private static final String XML_ADDL_RUN_PARAMS = "addl_run_params";
    private static final String XML_INSTALLATION = "installation";
    private static final String XML_POLICY = "policy";
    private static final String XML_MULTIPLE = "multiple";
    private static final String DEFAULT_SHELL = "sh";
    private static final String SYSTEM_TEMPORARY_DATABASE = "stdb";
    private static final String UNITS_MEGABYTES = "m";
    private static final String UNITS_KILOBYTES = "k";
    private static final String UNITS_GIGABYTES = "g";
    private static final String UNITS_TERABYTES = "t";
    private static final String XML_CLUSTER = "cluster";
    private static final String XML_SERVER = "server";
    private static final String XML_MAX_INSTANCES = "max_instances";
    private static final String XML_TRACEFLAGS = "traceflags";
    private static final String XML_TRACEFLAG = "traceflag";
    private static final String XML_DEVICES = "devices";
    private static final String XML_PAGE_SIZE = "page_size";
    private static final String XML_CHECK_ONLY = "check_only";
    private static final String DEVICE_TYPE_QUORUM = "quorum";
    private static final String DEVICE_TYPE_MASTER = "master";
    private static final String DEVICE_TYPE_SYBSYSTEMPROCS = "sybsystemprocs";
    private static final String DEVICE_TYPE_SYSTEM = "system";
    private static final String DEVICE_TYPE_PCI = "pci";
    public static final String DEVICE_NAME_QUORUM = "quorum";
    public static final String DEVICE_NAME_MASTER = "master";
    public static final String DEVICE_NAME_SYBSYSTEMPROCS = "sysprocsdev";
    public static final String DEVICE_NAME_SYSTEM = "systemdbdev";
    public static final String DEVICE_NAME_PCI = "pci";
    public static final String DATABASE_NAME_MASTER = "master";
    public static final String DATABASE_NAME_SYBSYSTEMPROCS = "sybsystemprocs";
    public static final String DATABASE_NAME_SYSTEM = "sybsystemdb";
    public static final String DATABASE_NAME_PCI = "pcidb";

    public static Element getElement(ICluster iCluster) throws ClusterConfigException {
        Element element;
        String string;
        String string2;
        Object object;
        if (iCluster == null) {
            log.error((Object)"XMLCluster - getElement() - was passed a cluster who's value is null.");
            throw new ClusterConfigException("sdcadmin.cluster.value.missing.error", "cluster object");
        }
        String string3 = iCluster.getName();
        if (string3 == null || string3.equals("")) {
            log.error((Object)"XMLCluster - getElement() - was not provided a named cluster.");
            throw new ClusterConfigException("sdcadmin.cluster.value.missing.error", "cluster name");
        }
        Integer n = iCluster.getMaxInstances();
        if (n == null) {
            log.error((Object)"XMLCluster - getElement() - maxInstances was null.");
            throw new ClusterConfigException("sdcadmin.cluster.value.missing.error", "maximum instances");
        }
        IServer[] iServerArray = iCluster.getServersArray();
        Element element2 = new Element(XML_CLUSTER).setAttribute(XML_NAME, string3).setAttribute(XML_MAX_INSTANCES, n.toString()).setAttribute(XML_VERSION, String.valueOf(6));
        element2.addContent((Content)XMLCluster.getElementTraceflags((EntryBase)((Object)iCluster)));
        if (iCluster.getStatus() != -1) {
            element2.setAttribute(XML_STATUS, String.valueOf(iCluster.getStatus()));
        }
        if (iCluster.getUid() != null) {
            element2.setAttribute(XML_UID, iCluster.getUid());
        }
        if (iCluster.getBootUid() != null) {
            element2.setAttribute(XML_BOOTUID, iCluster.getBootUid());
        }
        if (iCluster.getConfigUid() != null) {
            element2.setAttribute(XML_CONFIGUID, iCluster.getConfigUid());
        }
        if (iCluster.getBackupServerName() != null) {
            object = new Element(XML_BACKUPSERVER);
            object.setAttribute(XML_NAME, iCluster.getBackupServerName());
            if (iCluster.getBackupServerLogFile() != null) {
                object.setAttribute(XML_LOGFILE, iCluster.getBackupServerLogFile());
            }
            element2.addContent((Content)object);
        }
        if (iCluster.areMultipleBackupServersPresent()) {
            object = new Element(XML_BACKUPSERVER);
            object.setAttribute(XML_MULTIPLE, String.valueOf(iCluster.areMultipleBackupServersPresent()));
            if (iCluster.getBackupServersPolicy() != null) {
                object.setAttribute(XML_POLICY, iCluster.getBackupServersPolicy());
            }
            element2.addContent((Content)object);
        }
        element2.addContent((Content)XMLCluster.getElementDevices(iCluster, iServerArray));
        if (iCluster.getInstallationMode() != null) {
            object = new Element(XML_INSTALLATION);
            object.setAttribute(XML_MODE, iCluster.getInstallationMode());
            if (iCluster.isLDAPconfigured()) {
                object.setAttribute(XML_LDAP, String.valueOf(iCluster.isLDAPconfigured()));
            }
            element2.addContent((Content)object);
        }
        if ((object = iCluster.getPrimaryInterconnect()) == null) {
            log.error((Object)"XMLCluster - getElement() - cluster did not define a primary interconnect.");
            throw new ClusterConfigException("sdcadmin.cluster.value.missing.error", "primary interconnect");
        }
        String string4 = iCluster.getSecondaryInterconnect();
        if (string4 == null || string4.equals("")) {
            log.debug((Object)"XMLCluster - getElement() - cluster did not define a secondary interconnect.");
        }
        Element element3 = new Element(XML_NODES).setAttribute(XML_PRIMARY_PROTOCOL, (String)object);
        if (string4 != null) {
            element3.setAttribute(XML_SECONDARY_PROTOCOL, string4);
        }
        int n2 = XMLCluster.getFirstPort(iServerArray);
        element3.setAttribute(XML_FIRST_PORT, String.valueOf(n2));
        iCluster = XMLCluster.setClusterCommon(iCluster, iServerArray);
        element3 = XMLCluster.getElementBase(element3, (EntryBase)((Object)iCluster), null);
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        for (int i = 0; i < iServerArray.length; ++i) {
            string2 = iServerArray[i].getNode();
            if (string2 != null) {
                if (treeMap.containsKey(string2)) continue;
                treeMap.put(string2, string2);
                continue;
            }
            log.error((Object)("The instance " + iServerArray[i].getName() + " did not have a node/host name.  This will cause an incomplete XML representation. "));
        }
        Iterator iterator = treeMap.keySet().iterator();
        while (iterator.hasNext()) {
            string2 = null;
            string = (String)iterator.next();
            for (int i = 0; i < iServerArray.length; ++i) {
                Element element4;
                if (!iServerArray[i].getNode().equalsIgnoreCase(string)) continue;
                if (string2 == null) {
                    string2 = new Element(XML_NODE).setAttribute(XML_NAME, string).setAttribute(XML_PUBLIC_ADDRESS, iServerArray[i].getPublicAddress() == null ? string : iServerArray[i].getPublicAddress()).setAttribute(XML_PRIMARY_ADDRESS, iServerArray[i].getPrimaryAddress());
                    if (iServerArray[i].getSecondaryAddress() != null) {
                        string2.setAttribute(XML_SECONDARY_ADDRESS, iServerArray[i].getSecondaryAddress());
                    }
                    if (iServerArray[i].getAgentPort() != null) {
                        string2.setAttribute(XML_UAF_PORT, iServerArray[i].getAgentPort());
                    }
                }
                element = new Element(XML_INSTANCE).setAttribute(XML_ID, iServerArray[i].getId().toString()).setAttribute(XML_NAME, iServerArray[i].getName());
                element.addContent((Content)new Element(XML_INTERFACE).setAttribute(XML_PORT, iServerArray[i].getQueryPort()).setAttribute(XML_TRANSPORT, iServerArray[i].getQueryTransport()));
                Element element5 = new Element(XML_PROTOCOL_SPEC);
                element5.addContent((Content)new Element(XML_PRIMARY_SPEC).setAttribute(XML_PORT_START, iServerArray[i].getPrimaryPortStart()));
                if (iServerArray[i].getSecondaryPortStart() != null) {
                    element5.addContent((Content)new Element(XML_SECONDARY_SPEC).setAttribute(XML_PORT_START, iServerArray[i].getSecondaryPortStart()));
                }
                element.addContent((Content)element5);
                if (iServerArray[i].getBackupServerPort() != null && iServerArray[i].getQueryTransport() != null) {
                    element4 = new Element(XML_BACKUPSERVER);
                    if ((iCluster.areMultipleBackupServersPresent() || iCluster.getBackupServersPolicy() != null) && iServerArray[i].getBackupServerName() != null) {
                        element4.setAttribute(XML_NAME, iServerArray[i].getBackupServerName());
                        if (iServerArray[i].getBackupServerLogFile() != null) {
                            element4.setAttribute(XML_LOGFILE, iServerArray[i].getBackupServerLogFile());
                        }
                    }
                    element4.setAttribute(XML_PORT, iServerArray[i].getBackupServerPort());
                    element4.setAttribute(XML_TRANSPORT, iServerArray[i].getQueryTransport());
                    element.addContent((Content)element4);
                }
                if (iServerArray[i].getTempdbDeviceName() != null) {
                    element.addContent((Content)new Element(XML_DATABASE).setAttribute(XML_DEVICE, iServerArray[i].getTempdbDeviceName()).setAttribute(XML_TYPE, SYSTEM_TEMPORARY_DATABASE).setAttribute(XML_NAME, iServerArray[i].getTempdbDbName()).setAttribute(XML_SIZE, iServerArray[i].getTempdbDbSize()).setAttribute(XML_UNITS, UNITS_MEGABYTES));
                }
                if (iServerArray[i].getLogFile() != null) {
                    element.addContent((Content)new Element(XML_LOGFILE).setAttribute(XML_PATH, iServerArray[i].getLogFile()));
                }
                if (iServerArray[i].getXpServerPort() != null) {
                    element.addContent((Content)new Element(XML_XPSERVER).setAttribute(XML_PORT, iServerArray[i].getXpServerPort()).setAttribute(XML_TRANSPORT, iServerArray[i].getQueryTransport()));
                }
                if (iServerArray[i].getMonitorServerPort() != null) {
                    element4 = new Element(XML_MONITORSERVER);
                    element4.setAttribute(XML_PORT, iServerArray[i].getMonitorServerPort());
                    element4.setAttribute(XML_TRANSPORT, iServerArray[i].getQueryTransport());
                    if (iServerArray[i].getMonitorServerLogFile() != null) {
                        element4.setAttribute(XML_PATH, iServerArray[i].getMonitorServerLogFile());
                    }
                    element.addContent((Content)element4);
                }
                element = XMLCluster.getElementBase(element, (EntryBase)((Object)iServerArray[i]), (EntryBase)((Object)iCluster));
                string2.addContent((Content)element);
            }
            element3.addContent((Content)string2);
        }
        element2.addContent((Content)element3);
        string2 = null;
        if (iCluster.getOldServerName() != null) {
            string2 = new Element(XML_SERVER).setAttribute(XML_NAME, iCluster.getOldServerName()).setAttribute(XML_CHECK_ONLY, iCluster.isUpgradeCheck() ? "y" : "n");
            string = new Element(XML_OLD_SYBASE_HOME).setAttribute(XML_VALUE, iCluster.getOldSybaseHome());
            Element element6 = new Element(XML_OLD_ASE_HOME).setAttribute(XML_VALUE, iCluster.getOldASEHome());
            element = new Element(XML_OLD_OCS_HOME).setAttribute(XML_VALUE, iCluster.getOldOCSHome());
            string2.addContent((Content)string);
            string2.addContent((Content)element6);
            string2.addContent((Content)element);
        }
        string = new Element(XML_ASE_SDC);
        string.addContent((Content)element2);
        if (string2 != null) {
            string.addContent((Content)string2);
        }
        Element element7 = new Element(XML_ROOT);
        element7.addContent((Content)string);
        return element7;
    }

    private static ICluster setClusterCommon(ICluster iCluster, IServer[] iServerArray) {
        String string = iServerArray[0].getConfigFile();
        boolean bl = true;
        String string2 = iServerArray[0].getInterfacesPath();
        boolean bl2 = true;
        String string3 = iServerArray[0].getAddlRunParameters();
        boolean bl3 = true;
        String string4 = iServerArray[0].getSybaseHome();
        boolean bl4 = true;
        String string5 = iServerArray[0].getAseHome();
        boolean bl5 = true;
        String string6 = iServerArray[0].getEnvShellPath();
        boolean bl6 = true;
        for (int i = 0; i < iServerArray.length; ++i) {
            if (bl && !XMLCluster.isSame(string, iServerArray[i].getConfigFile())) {
                bl = false;
            }
            if (bl2 && !XMLCluster.isSame(string2, iServerArray[i].getInterfacesPath())) {
                bl2 = false;
            }
            if (bl3 && !XMLCluster.isSame(string3, iServerArray[i].getAddlRunParameters())) {
                bl3 = false;
            }
            if (bl4 && !XMLCluster.isSame(string4, iServerArray[i].getSybaseHome())) {
                bl4 = false;
            }
            if (bl5 && !XMLCluster.isSame(string5, iServerArray[i].getAseHome())) {
                bl5 = false;
            }
            if (!bl6 || XMLCluster.isSame(string6, iServerArray[i].getEnvShellPath())) continue;
            bl6 = false;
        }
        if (bl && string != null && !string.equals("")) {
            iCluster.setConfigFile(string);
        }
        if (bl2 && string2 != null && !string2.equals("")) {
            iCluster.setInterfacesPath(string2);
        }
        if (bl3) {
            iCluster.setAddlRunParameters(string3);
        }
        if (bl4) {
            iCluster.setSybaseHome(string4);
        }
        if (bl5) {
            iCluster.setAseHome(string5);
        }
        if (bl6) {
            iCluster.setEnvShellPath(string6);
        }
        return iCluster;
    }

    private static boolean isSame(String string, String string2) {
        if (string == null && string2 == null) {
            return true;
        }
        if (string == null && string2 != null) {
            return false;
        }
        if (string != null && string2 == null) {
            return false;
        }
        return string.equals(string2);
    }

    private static int getFirstPort(IServer[] iServerArray) {
        int n = Integer.MAX_VALUE;
        for (int i = 0; i < iServerArray.length; ++i) {
            String string;
            String string2 = iServerArray[i].getPrimaryPortStart();
            if (string2 == null || string2.equals("")) {
                log.error((Object)"XMLCluster - getElement() - cluster did not define a primary protocol start.");
                string2 = "0";
            }
            if ((string = iServerArray[i].getSecondaryPortStart()) == null || string.equals("")) {
                log.debug((Object)"XMLCluster - getElement() - cluster did not define a secondary protocol start.");
                string = "0";
            }
            int n2 = 0;
            try {
                n2 = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                log.error((Object)("XMLCluster - getElement() - Unable to format the primary port start " + string2));
            }
            int n3 = 0;
            try {
                n3 = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                log.error((Object)("XMLCluster - getElement() - Unable to format the secondary port start " + string2));
            }
            if (n > n2) {
                n = n2;
            }
            if (n <= n3) continue;
            n = n3;
        }
        return n;
    }

    public static String getClusterName(Element element) throws ClusterConfigException {
        Element element2;
        String string = null;
        Element element3 = null;
        if (element != null && element.getName().equalsIgnoreCase(XML_ROOT) && (element2 = element.getChild(XML_ASE_SDC)) != null && (element3 = element2.getChild(XML_CLUSTER)) != null) {
            string = element3.getAttributeValue(XML_NAME);
        }
        return string;
    }

    public static ICluster processInputFile(String string, String string2, File file) throws ClusterConfigException {
        ICluster iCluster = null;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            FileReader fileReader = new FileReader(file);
            char[] cArray = new char[2048];
            int n = 0;
            do {
                if ((n = fileReader.read(cArray)) <= 0) continue;
                stringBuffer.append(String.copyValueOf(cArray, 0, n));
            } while (n > 0);
            fileReader.close();
            String string3 = stringBuffer.toString();
            log.debug((Object)("The add instance XML is as follows: " + string3));
            Element element = JDomUtil.getDocument((String)string3).getRootElement();
            try {
                String string4 = XMLCluster.getClusterName(element);
                if (string4 != null && !string4.equalsIgnoreCase(string)) {
                    throw new ClusterConfigException("command.error.create.cluster.file.name.nomatch", string, (Object)string4, (Object)file.getAbsolutePath());
                }
            }
            catch (ClusterConfigException clusterConfigException) {
                log.equals(clusterConfigException);
            }
            try {
                iCluster = ClusterConfigFactory.createCluster(string);
                iCluster = XMLCluster.getCluster(iCluster, element);
                iCluster.dump();
            }
            catch (ClusterConfigException clusterConfigException) {
                throw new ClusterConfigException("command.error.xml.configuration", file.getAbsolutePath());
            }
        }
        catch (Exception exception) {
            throw new ClusterConfigException("command.error.xml.configuration.reason", file.getAbsolutePath(), (Object)exception.getMessage());
        }
        return iCluster;
    }

    public static ICluster getCluster(ICluster iCluster, Element element) throws ClusterConfigException {
        String string;
        String string2;
        String string3;
        String string4;
        Object object;
        String string5;
        String string6;
        Object object2;
        Object object3;
        Object object4;
        Element element2 = null;
        Element element3 = null;
        if (element.getName().equalsIgnoreCase(XML_ROOT) && (object4 = element.getChild(XML_ASE_SDC)) != null) {
            element2 = object4.getChild(XML_CLUSTER);
            if (element2 != null) {
                if (iCluster.getName() == null) {
                    object3 = element2.getAttributeValue(XML_NAME);
                    iCluster.setName((String)object3);
                }
                if ((object3 = element2.getAttributeValue(XML_MAX_INSTANCES)) != null) {
                    object2 = Integer.valueOf((String)object3);
                    iCluster.setMaxInstances((Integer)object2);
                }
                if ((object2 = element2.getAttributeValue(XML_STATUS)) != null) {
                    iCluster.setStatus(Integer.parseInt((String)object2));
                }
                if ((string6 = element2.getAttributeValue(XML_BOOTUID)) != null) {
                    iCluster.setBootUid(string6);
                }
                if ((string5 = element2.getAttributeValue(XML_CONFIGUID)) != null) {
                    iCluster.setConfigUid(string5);
                }
                if ((object = element2.getAttributeValue(XML_UID)) != null) {
                    iCluster.setUid((String)object);
                    iCluster.setQuorumUid((String)object);
                    iCluster.setMasterUid((String)object);
                }
            }
            if ((element3 = object4.getChild(XML_SERVER)) != null) {
                object3 = element3.getAttributeValue(XML_NAME);
                iCluster.setOldServerName((String)object3);
                object2 = element3.getAttributeValue(XML_CHECK_ONLY);
                iCluster.setUpgradeCheck(((String)object2).equals("y"));
            }
        }
        if (iCluster != null && element3 != null) {
            object4 = element3.getChild(XML_OLD_SYBASE_HOME);
            if (object4 != null) {
                object3 = object4.getAttributeValue(XML_VALUE);
                iCluster.setOldSybaseHome((String)object3);
            }
            if ((object3 = element3.getChild(XML_OLD_ASE_HOME)) != null) {
                object2 = object3.getAttributeValue(XML_VALUE);
                iCluster.setOldASEHome((String)object2);
            }
            if ((object2 = element3.getChild(XML_OLD_OCS_HOME)) != null) {
                string6 = object2.getAttributeValue(XML_VALUE);
                iCluster.setOldOCSHome(string6);
            }
        }
        if (iCluster != null && element2 != null && (object4 = element2.getChild(XML_TRACEFLAGS)) != null) {
            object3 = object4.getChildren(XML_TRACEFLAG);
            for (int i = 0; i < object3.size(); ++i) {
                string6 = (Element)object3.get(i);
                string5 = string6.getAttributeValue(XML_VALUE);
                if (string5 == null) continue;
                object = Integer.valueOf(string5);
                iCluster.addTracesflag((Integer)object);
            }
        }
        if (iCluster != null && element2 != null && (object4 = element2.getChild(XML_BACKUPSERVER)) != null) {
            String string7;
            object3 = object4.getAttributeValue(XML_NAME);
            if (object3 != null && !((String)object3).equals("")) {
                iCluster.setBackupServerName((String)object3);
            }
            if ((string7 = object4.getAttributeValue(XML_LOGFILE)) != null && !string7.equals("")) {
                iCluster.setBackupServerLogFile(string7);
            }
            if ((string6 = object4.getAttributeValue(XML_MULTIPLE)) != null && !string6.equals("")) {
                iCluster.setMultipleBackupServersPresent(Boolean.valueOf(string6));
            }
            if ((string5 = object4.getAttributeValue(XML_POLICY)) != null && !string5.equals("")) {
                iCluster.setBackupServersPolicy(string5);
                iCluster.setMultipleBackupServersPresent(true);
            }
        }
        if (iCluster != null && element2 != null && (object4 = element2.getChild(XML_INSTALLATION)) != null) {
            object3 = object4.getAttributeValue(XML_MODE);
            if (object3 != null && !((String)object3).equals("")) {
                iCluster.setInstallationMode((String)object3);
            }
            String string8 = object4.getAttributeValue(XML_LDAP);
            boolean bl = Boolean.valueOf(string8);
            iCluster.setLDAPConfigured(bl);
        }
        object4 = new TreeMap();
        if (iCluster != null && element2 != null && (object3 = element2.getChild(XML_DEVICES)) != null) {
            String string9 = object3.getAttributeValue(XML_PAGE_SIZE);
            if (string9 != null) {
                iCluster.setPageSize(string9);
            }
            List list = object3.getChildren(XML_DEVICE);
            for (int i = 0; i < list.size(); ++i) {
                object = (Element)list.get(i);
                string4 = object.getAttributeValue(XML_TYPE);
                if (string4 == null) {
                    string3 = object.getAttributeValue(XML_NAME);
                    if (string3 == null) continue;
                    ((TreeMap)object4).put(string3, object);
                    continue;
                }
                if (string4.equalsIgnoreCase("quorum")) {
                    string3 = object.getAttributeValue(XML_PATH);
                    if (string3 == null) continue;
                    iCluster.setQuorum(string3);
                    continue;
                }
                if (string4.equalsIgnoreCase("master")) {
                    string3 = object.getAttributeValue(XML_PATH);
                    if (string3 != null) {
                        iCluster.setMasterDevice(string3);
                        ((TreeMap)object4).put("master", object);
                    }
                    if ((string2 = XMLCluster.toIntMB(object.getAttributeValue(XML_SIZE), object.getAttributeValue(XML_UNITS))) != null) {
                        iCluster.setMasterDeviceSize(string2);
                    }
                    if ((string = object.getChild(XML_DATABASE)) == null || (string2 = XMLCluster.toIntMB(string.getAttributeValue(XML_SIZE), string.getAttributeValue(XML_UNITS))) == null) continue;
                    iCluster.setMasterDatabaseSize(string2);
                    continue;
                }
                if (string4.equalsIgnoreCase("sybsystemprocs")) {
                    string3 = object.getAttributeValue(XML_PATH);
                    if (string3 != null) {
                        iCluster.setSystemProcedureDevice(string3);
                        ((TreeMap)object4).put(DEVICE_NAME_SYBSYSTEMPROCS, object);
                    }
                    if ((string2 = XMLCluster.toIntMB(object.getAttributeValue(XML_SIZE), object.getAttributeValue(XML_UNITS))) != null) {
                        iCluster.setSystemProcedureDeviceSize(string2);
                    }
                    if ((string = object.getChild(XML_DATABASE)) == null || (string2 = XMLCluster.toIntMB(string.getAttributeValue(XML_SIZE), string.getAttributeValue(XML_UNITS))) == null) continue;
                    iCluster.setSystemProcedureDatabaseSize(string2);
                    continue;
                }
                if (string4.equalsIgnoreCase(DEVICE_TYPE_SYSTEM)) {
                    string3 = object.getAttributeValue(XML_PATH);
                    if (string3 != null) {
                        iCluster.setSystemDevice(string3);
                        ((TreeMap)object4).put(DEVICE_NAME_SYSTEM, object);
                    }
                    if ((string2 = XMLCluster.toIntMB(object.getAttributeValue(XML_SIZE), object.getAttributeValue(XML_UNITS))) != null) {
                        iCluster.setSystemDeviceSize(string2);
                    }
                    if ((string = object.getChild(XML_DATABASE)) == null || (string2 = XMLCluster.toIntMB(string.getAttributeValue(XML_SIZE), string.getAttributeValue(XML_UNITS))) == null) continue;
                    iCluster.setSystemDatabaseSize(string2);
                    continue;
                }
                if (!string4.equalsIgnoreCase("pci")) continue;
                string3 = object.getAttributeValue(XML_PATH);
                if (string3 != null) {
                    iCluster.setPCIDevice(string3);
                    ((TreeMap)object4).put("pci", object);
                }
                if ((string2 = XMLCluster.toIntMB(object.getAttributeValue(XML_SIZE), object.getAttributeValue(XML_UNITS))) != null) {
                    iCluster.setPCIDeviceSize(string2);
                }
                if ((string = object.getChild(XML_DATABASE)) == null || (string2 = XMLCluster.toIntMB(string.getAttributeValue(XML_SIZE), string.getAttributeValue(XML_UNITS))) == null) continue;
                iCluster.setPCIDatabaseSize(string2);
            }
        }
        if (iCluster != null && element2 != null && (object3 = element2.getChild(XML_NODES)) != null) {
            String string10;
            String string11 = object3.getAttributeValue(XML_PRIMARY_PROTOCOL);
            if (string11 != null) {
                iCluster.setPrimaryInterconnect(string11);
            }
            if ((string10 = object3.getAttributeValue(XML_SECONDARY_PROTOCOL)) != null) {
                iCluster.setSecondaryInterconnect(string10);
            }
            iCluster = (ICluster)((Object)XMLCluster.setEntryBase((EntryBase)((Object)iCluster), (Element)object3, null));
            List list = object3.getChildren(XML_NODE);
            for (int i = 0; i < list.size(); ++i) {
                string4 = (Element)list.get(i);
                string3 = string4.getAttributeValue(XML_NAME);
                string2 = string4.getAttributeValue(XML_PUBLIC_ADDRESS);
                if (string2 == null || string2.equals("")) {
                    string2 = string3;
                }
                string = string4.getAttributeValue(XML_PRIMARY_ADDRESS);
                String string12 = string4.getAttributeValue(XML_SECONDARY_ADDRESS);
                String string13 = string4.getAttributeValue(XML_UAF_PORT);
                List list2 = string4.getChildren(XML_INSTANCE);
                for (int j = 0; j < list2.size(); ++j) {
                    Element element4;
                    Object object5;
                    String string14;
                    Object object6;
                    Object object7;
                    String string15;
                    String string16;
                    String string17;
                    String string18;
                    Element element5;
                    IServer iServer = null;
                    Element element6 = (Element)list2.get(j);
                    String string19 = element6.getAttributeValue(XML_NAME);
                    if (string19 == null) continue;
                    iServer = ClusterConfigFactory.createServer(string19);
                    String string20 = element6.getAttributeValue(XML_ID);
                    if (string20 != null) {
                        iServer.setId(Integer.valueOf(string20));
                    }
                    if ((element5 = element6.getChild(XML_INTERFACE)) != null) {
                        string18 = element5.getAttributeValue(XML_PORT);
                        if (string18 != null) {
                            iServer.setQueryPort(string18);
                        }
                        if ((string17 = element5.getAttributeValue(XML_TRANSPORT)) != null) {
                            iServer.setQueryTransport(string17);
                        }
                    }
                    if (string2 != null) {
                        iServer.setPublicAddress(string2);
                    }
                    if (string != null) {
                        iServer.setPrimaryAddress(string);
                    }
                    if (string12 != null) {
                        iServer.setSecondaryAddress(string12);
                    }
                    if ((string18 = element6.getChild(XML_PROTOCOL_SPEC)) != null) {
                        string17 = string18.getChild(XML_PRIMARY_SPEC);
                        if (string17 != null && (string16 = string17.getAttributeValue(XML_PORT_START)) != null) {
                            iServer.setPrimaryPortStart(string16);
                        }
                        if ((string16 = string18.getChild(XML_SECONDARY_SPEC)) != null && (string15 = string16.getAttributeValue(XML_PORT_START)) != null) {
                            iServer.setSecondaryPortStart(string15);
                        }
                    }
                    if ((string17 = element6.getChild(XML_XPSERVER)) != null && (string16 = string17.getAttributeValue(XML_PORT)) != null) {
                        iServer.setXpServerPort(string16);
                    }
                    if ((string16 = element6.getChild(XML_MONITORSERVER)) != null) {
                        string15 = string16.getAttributeValue(XML_PORT);
                        if (string15 != null) {
                            iServer.setMonitorServerPort(string15);
                        }
                        if ((object7 = string16.getAttributeValue(XML_PATH)) != null) {
                            iServer.setMonitorServerLogFile((String)object7);
                        }
                    }
                    iServer = (IServer)((Object)XMLCluster.setEntryBase((EntryBase)((Object)iServer), element6, (EntryBase)((Object)iCluster)));
                    string15 = string4.getChild(XML_TRACEFLAGS);
                    if (string15 != null) {
                        object7 = string15.getChildren(XML_TRACEFLAG);
                        for (int k = 0; k < object7.size(); ++k) {
                            object6 = (Element)object7.get(k);
                            string14 = object6.getAttributeValue(XML_VALUE);
                            if (string14 == null) continue;
                            object5 = Integer.valueOf(string14);
                            iServer.addTracesflag((Integer)object5);
                        }
                    }
                    if (string13 != null) {
                        iServer.setAgentPort(string13);
                    }
                    if (string3 != null) {
                        iServer.setNode(string3);
                    }
                    if (string2 != null) {
                        iServer.setPublicAddress(string2);
                    }
                    if ((object7 = element6.getChild(XML_BACKUPSERVER)) != null) {
                        String string21 = object7.getAttributeValue(XML_PORT);
                        if (string21 != null) {
                            iServer.setBackupServerPort(string21);
                        }
                        if (iCluster.areMultipleBackupServersPresent()) {
                            object6 = object7.getAttributeValue(XML_NAME);
                            if (object6 != null && !((String)object6).equals("")) {
                                iServer.setBackupServerName((String)object6);
                            }
                            if ((string14 = object7.getAttributeValue(XML_LOGFILE)) != null && !string14.equals("")) {
                                iServer.setBackupServerLogFile(string14);
                            }
                        }
                    }
                    if ((element4 = element6.getChild(XML_DATABASE)) != null && ((TreeMap)object4).containsKey(object6 = element4.getAttributeValue(XML_DEVICE))) {
                        iServer.setTempdbDeviceName((String)object6);
                        string14 = (Element)((TreeMap)object4).get(object6);
                        if (string14 != null) {
                            String string22;
                            String string23;
                            String string24;
                            object5 = string14.getAttributeValue(XML_PATH);
                            if (object5 != null) {
                                iServer.setTempdbDevicePath((String)object5);
                            }
                            if ((string24 = string14.getAttributeValue(XML_SIZE)) != null) {
                                iServer.setTempdbDeviceSize(string24);
                            }
                            if ((string23 = element4.getAttributeValue(XML_NAME)) != null) {
                                iServer.setTempdbDbName(string23);
                            }
                            if ((string22 = element4.getAttributeValue(XML_SIZE)) != null) {
                                iServer.setTempdbDbSize(string22);
                            }
                        }
                    }
                    if ((object6 = element6.getChild(XML_LOGFILE)) != null && (string14 = object6.getAttributeValue(XML_PATH)) != null) {
                        iServer.setLogFile(string14);
                    }
                    iCluster.addServer(iServer.getId(), iServer);
                }
            }
        }
        return iCluster;
    }

    private static Element getElementTraceflags(EntryBase entryBase) {
        Element element = new Element(XML_TRACEFLAGS);
        Enumeration enumeration = entryBase.getTracesflags();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                Integer n = (Integer)enumeration.nextElement();
                if (n == null) continue;
                element.addContent((Content)new Element(XML_TRACEFLAG).setAttribute(XML_VALUE, n.toString()));
            }
        }
        return element;
    }

    private static EntryBase setEntryBase(EntryBase entryBase, Element element, EntryBase entryBase2) {
        Element element2 = element.getChild(XML_CONFIG_PATH);
        if (element2 != null) {
            entryBase.setConfigFile(element2.getAttributeValue(XML_VALUE));
        } else if (entryBase2 != null) {
            entryBase.setConfigFile(entryBase2.getConfigFile());
        }
        Element element3 = element.getChild(XML_INTERFACES_PATH);
        if (element3 != null) {
            entryBase.setInterfacesPath(element3.getAttributeValue(XML_VALUE));
        } else if (entryBase2 != null) {
            entryBase.setInterfacesPath(entryBase2.getInterfacesPath());
        }
        Element element4 = element.getChild(XML_ADDL_RUN_PARAMS);
        if (element4 != null) {
            entryBase.setAddlRunParameters(element4.getAttributeValue(XML_VALUE));
        } else if (entryBase2 != null) {
            entryBase.setAddlRunParameters(entryBase2.getAddlRunParameters());
        }
        Element element5 = element.getChild(XML_SYBASE_HOME);
        if (element5 != null) {
            entryBase.setSybaseHome(element5.getAttributeValue(XML_VALUE));
        } else if (entryBase2 != null) {
            entryBase.setSybaseHome(entryBase2.getSybaseHome());
        }
        Element element6 = element.getChild(XML_ASE_HOME);
        if (element6 != null) {
            entryBase.setAseHome(element6.getAttributeValue(XML_VALUE));
        } else if (entryBase2 != null) {
            entryBase.setAseHome(entryBase2.getAseHome());
        }
        Element element7 = element.getChild(XML_ENV_SHELL_PATH);
        if (element7 != null) {
            entryBase.setEnvShellPath(element7.getAttributeValue(XML_VALUE));
        } else if (entryBase2 != null) {
            entryBase.setEnvShellPath(entryBase2.getEnvShellPath());
        }
        return entryBase;
    }

    private static Element getElementBase(Element element, EntryBase entryBase, EntryBase entryBase2) {
        if (entryBase.getConfigFile() != null) {
            element.addContent((Content)new Element(XML_CONFIG_PATH).setAttribute(XML_VALUE, entryBase.getConfigFile()));
        }
        if (!(entryBase.getInterfacesPath() == null || entryBase2 != null && entryBase.getInterfacesPath().equals(entryBase2.getInterfacesPath()))) {
            element.addContent((Content)new Element(XML_INTERFACES_PATH).setAttribute(XML_VALUE, entryBase.getInterfacesPath()));
        }
        if (!(entryBase.getAddlRunParameters() == null || entryBase2 != null && entryBase.getAddlRunParameters().equals(entryBase2.getAddlRunParameters()))) {
            element.addContent((Content)new Element(XML_ADDL_RUN_PARAMS).setAttribute(XML_VALUE, entryBase.getAddlRunParameters()));
        }
        if (entryBase.getSybaseHome() != null) {
            element.addContent((Content)new Element(XML_SYBASE_HOME).setAttribute(XML_VALUE, entryBase.getSybaseHome()));
        }
        if (entryBase.getAseHome() != null) {
            element.addContent((Content)new Element(XML_ASE_HOME).setAttribute(XML_VALUE, entryBase.getAseHome()));
        }
        if (entryBase.getEnvShellPath() != null) {
            element.addContent((Content)new Element(XML_ENV_SHELL_PATH).setAttribute(XML_VALUE, entryBase.getEnvShellPath()).setAttribute(XML_TYPE, DEFAULT_SHELL));
        }
        return element;
    }

    private static Element getElementDevices(ICluster iCluster, IServer[] iServerArray) throws ClusterConfigException {
        Element element;
        TreeMap<String, IServer> treeMap = new TreeMap<String, IServer>();
        Element element2 = new Element(XML_DEVICES);
        if (iCluster.getPageSize() != null) {
            element2.setAttribute(XML_PAGE_SIZE, iCluster.getPageSize());
            element2.setAttribute(XML_UNITS, UNITS_KILOBYTES);
        }
        if (iCluster.getQuorum() != null) {
            element2.addContent((Content)new Element(XML_DEVICE).setAttribute(XML_TYPE, "quorum").setAttribute(XML_NAME, "quorum").setAttribute(XML_PATH, iCluster.getQuorum()));
        }
        if (iCluster.getMasterDevice() != null) {
            element = new Element(XML_DEVICE).setAttribute(XML_TYPE, "master").setAttribute(XML_NAME, "master").setAttribute(XML_PATH, iCluster.getMasterDevice());
            if (iCluster.getMasterDeviceSize() != null) {
                element.setAttribute(XML_SIZE, iCluster.getMasterDeviceSize());
                element.setAttribute(XML_UNITS, UNITS_MEGABYTES);
            }
            treeMap.put("master", null);
            if (iCluster.getMasterDatabaseSize() != null) {
                element.addContent((Content)new Element(XML_DATABASE).setAttribute(XML_NAME, "master").setAttribute(XML_SIZE, iCluster.getMasterDatabaseSize()).setAttribute(XML_UNITS, UNITS_MEGABYTES));
            }
            element2.addContent((Content)element);
        }
        if (iCluster.getSystemProcedureDevice() != null) {
            element = new Element(XML_DEVICE).setAttribute(XML_TYPE, "sybsystemprocs").setAttribute(XML_NAME, DEVICE_NAME_SYBSYSTEMPROCS).setAttribute(XML_PATH, iCluster.getSystemProcedureDevice());
            if (iCluster.getSystemProcedureDeviceSize() != null) {
                element.setAttribute(XML_SIZE, iCluster.getSystemProcedureDeviceSize());
                element.setAttribute(XML_UNITS, UNITS_MEGABYTES);
            }
            treeMap.put(DEVICE_NAME_SYBSYSTEMPROCS, null);
            if (iCluster.getSystemProcedureDatabaseSize() != null) {
                element.addContent((Content)new Element(XML_DATABASE).setAttribute(XML_NAME, "sybsystemprocs").setAttribute(XML_SIZE, iCluster.getSystemProcedureDatabaseSize()).setAttribute(XML_UNITS, UNITS_MEGABYTES));
            }
            element2.addContent((Content)element);
        }
        if (iCluster.getSystemDevice() != null) {
            element = new Element(XML_DEVICE).setAttribute(XML_TYPE, DEVICE_TYPE_SYSTEM).setAttribute(XML_NAME, DEVICE_NAME_SYSTEM).setAttribute(XML_PATH, iCluster.getSystemDevice());
            if (iCluster.getSystemDeviceSize() != null) {
                element.setAttribute(XML_SIZE, iCluster.getSystemDeviceSize());
                element.setAttribute(XML_UNITS, UNITS_MEGABYTES);
            }
            treeMap.put(DEVICE_NAME_SYSTEM, null);
            if (iCluster.getSystemDatabaseSize() != null) {
                element.addContent((Content)new Element(XML_DATABASE).setAttribute(XML_NAME, DATABASE_NAME_SYSTEM).setAttribute(XML_SIZE, iCluster.getSystemDatabaseSize()).setAttribute(XML_UNITS, UNITS_MEGABYTES));
            }
            element2.addContent((Content)element);
        }
        if (iCluster.getPCIDevice() != null) {
            element = new Element(XML_DEVICE).setAttribute(XML_TYPE, "pci").setAttribute(XML_NAME, "pci").setAttribute(XML_PATH, iCluster.getPCIDevice());
            if (iCluster.getPCIDeviceSize() != null) {
                element.setAttribute(XML_SIZE, iCluster.getPCIDeviceSize());
                element.setAttribute(XML_UNITS, UNITS_MEGABYTES);
            }
            treeMap.put("pci", null);
            if (iCluster.getPCIDatabaseSize() != null) {
                element.addContent((Content)new Element(XML_DATABASE).setAttribute(XML_NAME, DATABASE_NAME_PCI).setAttribute(XML_SIZE, iCluster.getPCIDatabaseSize()).setAttribute(XML_UNITS, UNITS_MEGABYTES));
            }
            element2.addContent((Content)element);
        }
        for (int i = 0; i < iServerArray.length; ++i) {
            String string = iServerArray[i].getTempdbDeviceName();
            if (string == null || treeMap.containsKey(string)) continue;
            treeMap.put(string, iServerArray[i]);
        }
        for (String string : treeMap.keySet()) {
            IServer iServer = (IServer)treeMap.get(string);
            if (iServer == null) continue;
            String string2 = iServer.getTempdbDevicePath();
            if (string2 == null) {
                log.error((Object)FileUtil.removeControlCharacter("XMLCluster - getElement() - device " + string + " did not define a path."));
                throw new ClusterConfigException("sdcadmin.cluster.value.missing.error", "path for device " + string);
            }
            String string3 = iServer.getTempdbDeviceSize();
            if (string3 == null) {
                log.error((Object)FileUtil.removeControlCharacter("XMLCluster - getElement() - device " + string + " did not define a size."));
                throw new ClusterConfigException("sdcadmin.cluster.value.missing.error", "size for device " + string);
            }
            Element element3 = new Element(XML_DEVICE).setAttribute(XML_NAME, string).setAttribute(XML_PATH, string2).setAttribute(XML_SIZE, string3).setAttribute(XML_UNITS, UNITS_MEGABYTES);
            element2.addContent((Content)element3);
        }
        return element2;
    }

    public static String getXMLClusterString(ICluster iCluster) throws ClusterConfigException {
        String string = null;
        try {
            Element element = XMLCluster.getElement(iCluster);
            string = JDomUtil.toString((Element)element);
        }
        catch (IOException iOException) {
            log.error((Object)"The cluster entry element could not be converted to a string.");
            log.debug((Object)iOException);
            log.debug((Object)iOException.getCause());
        }
        return string;
    }

    public static ICluster getICluster(String string) {
        ICluster iCluster = null;
        try {
            Document document = JDomUtil.getDocument((String)string);
            Element element = document.getRootElement();
            String string2 = XMLCluster.getClusterName(element);
            iCluster = ClusterConfigFactory.createCluster(string2);
            iCluster = XMLCluster.getCluster(iCluster, element);
        }
        catch (Exception exception) {
            log.error((Object)exception);
            log.debug((Object)exception);
            log.debug((Object)exception.getCause());
        }
        return iCluster;
    }

    private static String toIntMB(String string, String string2) {
        if (null == string || null == string2) {
            return null;
        }
        String string3 = UNITS_MEGABYTES;
        if (string2 != null && string2.length() > 0 && (string2.equalsIgnoreCase(UNITS_KILOBYTES) || string2.equalsIgnoreCase(UNITS_GIGABYTES) || string2.equalsIgnoreCase(UNITS_TERABYTES))) {
            string3 = string2;
        }
        float f = 0.0f;
        float f2 = 0.0f;
        try {
            f2 = f = Float.parseFloat(string);
        }
        catch (NumberFormatException numberFormatException) {
            f = 0.0f;
        }
        if (string3.equalsIgnoreCase(UNITS_KILOBYTES)) {
            f2 = f / 1024.0f;
        } else if (string3.equalsIgnoreCase(UNITS_GIGABYTES)) {
            f2 = f * 1024.0f;
        } else if (string3.equalsIgnoreCase(UNITS_TERABYTES)) {
            f2 = f * 1024.0f * 1024.0f;
        }
        return new Integer(Math.round(f2)).toString();
    }
}

