/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.jdbc;

import com.sybase.jdbc4.jdbc.SybBatchUpdateException;
import com.sybase.jdbc4.jdbc.SybConnectionDeadException;
import com.sybase.jdbc4.jdbc.SybHAException;
import com.sybase.jdbc4.jdbc.SybSQLException;
import com.sybase.jdbc4.tds.Language;
import com.sybase.jdbc4.utils.Debug;
import com.sybase.jdbc4.utils.UnimplementedOperationException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.sql.BatchUpdateException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.util.ResourceBundle;
import org.ietf.jgss.GSSException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ErrorMessage {
    private static ResourceBundle a;
    public static final String ERR_LOADING_SYBSOCKET_FACTORY = "JZ0NF";
    public static final String ERR_URL_AND_SYBSOCKET_FACTORY = "JZ0US";
    public static final String ERR_USERNAME_TOO_LONG = "JZ001";
    public static final String ERR_PASSWORD_TOO_LONG = "JZ002";
    public static final String ERR_URL_FORMAT_ERROR = "JZ003";
    public static final String ERR_URL_FORMAT_ERROR_WITH_NFE = "JZ0NE";
    public static final String ERR_BAD_PORT_NUMBER = "JZ0PN";
    public static final String WARN_USE_FAILED = "010UF";
    public static final String WARN_LOGIN_DATABASE_FAILED = "010DF";
    public static final String ERR_BAD_CONVERT_TYPE_COMBINATION = "JZ0TC";
    public static final String ERR_BAD_CONVERT_TYPE_COMB_VALUES = "JZ0TE";
    public static final String ERR_ILLEGAL_TYPE_CONVERSION = "JZ0TI";
    public static final String ERR_ILLEGAL_HEX_CHAR = "JZ0HC";
    public static final String IO_TRUNCATION_WITH_STRING = "JZ0TS";
    public static final String IO_THREAD_DEATH = "JZ0TD";
    public static final String ERR_USERNAME_MISSING = "JZ004";
    public static final String ERR_BAD_COOKIE = "JZ0BC";
    public static final String ERR_BAD_COOKIE_MESSAGE = "JZ0BM";
    public static final String ERR_IO_EXCEPTION = "JZ006";
    public static final String ERR_BAD_COLUMN_INDEX = "JZ008";
    public static final String ERR_WASNULL_NO_COLUMN = "JZ0NC";
    public static final String ERR_BAD_CONVERT = "JZ009";
    public static final String ERR_BAD_PREC_SCALE = "JZ00A";
    public static final String ERR_PREC_SCALE_TOO_SMALL = "JZ00C";
    public static final String ERR_SCALE_TOO_SMALL = "JZ00I";
    public static final String ERR_LOGIN = "JZ00L";
    public static final String ERR_LOGIN_TIMEOUT = "JZ00M";
    public static final String ERR_READ_TIMEOUT_SQLEX = "JZ0TO";
    public static final String WARN_HA_REQUEST_DENIED = "010HA";
    public static final String WARN_HA_FAILOVER_NOT_SUPPORTED = "010HD";
    public static final String ERR_HA_SECONDARY_MISSING = "JZ0F1";
    public static final String ERR_HA_FAILOVER = "JZ0F2";
    public static final String WARN_KERBEROS_LOGIN_FAILED = "010KF";
    public static final String WARN_TDS_VERSION = "0100V";
    public static final String ERR_NUMERIC_OFLO = "JZ00B";
    public static final String ERR_CUR_NOT_FOUND = "JZ00D";
    public static final String ERR_CURSOR_ALREADY = "JZ00F";
    public static final String ERR_CURSOR_IN_USE = "JZ00E";
    public static final String ERR_UPDATE_NOT_SET = "JZ00G";
    public static final String ERR_NOT_UPDATABLE = "JZ00H";
    public static final String ERR_ROW_MODIFIED = "JZ0RM";
    public static final String ERR_ROW_DELETED = "JZ0RD";
    public static final String ERR_INVALID_READER = "JZ0IR";
    public static final String ERR_INVALID_STREAM = "JZ0IS";
    public static final String ERR_LANGUAGE_CURSOR_CANT_SCROLL = "JZ0LC";
    public static final String ERR_BAD_METHOD_FOR_TYPE = "JZ0BT";
    public static final String ERR_BAD_METHOD_FOR_ROW = "JZ0BR";
    public static final String WARN_RESULTSET_TYPE_CHANGE = "010RC";
    public static final String ERR_BAD_DATA = "JZ0BD";
    public static final String ERR_NOT_REGISTERED = "JZ0D0";
    public static final String ERR_INVALID_KEY = "JZ0D1";
    public static final String ERR_EXPIRED = "JZ0D2";
    public static final String INFO_EXPIRES_SOON = "000D3";
    public static final String ERR_BAD_PROTOCOL = "JZ0D4";
    public static final String ERR_LOADING_PROTOCOL = "JZ0D5";
    public static final String ERR_UNKNOWN_VERSION = "JZ0D6";
    public static final String ERR_LOADING_URL_PROVIDER = "JZ0D7";
    public static final String ERR_INITIALIZING_URL_PROVIDER = "JZ0D8";
    public static final String ERR_CONNECTION_PROP = "JZ011";
    public static final String ERR_PROPERTY_ACCESS = "JZ012";
    public static final String ERR_JNDI_ENTRY = "JZ013";
    public static final String ERR_TRANS_NONE = "JZ014";
    public static final String ERR_GSSMANAGER_CONN_PROP = "JZ015";
    public static final String ERR_INVALID_SAVEPOINT = "JZ017";
    public static final String ERR_SAVEPOINT_NAME_ID = "JZ018";
    public static final String ERR_SQLINI_SERVERNAME = "JZ019";
    public static final String ERR_SQLINI_ENTRY = "JZ020";
    public static final String ERR_FILE_NOT_FOUND = "JZ021";
    public static final String ERR_FORMAT_ERROR = "JZ022";
    public static final String ERR_EMPTY_FILE = "JZ023";
    public static final String ERR_SQLINI_SERVER_ENTRY_NOTFOUND = "JZ024";
    public static final String ERR_SQLINI_INVALID_TLI_FORMAT = "JZ025";
    public static final String ERR_SQLINI_PROTOCOL_NOTSUPPORTED = "JZ026";
    public static final String ERR_SQLINI_KERBEROS_NOTSUPPORTED = "JZ027";
    public static final String ERR_JCE_PROVIDER_CLASS = "JZ028";
    public static final String ERR_LOOKUP_ASA = "JZ029";
    public static final String WARN_DUPLICATE_PROPERTY = "010DP";
    public static final String WARN_UNKNOWN_PROPERTY = "010UP";
    public static final String WARN_HOSTNAME_TRUNCATED = "010HT";
    public static final String WARN_LITERAL_PARAM_OVERRIDE = "010PO";
    public static final String WARN_COMMIT_PENDING_STMTS = "010CP";
    public static final String ERR_CONNECTION_DEAD = "JZ0C0";
    public static final String ERR_IOE_KILLED_CONNECTION = "JZ0C1";
    public static final String ERR_STATEMENT_BUSY = "JZ0S0";
    public static final String ERR_STATEMENT_IDLE = "JZ0S1";
    public static final String ERR_STATEMENT_CLOSED = "JZ0S2";
    public static final String ERR_RESULTSET_DEAD = "JZ0R0";
    public static final String ERR_RESULTSET_IDLE = "JZ0R1";
    public static final String ERR_RESULTSET_NULL = "JZ0R2";
    public static final String ERR_READ_PAST_RESULTSET = "JZ0R5";
    public static final String ERR_INVALID_COLUMN_NAME = "S0022";
    public static final String ERR_COLUMN_DEAD = "JZ0R3";
    public static final String ERR_BAD_TXTPTR = "JZ0R4";
    public static final String ERR_WRONG_LENGTH = "JZ0J0";
    public static final String ERR_ILLEGAL_FETCH_SIZE = "JZ0BI";
    public static final String ERR_ILLEGAL_IMPLICIT_CURSOR_FETCH_SIZE = "JZ0BJ";
    public static final String ERR_UNEXPECTED_RESULTTYPE = "JZ0P1";
    public static final String WARN_UNPROCESSED_PARAM = "010P4";
    public static final String WARN_UNPROCESSED_ROW = "010P6";
    public static final String ERR_PROTOCOL_ERROR = "JZ0P4";
    public static final String ERR_NOT_CACHED = "JZ0P7";
    public static final String ERR_EVENT_INIT = "JZ0H0";
    public static final String ERR_EVENT_NOTFOUND = "JZ0H1";
    public static final String ERR_BAD_ARGUMENT = "JZ0I3";
    public static final String ERR_BAD_CHARSET = "JZ0I5";
    public static final String ERR_CHARSET_CONVERT = "JZ0I6";
    public static final String ERR_SERVER_CHARSET_NOT_SUPPORTED_IN_JAVA = "JZ0IB";
    public static final String IO_NO_GATEWAY_RESPONSE = "JZ0I7";
    public static final String IO_GATEWAY_REFUSED = "JZ0I8";
    public static final String IO_TRUNCATION = "JZ0IA";
    public static final String IO_INPUTSTREAM_CLOSED = "JZ0I9";
    public static final String ERR_READ_STREAM = "JZ0T2";
    public static final String ERR_READ_TIMEOUT = "JZ0T3";
    public static final String ERR_WRITE_TIMEOUT = "JZ0T4";
    public static final String IO_CACHE_FULL = "JZ0T5";
    public static final String ERR_TUNNELLED_URL = "JZ0T6";
    public static final String ERR_READ_STREAM_THREAD_DEATH = "JZ0T7";
    public static final String ERR_READ_STREAM_SYNC = "JZ0T8";
    public static final String ERR_WRITE_STREAM_SYNC = "JZ0T9";
    public static final String ERR_READ_EOM = "JZ0EM";
    public static final String ERR_ESCAPE_SYNTAX = "JZ0S8";
    public static final String ERR_NO_FUNCTION_INFO = "JZ0SH";
    public static final String ERR_FUNCTION_ESCAPE_NOT_IMPL = "JZ0SI";
    public static final String ERR_METADATA_INFO = "JZ0SJ";
    public static final String WARN_METADATA_INFO_WITH_EXCEPTION = "010MX";
    public static final String WARN_METADATA_INFO = "010SJ";
    public static final String WARN_OLD_METADATA_INFO = "010SL";
    public static final String ERR_RSMD_NOT_AVAILABLE = "JZ0MD";
    public static final String ERR_OUTER_JOINS_NOT_SUPPORTED = "JZ0SK";
    public static final String WARN_OPT_NOT_AVAIL = "010SK";
    public static final String ERR_INPARAM_NOT_SET = "JZ0SA";
    public static final String ERR_BAD_PARAM_INDEX = "JZ0SB";
    public static final String ERR_BAD_INPARAM_INDEX = "JZ0SC";
    public static final String ERR_NO_OUTPARAM = "JZ0SD";
    public static final String ERR_NOT_JDBC_OBJ = "JZ0SE";
    public static final String ERR_NOT_EXPECTING_PARAM = "JZ0SF";
    public static final String ERR_MISSING_PARAMS = "JZ0SG";
    public static final String ERR_SET_PARAM_MIXED = "JZ0SV";
    public static final String ERR_BAD_DATETIME_PARAM = "JZ0SU";
    public static final String ERR_INVALID_METHOD = "JZ0S3";
    public static final String ERR_EMPTY_QUERY = "JZ0S4";
    public static final String ERR_GLOBAL_TRAN_IN_PROGRESS = "JZ0S5";
    public static final String ERR_GLOBAL_PRE_12 = "JZ0S6";
    public static final String ERR_SQL_TYPE = "JZ0SL";
    public static final String ERR_CANT_SEND_LITERAL = "JZ0SM";
    public static final String ERR_NEGATIVE_FIELD_SIZE = "JZ0SN";
    public static final String ERR_INVALID_RESULTSET_CONCUR_TYPE = "JZ0SO";
    public static final String ERR_INVALID_RESULTSET_TYPE = "JZ0SP";
    public static final String ERR_INVALID_RESULTSET_HOLD_TYPE = "JZ0SW";
    public static final String ERR_INVALID_UDT_TYPE = "JZ0SQ";
    public static final String ERR_NEGATIVE_MAXROW_SIZE = "JZ0SR";
    public static final String ERR_NEGATIVE_TIMEOUT_SIZE = "JZ0SS";
    public static final String ERR_JAVA_OBJECT_AS_LITERAL = "JZ0ST";
    public static final String ERR_COLUMNTYPE_UNKN = "JZ0P8";
    public static final String ERR_COMPUTE_BY = "JZ0P9";
    public static final String ERR_CANCELLED = "JZ0PA";
    public static final String ERR_NOT_IMPLEMENTED = "ZZ00A";
    public static final String ERR_NOT_SUPPORTED = "JZ0NS";
    public static final String ERR_ASSERT_FAILED = "JZ0AF";
    public static final String WARN_ASSERT_FAILED = "010AF";
    public static final String ERR_UPDATECOUNT_UNAVAILABLE = "JZ0CU";
    public static final String ERR_NO_OUTPARAMS_ALLOWED = "JZ0BP";
    public static final String ERR_BATCH_STMTS_NOTSUPPORTED = "JZ0BS";
    public static final String ERR_BATCH_UPDATE_EXCEPTION = "JZ0BE";
    public static final String WARN_CAPABILITY_MISMATCH = "010SM";
    public static final String ERR_DESERIALIZATION = "JZ010";
    public static final String WARN_WRITE_ACCESS_DENIED = "010SN";
    public static final String WARN_FILEIO_FAILED = "010SP";
    public static final String WARN_SERVER_CHARSET_USED = "010TP";
    public static final String WARN_USING_ASCII_CHARSET = "010TQ";
    public static final String ERR_UNSUPPORTED_CAPABILITY = "JZ0PB";
    public static final String ERR_NO_XA_SUPPORT = "JZ0XS";
    public static final String ERR_UNRECOGNIZED_XA_COORD = "JZ0XC";
    public static final String ERR_NOT_XA_USER = "JZ0XU";
    public static final String ERR_PARAMS_NEED_WIDETABLE = "JZ0PC";
    public static final String ERR_DYNAMIC_NEEDS_WIDETABLE = "JZ0PD";
    public static final String ERR_CURDECLARE_NEEDS_WIDETABLE = "JZ0PE";
    public static final String WARN_CONNECTION_LOGIN_REFUSED = "010SQ";
    public static final String WARN_PRELOAD_FAILED = "010PF";
    public static final String ERR_NO_CLASSLOADER_SUPPLIED = "JZ0CL";
    public static final String ERR_GSS_EXCEPTION = "JZ0GS";
    public static final String ERR_BAD_GSSMANAGER_CLASS_NAME = "JZ0GN";
    public static final String ERR_BAD_GSSMANAGER_CLASS = "JZ0GC";
    public static final String WARN_USE_HOSTNAME_FOR_SERVICE_PRINCIPAL = "010HN";
    public static final String WARN_SETNANOS_TRUNCATED = "01S07";
    public static final String WARN_LOCALTX_ROLLEDBACK = "01S08";
    public static final String WARN_GLOBAL_TRAN_IN_PROGRESS = "01S09";
    public static final String WARN_GLOBAL_PRE_12 = "01S10";
    public static final String ERR_BAD_FUNCTION_PARAM = "JZ0FP";
    public static final String ERR_BAD_GEN_KEY_COLUMNS = "JZ0GK";
    public static final String ERR_NO_GEN_KEYS_USED = "JZ0NK";
    public static final String ERR_LOADING_CIPHER = "JZ0LA";
    public static final String ERR_SYBBCP_NOT_INITIALIZED = "JZBK1";
    public static final String ERR_BULKLOAD_VALID_FOR_BATCHES = "JZBK2";
    public static final String ERR_BULKLOAD_TABLE_DOES_NOT_EXIST = "JZBK3";
    public static final String ERR_PASSWORD_EXPIRED = "01ZZZ";
    public static final String NULL_NOT_ALLOWED = "JZNNA";
    public static final String ERR_INVALID_BULKLOAD_VALUE = "JZBKI";
    public static final String ERR_ILLEGAL_BCP_USAGE = "JZBK4";
    public static final String ERR_BCP_AUTOCOMMIT = "JZBK5";
    public static final String ERR_SQL_FEATURE_NOT_SUPPORTED = "JZ030";
    public static final String ERR_UNWRAP_FAILURE = "JZ031";
    public static final String WARN_LENGTH_CASTED_LONG_TO_INT = "01S11";
    public static final String ERR_BAD_BIGDATETIME_RANGE = "JZ032";
    public static final String ERR_BAD_BLOBTYPE = "JZ033";

    private ErrorMessage() {
    }

    public static void raiseError(String string, String string2, String string3) throws SQLException {
        SQLException sQLException = new SQLException(ErrorMessage.a(true, string, string2, string3), string);
        throw sQLException;
    }

    public static void raiseError(String string, String string2, String string3, String string4) throws SQLException {
        SQLException sQLException = new SQLException(ErrorMessage.a(true, string, string2, string3, string4), string);
        throw sQLException;
    }

    public static void raiseError(String string, String string2) throws SQLException {
        SQLException sQLException = new SQLException(ErrorMessage.a(true, string, string2), string);
        throw sQLException;
    }

    public static void raiseError(String string) throws SQLException {
        SQLException sQLException = new SQLException(ErrorMessage.a(true, string), string);
        throw sQLException;
    }

    public static void raiseError(String string, SQLException sQLException) throws SQLException {
        SQLException sQLException2 = new SQLException(ErrorMessage.a(true, string), string);
        sQLException2.setNextException(sQLException);
        throw sQLException2;
    }

    public static void raiseError(String string, String string2, SQLException sQLException) throws SQLException {
        SQLException sQLException2 = new SQLException(ErrorMessage.a(true, string, string2), string);
        sQLException2.setNextException(sQLException);
        throw sQLException2;
    }

    public static void raiseWarning(String string, String string2, String string3) throws SQLWarning {
        throw new SQLWarning(ErrorMessage.a(true, string, string2, string3), string);
    }

    public static void raiseWarning(String string, String string2) throws SQLWarning {
        throw ErrorMessage.createWarning(string, string2);
    }

    public static void raiseWarning(String string) throws SQLWarning {
        throw ErrorMessage.createWarning(string);
    }

    public static void raiseMethodNotSupportedException(Object object, String string) throws SQLFeatureNotSupportedException {
        String[] stringArray = new String[]{(object != null ? object.getClass().getName() : "") + "." + string};
        String string2 = ErrorMessage.a(false, ERR_SQL_FEATURE_NOT_SUPPORTED, stringArray);
        SQLFeatureNotSupportedException sQLFeatureNotSupportedException = new SQLFeatureNotSupportedException(string2);
        throw sQLFeatureNotSupportedException;
    }

    public static SQLWarning createWarning(String string) {
        return new SQLWarning(ErrorMessage.a(true, string), string);
    }

    public static SQLWarning createWarning(String string, String string2) {
        return new SQLWarning(ErrorMessage.a(true, string, string2), string);
    }

    public static void raiseIOException(String string, String string2) throws IOException {
        throw new IOException(ErrorMessage.a(true, string, string2));
    }

    public static void raiseIOException(String string) throws IOException {
        throw new IOException(ErrorMessage.a(true, string));
    }

    public static void raiseIOECheckDead(SQLException sQLException) throws IOException {
        String string = sQLException.getMessage();
        boolean bl = false;
        while (sQLException != null) {
            if (ERR_IOE_KILLED_CONNECTION.equals(sQLException.getSQLState())) {
                bl = true;
                break;
            }
            sQLException = sQLException.getNextException();
        }
        if (bl) {
            IOException iOException = ErrorMessage.makeIOException(ERR_IO_EXCEPTION, string);
            ErrorMessage.raiseSybConnectionDeadException(iOException);
        } else {
            ErrorMessage.raiseIOException(ERR_IO_EXCEPTION, string);
        }
    }

    public static IOException makeIOException(String string, String string2) {
        return new IOException(ErrorMessage.a(true, string, string2));
    }

    public static IOException makeIOException(String string) {
        return new IOException(ErrorMessage.a(true, string));
    }

    public static void raiseHAException(String string) throws SybHAException {
        throw new SybHAException(ErrorMessage.a(true, string));
    }

    public static SQLException createIOEKilledConnEx(IOException iOException) {
        SQLException sQLException = new SQLException(ErrorMessage.a(true, ERR_IO_EXCEPTION, iOException.toString()), ERR_IO_EXCEPTION);
        SQLException sQLException2 = new SQLException(ErrorMessage.a(true, ERR_IOE_KILLED_CONNECTION), ERR_IOE_KILLED_CONNECTION);
        sQLException.setNextException(sQLException2);
        return sQLException;
    }

    public static void raiseSybConnectionDeadException(IOException iOException) throws SybConnectionDeadException {
        throw new SybConnectionDeadException(iOException);
    }

    public static void raiseErrorCheckDead(IOException iOException) throws SQLException {
        if (iOException instanceof SybConnectionDeadException) {
            SQLException sQLException = ErrorMessage.createIOEKilledConnEx(iOException);
            throw sQLException;
        }
        if (iOException instanceof InterruptedIOException || iOException.toString().indexOf(ERR_READ_TIMEOUT) != -1) {
            SQLException sQLException = new SQLException(ErrorMessage.a(true, ERR_READ_TIMEOUT_SQLEX), ERR_READ_TIMEOUT_SQLEX);
            ErrorMessage.raiseError(ERR_IO_EXCEPTION, iOException.toString(), sQLException);
        } else {
            ErrorMessage.raiseError(ERR_IO_EXCEPTION, iOException.toString());
        }
    }

    public static void raiseErrorCheckDead(IOException iOException, SQLException sQLException) throws SQLException {
        if (iOException instanceof SybConnectionDeadException) {
            SQLException sQLException2 = ErrorMessage.createIOEKilledConnEx(iOException);
            sQLException2.setNextException(sQLException);
            throw sQLException2;
        }
        if (iOException instanceof InterruptedIOException || iOException.toString().indexOf(ERR_READ_TIMEOUT) != -1) {
            SQLException sQLException3 = new SQLException(ErrorMessage.a(true, ERR_READ_TIMEOUT_SQLEX), ERR_READ_TIMEOUT_SQLEX);
            sQLException.setNextException(sQLException3);
            ErrorMessage.raiseError(ERR_IO_EXCEPTION, iOException.toString(), sQLException);
        } else {
            ErrorMessage.raiseError(ERR_IO_EXCEPTION, iOException.toString(), sQLException);
        }
    }

    public static void raiseRuntimeException(String string, String[] stringArray) throws RuntimeException {
        String string2 = ErrorMessage.a(false, string, stringArray);
        if (string.equals(ERR_NOT_SUPPORTED)) {
            throw new UnsupportedOperationException(string2);
        }
        if (string.equals(ERR_NOT_IMPLEMENTED)) {
            throw new UnimplementedOperationException(string2);
        }
        if (string.equals(ERR_ASSERT_FAILED)) {
            RuntimeException runtimeException = new RuntimeException(string2);
            Debug.printStackTrace(null, runtimeException);
            throw runtimeException;
        }
        if (string.equals(WARN_ASSERT_FAILED)) {
            Debug.println(string2);
        }
    }

    public static SQLException makeIOReportableException(String string, Exception exception) {
        String string2 = ErrorMessage.a(true, string);
        if (exception != null) {
            string2 = string2 + ": " + exception.toString();
        }
        return new SQLException(string2, string);
    }

    public static void raiseBatchUpdateException(SQLException sQLException, int[] nArray) throws BatchUpdateException {
        BatchUpdateException batchUpdateException = sQLException instanceof SybSQLException ? new SybBatchUpdateException((SybSQLException)sQLException, ErrorMessage.a(true, ERR_BATCH_UPDATE_EXCEPTION, sQLException.getMessage()), ERR_BATCH_UPDATE_EXCEPTION, 0, nArray) : new BatchUpdateException(ErrorMessage.a(true, ERR_BATCH_UPDATE_EXCEPTION, sQLException.getMessage()), ERR_BATCH_UPDATE_EXCEPTION, 0, nArray);
        batchUpdateException.setNextException(sQLException);
        throw batchUpdateException;
    }

    public static void raiseGSSError(GSSException gSSException) throws SQLException {
        String[] stringArray = new String[4];
        stringArray[1] = gSSException.getMajorString();
        if (stringArray[1] == null) {
            stringArray[1] = "";
        }
        stringArray[3] = gSSException.getMinorString();
        if (stringArray[3] == null) {
            stringArray[3] = "";
        }
        stringArray[0] = String.valueOf(gSSException.getMajor());
        stringArray[2] = String.valueOf(gSSException.getMinor());
        SQLException sQLException = new SQLException(ErrorMessage.a(true, ERR_GSS_EXCEPTION, stringArray), ERR_GSS_EXCEPTION);
        throw sQLException;
    }

    public static void print(String string, String string2) {
        System.out.println(ErrorMessage.a(false, string, string2));
    }

    private static String a(boolean bl, String string, String[] stringArray) {
        String string2 = ErrorMessage.if(bl, string);
        if (stringArray != null) {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                string2 = ErrorMessage.a(string, string2, i2 + 1, stringArray[i2]);
            }
        }
        return string2;
    }

    private static String a(boolean bl, String string) {
        String string2 = ErrorMessage.if(bl, string);
        return string2;
    }

    private static String a(boolean bl, String string, String string2) {
        String string3 = ErrorMessage.if(bl, string);
        string3 = ErrorMessage.a(string, string3, 1, string2);
        return string3;
    }

    private static String a(boolean bl, String string, String string2, String string3) {
        String string4 = ErrorMessage.if(bl, string);
        string4 = ErrorMessage.a(string, string4, 1, string2);
        string4 = ErrorMessage.a(string, string4, 2, string3);
        return string4;
    }

    private static String a(boolean bl, String string, String string2, String string3, String string4) {
        String string5 = ErrorMessage.if(bl, string);
        string5 = ErrorMessage.a(string, string5, 1, string2);
        string5 = ErrorMessage.a(string, string5, 2, string3);
        string5 = ErrorMessage.a(string, string5, 3, string4);
        return string5;
    }

    private static String if(boolean bl, String string) {
        String string2;
        try {
            string2 = a.getString(string);
            if (bl) {
                string2 = string + ": " + string2;
            }
        }
        catch (Exception exception) {
            string2 = "Internal error, missing message for: " + string + " exception: " + exception.toString();
        }
        return string2;
    }

    private static String a(String string, String string2, int n2, String string3) {
        String string4 = "%" + n2 + "s";
        int n3 = string2.indexOf(string4);
        String string5 = string2;
        if (n3 == -1) {
            if (string5.indexOf(ErrorMessage.a(false, ERR_BAD_COOKIE_MESSAGE)) == -1) {
                string5 = string5.concat(ErrorMessage.a(false, ERR_BAD_COOKIE_MESSAGE));
            }
            string5 = string5.concat(ErrorMessage.a(false, ERR_BAD_COOKIE, "" + n2, string3));
            return string5;
        }
        int n4 = n3 + string4.length();
        string5 = string2.substring(0, n3) + string3 + string2.substring(n4);
        return string5;
    }

    static {
        try {
            a = ResourceBundle.getBundle("com.sybase.jdbc4.jdbc.resource.Messages", Language.getLocale());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

