/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.tds;

import java.util.Enumeration;
import java.util.Hashtable;

public class Iana {
    protected static final String UNSUPPORTED_CHARSET = "UnsupportedCharset";
    private static final Hashtable a = new Hashtable();

    public static String lookupIana(String string) {
        Object v2 = a.get(string);
        if (v2 == null) {
            return UNSUPPORTED_CHARSET;
        }
        return v2.toString();
    }

    public static String reverseLookupIana(String string) {
        if (a.contains(string)) {
            Enumeration enumeration = a.keys();
            String string2 = null;
            while (enumeration.hasMoreElements()) {
                string2 = enumeration.nextElement().toString();
                String string3 = a.get(string2).toString();
                if (!string3.equals(string)) continue;
                return string2;
            }
        }
        return UNSUPPORTED_CHARSET;
    }

    public static boolean truncationConversionOK(String string) {
        String string2 = Iana.lookupIana(string);
        if (string.equals(string2)) {
            return true;
        }
        if ("cp037".equals(string2)) {
            return false;
        }
        return false;
    }

    public static Hashtable getConversionMap() {
        return a;
    }

    static {
        a.put("iso_1", "ISO8859_1");
        a.put("ascii_7", "ASCII");
        a.put("cp1252", "Cp1252");
        a.put("cp850", "Cp850");
        a.put("cp437", "Cp437");
        a.put("mac", "MacRoman");
        a.put("roman8", "hp-roman8");
        a.put("unknown", UNSUPPORTED_CHARSET);
        a.put("cp037", "Cp037");
        a.put("big5", "Big5");
        a.put("big5hk", "Big5_HKSCS");
        a.put("iso88592", "ISO8859_2");
        a.put("iso88595", "ISO8859_5");
        a.put("iso88596", "ISO8859_6");
        a.put("iso88597", "ISO8859_7");
        a.put("iso88598", "ISO8859_8");
        a.put("iso88599", "ISO8859_9");
        a.put("iso15", "ISO8859_15_FDIS");
        a.put("cp852", "Cp852");
        a.put("ibm420", "Cp420");
        a.put("cp500", "Cp500");
        a.put("cp855", "Cp855");
        a.put("cp857", "Cp857");
        a.put("cp860", "Cp860");
        a.put("cp863", "Cp863");
        a.put("cp864", "Cp864");
        a.put("cp869", "Cp869");
        a.put("ibm918", "Cp918");
        a.put("koi8", "KOI8_R");
        a.put("cp866", "Cp866");
        a.put("cp1250", "Cp1250");
        a.put("cp1251", "Cp1251");
        a.put("cp1253", "Cp1253");
        a.put("cp1254", "Cp1254");
        a.put("cp1255", "Cp1255");
        a.put("cp1256", "Cp1256");
        a.put("cp1257", "Cp1257");
        a.put("cp1258", "Cp1258");
        a.put("cp874", "Cp874");
        a.put("tis620", "MS874");
        a.put("mac_cyr", "MacCyrillic");
        a.put("mac_ee", "MacCentralEurope");
        a.put("macgreek", "MacGreek");
        a.put("macturk", "MacTurkish");
        a.put("sjis", "MS932");
        a.put("eucjis", "EUC_JP");
        a.put("deckanji", "EUC_JP");
        a.put("utf8", "UTF8");
        a.put("cp932", "MS932");
        a.put("cp936", "GBK");
        a.put("eucgb", "EUC_CN");
        a.put("eucksc", "EUC_KR");
        a.put("cp950", "Cp950");
        a.put("cp949", "Cp949");
        a.put("gb18030", "GB18030");
        a.put("euccns", "EUC_TW");
        a.put("ucs2", "Unicode");
    }
}

