/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.tds;

import com.sybase.jdbc4.jdbc.SybProperty;
import com.sybase.jdbc4.tds.DataFormat;
import com.sybase.jdbc4.tds.RowDataFormat2;
import com.sybase.jdbc4.tds.RowFormatToken;
import com.sybase.jdbc4.tds.Tds;
import com.sybase.jdbc4.tds.TdsInputStream;
import java.io.IOException;
import java.sql.SQLException;

public class RowFormat2Token
extends RowFormatToken {
    private int aD = -1;

    public RowFormat2Token(int n2) throws SQLException {
        this._numUserColumns = n2;
        this._numColumns = n2;
        this._column = new RowDataFormat2[this._numColumns];
    }

    public RowFormat2Token() throws SQLException {
        this._numColumns = 0;
        this._column = new RowDataFormat2[this._numColumns];
    }

    public RowFormat2Token(TdsInputStream tdsInputStream) throws IOException {
        super(tdsInputStream);
    }

    public RowFormat2Token(TdsInputStream tdsInputStream, long l2) throws IOException {
        super(tdsInputStream, l2);
    }

    @Override
    protected DataFormat dataFormatFactory(TdsInputStream tdsInputStream) throws IOException {
        return new RowDataFormat2(tdsInputStream);
    }

    @Override
    protected long readLength(TdsInputStream tdsInputStream) throws IOException {
        long l2 = tdsInputStream.readUnsignedIntAsLong();
        return l2;
    }

    @Override
    protected String getLabel(int n2) throws SQLException {
        return ((RowDataFormat2)this.getDataFormat(n2)).getLabelName();
    }

    protected String getDBOwnerName(int n2) throws SQLException {
        return ((RowDataFormat2)this.getDataFormat(n2)).getSchemaName();
    }

    @Override
    public String getColumnLabel(int n2) throws SQLException {
        int n3 = this.mapColumn(n2);
        return this.getLabel(n3);
    }

    @Override
    public String getColumnName(int n2) throws SQLException {
        if (this.aD == -1 && this.w()) {
            this.aD = 1;
        }
        if (this.aD == 1) {
            return this.getColumnLabel(n2);
        }
        return this.getName(this.mapColumn(n2));
    }

    private boolean w() throws SQLException {
        SybProperty sybProperty = ((Tds)this._tpc._protocol).getSybProperty();
        return sybProperty.getBoolean(65);
    }

    @Override
    public String getSchemaName(int n2) throws SQLException {
        int n3 = this.mapColumn(n2);
        String string = this.getDBOwnerName(n3);
        return string;
    }

    @Override
    public String getTableName(int n2) throws SQLException {
        int n3 = this.mapColumn(n2);
        return ((RowDataFormat2)this.getDataFormat(n3)).getTableName();
    }

    @Override
    public String getCatalogName(int n2) throws SQLException {
        int n3 = this.mapColumn(n2);
        return ((RowDataFormat2)this.getDataFormat(n3)).getCatalogName();
    }

    @Override
    public String getColumnTypeName(int n2) throws SQLException {
        int n3 = this.mapColumn(n2);
        int n4 = this.getDataFormat((int)n3)._datatype;
        String string = this.getCatalogName(n2);
        n4 = super.getColumnDataType(n4, n3);
        return ((Tds)this._tpc._protocol).getColumnTypeName(n4, this._column[n3]._usertype, string);
    }
}

