/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.timedio;

import com.sybase.jdbc4.jdbc.Protocol;
import com.sybase.jdbc4.jdbc.ProtocolContext;
import com.sybase.jdbc4.timedio.InStreamMgr;
import com.sybase.jdbc4.timedio.OutStreamMgr;
import com.sybase.jdbc4.timedio.RequestObj;
import com.sybase.jdbc4.timedio.ResponseQueue;
import com.sybase.jdbc4.utils.BufferInterval;
import java.io.IOException;
import java.sql.SQLException;

public abstract class StreamContext
extends ProtocolContext {
    protected int _state;
    protected int _pduState;
    protected ResponseQueue _responseQue;
    protected RequestObj _request;
    protected InStreamMgr _inMgr;

    public StreamContext(Protocol protocol, InStreamMgr inStreamMgr, OutStreamMgr outStreamMgr) {
        super(protocol);
        this._inMgr = inStreamMgr;
        this._state = 1;
        this._request = new RequestObj(outStreamMgr.getWaitQueue());
        this._responseQue = new ResponseQueue(inStreamMgr.getReadQueue(), 10);
    }

    protected void refreshYourself(Protocol protocol, InStreamMgr inStreamMgr, OutStreamMgr outStreamMgr) {
        this._inMgr = inStreamMgr;
        this._state = 1;
        this._request = new RequestObj(outStreamMgr.getWaitQueue());
        this._responseQue = new ResponseQueue(inStreamMgr.getReadQueue(), 10);
    }

    protected abstract void close(boolean var1);

    protected abstract void chainException(SQLException var1);

    protected abstract void beginRequest() throws SQLException;

    protected abstract BufferInterval queueData(BufferInterval var1);

    @Override
    public void setSponsor(ProtocolContext protocolContext) {
        if (protocolContext != null) {
            StreamContext streamContext = (StreamContext)protocolContext;
            this._request._guestOf = streamContext._request;
        } else {
            this._request._guestOf = null;
        }
    }

    protected int responseState() {
        return this._pduState;
    }

    protected abstract void cancelled();

    protected BufferInterval makeChunk(BufferInterval bufferInterval, int n2, boolean bl) {
        if (n2 == 0) {
            return bufferInterval;
        }
        BufferInterval bufferInterval2 = null;
        if (n2 < bufferInterval._length) {
            bufferInterval2 = bufferInterval.divide(n2);
        } else {
            bufferInterval2 = bufferInterval;
            bufferInterval = null;
        }
        if (bufferInterval2 != null) {
            if (bl) {
                bufferInterval2.free();
            } else {
                this._responseQue.push(bufferInterval2);
            }
        }
        return bufferInterval;
    }

    protected void setState(int n2) {
        this._state = n2;
    }

    @Override
    public int getState() {
        return this._state;
    }

    protected int getTimeUntilTimeout() throws IOException {
        return this._timeout;
    }

    @Override
    public int getTimeLeft() {
        return this._timeout;
    }
}

