/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util.ds;

import com.sybase.util.ds.Settings;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class Utils {
    private static final String STR_WINDOWS = "Windows";
    public static final String OS_NAME = System.getProperty("os.name");
    public static final boolean OS_WINDOWS = OS_NAME.indexOf("Windows") != -1;
    private static Hashtable _hostIPs = new Hashtable();

    public static File getSybaseDir() {
        File file = null;
        String string = "SYBASE";
        String string2 = System.getProperty("sybase.home");
        if (string2 == null && (string2 = Utils.getEnVariable(string)) == null) {
            return file;
        }
        File file2 = new File(string2);
        if (file2.isDirectory()) {
            file = file2;
        }
        return file;
    }

    public static String getSybasePath() {
        String string = null;
        File file = Utils.getSybaseDir();
        if (file != null) {
            string = Utils.getCanonicalPath(file);
        }
        return string;
    }

    public static String getCanonicalPath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException iOException) {
            return file.getAbsolutePath();
        }
    }

    public static String getOCSPath() {
        String string = "SYBASE_OCS";
        String string2 = System.getProperty("ocs.home");
        if (string2 == null) {
            string2 = Utils.getEnVariable(string);
        }
        return string2;
    }

    public static String getEnVariable(String string) {
        String string2 = null;
        if (OS_WINDOWS) {
            try {
                Process process = null;
                process = OS_NAME.indexOf("9") != -1 ? Runtime.getRuntime().exec("command /c echo %" + string + "%") : Runtime.getRuntime().exec("cmd /c echo %" + string + "%");
                InputStream inputStream = process.getInputStream();
                byte[] byArray = new byte[10240];
                int n = inputStream.read(byArray);
                while (n != -1) {
                    string2 = new String(byArray, 0, n);
                    n = inputStream.read(byArray);
                }
                process.destroy();
            }
            catch (IOException iOException) {
                string2 = null;
            }
            if (string2 != null && string2.indexOf("%") != -1) {
                string2 = null;
            }
        } else {
            String[] stringArray = new String[]{"env"};
            Runtime runtime = Runtime.getRuntime();
            try {
                String string3;
                Process process = runtime.exec(stringArray);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                while ((string3 = bufferedReader.readLine()) != null) {
                    if (string3.indexOf(string + "=") != 0) continue;
                    string2 = string3.substring(string.length() + 1);
                }
                bufferedReader.close();
            }
            catch (IOException iOException) {
                string2 = null;
            }
        }
        return string2 != null ? string2.trim() : string2;
    }

    public static String getHostAndPort(String string, String string2) {
        int n = -1;
        try {
            n = Integer.valueOf(string2);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return Utils.getHostAndPort(string, n);
    }

    public static String getHostAndPort(String string, int n) {
        String string2 = "";
        if (string != null && string.length() > 0) {
            string2 = string2 + string;
            if (n >= 0) {
                string2 = string2 + ":" + n;
            }
        }
        return string2;
    }

    public static String getIP(String string) {
        if (string == null) {
            return null;
        }
        Object v = _hostIPs.get(string);
        if (v != null) {
            return v.toString();
        }
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            String string2 = inetAddress.getHostAddress();
            _hostIPs.put(string, string2);
            return string2;
        }
        catch (UnknownHostException unknownHostException) {
            return string;
        }
    }

    public static String getIPAndPort(String string, String string2) {
        return Utils.getHostAndPort(Utils.getIP(string), string2);
    }

    public static boolean sameHost(String string, String string2) {
        return Utils.getIP(string).equals(Utils.getIP(string2));
    }

    public static String[] getChildrenNames(Preferences preferences) {
        String[] stringArray = null;
        try {
            stringArray = preferences.childrenNames();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
        return stringArray;
    }

    public static void removeNode(Preferences preferences) {
        try {
            preferences.removeNode();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    public static void setInitialColumnWidths(JTable jTable) {
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        int n = jTable.getModel().getColumnCount();
        int n2 = jTable.getPreferredScrollableViewportSize().height;
        int n3 = n2 / jTable.getRowHeight();
        int n4 = jTable.getRowCount();
        int n5 = Math.min(n4, n3);
        if (n5 < 20 && n4 >= 20) {
            n5 = 20;
        }
        for (int i = 0; i < n; ++i) {
            Object object;
            TableCellRenderer tableCellRenderer;
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            int n6 = 0;
            JTableHeader jTableHeader = jTable.getTableHeader();
            if (jTableHeader != null) {
                tableCellRenderer = jTableHeader.getDefaultRenderer();
                object = tableColumn.getHeaderValue();
                if (object != null) {
                    try {
                        n6 = tableCellRenderer.getTableCellRendererComponent((JTable)jTable, (Object)object, (boolean)false, (boolean)false, (int)-1, (int)0).getPreferredSize().width;
                    }
                    catch (Exception exception) {
                        return;
                    }
                }
            }
            for (int j = 0; j < n5; ++j) {
                tableCellRenderer = jTable.getCellRenderer(j, i);
                object = jTable.getModel().getValueAt(j, i);
                if (object == null && j >= (n5 = Math.min(jTable.getRowCount(), 10))) break;
                int n7 = tableCellRenderer.getTableCellRendererComponent((JTable)jTable, (Object)object, (boolean)false, (boolean)false, (int)j, (int)i).getPreferredSize().width;
                n6 = Math.max(n6, n7);
            }
            tableColumn.setPreferredWidth(n6 + jTable.getIntercellSpacing().width);
        }
        jTable.sizeColumnsToFit(-1);
    }

    public static boolean getEnableServerDiscovery() {
        return Settings.getEnableServerDiscovery();
    }

    public static boolean isNormalPath(String string) {
        return string != null && string.length() > 0 && string.indexOf("..") < 0;
    }

    public static boolean isExistingFile(String string) {
        if (!Utils.isNormalPath(string)) {
            return false;
        }
        File file = new File(string);
        return file.isFile();
    }

    public static File getExistingFile(String string) throws FileNotFoundException {
        if (!Utils.isExistingFile(string)) {
            throw new FileNotFoundException();
        }
        return new File(string);
    }

    public static FileInputStream getFileInputStream(String string) throws FileNotFoundException {
        if (!Utils.isExistingFile(string)) {
            throw new FileNotFoundException();
        }
        return new FileInputStream(string);
    }

    public static FileOutputStream getFileOutputStream(String string) throws FileNotFoundException {
        if (!Utils.isExistingFile(string)) {
            throw new FileNotFoundException();
        }
        return new FileOutputStream(string);
    }

    public static String encryptPassword(String string) {
        String string2 = "";
        for (int i = 0; i < string.length(); ++i) {
            string2 = string2 + (char)(string.charAt(i) + i);
        }
        return string2;
    }

    public static String decryptPassword(String string) {
        String string2 = "";
        for (int i = 0; i < string.length(); ++i) {
            string2 = string2 + (char)(string.charAt(i) - i);
        }
        return string2;
    }
}

