/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util.ds.interfaces;

import com.sybase.util.ds.interfaces.Service;
import com.sybase.util.ds.interfaces.SyInterfacesDriverBase;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SyInterfacesEntry
extends SyInterfacesDriverBase {
    private String _entryName;
    private ArrayList _servicesList;

    public SyInterfacesEntry(String string) {
        this.setName(string);
        this._servicesList = new ArrayList();
    }

    public void setName(String string) {
        this._entryName = string.trim();
    }

    public String getName() {
        return this._entryName;
    }

    public String getValue(String string) {
        for (int i = 0; i < this._servicesList.size(); ++i) {
            Service service = (Service)this._servicesList.get(i);
            if (!service.hasPort() || !service.isType(string)) continue;
            service.setFormat(this._format);
            return service.getValue();
        }
        return null;
    }

    private Service getService(String string) {
        for (int i = 0; i < this._servicesList.size(); ++i) {
            Service service = (Service)this._servicesList.get(i);
            if (!service.hasPort() || !service.isType(string)) continue;
            return service;
        }
        return null;
    }

    public List getServices(String string) {
        ArrayList<Service> arrayList = new ArrayList<Service>();
        for (int i = 0; i < this._servicesList.size(); ++i) {
            Service service = (Service)this._servicesList.get(i);
            if (!service.isType(string)) continue;
            arrayList.add(service);
        }
        return arrayList;
    }

    public void addService(Service service) {
        this._servicesList.add(service);
    }

    protected void setServices(List list) {
        this._servicesList.clear();
        this._servicesList.addAll(list);
    }

    public List getServices() {
        return this._servicesList;
    }

    private String getQueryKeyValue() {
        String string = this.getValue("query");
        if (string != null && string.toLowerCase().startsWith("$base")) {
            int n = string.indexOf(59);
            if (n >= 0) {
                String string2 = string.substring(n + 1, string.length()).toLowerCase();
                if ((n = string2.indexOf(59)) >= 0) {
                    string2 = string2.substring(0, n);
                }
                string = this.getValue(string2);
            } else {
                string = null;
            }
        }
        return string;
    }

    public String getPort() {
        Service service = this.getService("query");
        if (service != null) {
            return service.getPort();
        }
        return null;
    }

    public String getFilter() {
        Service service = this.getService("query");
        if (service != null) {
            return service.getFilter();
        }
        return null;
    }

    public boolean isSSL() {
        Service service = this.getService("query");
        if (service != null) {
            return service.isSSL();
        }
        return false;
    }

    public String getHost() {
        Service service = this.getService("query");
        if (service == null) {
            service = this.getService("master");
        }
        if (service != null) {
            return service.getHost();
        }
        return null;
    }

    public boolean bind() {
        if (this.findSubjectLine(this._entryName) != -1) {
            List list = this.getServices(this._entryName);
            this._servicesList.addAll(list);
            return true;
        }
        return false;
    }

    public String toString() {
        String string = this._entryName + "\n";
        List list = this.getServices();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Service service = (Service)iterator.next();
            string = string + service.toString();
            string = string + "\n";
        }
        return string;
    }
}

