/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util.ds.ldap;

import com.sybase.util.ds.Utils;
import com.sybase.util.ds.ldap.LDAPConfigFileParser;
import com.sybase.util.ds.ldap.LDAPException;
import com.sybase.util.ds.ldap.SyLDAPServer;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import java.util.Vector;

public class LibctlDriver {
    private Vector _lines;
    private String _fileName;
    private String _fileName64;
    private LDAPConfigFileParser _ldapConfigFileParser;
    private Vector _ldapServerNamesList = new Vector();
    private Vector _syLDAPServers = new Vector();
    private String[] _ldapServerNames;
    private final String LIBTCL = "libtcl.cfg";
    private final String LIBTCL64 = "libtcl64.cfg";
    private final String CONFIG = "config";
    private final String SYBASE_TCL_CFG = "SYBASE_TCL_CFG";
    private final String INI = "ini";
    private final String _smallLDAP = "ldap://";
    private final String _bigLDAP = "LDAP://";
    private final String _smallLDAPS = "ldaps://";
    private final String _bigLDAPS = "LDAPS://";

    public LibctlDriver() throws FileNotFoundException, IOException, SecurityException, LDAPException {
        String string = Utils.getEnVariable("SYBASE_TCL_CFG");
        if (Utils.isExistingFile(string)) {
            this._fileName = string;
            this.parseFile(this._fileName);
            return;
        }
        Properties properties = System.getProperties();
        String string2 = Utils.getSybasePath();
        String string3 = Utils.getOCSPath();
        String string4 = properties.getProperty("file.separator");
        boolean bl = false;
        if (string2 == null) {
            throw new LDAPException("ERR_SYBASE_ENV_NOT_DEFINED", "MSG_LDAP_CONFIG");
        }
        if (string2.equals("")) {
            throw new LDAPException("ERR_SYBASE_ENV_DEFINED_BLANK", "MSG_LDAP_CONFIG");
        }
        if (string3 == null) {
            throw new LDAPException("ERR_OCS_HOME_ENV_NOT_DEFINED");
        }
        if (string3.equals("")) {
            throw new LDAPException("ERR_OCS_HOME_ENV_DEFINED_BLANK");
        }
        string = string2 + string4 + string3 + string4;
        string = Utils.OS_WINDOWS ? string + "ini" + string4 : string + "config" + string4;
        this._fileName = string + "libtcl.cfg";
        this._fileName64 = string + "libtcl64.cfg";
        if (Utils.isExistingFile(this._fileName)) {
            this.parseFile(this._fileName);
            bl = true;
        }
        if (Utils.isExistingFile(this._fileName64)) {
            this.parseFile(this._fileName64);
            bl = true;
        }
        if (!bl) {
            LDAPException lDAPException = new LDAPException("ERR_LDAP_FILE_NOT_FOUND");
            throw new FileNotFoundException(lDAPException.getMessage());
        }
    }

    public LibctlDriver(String string) throws FileNotFoundException, IOException, SecurityException, LDAPException {
        this._fileName = string;
        this.parseFile(string);
    }

    private void parseFile(String string) throws FileNotFoundException, SecurityException, IOException, LDAPException {
        try {
            URL uRL = new URL(string);
            this._ldapConfigFileParser = new LDAPConfigFileParser();
            if (!this._ldapConfigFileParser.probe(uRL)) {
                throw new LDAPException("ERR_FORMAT_ERROR", "MSG_LDAP_CONFIG", string);
            }
            this.loadFile(uRL);
        }
        catch (MalformedURLException malformedURLException) {
            if (!Utils.isExistingFile(string)) {
                this._fileName = null;
                LDAPException lDAPException = new LDAPException("ERR_LDAP_FILE_NOT_FOUND");
                throw new FileNotFoundException(lDAPException.getMessage());
            }
            this._ldapConfigFileParser = new LDAPConfigFileParser();
            if (!this._ldapConfigFileParser.probe(string)) {
                this._fileName = null;
                throw new LDAPException("ERR_FORMAT_ERROR", "MSG_LDAP_CONFIG", string);
            }
            this.loadFile(string);
        }
        this.parseLines();
    }

    public void loadFile(URL uRL) throws IOException {
        InputStream inputStream = uRL.openStream();
        this.loadFile(inputStream);
    }

    public void loadFile(String string) throws IOException {
        this.loadFile(Utils.getFileInputStream(string));
    }

    public void loadFile(InputStream inputStream) throws IOException {
        this._lines = new Vector();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String string = "";
        while ((string = bufferedReader.readLine()) != null) {
            this._lines.addElement(string);
        }
        bufferedReader.close();
    }

    private void parseLines() throws LDAPException {
        String string = null;
        for (int i = 0; i < this._lines.size(); ++i) {
            string = (String)this._lines.elementAt(i);
            if (this._ldapConfigFileParser.isBlankLine(string) || this._ldapConfigFileParser.isCommentLine(string) || !this.isaSubject(string)) continue;
            this.parseLDAPLine(string);
        }
        this.fillLDAPServerNames();
    }

    private void parseLDAPLine(String string) throws LDAPException {
        try {
            String string2;
            if (string.indexOf("ldap://") != -1) {
                string2 = "ldap://";
            } else if (string.indexOf("ldaps://") != -1) {
                string2 = "ldaps://";
            } else if (string.indexOf("LDAP://") != -1) {
                string2 = "LDAP://";
            } else if (string.indexOf("LDAPS://") != -1) {
                string2 = "LDAPS://";
            } else {
                throw new LDAPException("ERR_LDAP_FILE_IS_CORRUPT");
            }
            String string3 = string.substring(string.indexOf(string2) + string2.length());
            String string4 = "";
            string4 = string2.toLowerCase().equals("ldap://") ? "ldap://" + string3 : "ldaps://" + string3;
            String string5 = string3.substring(0, string3.indexOf("/"));
            this._ldapServerNamesList.addElement(string5);
            int n = string5.indexOf(":");
            String string6 = n != -1 ? string5.substring(0, n).trim() : string5;
            String string7 = null;
            if (string5 != null && n != -1) {
                string7 = string5.substring(n + 1).trim();
            }
            SyLDAPServer syLDAPServer = new SyLDAPServer(string5, string6, string7, string4);
            this._syLDAPServers.addElement(syLDAPServer);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new LDAPException("ERR_LDAP_FILE_IS_CORRUPT");
        }
        catch (NullPointerException nullPointerException) {
            throw new LDAPException("ERR_LDAP_FILE_IS_CORRUPT");
        }
    }

    private void fillLDAPServerNames() {
        this._ldapServerNames = new String[this._ldapServerNamesList.size()];
        this._ldapServerNamesList.copyInto(this._ldapServerNames);
    }

    public String[] getLDAPServerNames() {
        return (String[])this._ldapServerNames.clone();
    }

    public Vector getLDAPServers() {
        return (Vector)this._syLDAPServers.clone();
    }

    public boolean containsLDAPServerName(String string) {
        for (int i = 0; i < this._ldapServerNames.length; ++i) {
            if (!string.equals(this._ldapServerNames[i])) continue;
            return true;
        }
        return false;
    }

    public SyLDAPServer getLDAPServer(String string) {
        for (int i = 0; i < this._syLDAPServers.size(); ++i) {
            if (!string.equals(((SyLDAPServer)this._syLDAPServers.elementAt(i)).getServerName())) continue;
            return (SyLDAPServer)this._syLDAPServers.elementAt(i);
        }
        return null;
    }

    private boolean isaSubject(String string) {
        return this._ldapConfigFileParser.isaSubject(string);
    }

    protected int findSubjectLine(String string) {
        String string2 = "[" + string + "]";
        for (int i = 0; i < this._lines.size(); ++i) {
            String string3 = (String)this._lines.elementAt(i);
            if (!string2.equals(string3)) continue;
            return i;
        }
        return -1;
    }

    public String getLDAP32FileName() {
        return this._fileName;
    }

    public String getLDAP64FileName() {
        return this._fileName64;
    }
}

