/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util.ds.ui;

import com.sybase.util.ds.Utils;
import com.sybase.util.ds.ui.BaseDialog;
import com.sybase.util.ds.ui.NewPasswordPage;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class NewPasswordDialog
extends BaseDialog
implements DocumentListener {
    private NewPasswordPage _page;
    private String _oldEncryptedPassword;
    private String _newEncryptedPassword;

    public NewPasswordDialog(JDialog jDialog, String string) {
        super(jDialog);
        this._oldEncryptedPassword = Utils.encryptPassword(string);
    }

    public NewPasswordDialog(JFrame jFrame, String string) {
        super(jFrame);
        this._oldEncryptedPassword = Utils.encryptPassword(string);
    }

    public String create() {
        this.setVisible(this.createUI());
        this.destroyUI();
        return this._newEncryptedPassword == null ? null : Utils.decryptPassword(this._newEncryptedPassword);
    }

    private boolean createUI() {
        this._page = new NewPasswordPage();
        if (this._newEncryptedPassword != null) {
            this._page.newPasswordField.setText(Utils.decryptPassword(this._newEncryptedPassword));
            this._page.newPasswordField.selectAll();
            this._page.newPasswordField.requestFocus();
        }
        this._page.newPasswordField.getDocument().addDocumentListener(this);
        this._page.confirmPasswordField.getDocument().addDocumentListener(this);
        String string = _res.get("CHANGE_PASSWORD");
        super.createUI((JPanel)((Object)this._page), string);
        this._okButton.setEnabled(false);
        return true;
    }

    void destroyUI() {
        super.destroyUI();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.textValueChanged();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.textValueChanged();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.textValueChanged();
    }

    void textValueChanged() {
        this._okButton.setEnabled(!this.getNewPassword().equals(Utils.decryptPassword(this._oldEncryptedPassword)) && this.getNewPassword().equals(this.getConfirmPassword()) && this.getNewPassword().length() > 0);
    }

    String getNewPassword() {
        return new String(this._page.newPasswordField.getPassword());
    }

    public void setNewPassword(String string) {
        this._newEncryptedPassword = Utils.encryptPassword(string);
    }

    String getConfirmPassword() {
        return new String(this._page.confirmPasswordField.getPassword());
    }

    void handleOK() {
        this.setVisible(false);
        this._newEncryptedPassword = Utils.encryptPassword(this.getNewPassword());
    }

    void handleCancel() {
        this.setVisible(false);
        this._newEncryptedPassword = null;
    }
}

