/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util.ds.ui;

import com.sybase.util.ds.ui.BaseDialog;
import com.sybase.util.ds.ui.GeneralPage;
import com.sybase.util.ds.ui.LDAPPage;
import com.sybase.util.ds.ui.ServerDiscoveryPage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SettingsDialog
extends BaseDialog
implements ChangeListener,
MouseListener {
    private JTabbedPane _tabbedPane = null;
    private ServerDiscoveryPage _serverDiscoveryPage = null;
    private LDAPPage _ldapPage = null;
    private GeneralPage _generalPage = null;
    private List _retcodes = new ArrayList();
    private String _filterId;
    private String _initialPage;
    private boolean _discoveryVisible = true;

    public SettingsDialog(JDialog jDialog) {
        super(jDialog);
        this._filterId = "ASE";
    }

    public SettingsDialog(JDialog jDialog, String string) {
        super(jDialog);
        this._filterId = string;
    }

    public void setInitialPage(String string) {
        this._initialPage = string;
    }

    public void setEnableServerDiscoveryVisible(boolean bl) {
        this._discoveryVisible = bl;
    }

    private int getInitialPageIndex() {
        if (this._initialPage == null || this._tabbedPane == null) {
            return 0;
        }
        for (int i = 0; i < this._tabbedPane.getTabCount(); ++i) {
            if (!this._tabbedPane.getTitleAt(i).equals(this._initialPage)) continue;
            return i;
        }
        return 0;
    }

    public List create() {
        this._retcodes.clear();
        this.setVisible(this.createGUI());
        this.destroyUI();
        return this._retcodes;
    }

    void destroyUI() {
        this._serverDiscoveryPage = null;
        this._tabbedPane = null;
        super.destroyUI();
    }

    private boolean createGUI() {
        this._tabbedPane = new JTabbedPane();
        if (this._filterId.equals("ASE")) {
            this._generalPage = new GeneralPage();
            this._generalPage.init(this);
            this._tabbedPane.addTab(_res.get("GENERAL"), (Component)((Object)this._generalPage));
            this._ldapPage = new LDAPPage();
            this._ldapPage.init(this, this);
            this._ldapPage.enableComponents();
            this._tabbedPane.addTab(_res.get("LDAP"), (Component)((Object)this._ldapPage));
        }
        this._serverDiscoveryPage = new ServerDiscoveryPage(this._filterId);
        this._serverDiscoveryPage.init(this);
        this._serverDiscoveryPage.setParentDialog(this);
        this._serverDiscoveryPage.enableComponents();
        this._serverDiscoveryPage.discoveryCheckBox.setVisible(this._discoveryVisible);
        this._serverDiscoveryPage.serversList.addMouseListener(this);
        this._tabbedPane.addTab(_res.get("SERVER_DISCOVERY"), (Component)((Object)this._serverDiscoveryPage));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this._tabbedPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel.add((Component)this._tabbedPane, "Center");
        this._tabbedPane.setSelectedIndex(this.getInitialPageIndex());
        super.createUI(jPanel, _res.get("SETTINGS_TITLE"));
        return true;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this._serverDiscoveryPage.handleMouseClicked(mouseEvent);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (this._serverDiscoveryPage != null && object == this._serverDiscoveryPage.addButton || object == this._serverDiscoveryPage.editButton || object == this._serverDiscoveryPage.removeButton || object == this._serverDiscoveryPage.upButton || object == this._serverDiscoveryPage.downButton || object == this._serverDiscoveryPage.filtersButton || object == this._serverDiscoveryPage.discoveryCheckBox) {
            this._serverDiscoveryPage.handleActionPerformed(actionEvent);
        } else if (this._ldapPage != null && object == this._ldapPage.ldapCheckBox) {
            this._ldapPage.handleActionPerformed();
        } else if (this._generalPage != null && object == this._generalPage.loginTimeoutCheckBox || object == this._generalPage.saveServersCheckBox) {
            this._generalPage.handleActionPerformed(actionEvent);
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        if (this._ldapPage != null && object == this._ldapPage.timeoutSlider) {
            this._ldapPage.handleStateChanged();
        }
    }

    void handleOK() {
        boolean bl = this.saveSettings();
        if (bl) {
            this.setVisible(false);
        }
    }

    private boolean saveSettings() {
        this._retcodes.clear();
        boolean bl = this._serverDiscoveryPage != null && this._serverDiscoveryPage.getEnableSave();
        boolean bl2 = false;
        if (bl) {
            bl2 = this._serverDiscoveryPage.saveSettings();
        }
        boolean bl3 = this._serverDiscoveryPage != null && this._serverDiscoveryPage.getFilterChanged();
        this._retcodes.add(new Boolean(bl2 || bl3));
        boolean bl4 = this._ldapPage != null && this._ldapPage.getEnableSave();
        boolean bl5 = false;
        if (bl4) {
            bl5 = this._ldapPage.saveSettings();
        }
        this._retcodes.add(new Boolean(bl5));
        boolean bl6 = this._generalPage != null;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = false;
        if (bl6) {
            bl7 = this._generalPage.saveSettings();
            bl8 = this._generalPage.isNumSavedServersChanged();
            bl9 = this._generalPage.clearServersCheckBox.isSelected();
        }
        this._retcodes.add(new Boolean(bl8));
        this._retcodes.add(new Boolean(bl9));
        boolean bl10 = bl && !bl2 || bl4 && !bl5 || bl6 && !bl7;
        return !bl10;
    }

    void handleCancel() {
        this._retcodes.clear();
        this.setVisible(false);
    }

    public boolean isLDAPChanged() {
        if (this._retcodes.size() > 1) {
            Boolean bl = (Boolean)this._retcodes.get(1);
            return bl;
        }
        return false;
    }

    public boolean isNumSavedServersChanged() {
        if (this._retcodes.size() > 2) {
            Boolean bl = (Boolean)this._retcodes.get(2);
            return bl;
        }
        return false;
    }

    public boolean isClearServersSelected() {
        if (this._retcodes.size() > 3) {
            Boolean bl = (Boolean)this._retcodes.get(3);
            return bl;
        }
        return false;
    }
}

