/*
 * Decompiled with CFR 0.152.
 */
package com.ianywhere.errorreporting;

import com.ianywhere.errorreporting.ErrorReport;
import com.ianywhere.errorreporting.ErrorReportingServiceClient;
import com.ianywhere.errorreporting.ExceptionHandler;
import com.ianywhere.errorreporting.SubmitPanel;
import com.sybase.util.SybButton;
import com.sybase.util.SybComboBox;
import com.sybase.util.SybFileChooser;
import com.sybase.util.SybFileFilter;
import com.sybase.util.SybTextArea;
import com.sybase.util.UIUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;

public class ErrorReportViewer
extends JFrame
implements WindowListener,
ActionListener,
DropTargetListener {
    private SybTextArea _report;
    private SybComboBox _fileComboBox;
    private DefaultComboBoxModel _cbModel;
    private SybButton _browse;
    private File _initialFolder = null;

    public static void main(String[] stringArray) {
        UIUtils.installLookAndFeel();
        new ErrorReportViewer().setVisible(true);
    }

    private ErrorReportViewer() {
        int n;
        File[] fileArray = ErrorReportingServiceClient.getUploadFiles("iAnywhere");
        File[] fileArray2 = ErrorReportingServiceClient.getUploadFiles("Sybase");
        HashSet<File> hashSet = new HashSet<File>();
        for (n = 0; n < fileArray.length; ++n) {
            if (fileArray[n].length() <= 0L) continue;
            hashSet.add(fileArray[n]);
        }
        for (n = 0; n < fileArray2.length; ++n) {
            if (fileArray2[n].length() <= 0L) continue;
            hashSet.add(fileArray2[n]);
        }
        File[] fileArray3 = new File[hashSet.size()];
        hashSet.toArray(fileArray3);
        if (fileArray3.length == 0) {
            System.out.println("\nNo error report files found.");
            System.exit(0);
        }
        Arrays.sort(fileArray3, new ErrorReportingServiceClient.FileLastModifiedComparator());
        this.addWindowListener(this);
        this.setTitle("Error Report Viewer");
        this._cbModel = new DefaultComboBoxModel<File>(fileArray3);
        this._fileComboBox = new SybComboBox((ComboBoxModel)this._cbModel);
        this._fileComboBox.addActionListener(this);
        this._report = new SybTextArea();
        this._report.setMinimumSize(new Dimension(200, 200));
        this._report.setEditable(false);
        DropTarget dropTarget = new DropTarget(this._report, this);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add(this._report);
        jScrollPane.getViewport().setBackground(this._report.getBackground());
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        this._browse = new SybButton("&Open...");
        this._browse.addActionListener(this);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel.add((Component)this._fileComboBox, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 10, 0), 0, 0));
        jPanel.add((Component)this._browse, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 5, 10, 0), 0, 0));
        jPanel.add((Component)jScrollPane, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 21, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().add(jPanel);
        this.pack();
        this.setBounds(0, 0, 800, 600);
        this._fileComboBox.setSelectedIndex(0);
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        System.exit(0);
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._fileComboBox) {
            File file = (File)this._fileComboBox.getSelectedItem();
            this.displayFile(file);
        } else if (object == this._browse) {
            this.handleBrowse();
        }
    }

    private void handleBrowse() {
        SybFileChooser sybFileChooser = new SybFileChooser(17);
        SybFileFilter[] sybFileFilterArray = new SybFileFilter[]{new SybFileFilter("xml", "Error files", null), SybFileFilter.getAllFilesFilter()};
        sybFileChooser.setFilters(sybFileFilterArray, 0);
        if (sybFileChooser.showDialog(this, this._initialFolder, null)) {
            File file = sybFileChooser.getSelectedFile();
            this._initialFolder = file.getParentFile();
            if (this._cbModel.getIndexOf(file) == -1) {
                this._cbModel.insertElementAt(file, 0);
            }
            this._fileComboBox.setSelectedItem(file);
            this.displayFile(file);
        }
    }

    private void displayFile(File file) {
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            JAXBContext jAXBContext = JAXBContext.newInstance((String)"com.ianywhere.errorreporting");
            Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = schemaFactory.newSchema(new StreamSource(SubmitPanel.class.getResourceAsStream("/errorreport.xsd")));
            unmarshaller.setSchema(schema);
            ErrorReport errorReport = (ErrorReport)unmarshaller.unmarshal((InputStream)fileInputStream);
            this._report.setText("");
            this._report.append(ExceptionHandler.printBox("Stack Trace", 80));
            this._report.append("\n");
            this._report.append(errorReport.getStackTrace());
            this._report.append("\n");
            this._report.append(errorReport.getErrorLog());
            this._report.append("\n");
            this._report.append(ExceptionHandler.printBox("System Properties", 80));
            this._report.append("\n");
            this._report.append(errorReport.getSystemProperties());
            this._report.append("\n");
            this._report.setCaretPosition(0);
        }
        catch (Exception exception) {
            StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
            this._report.setText("*** Internal Error. File could not be displayed. ***\n" + exception.getClass().getName() + "\n" + exception.getLocalizedMessage() + "\n\nStack trace:\n");
            for (int i = 0; i < stackTraceElementArray.length; ++i) {
                this._report.append(stackTraceElementArray[i].toString());
                this._report.append("\n");
            }
            this._report.setCaretPosition(0);
        }
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        Transferable transferable = dropTargetDropEvent.getTransferable();
        DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
        block3: for (int i = 0; i < dataFlavorArray.length; ++i) {
            if (!dataFlavorArray[i].isFlavorJavaFileListType()) continue;
            dropTargetDropEvent.acceptDrop(3);
            try {
                List list = (List)transferable.getTransferData(dataFlavorArray[i]);
                for (int j = 0; j < list.size(); ++j) {
                    File file = new File(list.get(j).toString());
                    if (file.length() <= 0L) continue;
                    if (this._cbModel.getIndexOf(file) == -1) {
                        this._cbModel.insertElementAt(file, 0);
                    }
                    this._fileComboBox.setSelectedItem(file);
                    this.displayFile(file);
                    break block3;
                }
                continue;
            }
            catch (IOException iOException) {
                continue;
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                // empty catch block
            }
        }
        dropTargetDropEvent.dropComplete(true);
    }
}

