/*
 * Decompiled with CFR 0.152.
 */
package com.ianywhere.errorreporting;

import com.ianywhere.errorreporting.DiagnosticInfo;
import com.ianywhere.errorreporting.ErrorReport;
import com.ianywhere.errorreporting.ExceptionHandler;
import com.sun.org.apache.xml.internal.serialize.OutputFormat;
import com.sun.org.apache.xml.internal.serialize.XMLSerializer;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.zip.DeflaterOutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;

public class ErrorReportingServiceClient {
    static String _clientID = null;

    static String getOperatingSystem() {
        return System.getProperty("os.name") + " on " + System.getProperty("os.arch");
    }

    static final String uploadErrorReport(String string, ErrorReport errorReport) {
        String string2;
        try {
            String string3 = "--------------------" + Long.toString(System.currentTimeMillis(), 16);
            String string4 = "\r\n";
            String string5 = "--";
            URL uRL = new URL(string);
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setDoInput(true);
            uRLConnection.setDoOutput(true);
            uRLConnection.setUseCaches(false);
            uRLConnection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + string3);
            DataOutputStream dataOutputStream = new DataOutputStream(uRLConnection.getOutputStream());
            dataOutputStream.writeBytes(string5);
            dataOutputStream.writeBytes(string3);
            dataOutputStream.writeBytes(string4);
            dataOutputStream.writeBytes("Content-Disposition: form-data; name=\"client_id\"");
            dataOutputStream.writeBytes(string4);
            dataOutputStream.writeBytes(string4);
            if (ErrorReportingServiceClient.getClientID() == null) {
                dataOutputStream.writeBytes("");
            } else {
                dataOutputStream.writeBytes(ErrorReportingServiceClient.getClientID());
            }
            dataOutputStream.writeBytes(string4);
            dataOutputStream.writeBytes(string5);
            dataOutputStream.writeBytes(string3);
            dataOutputStream.writeBytes(string4);
            dataOutputStream.writeBytes("Content-Disposition: form-data; name=\"data\"");
            dataOutputStream.writeBytes(string4);
            dataOutputStream.writeBytes(string4);
            JAXBContext jAXBContext = JAXBContext.newInstance((String)"com.ianywhere.errorreporting");
            Marshaller marshaller = jAXBContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            OutputFormat outputFormat = new OutputFormat();
            outputFormat.setCDataElements(new String[]{"ns1^stack_trace", "ns1^system_properties", "ns1^error_log"});
            outputFormat.setPreserveSpace(true);
            outputFormat.setIndenting(true);
            DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(dataOutputStream);
            XMLSerializer xMLSerializer = new XMLSerializer(outputFormat);
            xMLSerializer.setOutputByteStream(deflaterOutputStream);
            marshaller.marshal((Object)errorReport, xMLSerializer.asContentHandler());
            deflaterOutputStream.finish();
            dataOutputStream.writeBytes(string4);
            dataOutputStream.writeBytes(string5);
            dataOutputStream.writeBytes(string3);
            dataOutputStream.writeBytes(string5);
            dataOutputStream.writeBytes(string4);
            dataOutputStream.flush();
            dataOutputStream.close();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
            StringBuffer stringBuffer = new StringBuffer(1024);
            String string6 = bufferedReader.readLine();
            while (string6 != null) {
                stringBuffer.append(string6);
                string6 = bufferedReader.readLine();
            }
            int n = stringBuffer.indexOf("submission_id=\"");
            if (n <= 0) {
                return null;
            }
            int n2 = stringBuffer.indexOf("\"", n += "submission_id=\"".length());
            string2 = stringBuffer.substring(n, n2);
            if (ErrorReportingServiceClient.getClientID() == null && (n = stringBuffer.indexOf("client_id=\"")) > 0) {
                n2 = stringBuffer.indexOf("\"", n += "client_id=\"".length());
                ErrorReportingServiceClient.setClientID(stringBuffer.substring(n, n2));
            }
        }
        catch (JAXBException jAXBException) {
            return null;
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            return null;
        }
        return string2;
    }

    static String getSubmissionStatus(String string, String string2) {
        String string3 = null;
        try {
            URL uRL = new URL(string);
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setDoInput(true);
            uRLConnection.setDoOutput(true);
            uRLConnection.setUseCaches(false);
            uRLConnection.setRequestProperty("Content-Type", "text/xml");
            PrintStream printStream = new PrintStream(uRLConnection.getOutputStream());
            printStream.print("&submission_id=" + string2);
            if (ErrorReportingServiceClient.getClientID() != null) {
                printStream.print("&client_id=" + ErrorReportingServiceClient.getClientID());
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
            StringBuffer stringBuffer = new StringBuffer(1024);
            String string4 = bufferedReader.readLine();
            while (string4 != null) {
                stringBuffer.append(string4);
                string4 = bufferedReader.readLine();
            }
            int n = stringBuffer.indexOf("response=\"") + "response=\"".length();
            int n2 = stringBuffer.indexOf("\"", n);
            string3 = stringBuffer.substring(n, n2);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string3;
    }

    static final File[] getUploadFiles(String string) {
        File[] fileArray = new File[]{};
        String string2 = ErrorReportingServiceClient.getErrorReportDirectoryName(string);
        File file = new File(string2);
        ExceptionHandler.ErrorFileFilter errorFileFilter = new ExceptionHandler.ErrorFileFilter();
        if (file.exists() && file.isDirectory()) {
            fileArray = file.listFiles(errorFileFilter);
            Arrays.sort(fileArray, new FileLastModifiedComparator());
        }
        return fileArray;
    }

    static String getErrorReportDirectoryName(String string) {
        String string2 = null;
        if (DiagnosticInfo.isInstalled()) {
            string2 = DiagnosticInfo.getDiagnosticDirectory();
        }
        if (string2 == null) {
            String string3;
            String string4;
            if (string == null || string.length() == 0) {
                string2 = System.getProperty("user.home") + System.getProperty("file.separator");
            } else if (System.getProperty("os.name").indexOf("Windows") != -1 && (string4 = System.getProperty("user.home")).endsWith(string3 = System.getProperty("user.name"))) {
                string2 = string4.substring(0, string4.length() - string3.length()) + "All Users" + System.getProperty("file.separator") + "Application Data" + System.getProperty("file.separator") + string + System.getProperty("file.separator");
            }
        } else if (!string2.endsWith(System.getProperty("file.separator"))) {
            string2 = string2 + System.getProperty("file.separator");
        }
        return string2;
    }

    private static ResourceBundle getResourceBundle() {
        ResourceBundle resourceBundle = null;
        String string = System.getProperty("language", System.getProperty("user.language", null));
        String string2 = System.getProperty("country", System.getProperty("user.region", null));
        if (string != null && string2 != null) {
            try {
                resourceBundle = ResourceBundle.getBundle("com.ianywhere.errorreporting.ErrorReportingClientResourceBundle", new Locale(string, string2));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (resourceBundle == null) {
            try {
                resourceBundle = ResourceBundle.getBundle("com.ianywhere.errorreporting.ErrorReportingClientResourceBundle", Locale.getDefault());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (resourceBundle == null) {
            try {
                resourceBundle = ResourceBundle.getBundle("com.ianywhere.errorreporting.ErrorReportingClientResourceBundle");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (resourceBundle == null) {
            throw new MissingResourceException("Can't find resource for base name ianywhere.errorreporting.ErrorReportingClientResourceBundle", "", "");
        }
        return resourceBundle;
    }

    static final String getI18NMessage(String string) {
        String string2 = "";
        try {
            string2 = (String)ErrorReportingServiceClient.getResourceBundle().getObject(string);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return string2;
    }

    static final String getClientID() {
        if (_clientID == null && DiagnosticInfo.isInstalled()) {
            _clientID = DiagnosticInfo.getClientID();
        }
        return _clientID;
    }

    static void setClientID(String string) {
        _clientID = string;
        if (DiagnosticInfo.isInstalled()) {
            DiagnosticInfo.setClientID(_clientID);
        }
    }

    static class FileLastModifiedComparator
    implements Comparator<File> {
        FileLastModifiedComparator() {
        }

        @Override
        public int compare(File file, File file2) {
            long l;
            long l2 = file.lastModified();
            if (l2 > (l = file2.lastModified())) {
                return -1;
            }
            if (l2 < l) {
                return 1;
            }
            return 0;
        }
    }
}

