/*
 * Decompiled with CFR 0.152.
 */
package com.ianywhere.errorreporting;

import com.ianywhere.errorreporting.ErrorReportingServiceClient;
import com.ianywhere.errorreporting.ExceptionHandlerClient;
import com.sybase.util.DialogUtils;
import com.sybase.util.SybFileChooser;
import com.sybase.util.SybFileFilter;
import com.sybase.util.SybOptionPane;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

class ExceptionDialog
extends JDialog
implements ActionListener {
    private JButton _ok;
    private JButton _save;
    private JButton _copyToClipboard;
    private JButton _exit;
    private JTextArea _textField;
    private String _defaultFileName;

    public static void create(JFrame jFrame, ExceptionHandlerClient exceptionHandlerClient, String string) {
        String string2 = null;
        if (exceptionHandlerClient != null) {
            string2 = exceptionHandlerClient.getDialogTitle() + " - " + exceptionHandlerClient.getApplicationName();
        }
        if (string2 == null) {
            string2 = "Internal Error";
        }
        ExceptionDialog exceptionDialog = new ExceptionDialog(exceptionHandlerClient, jFrame, string2, string);
        exceptionDialog.setVisible(true);
    }

    private ExceptionDialog(ExceptionHandlerClient exceptionHandlerClient, JFrame jFrame, String string, String string2) {
        super(jFrame, string, true);
        String string3;
        File file;
        Object object;
        if (exceptionHandlerClient != null) {
            object = ErrorReportingServiceClient.getErrorReportDirectoryName(exceptionHandlerClient.getVendorName().replaceAll(" ", ""));
            file = new File((String)object);
            this._defaultFileName = exceptionHandlerClient.getDefaultFileName() != null ? (String)object + exceptionHandlerClient.getDefaultFileName() : (String)object + "errors.err.xml";
        } else {
            object = ErrorReportingServiceClient.getErrorReportDirectoryName("");
            file = new File((String)object);
            this._defaultFileName = (String)object + "errors.err.xml";
        }
        if (!file.exists()) {
            file.mkdir();
        }
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JLabel jLabel = new JLabel("This program encountered an internal error. Details are in the text field below.");
        jPanel.add(jLabel);
        jPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        if (exceptionHandlerClient != null && (string3 = exceptionHandlerClient.getContactInformation()) != null) {
            jLabel = new JLabel(string3);
            object = jLabel.getFont();
            jLabel.setFont(new Font(((Font)object).getFontName(), ((Font)object).getStyle() | 1, ((Font)object).getSize()));
            jLabel.setForeground(Color.red.darker());
            jPanel.add(jLabel);
            jPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        }
        this._textField = new JTextArea(string2, 15, 80);
        this._textField.setEditable(false);
        this._textField.setFont(new Font("Monospaced", 0, 12));
        this._textField.setCaretPosition(0);
        JScrollPane jScrollPane = new JScrollPane(this._textField);
        jScrollPane.setAlignmentX(0.0f);
        jPanel.add(jScrollPane);
        jPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(Box.createHorizontalGlue());
        this._ok = new JButton("OK");
        this._ok.setMnemonic('O');
        this._ok.addActionListener(this);
        jPanel2.add(this._ok);
        this._save = new JButton("Save To File...");
        this._save.setMnemonic('S');
        this._save.addActionListener(this);
        jPanel2.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel2.add(this._save);
        jPanel2.setAlignmentX(0.0f);
        this._copyToClipboard = new JButton("Copy To Clipboard");
        this._copyToClipboard.setMnemonic('C');
        this._copyToClipboard.addActionListener(this);
        jPanel2.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel2.add(this._copyToClipboard);
        this._exit = new JButton("Exit");
        this._exit.setMnemonic('E');
        this._exit.addActionListener(this);
        jPanel2.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel2.add(this._exit);
        DialogUtils.makeComponentsSameWidth(this._ok, this._save, this._copyToClipboard, this._exit);
        jPanel2.setAlignmentX(0.0f);
        jPanel.add(jPanel2);
        Container container = this.getContentPane();
        container.add(jPanel);
        this.pack();
        this.setLocationRelativeTo(jFrame);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._ok) {
            this.setVisible(false);
        } else if (object == this._save) {
            this.handleSave();
        } else if (object == this._copyToClipboard) {
            this._textField.selectAll();
            this._textField.copy();
        } else if (object == this._exit) {
            System.exit(-1);
        }
    }

    private void handleSave() {
        String string = this.getFileName();
        if (string != null) {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(string);
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fileOutputStream);
                outputStreamWriter.write(this._textField.getText());
                outputStreamWriter.write("\n");
                outputStreamWriter.flush();
                outputStreamWriter.close();
            }
            catch (IOException iOException) {
                String string2 = "Could not save file.\n" + iOException.getMessage();
                SybOptionPane.showMessageDialog(this, string2, this.getTitle(), 0);
            }
        }
    }

    private String getFileName() {
        String string = null;
        SybFileChooser sybFileChooser = new SybFileChooser(18);
        sybFileChooser.setFilters(new SybFileFilter[]{new SybFileFilter("txt", "Text Files")}, 0);
        sybFileChooser.setDefaultExtension("txt");
        File file = new File(this._defaultFileName);
        if (sybFileChooser.showDialog(this, null, file)) {
            File file2 = sybFileChooser.getSelectedFile();
            string = file2.getAbsolutePath();
        }
        return string;
    }
}

