/*
 * Decompiled with CFR 0.152.
 */
package com.ianywhere.errorreporting;

import com.ianywhere.errorreporting.ErrorReport;
import com.ianywhere.errorreporting.ErrorReportingServiceClient;
import com.ianywhere.errorreporting.ExceptionDialog;
import com.ianywhere.errorreporting.ExceptionHandlerClient;
import com.ianywhere.errorreporting.ObjectFactory;
import com.ianywhere.errorreporting.SendDialog;
import com.sun.org.apache.xml.internal.serialize.OutputFormat;
import com.sun.org.apache.xml.internal.serialize.XMLSerializer;
import com.sybase.util.EventMonitor;
import java.awt.DisplayMode;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

public class ExceptionHandler
implements Thread.UncaughtExceptionHandler {
    static final String DEFAULT_FILENAME = "errors.err.xml";
    private static ExceptionHandlerClient _client = null;
    private static ExceptionHandler _exceptionHandler = null;
    private static boolean _handlingException = false;

    static ExceptionHandler getExceptionHandler() {
        if (_exceptionHandler == null) {
            _exceptionHandler = new ExceptionHandler();
        }
        return _exceptionHandler;
    }

    public static void install() {
        System.setProperty("sun.awt.exception.handler", "com.ianywhere.errorreporting.ExceptionHandler");
        Thread.setDefaultUncaughtExceptionHandler(ExceptionHandler.getExceptionHandler());
    }

    public static void init(ExceptionHandlerClient exceptionHandlerClient) {
        if (_client == null) {
            _client = exceptionHandlerClient;
        }
    }

    @Override
    public void uncaughtException(Thread thread, Throwable throwable) {
        if (!_handlingException) {
            _handlingException = true;
            ExceptionHandler.handleException(throwable);
            _handlingException = false;
        }
    }

    public void handle(Throwable throwable) {
        this.uncaughtException(Thread.currentThread(), throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void handleException(Throwable throwable) {
        if (ExceptionHandler.shouldReportException(throwable)) {
            boolean bl;
            boolean bl2;
            if (_client == null) {
                bl2 = true;
                bl = true;
            } else {
                bl2 = _client.useGUI();
                bl = _client.showErrorReporter();
            }
            ExceptionHandler.writeExceptionFile(throwable);
            if (bl2) {
                try {
                    EventMonitor.pause();
                    if (bl) {
                        ExceptionHandler.reportError();
                    } else {
                        ExceptionHandler.showExceptionWithGUI(throwable);
                    }
                }
                catch (Throwable throwable2) {
                }
                finally {
                    EventMonitor.resume();
                }
            }
        }
    }

    public static void printBox(PrintStream printStream, String string, int n) {
        int n2;
        int n3 = string.length() + 4 + 4;
        int n4 = n > 0 ? (n - n3) / 2 : 0;
        StringBuffer stringBuffer = new StringBuffer(n3);
        for (n2 = 0; n2 < n4; ++n2) {
            stringBuffer.append(' ');
        }
        for (n2 = 0; n2 < n3; ++n2) {
            if (n2 == 0 || n2 == n3 - 1) {
                stringBuffer.append('+');
                continue;
            }
            stringBuffer.append('-');
        }
        StringBuffer stringBuffer2 = new StringBuffer(n3 + n4);
        for (n2 = 0; n2 < n4; ++n2) {
            stringBuffer2.append(' ');
        }
        stringBuffer2.append("|   ").append(string).append("   |");
        printStream.println(stringBuffer.toString());
        printStream.println(stringBuffer2);
        printStream.println(stringBuffer.toString());
        printStream.println();
    }

    public static String printBox(String string, int n) {
        int n2;
        int n3 = string.length() + 4 + 4;
        int n4 = n > 0 ? (n - n3) / 2 : 0;
        StringBuffer stringBuffer = new StringBuffer(n3);
        for (n2 = 0; n2 < n4; ++n2) {
            stringBuffer.append(' ');
        }
        for (n2 = 0; n2 < n3; ++n2) {
            if (n2 == 0 || n2 == n3 - 1) {
                stringBuffer.append('+');
                continue;
            }
            stringBuffer.append('-');
        }
        StringBuffer stringBuffer2 = new StringBuffer(n3 + n4);
        for (int i = 0; i < n4; ++i) {
            stringBuffer2.append(' ');
        }
        stringBuffer2.append("|   ").append(string).append("   |");
        StringBuffer stringBuffer3 = new StringBuffer(n * 4);
        stringBuffer3.append(stringBuffer.toString()).append("\n").append(stringBuffer2).append("\n").append(stringBuffer.toString()).append("\n");
        return stringBuffer3.toString();
    }

    private static boolean shouldReportException(Throwable throwable) {
        boolean bl;
        if (throwable instanceof NullPointerException) {
            bl = false;
            StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
            for (int i = 0; i < stackTraceElementArray.length; ++i) {
                String string = stackTraceElementArray[i].getClassName();
                if (i > 0 && string.equals("com.sybase.util.EventMonitor") || string.indexOf("sybase.") == -1 && string.indexOf("ianywhere.") == -1) continue;
                bl = true;
                break;
            }
        } else {
            bl = true;
        }
        return bl;
    }

    static void gatherInformation(PrintStream printStream, Throwable throwable) throws IOException, ExceptionIgnored {
        if (!ExceptionHandler.shouldReportException(throwable)) {
            throw new ExceptionIgnored();
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8192);
        PrintStream printStream2 = new PrintStream(byteArrayOutputStream);
        throwable.printStackTrace(printStream2);
        printStream2.flush();
        printStream2.close();
        byteArrayOutputStream.flush();
        String string = byteArrayOutputStream.toString();
        string = string + "\n\n" + ExceptionHandler.getAllStackTraces();
        ExceptionHandler.printBox(printStream, "Stack Trace", 80);
        printStream.println("Current thread: " + Thread.currentThread().getName());
        printStream.println(string);
        printStream.println();
        printStream.println();
        ExceptionHandler.printBox(printStream, "UI Trace", 80);
        EventMonitor.printEvents(printStream);
        printStream.println();
        printStream.println();
        if (_client != null) {
            try {
                _client.printApplicationInformation(printStream);
            }
            catch (Throwable throwable2) {
                printStream.println("\n*** A " + throwable2.getClass().getName() + " exception was caught while gathering application information");
                printStream.println("  " + throwable2.getLocalizedMessage());
            }
            printStream.println();
            printStream.println();
        }
        ExceptionHandler.printBox(printStream, "Classpath", 80);
        ExceptionHandler.printClasspath(printStream);
        printStream.println();
        printStream.println();
        ExceptionHandler.printBox(printStream, "Java VM", 80);
        printStream.println("Total memory: " + Runtime.getRuntime().totalMemory());
        printStream.println("Free memory: " + Runtime.getRuntime().freeMemory());
        ExceptionHandler.printProperties(printStream, System.getProperties());
        printStream.println();
        printStream.println();
        ExceptionHandler.printBox(printStream, "Look and Feel", 80);
        printStream.println(ExceptionHandler.getLAFInfo());
        printStream.println();
        printStream.println();
        ExceptionHandler.printBox(printStream, "Java Packages", 80);
        ExceptionHandler.printPackages(printStream);
        printStream.println();
        printStream.println();
    }

    static String getLAFInfo() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        if (!GraphicsEnvironment.isHeadless()) {
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
            for (n = 0; n < graphicsDeviceArray.length; ++n) {
                DisplayMode displayMode = graphicsDeviceArray[n].getDisplayMode();
                stringBuffer.append("Monitor " + (n + 1) + " size: ");
                stringBuffer.append(Integer.toString(displayMode.getWidth()));
                stringBuffer.append(" x ");
                stringBuffer.append(Integer.toString(displayMode.getHeight()));
                stringBuffer.append("\n");
            }
        }
        stringBuffer.append("Look and Feel:\n");
        stringBuffer.append("  Name:").append(lookAndFeel.getName());
        stringBuffer.append("\n");
        stringBuffer.append("  Description:").append(lookAndFeel.getDescription());
        stringBuffer.append("\n");
        stringBuffer.append("  IsNative:").append(lookAndFeel.isNativeLookAndFeel());
        stringBuffer.append("\n");
        stringBuffer.append("  IsSupported:").append(lookAndFeel.isSupportedLookAndFeel());
        stringBuffer.append("\n");
        stringBuffer.append("  ID:").append(lookAndFeel.getID());
        stringBuffer.append("\n");
        stringBuffer.append("  Class:").append(lookAndFeel.getClass().getName());
        stringBuffer.append("\n\n");
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Object[] objectArray = (String[])toolkit.getDesktopProperty("win.propNames");
        if (objectArray != null) {
            Arrays.sort(objectArray);
            stringBuffer.append("Desktop Properties:\n");
            for (n = 0; n < objectArray.length; ++n) {
                stringBuffer.append("  ").append((String)objectArray[n]).append("=").append(toolkit.getDesktopProperty((String)objectArray[n]).toString());
                stringBuffer.append("\n");
            }
        } else {
            stringBuffer.append("\nNo desktop properties.\n");
        }
        return stringBuffer.toString();
    }

    static String getAllStackTraces() {
        StringBuffer stringBuffer = new StringBuffer(1024);
        Map<Thread, StackTraceElement[]> map = Thread.getAllStackTraces();
        Set<Map.Entry<Thread, StackTraceElement[]>> set = map.entrySet();
        for (Map.Entry<Thread, StackTraceElement[]> entry : set) {
            Thread thread = entry.getKey();
            StackTraceElement[] stackTraceElementArray = entry.getValue();
            stringBuffer.append("Thread:       ").append(thread.getName()).append("\n");
            stringBuffer.append("Priority:     ").append(thread.getPriority()).append("\n");
            stringBuffer.append("Thread Group: ").append(thread.getThreadGroup().getName()).append("\n");
            stringBuffer.append("State:        ").append((Object)thread.getState()).append("\n");
            stringBuffer.append("\n");
            stringBuffer.append("Stack Trace").append("\n");
            for (StackTraceElement stackTraceElement : stackTraceElementArray) {
                stringBuffer.append(stackTraceElement).append("\n");
            }
            stringBuffer.append("--------------------------------------------------------------------------------").append("\n\n");
        }
        return stringBuffer.toString();
    }

    static void gatherInformationForReport(PrintStream printStream, Throwable throwable) throws IOException, ExceptionIgnored {
        if (!ExceptionHandler.shouldReportException(throwable)) {
            throw new ExceptionIgnored();
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8192);
        PrintStream printStream2 = new PrintStream(byteArrayOutputStream);
        throwable.printStackTrace(printStream2);
        printStream2.flush();
        printStream2.close();
        byteArrayOutputStream.flush();
        String string = byteArrayOutputStream.toString();
        string = string + "\n\n" + ExceptionHandler.getAllStackTraces();
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append(ExceptionHandler.printBox("UI Trace", 80)).append(EventMonitor.getEvents()).append("\n\n");
        if (_client != null) {
            try {
                stringBuffer.append(_client.getApplicationInformation());
            }
            catch (Throwable throwable2) {
                stringBuffer.append("\n*** A ").append(throwable2.getClass().getName()).append(" exception was caught while gathering application information").append("\n  ").append(throwable2.getLocalizedMessage());
            }
            stringBuffer.append("\n\n");
        }
        stringBuffer.append(ExceptionHandler.printBox("Classpath", 80)).append(ExceptionHandler.getClasspath()).append("\n\n");
        stringBuffer.append(ExceptionHandler.printBox("Java VM", 80)).append("\n");
        stringBuffer.append("Total memory: ").append(Runtime.getRuntime().totalMemory()).append("\n");
        stringBuffer.append("Free memory: ").append(Runtime.getRuntime().freeMemory()).append("\n\n");
        stringBuffer.append(ExceptionHandler.printBox("Look and Feel", 80));
        stringBuffer.append(ExceptionHandler.getLAFInfo());
        stringBuffer.append("\n\n");
        stringBuffer.append(ExceptionHandler.printBox("Java Packages", 80)).append("\n");
        stringBuffer.append(ExceptionHandler.getPackages()).append("\n\n");
        try {
            JAXBContext jAXBContext = JAXBContext.newInstance((String)"com.ianywhere.errorreporting");
            ObjectFactory objectFactory = new ObjectFactory();
            ErrorReport errorReport = objectFactory.createErrorReport();
            if (_client != null) {
                errorReport.setVendor(_client.getVendorName());
                errorReport.setProduct(_client.getProductName());
                errorReport.setApplication(_client.getApplicationName());
                errorReport.setApplicationVersionMajor(_client.getApplicationVersionMajor());
                errorReport.setApplicationVersionMinor(_client.getApplicationVersionMinor());
                errorReport.setApplicationVersionPatch(_client.getApplicationVersionPatch());
                errorReport.setApplicationVersionBuild(_client.getApplicationVersionBuild());
                errorReport.setModule(_client.getModuleName());
                errorReport.setModuleVersionMajor(_client.getModuleVersionMajor());
                errorReport.setModuleVersionMinor(_client.getModuleVersionMinor());
                errorReport.setModuleVersionPatch(_client.getModuleVersionPatch());
                errorReport.setModuleVersionBuild(_client.getModuleVersionBuild());
            }
            errorReport.setOperatingSystem(ErrorReportingServiceClient.getOperatingSystem());
            errorReport.setLocale(Locale.getDefault().toString());
            errorReport.setStackTrace(string);
            errorReport.setSystemProperties(ExceptionHandler.getProperties(System.getProperties()));
            errorReport.setErrorLog(stringBuffer.toString());
            Marshaller marshaller = jAXBContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            OutputFormat outputFormat = new OutputFormat();
            outputFormat.setCDataElements(new String[]{"ns1^stack_trace", "ns1^system_properties", "ns1^error_log"});
            outputFormat.setPreserveSpace(true);
            outputFormat.setIndenting(true);
            XMLSerializer xMLSerializer = new XMLSerializer(outputFormat);
            xMLSerializer.setOutputByteStream(printStream);
            marshaller.marshal((Object)errorReport, xMLSerializer.asContentHandler());
            printStream.close();
        }
        catch (JAXBException jAXBException) {
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void printClasspath(PrintStream printStream) {
        try {
            String string = System.getProperty("java.class.path");
            String string2 = System.getProperty("path.separator");
            StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
            while (stringTokenizer.hasMoreElements()) {
                File file = new File(stringTokenizer.nextToken());
                printStream.println(file.getCanonicalPath());
                if (file.exists()) {
                    printStream.println("    Timestamp=" + new Timestamp(file.lastModified()));
                    printStream.println("    Length=" + file.length());
                } else {
                    printStream.println(file + "**** File does not exist");
                }
                printStream.println();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static String getClasspath() {
        StringBuffer stringBuffer = new StringBuffer(1024);
        try {
            String string = System.getProperty("java.class.path");
            String string2 = System.getProperty("path.separator");
            StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
            while (stringTokenizer.hasMoreElements()) {
                File file = new File(stringTokenizer.nextToken());
                stringBuffer.append(file.getCanonicalPath()).append("\n");
                if (file.exists()) {
                    stringBuffer.append("    Timestamp=").append(new Timestamp(file.lastModified())).append("\n");
                    stringBuffer.append("    Length=").append(file.length()).append("\n");
                } else {
                    stringBuffer.append(file).append("**** File does not exist").append("\n");
                }
                stringBuffer.append("\n");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return stringBuffer.toString();
    }

    private static String getProperties(Properties properties) {
        StringBuffer stringBuffer = new StringBuffer(1024);
        ArrayList<String> arrayList = new ArrayList<String>();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            Object obj = enumeration.nextElement();
            arrayList.add(obj.toString());
        }
        Collections.sort(arrayList);
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append((String)arrayList.get(i)).append("=").append(properties.getProperty((String)arrayList.get(i))).append("\n");
        }
        return stringBuffer.toString();
    }

    private static void printProperties(PrintStream printStream, Properties properties) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            Object obj = enumeration.nextElement();
            arrayList.add(obj.toString());
        }
        Collections.sort(arrayList);
        printStream.println("System properties:");
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            String string = (String)arrayList.get(i);
            printStream.println("    " + string + "=" + properties.getProperty(string));
        }
    }

    static void printPackages(PrintStream printStream) {
        Package[] packageArray = Package.getPackages();
        Arrays.sort(packageArray, new Comparator<Package>(){

            @Override
            public int compare(Package package_, Package package_2) {
                return package_.getName().compareTo(package_2.getName());
            }
        });
        int n = packageArray.length;
        for (int i = 0; i < n; ++i) {
            printStream.println("Package: " + packageArray[i].getName());
            printStream.println("    Implementation title: " + packageArray[i].getImplementationTitle());
            printStream.println("    Implementation vendor: " + packageArray[i].getImplementationVendor());
            printStream.println("    Implementation version: " + packageArray[i].getImplementationVersion());
            printStream.println("    Specification title: " + packageArray[i].getSpecificationTitle());
            printStream.println("    Specification vendor: " + packageArray[i].getSpecificationVendor());
            printStream.println("    Specification version: " + packageArray[i].getSpecificationVersion());
            printStream.println("");
        }
    }

    static String getPackages() {
        StringBuffer stringBuffer = new StringBuffer(1024);
        Package[] packageArray = Package.getPackages();
        Arrays.sort(packageArray, new Comparator<Package>(){

            @Override
            public int compare(Package package_, Package package_2) {
                return package_.getName().compareTo(package_2.getName());
            }
        });
        int n = packageArray.length;
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("Package: ").append(packageArray[i].getName()).append("\n");
            stringBuffer.append("    Implementation title: ").append(packageArray[i].getImplementationTitle()).append("\n");
            stringBuffer.append("    Implementation vendor: ").append(packageArray[i].getImplementationVendor()).append("\n");
            stringBuffer.append("    Implementation version: ").append(packageArray[i].getImplementationVersion()).append("\n");
            stringBuffer.append("    Specification title: ").append(packageArray[i].getSpecificationTitle()).append("\n");
            stringBuffer.append("    Specification vendor: ").append(packageArray[i].getSpecificationVendor()).append("\n");
            stringBuffer.append("    Specification version: ").append(packageArray[i].getSpecificationVersion()).append("\n");
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeExceptionFile(Throwable throwable) {
        String string;
        String string2;
        File file;
        Object object;
        FileOutputStream fileOutputStream = null;
        PrintStream printStream = null;
        if (_client != null) {
            object = ErrorReportingServiceClient.getErrorReportDirectoryName(_client.getVendorName().replaceAll(" ", ""));
            file = new File((String)object);
            string2 = _client.getDefaultFileName() != null ? (String)object + _client.getDefaultFileName() : (String)object + DEFAULT_FILENAME;
        } else {
            object = ErrorReportingServiceClient.getErrorReportDirectoryName("");
            file = new File((String)object);
            string2 = (String)object + DEFAULT_FILENAME;
        }
        if (!file.exists()) {
            file.mkdir();
        }
        if (_client != null && _client.showErrorReporter()) {
            string = string2 + ".err.xml";
            int n = 2;
            while (((File)(object = new File(string))).exists()) {
                string = string2 + "-" + Integer.toString(n) + ".err.xml";
                ++n;
            }
        } else {
            string = string2 + ".txt";
            int n = 2;
            while (((File)(object = new File(string))).exists()) {
                string = string2 + "-" + Integer.toString(n) + ".txt";
                ++n;
            }
        }
        try {
            fileOutputStream = new FileOutputStream(string);
            printStream = new PrintStream(fileOutputStream);
            if (_client != null && _client.showErrorReporter()) {
                ExceptionHandler.gatherInformationForReport(printStream, throwable);
            } else {
                ExceptionHandler.gatherInformation(printStream, throwable);
            }
            System.err.println("Error! This program has encountered an internal error.");
            System.err.println("Details have been logged to " + string);
        }
        catch (IOException iOException) {
            System.err.println("This program has encountered an internal error (" + throwable.getClass().getName() + ")");
            throwable.printStackTrace();
        }
        catch (ExceptionIgnored exceptionIgnored) {
        }
        finally {
            if (printStream != null) {
                printStream.close();
                printStream = null;
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
                fileOutputStream = null;
            }
        }
    }

    static void showExceptionWithGUI(Throwable throwable) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8192);
            PrintStream printStream = new PrintStream(byteArrayOutputStream);
            ExceptionHandler.gatherInformation(printStream, throwable);
            printStream.flush();
            byteArrayOutputStream.flush();
            printStream.close();
            byteArrayOutputStream.close();
            JFrame jFrame = _client != null ? _client.getParent() : null;
            ExceptionDialog.create(jFrame, _client, byteArrayOutputStream.toString());
        }
        catch (IOException iOException) {
        }
        catch (ExceptionIgnored exceptionIgnored) {
            // empty catch block
        }
    }

    static void reportError() {
        String string;
        JFrame jFrame;
        Vector<String> vector = new Vector<String>();
        StringBuffer stringBuffer = new StringBuffer(8192);
        if (_client != null) {
            jFrame = _client.getParent();
            string = _client.getVendorName();
        } else {
            jFrame = null;
            string = "";
        }
        File[] fileArray = ErrorReportingServiceClient.getUploadFiles(string);
        int n = 0;
        if (fileArray != null && fileArray.length > 0) {
            for (int i = 0; i < fileArray.length; ++i) {
                try {
                    FileInputStream fileInputStream = new FileInputStream(fileArray[i]);
                    JAXBContext jAXBContext = JAXBContext.newInstance((String)"com.ianywhere.errorreporting");
                    Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
                    ErrorReport errorReport = (ErrorReport)unmarshaller.unmarshal((InputStream)fileInputStream);
                    stringBuffer.append(ExceptionHandler.printBox("Stack Trace", 80)).append("\n");
                    stringBuffer.append(errorReport.getStackTrace()).append("\n");
                    stringBuffer.append(errorReport.getErrorLog()).append("\n");
                    stringBuffer.append(ExceptionHandler.printBox("System Properties", 80)).append("\n");
                    stringBuffer.append(errorReport.getSystemProperties()).append("\n");
                    stringBuffer.append("----------------------------------------------------------------------------------------------------\n\n");
                }
                catch (FileNotFoundException fileNotFoundException) {
                    fileArray[i].delete();
                    break;
                }
                catch (IOException iOException) {
                    fileArray[i].delete();
                    break;
                }
                catch (JAXBException jAXBException) {
                    fileArray[i].delete();
                    break;
                }
                if (n < 5) {
                    try {
                        vector.add(fileArray[i].getCanonicalPath());
                    }
                    catch (IOException iOException) {
                        vector.add(fileArray[i].getAbsolutePath());
                    }
                    ++n;
                    continue;
                }
                fileArray[i].delete();
            }
            SendDialog.create(jFrame, _client, stringBuffer.toString(), vector);
        }
    }

    static class ErrorFileFilter
    implements FilenameFilter {
        ErrorFileFilter() {
        }

        @Override
        public boolean accept(File file, String string) {
            return string.endsWith(".err.xml");
        }
    }

    static class ExceptionIgnored
    extends Throwable {
        ExceptionIgnored() {
        }
    }
}

