/*
 * Decompiled with CFR 0.152.
 */
package com.ianywhere.errorreporting;

import com.ianywhere.errorreporting.DetailsDialog;
import com.ianywhere.errorreporting.ErrorReportingServiceClient;
import com.ianywhere.errorreporting.ExceptionHandlerClient;
import com.ianywhere.errorreporting.FinishPanel;
import com.ianywhere.errorreporting.InitialPanel;
import com.ianywhere.errorreporting.SubmitPanel;
import com.sybase.util.HTMLWindow;
import com.sybase.util.SybButton;
import com.sybase.util.SybLabel;
import com.sybase.util.SybMessageFormat;
import com.sybase.util.SybTextArea;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

class SendDialog
extends JDialog
implements WindowListener,
ActionListener,
HyperlinkListener {
    SybButton _sendReportButton;
    SybButton _dontSendReportButton;
    SybButton _submitOkButton;
    SybButton _resumeButton;
    SybButton _exitButton;
    private ExceptionHandlerClient _client;
    private String _applicationName = "";
    private String _errorReport = "";
    private Vector<String> _fileList;
    private CardLayout _sendDialogLayout;
    private Frame _parentFrame;
    private JPanel _cardPanel;
    private SubmitPanel _submitPanel;

    public static void create(Frame frame, ExceptionHandlerClient exceptionHandlerClient, String string, Vector<String> vector) {
        String string2 = null;
        if (exceptionHandlerClient != null) {
            string2 = exceptionHandlerClient.getDialogTitle() + " - " + exceptionHandlerClient.getApplicationName();
        }
        if (string2 == null) {
            string2 = ErrorReportingServiceClient.getI18NMessage("INTERNAL_ERROR");
        }
        SendDialog sendDialog = new SendDialog(frame, exceptionHandlerClient, string2, string, vector);
        sendDialog.setVisible(true);
    }

    public SendDialog(Frame frame, ExceptionHandlerClient exceptionHandlerClient, String string, String string2, Vector<String> vector) {
        super(frame, true);
        this._parentFrame = frame;
        this.init(frame, exceptionHandlerClient, string, string2, vector);
    }

    private void init(Window window, ExceptionHandlerClient exceptionHandlerClient, String string, String string2, Vector<String> vector) {
        Font font;
        this._client = exceptionHandlerClient;
        Image image = null;
        if (this._client != null) {
            this._applicationName = this._client.getApplicationName();
            image = this._client.getIconImage();
        }
        this._errorReport = string2;
        this._fileList = vector;
        this.addWindowListener(this);
        this.setTitle(string);
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SendDialog.this.dontSend();
            }
        };
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
        InitialPanel initialPanel = new InitialPanel(this, exceptionHandlerClient);
        this._submitPanel = new SubmitPanel(this, exceptionHandlerClient);
        FinishPanel finishPanel = new FinishPanel(this, exceptionHandlerClient);
        InputMap inputMap = this._dontSendReportButton.getInputMap(2);
        ActionMap actionMap = this._dontSendReportButton.getActionMap();
        if (inputMap != null && actionMap != null) {
            inputMap.put(keyStroke, "cancel");
            actionMap.put("cancel", abstractAction);
        }
        if ((font = UIManager.getDefaults().getFont("InternalFrame.titleFont")) == null) {
            font = new SybLabel().getFont();
            font = font.deriveFont(font.getStyle(), font.getSize() + 4);
        }
        GridBagLayout gridBagLayout = new GridBagLayout();
        JPanel jPanel = new JPanel(gridBagLayout, true);
        this.add(jPanel);
        jPanel.setForeground(SystemColor.windowText);
        jPanel.setBackground(SystemColor.window);
        SybTextArea sybTextArea = new SybTextArea(SybMessageFormat.format(ErrorReportingServiceClient.getI18NMessage("HAS_ENCOUNTERED_A_PROBLEM"), this._applicationName), 2, 0);
        jPanel.add(sybTextArea);
        sybTextArea.setFont(font);
        sybTextArea.setEditable(false);
        sybTextArea.setBorder(null);
        sybTextArea.setForeground(SystemColor.windowText);
        sybTextArea.setBackground(SystemColor.window);
        sybTextArea.setLineWrap(true);
        sybTextArea.setWrapStyleWord(true);
        sybTextArea.setFocusable(false);
        sybTextArea.setRows(2);
        JLabel jLabel = new JLabel("");
        if (image != null) {
            jLabel.setIcon(new ImageIcon(image));
        }
        jPanel.add(jLabel);
        this.getContentPane().add(jPanel);
        JSeparator jSeparator = new JSeparator(0);
        this.getContentPane().add(jSeparator);
        this._sendDialogLayout = new CardLayout();
        this._sendDialogLayout.addLayoutComponent(initialPanel, "INITIAL");
        this._sendDialogLayout.addLayoutComponent(this._submitPanel, "SUBMIT");
        this._sendDialogLayout.addLayoutComponent(finishPanel, "FINISH");
        this._cardPanel = new JPanel(this._sendDialogLayout, true);
        this._cardPanel.setLayout(this._sendDialogLayout);
        this._cardPanel.add((Component)initialPanel, "INITIAL");
        this._cardPanel.add((Component)this._submitPanel, "SUBMIT");
        this._cardPanel.add((Component)finishPanel, "FINISH");
        this.getContentPane().add(this._cardPanel);
        this._sendDialogLayout.show(this._cardPanel, "INITIAL");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        gridBagLayout.setConstraints(sybTextArea, gridBagConstraints);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        this.getContentPane().setLayout(gridBagLayout2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout2.setConstraints(jPanel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipadx = 0;
        gridBagLayout2.setConstraints(jSeparator, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagLayout2.setConstraints(this._cardPanel, gridBagConstraints);
        this.pack();
        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo(window);
        this.setDefaultCloseOperation(0);
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.dontSend();
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
        this.removeWindowListener(this);
        this.dispose();
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._sendReportButton) {
            if (this.showUpdateSupportInformation()) {
                this.getRootPane().setDefaultButton(this._submitOkButton);
                this._sendDialogLayout.show(this._cardPanel, "SUBMIT");
                this._submitPanel.submit();
                this._submitOkButton.requestFocusInWindow();
            }
        } else if (object == this._dontSendReportButton) {
            this.dontSend();
        } else if (object == this._submitOkButton) {
            this.dontSend();
        } else if (object == this._resumeButton) {
            this.setVisible(false);
        } else if (object == this._exitButton) {
            System.exit(-1);
        }
    }

    private void dontSend() {
        this.getRootPane().setDefaultButton(this._exitButton);
        this._sendDialogLayout.show(this._cardPanel, "FINISH");
        this._exitButton.requestFocusInWindow();
    }

    private boolean showUpdateSupportInformation() {
        return this._client != null && (this._client.showCheckForUpdates() && this._client.getCheckForUpdatesURL() != null && this._client.getCheckForUpdatesURL().length() > 0 || this._client.showTechSupportLink() && this._client.getTechSupportURL() != null && this._client.getTechSupportURL().length() > 0);
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (this._client != null && hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            if (hyperlinkEvent.getDescription().equals("REPORT_CONTENTS")) {
                DetailsDialog detailsDialog = new DetailsDialog(this, this._applicationName, this._errorReport, this._fileList, this._client.getDataCollectionPolicyURL());
                detailsDialog.setVisible(true);
            } else if (hyperlinkEvent.getDescription().equals("CHECK_FOR_UPDATE")) {
                HTMLWindow.open(this._client.getCheckForUpdatesURL(), "", null, 400, 400);
            } else if (hyperlinkEvent.getDescription().equals("TECHNICAL_SUPPORT")) {
                HTMLWindow.open(this._client.getTechSupportURL(), "", null, 400, 400);
            }
        }
    }
}

