/*
 * Decompiled with CFR 0.152.
 */
package com.ianywhere.errorreporting;

import com.ianywhere.errorreporting.ErrorReport;
import com.ianywhere.errorreporting.ErrorReportingServiceClient;
import com.ianywhere.errorreporting.ExceptionHandlerClient;
import com.ianywhere.errorreporting.SendDialog;
import com.sybase.util.SybButton;
import com.sybase.util.SybLabel;
import com.sybase.util.SybOptionPane;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.xml.sax.SAXException;

class SubmitPanel
extends JPanel
implements Runnable {
    private SendDialog _sendDialog;
    private final ExceptionHandlerClient _client;
    private SybLabel _preparingReportStatus;
    private SybLabel _connectingStatus;
    private SybLabel _reportingCompletedLabel;
    private SybLabel _submissionIDsLabel;
    private JTextField _submissionIDsTextField;
    private ArrayList<String> _submissionIDs;

    SubmitPanel(SendDialog sendDialog, ExceptionHandlerClient exceptionHandlerClient) {
        this._sendDialog = sendDialog;
        this._client = exceptionHandlerClient;
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicy(new SubmitPanelFocusTraversalPolicy());
        this.setFocusTraversalPolicyProvider(true);
        Font font = this.getFont();
        int n = font.getSize();
        BufferedImage bufferedImage = new BufferedImage(n, n, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setColor(this.getBackground());
        graphics2D.fillRect(0, 0, n, n);
        ImageIcon imageIcon = new ImageIcon(bufferedImage);
        this._preparingReportStatus = new SybLabel(ErrorReportingServiceClient.getI18NMessage("PREPARING_REPORT_LABEL"), imageIcon, 10);
        this.add(this._preparingReportStatus);
        this._connectingStatus = new SybLabel(ErrorReportingServiceClient.getI18NMessage("CONNECTING_LABEL"), imageIcon, 10);
        this.add(this._connectingStatus);
        this._reportingCompletedLabel = new SybLabel(ErrorReportingServiceClient.getI18NMessage("REPORTING_COMPLETED_LABEL"));
        this.add(this._reportingCompletedLabel);
        this._submissionIDsLabel = new SybLabel(ErrorReportingServiceClient.getI18NMessage("SUBMITTION_IDS"));
        this._submissionIDsLabel.setEnabled(false);
        this.add(this._submissionIDsLabel);
        this._submissionIDsTextField = new JTextField();
        this._submissionIDsTextField.setEditable(false);
        this._submissionIDsLabel.setLabelFor(this._submissionIDsTextField);
        this.add(this._submissionIDsTextField);
        this._sendDialog._submitOkButton = new SybButton(ErrorReportingServiceClient.getI18NMessage("OK_BUTTON"));
        this._sendDialog._submitOkButton.addActionListener(this._sendDialog);
        this._sendDialog._submitOkButton.setEnabled(false);
        sendDialog.getRootPane().setDefaultButton(this._sendDialog._submitOkButton);
        this.add(this._sendDialog._submitOkButton);
        SybLabel sybLabel = new SybLabel(" ");
        this.add(sybLabel);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        gridBagLayout.setConstraints(this._preparingReportStatus, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        gridBagLayout.setConstraints(this._connectingStatus, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        gridBagLayout.setConstraints(this._reportingCompletedLabel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(15, 10, 0, 0);
        gridBagLayout.setConstraints(this._submissionIDsLabel, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        gridBagLayout.setConstraints(this._submissionIDsTextField, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 10, 0);
        gridBagLayout.setConstraints(sybLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        gridBagLayout.setConstraints(sendDialog._submitOkButton, gridBagConstraints);
        this._reportingCompletedLabel.setText(" ");
    }

    void submit() {
        Thread thread = new Thread((Runnable)this, "SubErrorReport thread");
        thread.start();
    }

    @Override
    public void run() {
        block20: {
            File[] fileArray;
            ImageIcon imageIcon;
            boolean bl;
            block18: {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this._sendDialog.setDefaultCloseOperation(0);
                bl = true;
                Font font = this.getFont();
                int n = font.getSize();
                BufferedImage bufferedImage = new BufferedImage(n, n, 1);
                Graphics2D graphics2D = bufferedImage.createGraphics();
                graphics2D.setColor(this.getBackground());
                graphics2D.fillRect(0, 0, n, n);
                graphics2D.setColor(this.getForeground());
                graphics2D.drawLine(1, n / 2, n / 3, n - 2);
                graphics2D.drawLine(n / 3, n - 2, n - 2, 1);
                imageIcon = new ImageIcon(bufferedImage);
                String string = this._client != null ? this._client.getVendorName() : "";
                fileArray = ErrorReportingServiceClient.getUploadFiles(string);
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        SubmitPanel.this._preparingReportStatus.setIcon(imageIcon);
                    }
                };
                try {
                    SwingUtilities.invokeAndWait(runnable);
                }
                catch (InterruptedException interruptedException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    if (!(invocationTargetException.getCause() instanceof RuntimeException)) break block18;
                    throw (RuntimeException)invocationTargetException.getCause();
                }
            }
            this._submissionIDs = new ArrayList();
            if (null != fileArray && 0 < fileArray.length) {
                try {
                    for (File file : fileArray) {
                        FileInputStream fileInputStream = new FileInputStream(file);
                        JAXBContext jAXBContext = JAXBContext.newInstance((String)"com.ianywhere.errorreporting");
                        Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
                        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                        Schema schema = schemaFactory.newSchema(new StreamSource(SubmitPanel.class.getResourceAsStream("/errorreport.xsd")));
                        unmarshaller.setSchema(schema);
                        ErrorReport errorReport = (ErrorReport)unmarshaller.unmarshal((InputStream)fileInputStream);
                        String string = this._client != null ? this._client.getErrorReportingServiceSubmissionURL() : "";
                        String string2 = ErrorReportingServiceClient.uploadErrorReport(string, errorReport);
                        if (string2 == null) {
                            SybOptionPane.showMessageDialog(this, ErrorReportingServiceClient.getI18NMessage("CONNECT_ERROR"));
                            bl = false;
                            break;
                        }
                        file.delete();
                        this._submissionIDs.add(string2);
                    }
                }
                catch (FileNotFoundException iOException) {
                }
                catch (IOException jAXBException) {
                }
                catch (JAXBException sAXException) {
                }
                catch (SAXException sAXException) {
                    // empty catch block
                }
            }
            if (bl) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        SubmitPanel.this._connectingStatus.setIcon(imageIcon);
                        SubmitPanel.this._reportingCompletedLabel.setText(ErrorReportingServiceClient.getI18NMessage("REPORTING_COMPLETED_LABEL"));
                        StringBuffer stringBuffer = new StringBuffer();
                        for (String string : SubmitPanel.this._submissionIDs) {
                            stringBuffer.append(string).append(" ");
                        }
                        SubmitPanel.this._submissionIDsTextField.setText(stringBuffer.toString());
                        SubmitPanel.this._submissionIDsLabel.setEnabled(true);
                        ((SubmitPanel)SubmitPanel.this)._sendDialog._submitOkButton.requestFocusInWindow();
                    }
                };
                try {
                    SwingUtilities.invokeAndWait(runnable);
                }
                catch (InterruptedException interruptedException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    if (!(invocationTargetException.getCause() instanceof RuntimeException)) break block20;
                    throw (RuntimeException)invocationTargetException.getCause();
                }
            }
        }
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SubmitPanel.this.setVisible(false);
            }
        };
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
        InputMap inputMap = this._sendDialog._submitOkButton.getInputMap(2);
        ActionMap actionMap = this._sendDialog._submitOkButton.getActionMap();
        if (null != inputMap && null != actionMap) {
            inputMap.put(keyStroke, "cancel");
            actionMap.put("cancel", abstractAction);
        }
        this._sendDialog._submitOkButton.setEnabled(true);
        this._sendDialog.setDefaultCloseOperation(1);
    }

    private class SubmitPanelFocusTraversalPolicy
    extends FocusTraversalPolicy {
        private SubmitPanelFocusTraversalPolicy() {
        }

        @Override
        public Component getComponentAfter(Container container, Component component) {
            if (component.equals(((SubmitPanel)SubmitPanel.this)._sendDialog._submitOkButton)) {
                return SubmitPanel.this._submissionIDsTextField;
            }
            if (component.equals(SubmitPanel.this._submissionIDsTextField)) {
                return ((SubmitPanel)SubmitPanel.this)._sendDialog._submitOkButton;
            }
            return ((SubmitPanel)SubmitPanel.this)._sendDialog._submitOkButton;
        }

        @Override
        public Component getComponentBefore(Container container, Component component) {
            if (component.equals(((SubmitPanel)SubmitPanel.this)._sendDialog._submitOkButton)) {
                return SubmitPanel.this._submissionIDsTextField;
            }
            if (component.equals(SubmitPanel.this._submissionIDsTextField)) {
                return ((SubmitPanel)SubmitPanel.this)._sendDialog._submitOkButton;
            }
            return ((SubmitPanel)SubmitPanel.this)._sendDialog._submitOkButton;
        }

        @Override
        public Component getDefaultComponent(Container container) {
            return ((SubmitPanel)SubmitPanel.this)._sendDialog._submitOkButton;
        }

        @Override
        public Component getLastComponent(Container container) {
            return SubmitPanel.this._submissionIDsTextField;
        }

        @Override
        public Component getFirstComponent(Container container) {
            return ((SubmitPanel)SubmitPanel.this)._sendDialog._submitOkButton;
        }
    }
}

