/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.customization;

import com.sybase.customization.Customizable;
import com.sybase.customization.CustomizationPage;
import com.sybase.util.DialogUtils;
import com.sybase.util.LabelBar;
import com.sybase.util.Platform;
import com.sybase.util.SybButton;
import com.sybase.util.SybModalDialog;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.Position;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class CustomizeDialog
extends SybModalDialog
implements WindowListener,
ActionListener,
TreeSelectionListener {
    private static Icon _blankIcon = new BlankIcon();
    SybButton _okButton = new SybButton();
    SybButton _cancelButton = new SybButton();
    SybButton _helpButton = new SybButton();
    TreeItem _rootNode = new TreeItem(null);
    ComponentTree _componentTree = new ComponentTree(this._rootNode);
    JScrollPane _treeScrollPane = null;
    JPanel _detailPanel = new JPanel();
    CardLayout _detailPanelLayout = null;
    LabelBar _detailTitle = new LabelBar();
    ArrayList<CustomizationPage[]> _customizationPagesList = new ArrayList();
    boolean _windowOpened = false;
    boolean _windowFirstActivated = false;
    boolean _okWasPressed = false;
    private boolean _needsPacking = true;
    static final Border LIST_BORDER = new EmptyBorder(1, 1, 1, 1);
    static final String CUSTOMIZE_DIALOG_TITLE = "customizedialog.title";
    static final String CUSTOMIZE_DIALOG_TITLE_MAC = "customizedialogmac.title";
    static final String CUSTOMIZE_DIALOG_OK = "customizedialog.OK";
    static final String CUSTOMIZE_DIALOG_CANCEL = "customizedialog.Cancel";
    static final String CUSTOMIZE_DIALOG_HELP = "customizedialog.Help";

    public CustomizeDialog(Frame frame) {
        super(frame);
        this.init(null);
    }

    public CustomizeDialog(Dialog dialog) {
        super(dialog);
        this.init(null);
    }

    public CustomizeDialog(Frame frame, JComponent jComponent) {
        super(frame);
        this.init(jComponent);
    }

    public CustomizeDialog(Dialog dialog, JComponent jComponent) {
        super(dialog);
        this.init(jComponent);
    }

    private void init(JComponent jComponent) {
        this.setResizable(true);
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CustomizeDialog.this.rejectChanges(CustomizeDialog.this._rootNode);
                CustomizeDialog.this.closeWindow();
            }
        };
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
        AbstractAction abstractAction2 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CustomizeDialog.this.showHelp();
            }
        };
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke(112, 0);
        if (Platform.isMacOS()) {
            this.setTitle(CustomizeDialog.getI18NMessage(CUSTOMIZE_DIALOG_TITLE_MAC));
        } else {
            this.setTitle(CustomizeDialog.getI18NMessage(CUSTOMIZE_DIALOG_TITLE));
        }
        this._okButton.addActionListener(this);
        this._cancelButton.addActionListener(this);
        this._helpButton.addActionListener(this);
        this._componentTree.addTreeSelectionListener(this);
        InputMap inputMap = this._cancelButton.getInputMap(2);
        ActionMap actionMap = this._cancelButton.getActionMap();
        if (inputMap != null && actionMap != null) {
            inputMap.put(keyStroke, "cancel");
            actionMap.put("cancel", abstractAction);
        }
        InputMap inputMap2 = this.getRootPane().getInputMap(2);
        ActionMap actionMap2 = this.getRootPane().getActionMap();
        if (inputMap2 != null && actionMap2 != null) {
            inputMap2.put(keyStroke2, "help");
            actionMap2.put("help", abstractAction2);
        }
        JLabel jLabel = new JLabel();
        JPanel jPanel = new JPanel();
        this._treeScrollPane = new JScrollPane(this._componentTree);
        JPanel jPanel2 = new JPanel();
        this.setContentPane(jPanel2);
        jPanel2.setBorder(new EmptyBorder(new Insets(5, 5, 5, 5)));
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel2.setLayout(gridBagLayout);
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        jPanel.setLayout(gridBagLayout2);
        if (jComponent != null) {
            jPanel.add(jComponent);
        }
        jPanel.add(this._okButton);
        jPanel.add(this._cancelButton);
        jPanel.add(this._helpButton);
        jPanel.add(jLabel);
        this._detailPanelLayout = new CardLayout();
        this._detailPanel.setLayout(this._detailPanelLayout);
        this._detailPanelLayout.setHgap(0);
        this._detailPanelLayout.setVgap(0);
        jPanel2.add(this._treeScrollPane);
        jPanel2.add(this._detailTitle);
        jPanel2.add(this._detailPanel);
        jPanel2.add(jPanel);
        this.addWindowListener(this);
        this._okButton.setText(CustomizeDialog.getI18NMessage(CUSTOMIZE_DIALOG_OK));
        this._cancelButton.setText(CustomizeDialog.getI18NMessage(CUSTOMIZE_DIALOG_CANCEL));
        this._helpButton.setText(CustomizeDialog.getI18NMessage(CUSTOMIZE_DIALOG_HELP));
        jLabel.setText(" ");
        if (Platform.isMacOS()) {
            this._treeScrollPane.setVerticalScrollBarPolicy(22);
        } else {
            this._treeScrollPane.setVerticalScrollBarPolicy(20);
        }
        this._treeScrollPane.setHorizontalScrollBarPolicy(31);
        this._componentTree.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 2;
        int n = 1;
        if (jComponent != null) {
            gridBagConstraints.gridx = n++;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints.ipadx = 40;
            gridBagLayout2.setConstraints(jComponent, gridBagConstraints);
        }
        gridBagConstraints.gridx = n++;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.ipadx = 40;
        gridBagLayout2.setConstraints(this._okButton, gridBagConstraints);
        gridBagConstraints.gridx = n++;
        gridBagConstraints.ipadx = 40;
        gridBagLayout2.setConstraints(this._cancelButton, gridBagConstraints);
        gridBagConstraints.gridx = n++;
        gridBagLayout2.setConstraints(this._helpButton, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.ipadx = 0;
        gridBagLayout2.setConstraints(jLabel, gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.weighty = 0.0;
        gridBagConstraints2.gridheight = 2;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.insets = new Insets(0, 0, 0, 5);
        gridBagLayout.setConstraints(this._treeScrollPane, gridBagConstraints2);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.weighty = 0.0;
        gridBagConstraints2.gridheight = 1;
        gridBagConstraints2.gridwidth = 1;
        gridBagLayout.setConstraints(this._detailTitle, gridBagConstraints2);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.gridheight = 1;
        gridBagConstraints2.gridwidth = 1;
        gridBagLayout.setConstraints(this._detailPanel, gridBagConstraints2);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 2;
        gridBagConstraints2.gridheight = 1;
        gridBagConstraints2.gridwidth = 2;
        gridBagLayout.setConstraints(jPanel, gridBagConstraints2);
        this.getRootPane().setDefaultButton(this._okButton);
        this._okButton.requestFocus();
        this._componentTree.setCellRenderer(new TreeViewRenderer());
    }

    public TreeNode addCustomizationPages(Customizable customizable) {
        return this.addCustomizationPages(this._rootNode, customizable);
    }

    public TreeNode addCustomizationPages(TreeNode treeNode, Customizable customizable) {
        CustomizationPage[] customizationPageArray = customizable.getCustomizationPages();
        if (customizationPageArray != null && customizationPageArray.length > 0) {
            if (customizationPageArray.length == 1) {
                JComponent jComponent = (JComponent)customizationPageArray[0].getComponent();
                jComponent.putClientProperty("pages", customizationPageArray);
                this._detailPanel.add(customizationPageArray[0].getComponent(), customizable.getCustomizationGroupTitle());
            } else {
                JTabbedPane jTabbedPane = new JTabbedPane();
                jTabbedPane.putClientProperty("pages", customizationPageArray);
                jTabbedPane.setTabPlacement(1);
                for (CustomizationPage customizationPage : customizationPageArray) {
                    jTabbedPane.addTab(customizationPage.getTitle(), customizationPage.getComponent());
                }
                jTabbedPane.setSelectedIndex(0);
                this._detailPanel.add((Component)jTabbedPane, customizable.getCustomizationGroupTitle());
            }
            if (this._componentTree.isSelectionEmpty()) {
                this._componentTree.setSelectionRow(0);
            }
            this._customizationPagesList.add(customizationPageArray);
        }
        TreeNode treeNode2 = this.addNewTreeNode(treeNode, customizable);
        return treeNode2;
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl && this._needsPacking) {
            this._needsPacking = false;
            this._componentTree.updateUI();
            if (this._componentTree.isSelectionEmpty()) {
                this._componentTree.setSelectionRow(0);
            }
            Dimension dimension = this._componentTree.getPreferredSize();
            dimension.width += 4;
            this.getContentPane().add(Box.createHorizontalStrut(dimension.width), new GridBagConstraints(0, 99, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.pack();
            this.setLocationRelativeTo(this.getOwner());
        }
        super.setVisible(bl);
    }

    public TreeNode addNewTreeNode(TreeNode treeNode, Customizable customizable) {
        if (treeNode == null) {
            treeNode = this._rootNode;
        }
        TreeItem treeItem = new TreeItem(customizable);
        ((TreeItem)treeNode).add(treeItem);
        return treeItem;
    }

    public void destroy() {
        int n;
        if (this._detailPanel != null) {
            for (n = 0; n < this._detailPanel.getComponentCount(); ++n) {
                Component component = this._detailPanel.getComponent(n);
            }
        }
        int n2 = this._customizationPagesList.size();
        for (n = 0; n < n2; ++n) {
            CustomizationPage[] customizationPageArray;
            for (CustomizationPage customizationPage : customizationPageArray = this._customizationPagesList.get(n)) {
                customizationPage.destroy();
            }
        }
        this._customizationPagesList.clear();
        this._okButton.removeActionListener(this);
        this._cancelButton.removeActionListener(this);
        this._helpButton.removeActionListener(this);
        this._componentTree.removeTreeSelectionListener(this);
        this.removeWindowListener(this);
        DialogUtils.removeComponents(this);
    }

    public void selectComponentByClass(Class<?> clazz) {
        for (int i = 0; i < this._customizationPagesList.size(); ++i) {
            CustomizationPage[] customizationPageArray;
            for (CustomizationPage customizationPage : customizationPageArray = this._customizationPagesList.get(i)) {
                JComponent jComponent;
                JTabbedPane jTabbedPane;
                if (customizationPage.getClass() != clazz) continue;
                Enumeration<TreeNode> enumeration = this._rootNode.children();
                int n = 0;
                while (enumeration.hasMoreElements()) {
                    TreeItem treeItem = (TreeItem)enumeration.nextElement();
                    if (n == i) {
                        TreePath treePath = new TreePath(treeItem.getPath());
                        this._componentTree.setSelectionPath(treePath);
                        this._componentTree.scrollPathToVisible(treePath);
                        break;
                    }
                    ++n;
                }
                if ((jTabbedPane = (JTabbedPane)SwingUtilities.getAncestorOfClass(JTabbedPane.class, jComponent = (JComponent)customizationPage.getComponent())) != null) {
                    jTabbedPane.setSelectedComponent(jComponent);
                }
                return;
            }
        }
    }

    public void selectComponent(Customizable customizable) {
        TreePath treePath = this.findPathToComponent(this._rootNode, customizable);
        if (treePath != null) {
            this._componentTree.setSelectionPath(treePath);
            this._componentTree.scrollPathToVisible(treePath);
        } else {
            CustomizationPage[] customizationPageArray = customizable.getCustomizationPages();
            if (customizationPageArray != null && customizationPageArray.length > 0) {
                this.selectComponentByClass(customizationPageArray[0].getClass());
            }
        }
    }

    private TreePath findPathToComponent(TreeItem treeItem, Customizable customizable) {
        if (treeItem.isLeaf()) {
            Object object = treeItem.getUserObject();
            if (object == customizable) {
                return new TreePath(treeItem.getPath());
            }
        } else {
            Enumeration<TreeNode> enumeration = treeItem.children();
            while (enumeration.hasMoreElements()) {
                TreeItem treeItem2 = (TreeItem)enumeration.nextElement();
                TreePath treePath = this.findPathToComponent(treeItem2, customizable);
                if (treePath == null) continue;
                return treePath;
            }
        }
        return null;
    }

    private void showHelp() {
        Component[] componentArray = this._detailPanel.getComponents();
        int n = -1;
        for (int i = 0; i < componentArray.length; ++i) {
            if (!componentArray[i].isVisible()) continue;
            n = i;
            break;
        }
        if (n > -1) {
            JComponent jComponent = (JComponent)componentArray[n];
            CustomizationPage[] customizationPageArray = (CustomizationPage[])jComponent.getClientProperty("pages");
            int n2 = jComponent instanceof JTabbedPane ? ((JTabbedPane)jComponent).getSelectedIndex() : 0;
            customizationPageArray[n2].showHelp();
        }
    }

    private void okClicked() {
        boolean bl = true;
        int n = this._customizationPagesList.size();
        block0: for (int i = 0; i < n; ++i) {
            CustomizationPage[] customizationPageArray;
            for (CustomizationPage customizationPage : customizationPageArray = this._customizationPagesList.get(i)) {
                if (customizationPage.validateChanges()) continue;
                bl = false;
                break block0;
            }
        }
        if (bl) {
            this.acceptChanges(this._rootNode);
            this._okWasPressed = true;
            this.closeWindow();
        }
    }

    private void acceptChanges(TreeItem treeItem) {
        if (treeItem.getUserObject() != null) {
            ((Customizable)treeItem.getUserObject()).acceptChanges();
        }
        if (!treeItem.isLeaf()) {
            Enumeration<TreeNode> enumeration = treeItem.children();
            while (enumeration.hasMoreElements()) {
                this.acceptChanges((TreeItem)enumeration.nextElement());
            }
        }
    }

    private void rejectChanges(TreeItem treeItem) {
        if (treeItem.getUserObject() != null) {
            ((Customizable)treeItem.getUserObject()).rejectChanges();
        }
        if (!treeItem.isLeaf()) {
            Enumeration<TreeNode> enumeration = treeItem.children();
            while (enumeration.hasMoreElements()) {
                this.rejectChanges((TreeItem)enumeration.nextElement());
            }
        }
    }

    public void simulateOKClick() {
        this.okClicked();
    }

    public boolean wasOKClicked() {
        return this._okWasPressed;
    }

    private static ResourceBundle getResourceBundle() {
        ResourceBundle resourceBundle = null;
        String string = System.getProperty("language", System.getProperty("user.language", null));
        String string2 = System.getProperty("country", System.getProperty("user.region", null));
        if (string != null && string2 != null) {
            try {
                resourceBundle = ResourceBundle.getBundle("com.sybase.customization.CommonCustomizerResourceBundle", new Locale(string, string2));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (resourceBundle == null) {
            try {
                resourceBundle = ResourceBundle.getBundle("com.sybase.customization.CommonCustomizerResourceBundle", Locale.getDefault());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (resourceBundle == null) {
            try {
                resourceBundle = ResourceBundle.getBundle("com.sybase.customization.CommonCustomizerResourceBundle");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (resourceBundle == null) {
            throw new MissingResourceException("Can't find resource for base name com.sybase.customization.CommonCustomizerResourceBundle", "", "");
        }
        return resourceBundle;
    }

    static final String getI18NMessage(String string) {
        String string2 = "";
        try {
            string2 = (String)CustomizeDialog.getResourceBundle().getObject(string);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return string2;
    }

    private void closeWindow() {
        this.setVisible(false);
        this._windowOpened = false;
        this._windowFirstActivated = false;
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        TreePath treePath = treeSelectionEvent.getNewLeadSelectionPath();
        if (treePath != null) {
            Object object = treePath.getLastPathComponent();
            Object object2 = ((TreeItem)object).getUserObject();
            if (object2 != null) {
                this._detailPanelLayout.show(this._detailPanel, ((Customizable)object2).getCustomizationGroupTitle());
                this._detailTitle.setText(((Customizable)object2).getCustomizationGroupTitle());
            }
        } else {
            this._componentTree.setSelectionRow(0);
        }
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
        if (!this._windowOpened) {
            this._windowOpened = true;
            int n = this._customizationPagesList.size();
            for (int i = 0; i < n; ++i) {
                CustomizationPage[] customizationPageArray;
                for (CustomizationPage customizationPage : customizationPageArray = this._customizationPagesList.get(i)) {
                    customizationPage.initialize();
                }
            }
        }
        this._okWasPressed = false;
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.rejectChanges(this._rootNode);
        this.closeWindow();
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
        Dimension dimension = null;
        Insets insets = new Insets(0, 0, 0, 0);
        Border border = null;
        if (!this._windowOpened) {
            this._windowOpened = true;
            int n = this._customizationPagesList.size();
            for (int i = 0; i < n; ++i) {
                CustomizationPage[] customizationPageArray;
                for (CustomizationPage customizationPage : customizationPageArray = this._customizationPagesList.get(i)) {
                    customizationPage.initialize();
                }
            }
        }
        if (!this._windowFirstActivated) {
            this._windowFirstActivated = true;
            dimension = this._componentTree.getPreferredSize();
            border = this._treeScrollPane.getBorder();
            if (border != null) {
                insets = border.getBorderInsets(this._treeScrollPane);
            }
            this._treeScrollPane.setMinimumSize(new Dimension(dimension.width + insets.left + insets.right + 2, dimension.height + insets.top + insets.bottom));
        }
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._okButton) {
            this.okClicked();
        } else if (object == this._cancelButton) {
            this.rejectChanges(this._rootNode);
            this.closeWindow();
        } else if (object == this._helpButton) {
            this.showHelp();
        }
    }

    static class TreeViewRenderer
    extends JPanel
    implements TreeCellRenderer {
        private JLabel _iconLabel = new JLabel();
        private JLabel _textLabel = new JLabel();
        private static final Border NO_FOCUS_BORDER = new EmptyBorder(1, 1, 1, 1);

        TreeViewRenderer() {
            this.setOpaque(false);
            this.setLayout(new FlowLayout(0, 5, 0));
            this.add(this._iconLabel);
            this.add(this._textLabel);
            this._iconLabel.setBackground(UIManager.getColor("Tree.background"));
            this._iconLabel.setForeground(UIManager.getColor("Tree.foreground"));
            this._textLabel.setOpaque(true);
            this._textLabel.setBackground(UIManager.getColor("Tree.background"));
            this._textLabel.setForeground(UIManager.getColor("Tree.foreground"));
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            return this._textLabel.getAccessibleContext();
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            if (object != null) {
                this._textLabel.setBorder(bl4 ? UIManager.getBorder("Table.focusCellHighlightBorder") : NO_FOCUS_BORDER);
                TreeItem treeItem = (TreeItem)object;
                this._textLabel.setText(treeItem.toString());
                this._textLabel.setToolTipText(treeItem.toString());
                if (treeItem.getIcon() == null) {
                    this._iconLabel.setIcon(_blankIcon);
                } else {
                    this._iconLabel.setIcon(treeItem.getIcon());
                }
                if (bl && bl4) {
                    this._textLabel.setBackground(UIManager.getColor("TextField.selectionBackground"));
                    this._textLabel.setForeground(UIManager.getColor("TextField.selectionForeground"));
                } else if (bl && !bl4) {
                    this._textLabel.setBackground(SystemColor.control);
                    this._textLabel.setForeground(SystemColor.controlText);
                } else {
                    this._textLabel.setBackground(UIManager.getColor("Tree.background"));
                    this._textLabel.setForeground(UIManager.getColor("Label.foreground"));
                }
                Dimension dimension = new Dimension(Math.max(this._iconLabel.getHeight(), this._textLabel.getHeight()), this._iconLabel.getPreferredSize().width + this._textLabel.getPreferredSize().width);
                this.setSize(dimension);
            }
            return this;
        }
    }

    static class TreeItem
    extends DefaultMutableTreeNode {
        TreeItem(Customizable customizable) {
            super(customizable);
        }

        @Override
        public boolean isLeaf() {
            return this.getUserObject() != null;
        }

        @Override
        public String toString() {
            if (this.getUserObject() == null) {
                return "ROOT NODE";
            }
            return ((Customizable)this.getUserObject()).getCustomizationGroupTitle();
        }

        public Icon getIcon() {
            if (this.getUserObject() == null) {
                return null;
            }
            return ((Customizable)this.getUserObject()).getCustomizationGroupIcon();
        }
    }

    static class ComponentTree
    extends JTree {
        ComponentTree(TreeNode treeNode) {
            super(treeNode);
            this.expandRow(0);
            this.setRootVisible(false);
            this.setShowsRootHandles(false);
            this.getSelectionModel().setSelectionMode(1);
        }

        @Override
        public TreePath getNextMatch(String string, int n, Position.Bias bias) {
            int n2 = this.getRowCount();
            if (string == null) {
                throw new IllegalArgumentException();
            }
            if (n < 0 || n >= n2) {
                throw new IllegalArgumentException();
            }
            string = string.toUpperCase();
            int n3 = bias == Position.Bias.Forward ? 1 : -1;
            int n4 = n;
            do {
                String string2;
                Object object;
                if ((object = ((TreeItem)this.getPathForRow(n4).getLastPathComponent()).getUserObject()) == null) continue;
                if (object instanceof Customizable) {
                    string2 = ((Customizable)object).getCustomizationGroupTitle();
                    if (string2 != null) {
                        string2 = string2.toUpperCase();
                    }
                } else {
                    string2 = object.toString();
                    if (string2 != null) {
                        string2 = string2.toUpperCase();
                    }
                }
                if (string2 == null || !string2.startsWith(string)) continue;
                return this.getPathForRow(n4);
            } while ((n4 = (n4 + n3 + n2) % n2) != n);
            return null;
        }
    }

    static class BlankIcon
    implements Icon {
        private static final int SIZE = 16;

        BlankIcon() {
        }

        @Override
        public int getIconWidth() {
            return 16;
        }

        @Override
        public int getIconHeight() {
            return 16;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.setColor(component.getBackground());
            graphics.fillRect(n, n2, 15, 15);
        }
    }
}

