/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.datechooser;

import com.sybase.datechooser.DateChangeEvent;
import com.sybase.datechooser.DateChangeListener;
import com.sybase.datechooser.SybDateChooserPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JDialog;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;

public class SybDateChooser
extends JDialog
implements DateChangeListener,
WindowFocusListener,
ComponentListener {
    private SybDateChooserPanel _dateChooserPanel;
    private EventListenerList _listenerList = new EventListenerList();

    public SybDateChooser(Dialog dialog, String string) {
        super(dialog, string, false);
        this.init(dialog, null);
    }

    public SybDateChooser(Dialog dialog, String string, Component component) {
        super(dialog, string, false);
        this.init(dialog, component);
    }

    public SybDateChooser(Dialog dialog) {
        super(dialog, false);
        this.setUndecorated(true);
        this.init(dialog, null);
    }

    public SybDateChooser(Dialog dialog, Component component) {
        super(dialog, false);
        this.setUndecorated(true);
        this.init(dialog, component);
    }

    public SybDateChooser(Frame frame, String string, Component component) {
        super(frame, string, false);
        this.init(frame, component);
    }

    public SybDateChooser(Frame frame, String string) {
        super(frame, string, false);
        this.init(frame, null);
    }

    public SybDateChooser(Frame frame, Component component) {
        super(frame, false);
        this.setUndecorated(true);
        this.init(frame, component);
    }

    public SybDateChooser(Frame frame) {
        super(frame, false);
        this.setUndecorated(true);
        this.init(frame, null);
    }

    public static SybDateChooser getDialog(Component component, String string, Date date) {
        Window window = SwingUtilities.getWindowAncestor(component);
        SybDateChooser sybDateChooser = null;
        if (window instanceof Frame) {
            sybDateChooser = string != null ? new SybDateChooser((Frame)window, string, component) : new SybDateChooser((Frame)window, component);
        } else if (window instanceof Dialog) {
            sybDateChooser = string != null ? new SybDateChooser((Dialog)window, string, component) : new SybDateChooser((Dialog)window, component);
        }
        if (sybDateChooser == null) {
            return null;
        }
        sybDateChooser.setTodaysDate(new Date());
        sybDateChooser.setSelectedDate(date);
        return sybDateChooser;
    }

    public void setTodaysDate(Date date) {
        this._dateChooserPanel.setTodaysDate(date);
    }

    private void init(Window window, Component component) {
        this.addWindowFocusListener(this);
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SybDateChooser.this.setVisible(false);
            }
        };
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
        InputMap inputMap = this.getRootPane().getInputMap(2);
        ActionMap actionMap = this.getRootPane().getActionMap();
        if (inputMap != null && actionMap != null) {
            inputMap.put(keyStroke, "cancel");
            actionMap.put("cancel", abstractAction);
        }
        AbstractAction abstractAction2 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SybDateChooser.this.fireDateChanged(SybDateChooser.this.getSelectedDate());
                SybDateChooser.this.setVisible(false);
            }
        };
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke(10, 0);
        if (inputMap != null && actionMap != null) {
            inputMap.put(keyStroke2, "selectDay");
            actionMap.put("selectDay", abstractAction2);
        }
        this._dateChooserPanel = new SybDateChooserPanel();
        this._dateChooserPanel.addDateChangeListener(this);
        Container container = this.getContentPane();
        container.add("Center", this._dateChooserPanel);
        container.setBackground(SystemColor.text);
        this.pack();
        this.setResizable(false);
        if (component != null) {
            int n;
            Cursor cursor = component.getCursor();
            component.setCursor(new Cursor(3));
            Rectangle rectangle = component.getBounds();
            Point point = component.getLocationOnScreen();
            Rectangle rectangle2 = new Rectangle();
            for (GraphicsDevice graphicsDevice : GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()) {
                for (GraphicsConfiguration graphicsConfiguration : graphicsDevice.getConfigurations()) {
                    rectangle2 = rectangle2.union(graphicsConfiguration.getBounds());
                }
            }
            int n2 = (int)(point.getX() + rectangle.getWidth() / 2.0 - (double)(this.getWidth() / 2));
            if (n2 < 0) {
                n2 = 0;
            }
            if (n2 + this.getWidth() > rectangle2.width) {
                n2 = rectangle2.width - this.getWidth();
            }
            n = (n = (int)point.getY()) + rectangle.height + 1 + this.getHeight() + 30 < rectangle2.height ? n + rectangle.height + 1 : n - this.getHeight() - 1;
            this.setBounds(new Rectangle(n2, n, this.getWidth(), this.getHeight()));
            component.setCursor(cursor);
        } else {
            this.setLocationRelativeTo(window);
        }
        this.addComponentListener(this);
        this._dateChooserPanel.requestFocus();
    }

    public void goToToday() {
        this._dateChooserPanel.goToToday();
    }

    public void setSelectedDate() {
        this._dateChooserPanel.setSelectedDate();
    }

    public void setSelectedDate(Date date) {
        this._dateChooserPanel.setSelectedDate(date);
    }

    public Date getSelectedDate() {
        return this._dateChooserPanel.getSelectedDate();
    }

    public void destroy() {
        this._dateChooserPanel.removeDateChangeListener(this);
        this._dateChooserPanel.destroy();
        this.removeWindowFocusListener(this);
        this.removeComponentListener(this);
    }

    @Override
    public void dateChanged(DateChangeEvent dateChangeEvent) {
        if (dateChangeEvent.getBaseEvent() instanceof MouseEvent) {
            this.fireDateChanged(this.getSelectedDate());
            this.setVisible(false);
        }
    }

    @Override
    public void windowGainedFocus(WindowEvent windowEvent) {
    }

    @Override
    public void windowLostFocus(WindowEvent windowEvent) {
        this.setVisible(false);
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                SybDateChooser.this.destroy();
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void addDateChangeListener(DateChangeListener dateChangeListener) {
        this._listenerList.add(DateChangeListener.class, dateChangeListener);
    }

    public void removeDateChangeListener(DateChangeListener dateChangeListener) {
        this._listenerList.remove(DateChangeListener.class, dateChangeListener);
    }

    void fireDateChanged(Date date) {
        Object[] objectArray = this._listenerList.getListenerList();
        DateChangeEvent dateChangeEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != DateChangeListener.class) continue;
            if (dateChangeEvent == null) {
                dateChangeEvent = new DateChangeEvent(this, date, null);
            }
            ((DateChangeListener)objectArray[i + 1]).dateChanged(dateChangeEvent);
        }
    }
}

