/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.datechooser;

import com.sybase.datechooser.DateChangeEvent;
import com.sybase.datechooser.DateChangeListener;
import com.sybase.util.SybMenuItem;
import com.sybase.util.UIUtils;
import java.awt.BorderLayout;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.event.EventListenerList;
import javax.swing.plaf.basic.BasicArrowButton;

public class SybDateChooserPanel
extends JPanel
implements MouseListener,
ActionListener,
FocusListener {
    private static final Border EMPTY_BORDER = BorderFactory.createEmptyBorder(1, 1, 1, 1);
    private static final Border DAY_FOCUSED_BORDER = BorderFactory.createLineBorder(SystemColor.activeCaptionBorder, 1);
    private static final Border TODAY_BORDER = BorderFactory.createLineBorder(SystemColor.windowBorder, 1);
    private static final Border UNDERLINE_BORDER = BorderFactory.createMatteBorder(0, 0, 1, 0, SystemColor.textText);
    private Action _previousMonthKeyAction;
    private Action _nextMonthKeyAction;
    private Action _goToTodayAction;
    private Action _previousDayAction;
    private Action _nextDayAction;
    private Action _previousWeekAction;
    private Action _nextWeekAction;
    private GregorianCalendar _calendar;
    private JLabel[][] _days;
    private JPanel _daysGrid;
    private BasicArrowButton _previousMonth;
    private BasicArrowButton _nextMonth;
    private JLabel _selectedDay;
    private JLabel _todaysDateLabel;
    private JLabel _todaySampleDate;
    private Date _today = new Date();
    private DateFormat _todayDateFormat = DateFormat.getDateInstance(3);
    private JLabel _todayLabel = new JLabel();
    private JLabel _displayMonth = new JLabel();
    private JLabel _displayYear = new JLabel();
    private JPanel _monthYearPanel;
    private SimpleDateFormat _yearDateFormat;
    private SimpleDateFormat _monthDateFormat;
    private JPopupMenu _popupMenu;
    private boolean _popupTrigger = false;
    private JPopupMenu _monthPopupMenu;
    private EventListenerList _listenerList = new EventListenerList();
    static final String TODAY = "TODAY";
    static final String GO_TO_TODAY = "GO_TO_TODAY";

    public SybDateChooserPanel() {
        this(new Date());
    }

    public SybDateChooserPanel(Date date) {
        this.init();
        this.setSelectedDate(date);
    }

    public void setTodaysDate(Date date) {
        this._today = date;
        this._todayLabel.setText(this._todayDateFormat.format(this._today));
    }

    private void init() {
        int n;
        this.setFocusable(true);
        this._calendar = new GregorianCalendar();
        this._previousMonthKeyAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SybDateChooserPanel.this._calendar.add(2, 1);
                SybDateChooserPanel.this.update();
            }
        };
        KeyStroke keyStroke = KeyStroke.getKeyStroke(34, 0);
        ActionMap actionMap = this.getActionMap();
        InputMap inputMap = this.getInputMap(0);
        if (inputMap != null && actionMap != null) {
            inputMap.put(keyStroke, "previousMonth");
            actionMap.put("previousMonth", this._previousMonthKeyAction);
        }
        this._nextMonthKeyAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SybDateChooserPanel.this._calendar.add(2, -1);
                SybDateChooserPanel.this.update();
            }
        };
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke(33, 0);
        if (inputMap != null && actionMap != null) {
            inputMap.put(keyStroke2, "nextMonth");
            actionMap.put("nextMonth", this._nextMonthKeyAction);
        }
        this._goToTodayAction = new AbstractAction(SybDateChooserPanel.getI18NMessage(GO_TO_TODAY)){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SybDateChooserPanel.this.goToToday();
                SybDateChooserPanel.this.requestFocusInWindow();
            }
        };
        KeyStroke keyStroke3 = KeyStroke.getKeyStroke(71, 2);
        if (inputMap != null && actionMap != null) {
            inputMap.put(keyStroke3, "goToToday");
            actionMap.put("goToToday", this._goToTodayAction);
        }
        this._previousDayAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = SybDateChooserPanel.this.getSelectedDay();
                if (n > 1) {
                    SybDateChooserPanel.this.selectDay(n - 1);
                }
            }
        };
        KeyStroke keyStroke4 = KeyStroke.getKeyStroke(37, 0);
        if (inputMap != null && actionMap != null) {
            inputMap.put(keyStroke4, "previousDay");
            actionMap.put("previousDay", this._previousDayAction);
        }
        this._nextDayAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                int n2 = SybDateChooserPanel.this.getSelectedDay();
                if (n2 < (n = SybDateChooserPanel.this._calendar.getActualMaximum(5))) {
                    SybDateChooserPanel.this.selectDay(n2 + 1);
                }
            }
        };
        KeyStroke keyStroke5 = KeyStroke.getKeyStroke(39, 0);
        if (inputMap != null && actionMap != null) {
            inputMap.put(keyStroke5, "nextDay");
            actionMap.put("nextDay", this._nextDayAction);
        }
        this._previousWeekAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = SybDateChooserPanel.this.getSelectedDay();
                if (n > 7) {
                    SybDateChooserPanel.this.selectDay(n - 7);
                }
            }
        };
        KeyStroke keyStroke6 = KeyStroke.getKeyStroke(38, 0);
        if (inputMap != null && actionMap != null) {
            inputMap.put(keyStroke6, "previousWeek");
            actionMap.put("previousWeek", this._previousWeekAction);
        }
        this._nextWeekAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                int n2 = SybDateChooserPanel.this.getSelectedDay();
                if (n2 <= (n = SybDateChooserPanel.this._calendar.getActualMaximum(5)) - 7) {
                    SybDateChooserPanel.this.selectDay(n2 + 7);
                }
            }
        };
        KeyStroke keyStroke7 = KeyStroke.getKeyStroke(40, 0);
        if (inputMap != null && actionMap != null) {
            inputMap.put(keyStroke7, "nextWeek");
            actionMap.put("nextWeek", this._nextWeekAction);
        }
        DateFormatSymbols dateFormatSymbols = new DateFormatSymbols();
        this._monthPopupMenu = new JPopupMenu();
        String[] stringArray = dateFormatSymbols.getMonths();
        this._monthPopupMenu.add(new SybMenuItem(new AbstractAction(stringArray[0]){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SybDateChooserPanel.this.updateMonthDisplay(0);
            }
        }));
        this._monthPopupMenu.add(new SybMenuItem(new AbstractAction(stringArray[1]){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SybDateChooserPanel.this.updateMonthDisplay(1);
            }
        }));
        this._monthPopupMenu.add(new SybMenuItem(new AbstractAction(stringArray[2]){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SybDateChooserPanel.this.updateMonthDisplay(2);
            }
        }));
        this._monthPopupMenu.add(new SybMenuItem(new AbstractAction(stringArray[3]){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SybDateChooserPanel.this.updateMonthDisplay(3);
            }
        }));
        this._monthPopupMenu.add(new SybMenuItem(new AbstractAction(stringArray[4]){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SybDateChooserPanel.this.updateMonthDisplay(4);
            }
        }));
        this._monthPopupMenu.add(new SybMenuItem(new AbstractAction(stringArray[5]){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SybDateChooserPanel.this.updateMonthDisplay(5);
            }
        }));
        this._monthPopupMenu.add(new SybMenuItem(new AbstractAction(stringArray[6]){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SybDateChooserPanel.this.updateMonthDisplay(6);
            }
        }));
        this._monthPopupMenu.add(new SybMenuItem(new AbstractAction(stringArray[7]){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SybDateChooserPanel.this.updateMonthDisplay(7);
            }
        }));
        this._monthPopupMenu.add(new SybMenuItem(new AbstractAction(stringArray[8]){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SybDateChooserPanel.this.updateMonthDisplay(8);
            }
        }));
        this._monthPopupMenu.add(new SybMenuItem(new AbstractAction(stringArray[9]){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SybDateChooserPanel.this.updateMonthDisplay(9);
            }
        }));
        this._monthPopupMenu.add(new SybMenuItem(new AbstractAction(stringArray[10]){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SybDateChooserPanel.this.updateMonthDisplay(10);
            }
        }));
        this._monthPopupMenu.add(new SybMenuItem(new AbstractAction(stringArray[11]){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SybDateChooserPanel.this.updateMonthDisplay(11);
            }
        }));
        this._popupMenu = new JPopupMenu();
        this._popupMenu.add(new SybMenuItem(this._goToTodayAction));
        this._yearDateFormat = new SimpleDateFormat("yyyy");
        this._monthDateFormat = new SimpleDateFormat("MMMM");
        String[] stringArray2 = dateFormatSymbols.getShortWeekdays();
        int n2 = this._calendar.getFirstDayOfWeek();
        this._days = new JLabel[7][7];
        for (n = 0; n < 7; ++n) {
            if (n + n2 >= stringArray2.length) {
                n2 = n2 + 1 - stringArray2.length;
            }
            this._days[0][n] = new JLabel(stringArray2[n + n2], 4);
            this._days[0][n].setForeground(SystemColor.textText);
            this._days[0][n].setBorder(UNDERLINE_BORDER);
        }
        for (n = 1; n < 7; ++n) {
            for (int i = 0; i < 7; ++i) {
                this._days[n][i] = new JLabel(" ", 4);
                this._days[n][i].setForeground(SystemColor.textText);
                this._days[n][i].setBackground(SystemColor.textHighlight);
                this._days[n][i].setBorder(EMPTY_BORDER);
            }
        }
        this.update();
        this._previousMonth = new BasicArrowButton(7);
        this._previousMonth.setFocusable(false);
        this._nextMonth = new BasicArrowButton(3);
        this._nextMonth.setFocusable(false);
        this._monthYearPanel = new JPanel();
        this._monthYearPanel.setForeground(SystemColor.textHighlightText);
        this._monthYearPanel.setBackground(SystemColor.textHighlight);
        this._displayMonth.setForeground(SystemColor.textHighlightText);
        this._displayMonth.setBackground(SystemColor.textHighlight);
        this._displayMonth.setHorizontalAlignment(4);
        this._displayMonth.setHorizontalTextPosition(4);
        this._displayYear.setForeground(SystemColor.textHighlightText);
        this._displayYear.setBackground(SystemColor.textHighlight);
        this._displayYear.setHorizontalAlignment(2);
        this._displayYear.setHorizontalTextPosition(2);
        this._monthYearPanel.add(this._previousMonth);
        this._monthYearPanel.add(this._displayMonth);
        this._monthYearPanel.add(this._displayYear);
        this._monthYearPanel.add(this._nextMonth);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this._monthYearPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagLayout.setConstraints(this._previousMonth, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagLayout.setConstraints(this._displayMonth, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagLayout.setConstraints(this._displayYear, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(this._nextMonth, gridBagConstraints);
        Insets insets = this._previousMonth.getMargin();
        insets.left = 2;
        insets.right = 2;
        this._previousMonth.setMargin(insets);
        this._nextMonth.setMargin(insets);
        this._daysGrid = new JPanel(new GridLayout(7, 7, 5, 0));
        for (int i = 0; i < 7; ++i) {
            for (int j = 0; j < 7; ++j) {
                this._daysGrid.add(this._days[i][j]);
            }
        }
        this._daysGrid.setBackground(SystemColor.text);
        JPanel jPanel = new JPanel();
        jPanel.setBackground(SystemColor.text);
        jPanel.add(this._daysGrid);
        this.setTodaysDate(new Date());
        JPanel jPanel2 = new JPanel();
        jPanel2.setBackground(SystemColor.text);
        this._todaySampleDate = new JLabel("   ");
        this._todaysDateLabel = new JLabel(SybDateChooserPanel.getI18NMessage(TODAY));
        this._todaySampleDate.setBorder(TODAY_BORDER);
        jPanel2.add(this._todaySampleDate);
        jPanel2.add(this._todaysDateLabel);
        jPanel2.add(this._todayLabel);
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        jPanel2.setLayout(gridBagLayout2);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.anchor = 13;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.insets = new Insets(0, 5, 5, 0);
        gridBagLayout2.setConstraints(this._todaySampleDate, gridBagConstraints2);
        gridBagConstraints2.gridx = 1;
        gridBagLayout2.setConstraints(this._todaysDateLabel, gridBagConstraints2);
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.gridx = 2;
        gridBagConstraints2.weightx = 1.0;
        gridBagLayout2.setConstraints(this._todayLabel, gridBagConstraints2);
        this.setBorder(BorderFactory.createLineBorder(SystemColor.textText, 1));
        this.setLayout(new BorderLayout());
        this.add("North", this._monthYearPanel);
        this.add("Center", jPanel);
        this.add("South", jPanel2);
        this.setBackground(SystemColor.text);
        this.enableListeners();
    }

    @Override
    protected void paintBorder(Graphics graphics) {
        Rectangle rectangle = new Rectangle();
        rectangle.setBounds(this.getBounds());
        graphics.setColor(SystemColor.controlShadow);
        graphics.drawLine(0, 0, rectangle.width - 1, 0);
        graphics.drawLine(0, 0, 0, rectangle.height - 1);
        graphics.setColor(SystemColor.controlHighlight);
        graphics.drawLine(rectangle.width - 1, 0, rectangle.width - 1, rectangle.height - 1);
        graphics.drawLine(0, rectangle.height - 1, rectangle.width - 1, rectangle.height - 1);
        if (this.hasFocus()) {
            int n;
            graphics.setColor(SystemColor.textText);
            int n2 = rectangle.width - 4;
            for (n = 2; n < n2; n += 3) {
                graphics.drawLine(n, 2, n + 1, 2);
                graphics.drawLine(n, rectangle.height - 3, n + 1, rectangle.height - 3);
            }
            n2 = rectangle.height - 4;
            for (n = 2; n < n2; n += 3) {
                graphics.drawLine(2, n, 2, n + 1);
                graphics.drawLine(rectangle.width - 3, n, rectangle.width - 3, n + 1);
            }
        } else {
            graphics.setColor(this.getBackground());
            graphics.drawRect(2, 2, rectangle.width - 5, rectangle.height - 5);
        }
    }

    @Override
    public Insets getInsets() {
        return new Insets(4, 4, 4, 4);
    }

    public void goToToday() {
        this.setSelectedDate(new Date());
        this.update();
    }

    private int getSelectedDay() {
        if (this._selectedDay == null) {
            return -1;
        }
        try {
            return Integer.parseInt(this._selectedDay.getText());
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    private void selectDay(int n) {
        int n2;
        int n3 = this._calendar.getActualMaximum(5);
        if (n != -1) {
            if (n > n3) {
                n = n3;
            }
            this._calendar.set(5, n);
            this.fireDateChanged(this._calendar.getTime(), null);
        }
        if ((n2 = this._calendar.get(7) - this._calendar.getFirstDayOfWeek()) < 0) {
            n2 += 7;
        }
        this.selectDay(this._days[this._calendar.get(4)][n2]);
    }

    private void selectDay(JLabel jLabel) {
        if (this._daysGrid == null) {
            return;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this._today);
        if (this._selectedDay != null) {
            this._selectedDay.setForeground(SystemColor.textText);
            this._selectedDay.setOpaque(false);
            this._selectedDay.setBorder(EMPTY_BORDER);
            try {
                if (calendar.get(1) == this._calendar.get(1) && calendar.get(2) == this._calendar.get(2) && calendar.get(5) == Integer.parseInt(this._selectedDay.getText())) {
                    this._selectedDay.setBorder(TODAY_BORDER);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this._selectedDay = jLabel;
        this._selectedDay.setForeground(SystemColor.textHighlightText);
        this._selectedDay.setOpaque(true);
        if (this._daysGrid.hasFocus()) {
            this._selectedDay.setBorder(DAY_FOCUSED_BORDER);
        }
        try {
            if (calendar.get(1) == this._calendar.get(1) && calendar.get(2) == this._calendar.get(2) && calendar.get(5) == Integer.parseInt(this._selectedDay.getText())) {
                this._selectedDay.setBorder(TODAY_BORDER);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void update() {
        int n;
        for (n = 0; n < 7; ++n) {
            this._days[1][n].setText(" ");
            this._days[5][n].setText(" ");
            this._days[6][n].setText(" ");
            this._days[1][n].setBorder(EMPTY_BORDER);
            this._days[5][n].setBorder(EMPTY_BORDER);
            this._days[6][n].setBorder(EMPTY_BORDER);
        }
        n = this.getOffset();
        int n2 = this._calendar.getActualMaximum(5);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this._today);
        for (int i = 0; i < n2; ++i) {
            int n3 = i + 1;
            int n4 = (i + n) / 7 + 1;
            int n5 = (i + n) % 7;
            this._days[n4][n5].setText(String.valueOf(n3));
            if (calendar.get(1) == this._calendar.get(1) && calendar.get(2) == this._calendar.get(2) && calendar.get(5) == n3) {
                this._days[n4][n5].setBorder(TODAY_BORDER);
                continue;
            }
            this._days[n4][n5].setBorder(EMPTY_BORDER);
        }
        this.selectDay(this._calendar.get(5));
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer = this._monthDateFormat.format(this._calendar.getTime(), stringBuffer, new FieldPosition(1));
        this._displayMonth.setText(stringBuffer.toString());
        stringBuffer.setLength(0);
        stringBuffer = this._yearDateFormat.format(this._calendar.getTime(), stringBuffer, new FieldPosition(1));
        this._displayYear.setText(stringBuffer.toString());
    }

    private int getOffset() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(this._calendar.get(1), this._calendar.get(2), 1);
        int n = calendar.get(7) - calendar.getFirstDayOfWeek();
        if (n < 0) {
            n += 7;
        }
        return n;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this._previousMonth) {
            this._calendar.add(2, -1);
            this.update();
            this.requestFocusInWindow();
        } else if (actionEvent.getSource() == this._nextMonth) {
            this._calendar.add(2, 1);
            this.update();
            this.requestFocusInWindow();
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (this._popupTrigger) {
            this._popupTrigger = false;
            return;
        }
        if (mouseEvent.getSource() == this._todayLabel || mouseEvent.getSource() == this._todaysDateLabel || mouseEvent.getSource() == this._todaySampleDate) {
            this.setSelectedDate(this._today);
            this.requestFocusInWindow();
        } else if (mouseEvent.getSource() == this._displayMonth) {
            this._monthPopupMenu.setSelected(this._monthPopupMenu.getComponent(this._calendar.get(2)));
            UIUtils.showJPopupMenu(this._monthPopupMenu, (JComponent)mouseEvent.getComponent(), new Point(mouseEvent.getX(), mouseEvent.getY()));
        } else {
            JLabel jLabel = (JLabel)mouseEvent.getSource();
            if (!jLabel.getText().equals(" ")) {
                try {
                    this.selectDay(Integer.parseInt(jLabel.getText()));
                    this.fireDateChanged(this.getSelectedDate(), mouseEvent);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this._popupTrigger = false;
        if (mouseEvent.isPopupTrigger()) {
            UIUtils.showJPopupMenu(this._popupMenu, (JComponent)mouseEvent.getComponent(), new Point(mouseEvent.getX(), mouseEvent.getY()));
            this._popupTrigger = true;
            this.requestFocusInWindow();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this._popupTrigger = false;
        if (mouseEvent.isPopupTrigger()) {
            UIUtils.showJPopupMenu(this._popupMenu, (JComponent)mouseEvent.getComponent(), new Point(mouseEvent.getX(), mouseEvent.getY()));
            this._popupTrigger = true;
            this.requestFocusInWindow();
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        this.paintBorder(this.getGraphics());
        this.enableActions();
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.paintBorder(this.getGraphics());
        this.disableActions();
    }

    private void enableActions() {
        this._previousMonthKeyAction.setEnabled(true);
        this._nextMonthKeyAction.setEnabled(true);
        this._goToTodayAction.setEnabled(true);
        this._previousDayAction.setEnabled(true);
        this._nextDayAction.setEnabled(true);
        this._previousWeekAction.setEnabled(true);
        this._nextWeekAction.setEnabled(true);
    }

    private void disableActions() {
        this._previousMonthKeyAction.setEnabled(false);
        this._nextMonthKeyAction.setEnabled(false);
        this._goToTodayAction.setEnabled(false);
        this._previousDayAction.setEnabled(false);
        this._nextDayAction.setEnabled(false);
        this._previousWeekAction.setEnabled(false);
        this._nextWeekAction.setEnabled(false);
    }

    private void enableListeners() {
        this.addFocusListener(this);
        this._previousMonth.addActionListener(this);
        this._nextMonth.addActionListener(this);
        this._displayMonth.addMouseListener(this);
        this._todayLabel.addMouseListener(this);
        this._todaySampleDate.addMouseListener(this);
        this._todaysDateLabel.addMouseListener(this);
        for (int i = 1; i < 7; ++i) {
            for (int j = 0; j < 7; ++j) {
                this._days[i][j].addMouseListener(this);
            }
        }
    }

    private void disableListeners() {
        this.removeFocusListener(this);
        this._previousMonth.removeActionListener(this);
        this._nextMonth.removeActionListener(this);
        this._displayMonth.removeMouseListener(this);
        this._todayLabel.removeMouseListener(this);
        this._todaySampleDate.removeMouseListener(this);
        this._todaysDateLabel.removeMouseListener(this);
        for (int i = 1; i < 7; ++i) {
            for (int j = 0; j < 7; ++j) {
                this._days[i][j].removeMouseListener(this);
            }
        }
    }

    public void setSelectedDate() {
        this.setSelectedDate(new Date());
    }

    public void setSelectedDate(Date date) {
        this._calendar.setTime(date);
        this.selectDay(this._calendar.get(5));
        this.update();
        this.fireDateChanged(date, null);
    }

    public Date getSelectedDate() {
        if (this._calendar == null) {
            return null;
        }
        return this._calendar.getTime();
    }

    @Override
    public void setEnabled(boolean bl) {
        if (this.isEnabled() == bl) {
            return;
        }
        if (bl) {
            this._displayMonth.setForeground(SystemColor.textHighlightText);
            this._displayYear.setForeground(SystemColor.textHighlightText);
            this._selectedDay.setForeground(SystemColor.textHighlightText);
            this._monthYearPanel.setForeground(SystemColor.textHighlightText);
            this._displayMonth.setBackground(SystemColor.textHighlight);
            this._displayYear.setBackground(SystemColor.textHighlight);
            this._selectedDay.setBackground(SystemColor.textHighlight);
            this._monthYearPanel.setBackground(SystemColor.textHighlight);
            this.enableActions();
            this.enableListeners();
        } else {
            this._displayMonth.setForeground(SystemColor.inactiveCaptionText);
            this._displayYear.setForeground(SystemColor.inactiveCaptionText);
            this._selectedDay.setForeground(SystemColor.inactiveCaptionText);
            this._monthYearPanel.setForeground(SystemColor.inactiveCaptionText);
            this._displayMonth.setBackground(SystemColor.inactiveCaption);
            this._displayYear.setBackground(SystemColor.inactiveCaption);
            this._selectedDay.setBackground(SystemColor.inactiveCaption);
            this._monthYearPanel.setBackground(SystemColor.inactiveCaption);
            this.disableActions();
            this.disableListeners();
        }
        this.setFocusable(bl);
        this._daysGrid.setEnabled(bl);
        this._previousMonth.setEnabled(bl);
        this._nextMonth.setEnabled(bl);
        this._selectedDay.setEnabled(bl);
        this._todaysDateLabel.setEnabled(bl);
        this._todaySampleDate.setEnabled(bl);
        this._todayLabel.setEnabled(bl);
        this._displayMonth.setEnabled(bl);
        this._displayYear.setEnabled(bl);
        for (int i = 0; i < 7; ++i) {
            for (int j = 0; j < 7; ++j) {
                this._days[i][j].setEnabled(bl);
            }
        }
        super.setEnabled(bl);
    }

    private void updateMonthDisplay(int n) {
        this._calendar.set(2, n);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer = this._monthDateFormat.format(this._calendar.getTime(), stringBuffer, new FieldPosition(1));
        this._displayMonth.setText(stringBuffer.toString());
        this.update();
    }

    public void destroy() {
        if (this._popupMenu != null) {
            int n = this._popupMenu.getComponentCount();
            for (int i = n - 1; i >= 0; --i) {
                this._popupMenu.remove(i);
            }
            this._popupMenu = null;
        }
        this.disableListeners();
    }

    private static ResourceBundle getResourceBundle() {
        ResourceBundle resourceBundle = null;
        String string = System.getProperty("language", System.getProperty("user.language", null));
        String string2 = System.getProperty("country", System.getProperty("user.region", null));
        if (string != null && string2 != null) {
            try {
                resourceBundle = ResourceBundle.getBundle("com.sybase.datechooser.SybDateChooserResourceBundle", new Locale(string, string2));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (resourceBundle == null) {
            try {
                resourceBundle = ResourceBundle.getBundle("com.sybase.datechooser.SybDateChooserResourceBundle", Locale.getDefault());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (resourceBundle == null) {
            try {
                resourceBundle = ResourceBundle.getBundle("com.sybase.datechooser.SybDateChooserResourceBundle");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (resourceBundle == null) {
            throw new MissingResourceException("Can't find resource for base name com.sybase.datechooser.SybDateChooserResourceBundle", "", "");
        }
        return resourceBundle;
    }

    static final String getI18NMessage(String string) {
        String string2 = "";
        try {
            string2 = (String)SybDateChooserPanel.getResourceBundle().getObject(string);
        }
        catch (MissingResourceException missingResourceException) {
            string2 = string;
        }
        return string2;
    }

    public void addDateChangeListener(DateChangeListener dateChangeListener) {
        this._listenerList.add(DateChangeListener.class, dateChangeListener);
    }

    public void removeDateChangeListener(DateChangeListener dateChangeListener) {
        this._listenerList.remove(DateChangeListener.class, dateChangeListener);
    }

    void fireDateChanged(Date date, EventObject eventObject) {
        Object[] objectArray = this._listenerList.getListenerList();
        DateChangeEvent dateChangeEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != DateChangeListener.class) continue;
            if (dateChangeEvent == null) {
                dateChangeEvent = new DateChangeEvent(this, date, eventObject);
            }
            ((DateChangeListener)objectArray[i + 1]).dateChanged(dateChangeEvent);
        }
    }
}

