/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.helpManager;

import com.sybase.helpManager.FactoryHelp;
import com.sybase.helpManager.HelpNotFoundException;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.jar.JarFile;
import java.util.zip.ZipException;

class Dataset {
    private String _hsname = "";
    private URL _urlhelpset = null;
    private boolean _valid = false;
    private File _filejar = null;
    private JarFile _jarfile = null;

    Dataset(String string) throws HelpNotFoundException {
        this.validateParams(string);
    }

    Dataset(String string, String string2) throws HelpNotFoundException {
        this._hsname = string2;
        if (string == null || string.length() == 0) {
            this.validateParams(string2);
        } else {
            this.validateParams(string, string2);
        }
    }

    String getHelpSetName() {
        return this._hsname;
    }

    URL getHelpSetURL() {
        return this._urlhelpset;
    }

    boolean isValid() {
        return this._valid;
    }

    public String toString() {
        String string = "";
        try {
            string = this._urlhelpset.toExternalForm();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    protected static void trace(Dataset dataset) {
    }

    private void validateParams(String string) throws HelpNotFoundException {
        ClassLoader classLoader = this.getClass().getClassLoader();
        this._urlhelpset = classLoader.getResource(string);
        if (this._urlhelpset == null) {
            throw new HelpNotFoundException(FactoryHelp.getLocalizedString("ERR_HELPNOTFOUND_CLASSPATH", string), string);
        }
        this._valid = true;
    }

    private void validateParams(String string, String string2) throws HelpNotFoundException {
        this.setFileRef(string);
        if (this._jarfile.getEntry(string2) == null) {
            throw new HelpNotFoundException(FactoryHelp.getLocalizedString("ERR_HELPNOTFOUND_JAR_NOHELPSET", string2, string), string2);
        }
        try {
            this._urlhelpset = new URL("jar:file:///" + string + "!/" + string2);
        }
        catch (MalformedURLException malformedURLException) {
            throw new HelpNotFoundException(FactoryHelp.getLocalizedString("ERR_HELPNOTFOUND_URL", string2), string2);
        }
        this._valid = true;
    }

    private void setFileRef(String string) throws HelpNotFoundException {
        this._filejar = new File(string);
        if (this._filejar.exists()) {
            try {
                this._jarfile = new JarFile(this._filejar);
            }
            catch (ZipException zipException) {
                throw new HelpNotFoundException(FactoryHelp.getLocalizedString("ERR_HELPNOTFOUND_JAR_NOTJAR", string), string);
            }
            catch (IOException iOException) {
                throw new HelpNotFoundException(FactoryHelp.getLocalizedString("ERR_HELPNOTFOUND_JAR_NOTFOUND", string), string);
            }
        } else {
            throw new HelpNotFoundException(FactoryHelp.getLocalizedString("ERR_HELPNOTFOUND_JAR_NOTFOUND", string), string);
        }
    }

    void releaseResources() {
        this._urlhelpset = null;
        this._filejar = null;
        if (this._jarfile != null) {
            try {
                this._jarfile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this._jarfile = null;
    }
}

