/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.helpManager;

import com.sybase.helpManager.Dataset;
import com.sybase.helpManager.HelpNotFoundException;
import com.sybase.helpManager.HelpViewer;
import com.sybase.helpManager.ItemNotFoundException;
import com.sybase.helpManager.LinkLauncher;
import com.sybase.helpManager.SSIndex;
import com.sybase.util.FileLocator;
import com.sybase.util.Platform;
import com.sybase.util.SybMessageFormat;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.AccessControlException;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;

public class FactoryHelp {
    private static Properties _sysprop = null;
    private static String _propfilepath = null;
    private static SSIndex _arrViewer = new SSIndex(10);
    private static ResourceBundle _bundle = null;
    private static final String FILENAME_USER_PROPERTIES = "helpManager.lst";
    private static boolean _isApplet;
    private static Hashtable<String, Object> _tableViewer;

    public static HelpViewer getHelpViewer(String string, String string2, String string3) throws HelpNotFoundException {
        return FactoryHelp.getHelpViewer(string, string2, string3, true);
    }

    public static HelpViewer getHelpViewer(String string, String string2, String string3, boolean bl) throws HelpNotFoundException {
        HelpViewer helpViewer;
        String string4;
        String string5;
        if (string == null) {
            string = "";
        } else if (!string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        if (string2 == null) {
            string2 = "";
        }
        if (string3 == null) {
            string3 = "";
        }
        if ((string5 = FactoryHelp.getMapFileName(string, string2, string4 = Locale.getDefault().getLanguage(), string3)) != null && (helpViewer = (HelpViewer)_tableViewer.get(string5)) != null) {
            return helpViewer;
        }
        try {
            helpViewer = FactoryHelp._getHelpViewer(string5, string, string4);
        }
        catch (HelpNotFoundException helpNotFoundException) {
            if (bl) {
                string4 = "en";
                string5 = FactoryHelp.getMapFileName(string, string2, string4, string3);
                if (string5 != null && (helpViewer = (HelpViewer)_tableViewer.get(string5)) != null) {
                    return helpViewer;
                }
                helpViewer = FactoryHelp._getHelpViewer(string5, string, string4);
            }
            throw new HelpNotFoundException(helpNotFoundException.getMessage(), helpNotFoundException.missingComponent());
        }
        _tableViewer.put(string5, helpViewer);
        return helpViewer;
    }

    static String getMapFileName(String string, String string2, String string3, String string4) {
        String string5 = string2 + string3 + string4 + ".map";
        File file = new File(string + string5);
        if (file.exists()) {
            return file.getAbsolutePath();
        }
        file = new File(string + "eclipse" + File.separator + "plugins" + File.separator + string5);
        if (file.exists()) {
            return file.getAbsolutePath();
        }
        file = new File(string + string3 + File.separator + "htmlhelp" + File.separator + string5);
        if (file.exists()) {
            return file.getAbsolutePath();
        }
        return null;
    }

    private static HelpViewer _getHelpViewer(String string, String string2, String string3) throws HelpNotFoundException {
        HelpViewer helpViewer = new HelpViewer(string, string2, string3);
        return helpViewer;
    }

    public static HelpViewer getViewer(String string, String string2, String string3) throws HelpNotFoundException {
        return FactoryHelp.getViewer(string, string2, string3, true);
    }

    public static HelpViewer getViewer(String string, String string2, String string3, boolean bl) throws HelpNotFoundException {
        HelpViewer helpViewer;
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        if (string3 == null) {
            string3 = "";
        }
        String string4 = FactoryHelp.getJarFileName(string, string2, Locale.getDefault().getLanguage(), string3);
        String string5 = string2 + ".hs";
        try {
            helpViewer = FactoryHelp.getViewer(string4, string5);
        }
        catch (HelpNotFoundException helpNotFoundException) {
            if (bl) {
                string4 = FactoryHelp.getJarFileName(string, string2, "en", string3);
                helpViewer = FactoryHelp.getViewer(string4, string5);
            }
            throw new HelpNotFoundException(helpNotFoundException.getMessage(), helpNotFoundException.missingComponent());
        }
        return helpViewer;
    }

    public static HelpViewer getViewer(String string) throws HelpNotFoundException {
        return FactoryHelp.getViewer(null, string);
    }

    public static HelpViewer getViewer(String string, String string2) throws HelpNotFoundException {
        HelpViewer helpViewer;
        Dataset dataset = new Dataset(string, string2);
        try {
            helpViewer = (HelpViewer)_arrViewer.getItem(dataset.getHelpSetName());
        }
        catch (ItemNotFoundException itemNotFoundException) {
            helpViewer = new HelpViewer(dataset);
            _arrViewer.addItem(helpViewer);
        }
        return helpViewer;
    }

    static boolean isApplet() {
        return _isApplet;
    }

    static String getHMPropertiesFilepath() {
        if (_propfilepath == null) {
            _propfilepath = Platform.getUserConfigurationDirectory() + FILENAME_USER_PROPERTIES;
        }
        return _propfilepath;
    }

    static String getHelpMapFilepath() {
        if (_propfilepath == null) {
            _propfilepath = Platform.getUserConfigurationDirectory() + FILENAME_USER_PROPERTIES;
        }
        return _propfilepath;
    }

    static String getLocalizedString(String string) {
        return FactoryHelp.getLocalizedString(string, null, null);
    }

    static String getLocalizedString(String string, String string2) {
        return FactoryHelp.getLocalizedString(string, string2, null);
    }

    static String getLocalizedString(String string, String string2, String string3) {
        if (_bundle == null) {
            _bundle = ResourceBundle.getBundle("com.sybase.helpManager.HelpManagerResourceBundle");
        }
        try {
            Object[] objectArray = new Object[]{string2, string3};
            return SybMessageFormat.format(_bundle.getString(string), objectArray);
        }
        catch (MissingResourceException missingResourceException) {
            return string;
        }
    }

    public static String getJarFileName(String string, String string2, String string3, String string4) {
        StringBuilder stringBuilder = new StringBuilder();
        if (string != null && string.trim().length() > 0) {
            stringBuilder.append(string);
            if (!string.endsWith(File.separator)) {
                stringBuilder.append(File.separator);
            }
        }
        stringBuilder.append(string2);
        stringBuilder.append(string3);
        stringBuilder.append(string4);
        stringBuilder.append(".jar");
        File file = new File(stringBuilder.toString());
        if (!file.exists() && !file.isAbsolute() && FileLocator.isInstalled() && (file = FileLocator.find(file.getName())) != null) {
            stringBuilder.setLength(0);
            stringBuilder.append(file.getAbsolutePath());
        }
        return stringBuilder.toString();
    }

    static void launchOnlineBooks(LinkLauncher linkLauncher) {
        try {
            ((HelpViewer)_arrViewer.getItem(linkLauncher.getHelpSetName())).launchOnlineBooks(linkLauncher);
        }
        catch (ItemNotFoundException itemNotFoundException) {
            // empty catch block
        }
    }

    public static void disposeOfViewer(HelpViewer helpViewer) {
        if (helpViewer != null) {
            helpViewer.releaseResources();
            _arrViewer.removeItem(helpViewer);
        }
    }

    public static void main(String[] stringArray) {
        Properties properties = new Properties();
        try {
            properties.load(new BufferedInputStream(new FileInputStream("HelpManagerTest.settings")));
        }
        catch (IOException iOException) {
            System.out.println("Can't load HelpManagerTest.settings");
        }
        String string = properties.getProperty("ma_path");
        String string2 = properties.getProperty("ma_helpPrefix");
        String string3 = properties.getProperty("ma_version");
        HelpViewer helpViewer = null;
        System.out.println("Testing ...");
        try {
            helpViewer = FactoryHelp.getHelpViewer(string, string2, string3);
        }
        catch (HelpNotFoundException helpNotFoundException) {
            System.out.println(helpNotFoundException.getMessage());
            return;
        }
        int n = stringArray.length;
        if (n == 0 || stringArray[0].equals("1")) {
            helpViewer.showOnlineBook();
            return;
        }
        if (stringArray[0].equals("2")) {
            String string4 = "HELP_LOGON_DEFAULT";
            if (n > 1) {
                string4 = stringArray[1];
            }
            helpViewer.showHelpIndex(string4);
            return;
        }
        if (stringArray[0].equals("3")) {
            String string5;
            int n2 = 100;
            if (n > 1) {
                try {
                    n2 = Integer.valueOf(stringArray[1]);
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("\"" + stringArray[1] + "\" is not a number");
                    return;
                }
            }
            if ((string5 = helpViewer.getHelpIDForError(n2)) == null) {
                System.out.println("null");
            } else {
                helpViewer.showHelpIndex(string5);
            }
            return;
        }
        if (stringArray[0].equals("4")) {
            String[] stringArray2;
            String string6 = "CREATE TABLE mytab (a int, b char(16) );";
            if (n > 1) {
                string6 = stringArray[1];
            }
            if ((stringArray2 = helpViewer.getHelpIDForSQL(string6)) == null) {
                System.out.println("null");
            } else {
                System.out.println(stringArray2[0]);
                System.out.println(stringArray2[1]);
                helpViewer.showHelpIndex(stringArray2[0]);
            }
            return;
        }
    }

    static {
        try {
            _sysprop = System.getProperties();
            _isApplet = false;
        }
        catch (AccessControlException accessControlException) {
            _isApplet = true;
            _sysprop = new Properties();
        }
        _tableViewer = new Hashtable();
    }
}

