/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.helpManager;

import com.sybase.helpManager.FactoryHelp;
import com.sybase.helpManager.FlexWindow;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;

class FlexWindowPosition
implements ComponentListener {
    private static final String HM_PROPNAME_WIDTH = "helpManager.width";
    private static final String HM_PROPNAME_HEIGHT = "helpManager.height";
    private static final String HM_PROPNAME_POINTX = "helpManager.pointx";
    private static final String HM_PROPNAME_POINTY = "helpManager.pointy";
    private static final String FF_DEFAULT_WIDTH = "500";
    private static final String FF_DEFAULT_HEIGHT = "500";
    private static final String FF_DEFAULT_POINT = "10";
    private Properties _props = null;
    private Dimension _size = null;
    private Point _location = null;
    private boolean _userclosed = true;

    FlexWindowPosition(FlexWindow flexWindow) {
        this.loadProperties();
    }

    Point getLocation() {
        if (this._location == null) {
            this._location = new Point(Integer.valueOf(this._props.getProperty(HM_PROPNAME_POINTX, FF_DEFAULT_POINT)), Integer.valueOf(this._props.getProperty(HM_PROPNAME_POINTY, FF_DEFAULT_POINT)));
        }
        return this._location;
    }

    Dimension getSize() {
        if (this._size == null) {
            this._size = new Dimension(Integer.valueOf(this._props.getProperty(HM_PROPNAME_WIDTH, "500")), Integer.valueOf(this._props.getProperty(HM_PROPNAME_HEIGHT, "500")));
        }
        return this._size;
    }

    private void loadProperties() {
        this._props = new Properties();
        try {
            this._props.load(new BufferedInputStream(new FileInputStream(FactoryHelp.getHMPropertiesFilepath())));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void saveProperties() {
        try {
            this._props.store(new BufferedOutputStream(new FileOutputStream(FactoryHelp.getHMPropertiesFilepath())), "helpManager properties");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected boolean isUserClosed() {
        return this._userclosed;
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
        this.saveProperties();
        Window window = (Window)componentEvent.getComponent().getParent();
        this._userclosed = window == null ? false : window.isShowing();
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
        this._location = componentEvent.getComponent().getLocation();
        this._props.setProperty(HM_PROPNAME_POINTX, String.valueOf(this._location.x));
        this._props.setProperty(HM_PROPNAME_POINTY, String.valueOf(this._location.y));
        this.saveProperties();
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        this._size = componentEvent.getComponent().getSize();
        this._props.setProperty(HM_PROPNAME_WIDTH, String.valueOf(this._size.width));
        this._props.setProperty(HM_PROPNAME_HEIGHT, String.valueOf(this._size.height));
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
        this._userclosed = false;
    }

    void releaseResources() {
        this._props = null;
        this._size = null;
        this._location = null;
    }
}

