/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.helpManager;

import com.sybase.helpManager.FactoryHelp;
import com.sybase.helpManager.FlexWindow;
import com.sybase.helpManager.HelpSetContainer;
import com.sybase.helpManager.HelpViewerImp;
import com.sybase.helpManager.LinkLauncher;
import com.sybase.helpManager.PageException;
import com.sybase.helpManager.iConcreteHelpViewer;
import com.sybase.util.DetailsErrorDialog;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.security.AccessControlException;
import java.util.EmptyStackException;
import java.util.Stack;
import javax.help.BadIDException;
import javax.help.HelpSet;
import javax.help.Map;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

class HTMLHelpHelpViewerImp
extends HelpViewerImp
implements iConcreteHelpViewer,
KeyListener {
    protected FlexWindow _fWindow = null;
    private Stack<Window> _parents = new Stack();
    private Stack<Map.ID> _ids = new Stack();
    private static final String EXE_NAME_HTMLHELP = "keyhh.exe";

    HTMLHelpHelpViewerImp(HelpSetContainer helpSetContainer) {
        super(helpSetContainer);
    }

    @Override
    public void turnPage() {
        this.launchOnlineBooks(this.llHomeID());
    }

    @Override
    public void turnPage(final String string, boolean bl) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    HTMLHelpHelpViewerImp.this._hsc.jhcontent.setCurrentID(string);
                }
                catch (BadIDException badIDException) {
                    HTMLHelpHelpViewerImp.this._hsc.errlistener.TurnPageError(new PageException(string));
                    try {
                        Map.ID iD = HTMLHelpHelpViewerImp.this._hsc.helpset.getHomeID();
                        if (iD != null) {
                            HelpSetContainer cfr_ignored_0 = HTMLHelpHelpViewerImp.this._hsc;
                            String string2 = HTMLHelpHelpViewerImp.this._hsc.jhmodProps.getProperty("pagenotfound", iD.id);
                            if (string2 != null) {
                                HTMLHelpHelpViewerImp.this._hsc.jhcontent.setCurrentID(string2);
                            }
                        }
                    }
                    catch (BadIDException badIDException2) {
                        // empty catch block
                    }
                }
            }
        });
        if (bl) {
            this._fWindow.setVisible(true);
        }
    }

    @Override
    public void launchOnlineBooks(LinkLauncher linkLauncher) {
        String string = "";
        string = "keyhh.exe -" + this._hsc.helpsetname.substring(0, this._hsc.helpsetname.lastIndexOf(".")) + " " + this._hsc.olbooksname + "::/" + linkLauncher.getHelpID();
        this.execString(string);
    }

    @Override
    public void resetParent() {
        if (this._fWindow != null) {
            this._fWindow.dispose();
        }
        if (this._fWindow == null) {
            this._fWindow = new FlexWindow(this._hsc.helpset.getTitle());
            this._fWindow.addKeyListener(this);
            this._fWindow.setContent((JComponent)this._hsc.jhcontent);
        }
    }

    @Override
    public void resetParent(final Window window) {
        boolean bl = false;
        if (this._fWindow != null) {
            bl = this._fWindow.isVisible();
            this._fWindow.dispose();
        }
        if (window instanceof JDialog) {
            this._fWindow = new FlexWindow((JDialog)window, this._hsc.helpset.getTitle());
            this._fWindow.addKeyListener(this);
        } else {
            this._fWindow = new FlexWindow(this._hsc.helpset.getTitle());
            this._fWindow.addKeyListener(this);
            this._fWindow.setIconImage(((JFrame)window).getIconImage());
        }
        this._fWindow.setContent((JComponent)this._hsc.jhcontent);
        if (bl) {
            this._fWindow.setVisible(true);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    window.requestFocus();
                }
            });
        }
        window.addWindowListener(this);
        this._parents.push(window);
        this._ids.push(this._hsc.helpmodel.getCurrentID());
    }

    @Override
    public void releaseResources() {
        if (this._fWindow != null) {
            this._fWindow.releaseResources();
            this._fWindow = null;
        }
        this._parents.clear();
        this._parents = null;
        this._ids.clear();
        this._ids = null;
    }

    private String getFilenameFromMapID(String string) {
        String string2 = "";
        try {
            string2 = this._hsc.map.getURLFromID(Map.ID.create((String)string, (HelpSet)this._hsc.helpset)).getFile();
            string2 = string2.substring(string2.lastIndexOf("/") + 1, string2.length());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string2;
    }

    protected void execString(String string) {
        Window window = null;
        try {
            Runtime.getRuntime().exec(string);
        }
        catch (IOException iOException) {
            try {
                window = this._parents.peek();
            }
            catch (EmptyStackException emptyStackException) {
                // empty catch block
            }
            if (window != null && !(window instanceof Component)) {
                window = null;
            }
            DetailsErrorDialog.showDialog(window, FactoryHelp.getLocalizedString("ERR_ERROR_TITLE"), FactoryHelp.getLocalizedString("ERR_COULD_NOT_OPEN_HELP"), iOException.getLocalizedMessage(), null);
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
    }

    protected LinkLauncher llHomeID() {
        LinkLauncher linkLauncher = new LinkLauncher();
        Map.ID iD = this._hsc.helpset.getHomeID();
        if (iD != null) {
            linkLauncher.setHelpID(this.getFilenameFromMapID(iD.id));
        }
        return linkLauncher;
    }

    protected LinkLauncher llCurrentID() {
        LinkLauncher linkLauncher = new LinkLauncher();
        linkLauncher.setHelpID(this.getFilenameFromMapID(this._hsc.helpmodel.getCurrentID().id));
        return linkLauncher;
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
        block6: {
            Map.ID iD = null;
            try {
                Component component = this._parents.pop();
                while (!this._parents.empty() && !((Component)this._parents.peek()).isShowing()) {
                    component = this._parents.pop();
                }
                if (this._parents.empty()) break block6;
                try {
                    boolean bl;
                    iD = this._ids.pop();
                    boolean bl2 = bl = !this._fWindow.isUserClosed();
                    if (bl) {
                        this.turnPage(iD.id, true);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    ((Component)HTMLHelpHelpViewerImp.this._parents.peek()).requestFocus();
                                }
                                catch (EmptyStackException emptyStackException) {
                                    // empty catch block
                                }
                            }
                        });
                    }
                }
                catch (Exception exception) {}
            }
            catch (EmptyStackException emptyStackException) {
                this._fWindow.dispose();
            }
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 112: {
                this.launchOnlineBooks(this.llCurrentID());
                break;
            }
            case 27: {
                this._fWindow.dispose();
                break;
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }
}

