/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.helpManager;

import com.sybase.helpManager.Dataset;
import com.sybase.helpManager.FactoryHelp;
import com.sybase.helpManager.HTMLHelpHelpViewerImp;
import com.sybase.helpManager.HelpSetContainer;
import com.sybase.helpManager.HelpViewerImp;
import com.sybase.helpManager.InvalidHelpSetException;
import com.sybase.helpManager.JavaHelpHelpViewerImp;
import com.sybase.helpManager.NativeHelpViewerImp;
import com.sybase.helpManager.iConcreteHelpViewer;
import java.awt.Component;
import java.awt.Container;
import java.awt.SystemColor;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Properties;
import javax.help.BadIDException;
import javax.help.HelpSet;
import javax.help.HelpSetException;
import javax.help.JHelpContentViewer;
import javax.help.Map;
import javax.swing.JEditorPane;

class HelpSetDescriptor {
    protected HelpSetContainer _hsc = null;
    static final int OLBOOKTYPE_NOTSET = 0;
    static final int OLBOOKTYPE_NATIVEJH = 0;
    static final int OLBOOKTYPE_UNKNOWN = 1;
    static final int OLBOOKTYPE_HTMLHELP = 3;
    static final int OLBOOKTYPE_JAVAHELP = 4;
    private int _olbType = 1;
    private static final String OLBOOKTYPE_ID_HTMLHELP = ".chm";
    private static final String OLBOOKTYPE_ID_JAVAHELP = ".hs";

    HelpSetDescriptor() {
    }

    private void changeBackground(Container container) {
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Component component = container.getComponent(i);
            if (component instanceof JEditorPane) {
                component.setBackground(SystemColor.window);
            }
            if (!(component instanceof Container)) continue;
            this.changeBackground((Container)component);
        }
    }

    void init(Dataset dataset) throws InvalidHelpSetException {
        Map.ID iD = null;
        this._hsc = new HelpSetContainer();
        this._hsc.urlToHelpSet = dataset.getHelpSetURL();
        this._hsc.helpsetname = dataset.getHelpSetName();
        try {
            this._hsc.helpset = new HelpSet(this.getClass().getClassLoader(), this._hsc.urlToHelpSet);
        }
        catch (HelpSetException helpSetException) {
            throw new InvalidHelpSetException(FactoryHelp.getLocalizedString("ERR_HELPVIEWER_INVALIDHELPSET", this._hsc.urlToHelpSet.toExternalForm()), this._hsc.helpsetname);
        }
        this._hsc.map = this._hsc.helpset.getLocalMap();
        this._hsc.jhcontent = new JHelpContentViewer(this._hsc.helpset);
        this.changeBackground((Container)this._hsc.jhcontent);
        this._hsc.helpmodel = this._hsc.jhcontent.getModel();
        this._hsc.jhmodProps = new Properties();
        try {
            iD = Map.ID.create((String)"JHMOD_HELPSET_PROPERTIES", (HelpSet)this._hsc.helpset);
            this._olbType = 1;
            try {
                this._hsc.jhmodProps.load(this._hsc.map.getURLFromID(iD).openStream());
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this._hsc.olbooksname = this._hsc.jhmodProps.getProperty("olbooksname");
            if (this._hsc.olbooksname.substring(this._hsc.olbooksname.length() - OLBOOKTYPE_ID_HTMLHELP.length()).equalsIgnoreCase(OLBOOKTYPE_ID_HTMLHELP)) {
                this._olbType = 3;
            }
            if (this._hsc.olbooksname.substring(this._hsc.olbooksname.length() - OLBOOKTYPE_ID_JAVAHELP.length()).equalsIgnoreCase(OLBOOKTYPE_ID_JAVAHELP)) {
                this._olbType = 4;
            }
        }
        catch (BadIDException badIDException) {
            this._olbType = 0;
        }
    }

    iConcreteHelpViewer constructHelpViewerImp() {
        HelpViewerImp helpViewerImp = null;
        if (FactoryHelp.isApplet()) {
            helpViewerImp = new NativeHelpViewerImp(this._hsc);
        } else {
            switch (this._olbType) {
                case 0: {
                    helpViewerImp = new NativeHelpViewerImp(this._hsc);
                    break;
                }
                case 3: {
                    helpViewerImp = new HTMLHelpHelpViewerImp(this._hsc);
                    break;
                }
                case 4: {
                    helpViewerImp = new JavaHelpHelpViewerImp(this._hsc);
                    break;
                }
            }
        }
        return helpViewerImp;
    }

    void releaseResources() {
        this._hsc.releaseResources();
        this._hsc = null;
    }
}

