/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.helpManager;

import com.sybase.helpManager.Dataset;
import com.sybase.helpManager.EclipseHelpHelpViewer;
import com.sybase.helpManager.FactoryHelp;
import com.sybase.helpManager.HTMLHelpHelpViewer;
import com.sybase.helpManager.HelpErrorListener;
import com.sybase.helpManager.HelpNotFoundException;
import com.sybase.helpManager.HelpSetContainer;
import com.sybase.helpManager.HelpSetDescriptor;
import com.sybase.helpManager.InvalidHelpSetException;
import com.sybase.helpManager.LinkLauncher;
import com.sybase.helpManager.iConcreteHelpViewer;
import com.sybase.helpManager.iHelpViewer;
import com.sybase.helpManager.iHelpViewerImp;
import com.sybase.util.DetailsErrorDialog;
import java.awt.Window;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.AccessControlException;
import java.util.Properties;
import java.util.Stack;

public class HelpViewer
implements iHelpViewer,
Runnable {
    iConcreteHelpViewer _imp = null;
    Window _lastparent = null;
    Thread _loader = null;
    HelpSetDescriptor _hsdesc = null;
    Dataset _ds = null;
    PageRequest _lastRequest = null;
    Stack<HelpErrorListener> _pendingListeners = new Stack();
    InvalidHelpSetException _pendingError = null;
    Properties _helpMap = new Properties();
    iHelpViewerImp _helpViewerImp = null;
    String _helpType = null;

    public HelpViewer(Dataset dataset) {
        this._hsdesc = new HelpSetDescriptor();
        this._ds = dataset;
        this._loader = new Thread((Runnable)this, "olhelp loader");
        this._loader.setPriority(Math.max(Thread.currentThread().getPriority() - 1, 1));
        this._loader.start();
    }

    public HelpViewer(String string, String string2, String string3) throws HelpNotFoundException {
        if (string == null) {
            throw new HelpNotFoundException(FactoryHelp.getLocalizedString("ERR_HELPNOTFOUND_CLASSPATH", ""), "");
        }
        try {
            this._helpMap.load(new BufferedInputStream(new FileInputStream(string)));
        }
        catch (Exception exception) {
            throw new HelpNotFoundException(FactoryHelp.getLocalizedString("ERR_HELPNOTFOUND_CLASSPATH", string), string);
        }
        this._helpType = this._helpMap.getProperty("help_type");
        if (this._helpType.equals("htmlhelp")) {
            String string4 = string2 + string3 + File.separator + "htmlhelp" + File.separator + this._helpMap.getProperty("help_file_name");
            this._helpViewerImp = new HTMLHelpHelpViewer(string4);
        } else if (this._helpType.equals("eclipse")) {
            String string5 = this._helpMap.getProperty("eclipse_home");
            if (string5.equals("")) {
                string5 = string.replaceAll("documentation.*map$", "eclipse");
            }
            this._helpViewerImp = new EclipseHelpHelpViewer(string5, string3);
        } else {
            throw new HelpNotFoundException(FactoryHelp.getLocalizedString("ERR_HELPNOTFOUND_CLASSPATH", this._helpType), this._helpType);
        }
    }

    @Override
    public void run() {
        try {
            this._hsdesc.init(this._ds);
        }
        catch (InvalidHelpSetException invalidHelpSetException) {
            this.setLastError(invalidHelpSetException);
            return;
        }
        this.setImplementation(this._hsdesc.constructHelpViewerImp());
    }

    protected void setLastError(InvalidHelpSetException invalidHelpSetException) {
        this._pendingError = invalidHelpSetException;
    }

    protected synchronized void setImplementation(iConcreteHelpViewer iConcreteHelpViewer2) {
        this._imp = iConcreteHelpViewer2;
        if (this._lastRequest != null) {
            this._lastRequest.fulfillRequest();
            this._lastRequest = null;
        }
        while (!this._pendingListeners.empty()) {
            this._imp.addHelpErrorListener(this._pendingListeners.pop());
        }
    }

    public void showHelpIndex(String string) {
        if (string != null) {
            String string2 = this._helpMap.getProperty(string, null);
            if (string2 == null) {
                return;
            }
            this._helpViewerImp.showHelpIndex(string2);
        }
    }

    public void showOnlineBook() {
        this._helpViewerImp.showOnlineBook();
    }

    public String getHelpIDForError(int n) {
        String string = Integer.toString(n);
        if (this._helpMap.getProperty(string) == null) {
            return null;
        }
        return string;
    }

    public String[] getHelpIDForSQL(String string) {
        String[] stringArray = null;
        String[] stringArray2 = string.toLowerCase().split(" ");
        int n = Math.min(4, stringArray2.length);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = n - 1; i >= 0; --i) {
            int n2;
            stringBuilder.setLength(0);
            for (n2 = 0; n2 <= i; ++n2) {
                if (n2 > 0) {
                    stringBuilder.append("-");
                }
                stringBuilder.append(stringArray2[n2]);
            }
            stringBuilder.append("-statement");
            String string2 = stringBuilder.toString();
            if (this._helpMap.getProperty(string2) == null) continue;
            stringBuilder.setLength(0);
            for (n2 = 0; n2 <= i; ++n2) {
                if (n2 > 0) {
                    stringBuilder.append(" ");
                }
                stringBuilder.append(stringArray2[n2]);
            }
            stringArray = new String[]{string2, stringBuilder.toString().toUpperCase()};
            return stringArray;
        }
        return null;
    }

    @Override
    public void turnPage() {
        if (this._helpViewerImp != null) {
            this.showOnlineBook();
            return;
        }
        if (this._imp == null) {
            this._lastRequest = new PageRequest();
        } else {
            this._imp.turnPage();
        }
    }

    @Override
    public void turnPageSilent(String string, Window window) {
        if (this._helpViewerImp != null) {
            return;
        }
        this.turnPage(string, window, false);
    }

    @Override
    public void turnPage(String string, Window window) {
        if (this._helpViewerImp != null) {
            this.showHelpIndex(string);
            return;
        }
        this.turnPage(string, window, true);
    }

    private synchronized void turnPage(String string, Window window, boolean bl) {
        if (this._helpViewerImp != null) {
            if (bl) {
                this.showHelpIndex(string);
            }
            return;
        }
        if (this._imp == null) {
            this._lastRequest = new PageRequest(string, window, bl);
        } else {
            if (window == null) {
                this._imp.resetParent();
            } else if (window != this._lastparent) {
                this._imp.resetParent(window);
                this._lastparent = window;
            }
            if (string == null && this._hsdesc._hsc.helpset.getHomeID() != null) {
                HelpSetContainer cfr_ignored_0 = this._hsdesc._hsc;
                string = this._hsdesc._hsc.jhmodProps.getProperty("pagenotfound", this._hsdesc._hsc.helpset.getHomeID().id);
            }
            this._imp.turnPage(string, bl);
        }
    }

    @Override
    public void turnPage(int n, Window window) {
        if (this._helpViewerImp != null) {
            this.showHelpIndex(this.getHelpIDForError(n));
            return;
        }
        this.turnPage(String.valueOf(n), window, true);
    }

    @Override
    public String getID() {
        return this._imp.getID();
    }

    @Override
    public void launchOnlineBooks(LinkLauncher linkLauncher) {
        if (this._helpViewerImp != null) {
            this.showOnlineBook();
            return;
        }
        if (this._imp != null) {
            this._imp.launchOnlineBooks(linkLauncher);
        }
    }

    @Override
    public void addHelpErrorListener(HelpErrorListener helpErrorListener) {
        if (this._pendingError != null) {
            helpErrorListener.HelpViewerError(this._pendingError);
            this._pendingError = null;
        }
        if (this._imp != null) {
            this._imp.addHelpErrorListener(helpErrorListener);
        } else {
            this._pendingListeners.push(helpErrorListener);
        }
    }

    @Override
    public void removeHelpErrorListener(HelpErrorListener helpErrorListener) {
        if (this._imp != null) {
            this._imp.removeHelpErrorListener(helpErrorListener);
        }
    }

    public void releaseResources() {
        if (this._helpViewerImp != null) {
            this._helpViewerImp.releaseResources();
            return;
        }
        this._imp.releaseResources();
        this._imp = null;
        this._lastparent = null;
        this._loader = null;
        this._hsdesc.releaseResources();
        this._hsdesc = null;
        this._ds.releaseResources();
        this._ds = null;
        if (this._lastRequest != null) {
            this._lastRequest.releaseResources();
            this._lastRequest = null;
        }
        this._pendingListeners.clear();
        this._pendingListeners = null;
        this._pendingError = null;
    }

    public static synchronized void execString(String string) {
        Object var1_1 = null;
        try {
            Runtime.getRuntime().exec(string);
        }
        catch (IOException iOException) {
            DetailsErrorDialog.showDialog(var1_1, FactoryHelp.getLocalizedString("ERR_ERROR_TITLE"), FactoryHelp.getLocalizedString("ERR_COULD_NOT_OPEN_HELP"), iOException.getLocalizedMessage(), null);
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
    }

    protected class PageRequest {
        protected String _id;
        protected Window _parent;
        protected boolean _forcewindow;
        protected boolean _olbooks = false;

        public PageRequest() {
            this._olbooks = true;
        }

        public PageRequest(String string, Window window, boolean bl) {
            this._id = string;
            this._parent = window;
            this._forcewindow = bl;
        }

        public void fulfillRequest() {
            if (this._olbooks) {
                HelpViewer.this.turnPage();
            } else {
                HelpViewer.this.turnPage(this._id, this._parent, this._forcewindow);
            }
            this.releaseResources();
        }

        public void releaseResources() {
            this._parent = null;
        }
    }
}

