/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.helpManager;

import com.sybase.helpManager.HelpSetContainer;
import com.sybase.helpManager.HelpViewerImp;
import com.sybase.helpManager.LinkLauncher;
import com.sybase.helpManager.PageException;
import com.sybase.helpManager.iConcreteHelpViewer;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.EmptyStackException;
import java.util.Stack;
import javax.help.BadIDException;
import javax.help.DefaultHelpBroker;
import javax.help.Map;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

class NativeHelpViewerImp
extends HelpViewerImp
implements iConcreteHelpViewer {
    private DefaultHelpBroker _hb = null;
    private Stack<String> _ids = new Stack();
    private Stack<Window> _parents = new Stack();
    private boolean _boolDisplayed = false;
    private Timer _timer = null;
    private String _lastid = "";
    private int _level = 0;
    private boolean _showingHelpBroker = false;

    NativeHelpViewerImp(HelpSetContainer helpSetContainer) {
        super(helpSetContainer);
        this._hb = new DefaultHelpBroker(this._hsc.helpset);
        this._timer = new Timer(700, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NativeHelpViewerImp.this._boolDisplayed = NativeHelpViewerImp.this._hb.isDisplayed();
                if (!NativeHelpViewerImp.this._boolDisplayed) {
                    NativeHelpViewerImp.this._timer.stop();
                }
            }
        });
        this._timer.start();
    }

    @Override
    public void turnPage() {
        if (this._hsc.helpset.getHomeID() != null) {
            String string = this._hsc.helpset.getHomeID().id;
            this.turnPage(string, true);
        }
    }

    @Override
    public void turnPage(final String string, final boolean bl) {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    NativeHelpViewerImp.this._hb.setCurrentID(string);
                }
                catch (BadIDException badIDException) {
                    NativeHelpViewerImp.this._hsc.errlistener.TurnPageError(new PageException(string));
                    try {
                        if (NativeHelpViewerImp.this._hsc.helpset.getHomeID() != null) {
                            HelpSetContainer cfr_ignored_0 = NativeHelpViewerImp.this._hsc;
                            NativeHelpViewerImp.this._hb.setCurrentID(NativeHelpViewerImp.this._hsc.jhmodProps.getProperty("pagenotfound", NativeHelpViewerImp.this._hsc.helpset.getHomeID().id));
                        }
                    }
                    catch (BadIDException badIDException2) {
                        // empty catch block
                    }
                }
                finally {
                    if (bl) {
                        try {
                            NativeHelpViewerImp.this._hb.setDisplayed(true);
                        }
                        catch (Exception exception) {}
                        NativeHelpViewerImp.this._timer.start();
                    }
                }
            }
        });
    }

    @Override
    public void launchOnlineBooks(LinkLauncher linkLauncher) {
        this.turnPage(linkLauncher.getHelpID(), true);
    }

    @Override
    public void resetParent() {
        this.resetParent(null);
    }

    @Override
    public void resetParent(Window window) {
        Map.ID iD;
        boolean bl = false;
        Stack<Window> stack = new Stack<Window>();
        while (!this._parents.empty()) {
            Window window2 = this._parents.pop();
            if (window2 == window) {
                bl = true;
            }
            stack.push(window2);
        }
        this._level = 0;
        while (!stack.empty()) {
            ++this._level;
            this._parents.push((Window)stack.pop());
        }
        if (bl) {
            try {
                this._ids.pop();
            }
            catch (EmptyStackException emptyStackException) {}
        } else {
            ++this._level;
            if (window != null) {
                this._parents.push(window);
                window.addWindowListener(this);
            }
        }
        if ((iD = this._hb.getCurrentID()) != null) {
            this._lastid = iD.id;
        }
        this._ids.push(this._lastid);
        boolean bl2 = this._hb.isDisplayed();
        if (bl2) {
            this._hb.setDisplayed(false);
        }
        this._hb.setActivationWindow(window);
        if (bl2) {
            this._hb.setDisplayed(true);
        }
    }

    @Override
    public void releaseResources() {
        this._hb = null;
        this._ids.clear();
        this._ids = null;
        this._parents.clear();
        this._parents = null;
        this._timer.stop();
        this._timer = null;
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
        this._showingHelpBroker = this._hb.isDisplayed();
        this._hb.setDisplayed(false);
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
        this._hb.setDisplayed(this._showingHelpBroker);
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
        String string = "";
        try {
            this._parents.pop();
            --this._level;
            windowEvent.getWindow().removeWindowListener(this);
            string = this._ids.pop();
            if (string.length() > 0) {
                this.turnPage(string, this._boolDisplayed);
            }
            try {
                if (!this._parents.empty()) {
                    this._hb.setActivationWindow(this._parents.peek());
                }
            }
            catch (NullPointerException nullPointerException) {}
        }
        catch (EmptyStackException emptyStackException) {
            while (!this._ids.empty()) {
                this._ids.pop();
            }
            while (!this._parents.empty()) {
                this._parents.pop();
            }
            try {
                this._hb.setDisplayed(false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

