/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.Timer;

public class BarberPole
extends JComponent
implements ActionListener {
    Timer _timer = null;
    int _count = 0;
    int _lineThickness = 10;

    public BarberPole() {
        this(10);
    }

    public BarberPole(int n) {
        if (n > 0 && n < 101) {
            this._lineThickness = n;
        }
        this._timer = new Timer(10, this);
    }

    public void start() {
        this._timer.start();
    }

    public void stop() {
        this._timer.stop();
        this.repaint();
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (!bl) {
            this.stop();
        }
    }

    public void releaseResources() {
        this.stop();
        this._timer = null;
    }

    @Override
    public void paint(Graphics graphics) {
        Dimension dimension = null;
        int n = 0;
        int[] nArray = new int[4];
        int[] nArray2 = new int[4];
        super.paint(graphics);
        dimension = this.getSize();
        int n2 = dimension.width;
        int n3 = dimension.height;
        if (!this._timer.isRunning()) {
            if (this.getParent() != null && this.isOpaque()) {
                graphics.setColor(this.getParent().getBackground());
                graphics.fillRect(0, 0, n2, n3);
            }
        } else {
            graphics.setColor(SystemColor.window);
            graphics.fillRect(0, 0, n2, n3);
            graphics.setColor(SystemColor.textHighlight);
            int n4 = -1;
            while ((n4 - 1) * this._lineThickness < n2) {
                nArray[0] = n = n4 * this._lineThickness - this._count;
                nArray2[0] = 0;
                nArray[1] = n + this._lineThickness;
                nArray2[1] = 0;
                nArray[2] = n + this._lineThickness * 2;
                nArray2[2] = n3;
                nArray[3] = n + this._lineThickness;
                nArray2[3] = n3;
                graphics.fillPolygon(nArray, nArray2, 4);
                n4 += 2;
            }
            graphics.setColor(SystemColor.windowText);
            graphics.drawRect(0, 0, n2 - 1, n3 - 1);
            graphics.drawRect(1, 1, n2 - 3, n3 - 3);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this._timer) {
            ++this._count;
            if (this._count > this._lineThickness * 2) {
                this._count = 0;
            }
            this.repaint();
        }
    }
}

