/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util;

import com.sybase.util.ConfigurationDialog;
import com.sybase.util.Platform;
import com.sybase.util.Profile;
import com.sybase.util.SCC;
import com.sybase.util.SCCException;
import com.sybase.util.SCCResourcesBase;
import com.sybase.util.SCCTextOutput;
import com.sybase.util.STDIOWindow;
import com.sybase.util.SybOptionPane;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;

class BatchSCC
implements SCC {
    private static final String PROFILE_FILENAME = ".sybSourceControl5";
    private static final String ADD_SECTION = "add";
    private static final String CHECKIN_SECTION = "checkin";
    private static final String CHECKOUT_SECTION = "checkout";
    private static final String DIFF_SECTION = "diff";
    private static final String GET_SECTION = "get";
    private static final String HISTORY_SECTION = "history";
    private static final String OPTIONS_SECTION = "options";
    private static final String PROPERTIES_SECTION = "properties";
    private static final String REMOVE_SECTION = "remove";
    private static final String RENAME_SECTION = "rename";
    private static final String UNCHECKOUT_SECTION = "uncheckout";
    private static final String COMMAND_KEY = "command";
    private static BatchSCC _me = null;
    private static Profile _profile = null;
    private static boolean _supportsAdd = false;
    private static boolean _supportsCheckout = false;
    private static boolean _supportsCheckin = false;
    private static boolean _supportsDiff = false;
    private static boolean _supportsGet = false;
    private static boolean _supportsHistory = false;
    private static boolean _supportsProperties = false;
    private static boolean _supportsRemove = false;
    private static boolean _supportsUncheckout = false;
    private static STDIOWindow _window = null;
    private static SCCTextOutput _textOutput = null;

    static SCC getSourceControl() {
        if (_me == null) {
            _me = new BatchSCC();
        }
        return _me;
    }

    private BatchSCC() {
        String string = Platform.getUserConfigurationDirectory() + PROFILE_FILENAME;
        _profile = new Profile();
        try {
            _profile.open(string);
            this.updateSupportedCommandsFlags();
        }
        catch (IOException iOException) {
            SybOptionPane.showMessageDialog(BatchSCC.getParentFrame(), SCCResourcesBase.getMessage("M4", iOException.getLocalizedMessage()), SCCResourcesBase.getMessage("M1", new Object[0]), 0);
        }
    }

    private void updateSupportedCommandsFlags() {
        String string = _profile.getValue(ADD_SECTION, COMMAND_KEY);
        _supportsAdd = string != null;
        string = _profile.getValue(CHECKOUT_SECTION, COMMAND_KEY);
        _supportsCheckout = string != null;
        string = _profile.getValue(CHECKIN_SECTION, COMMAND_KEY);
        _supportsCheckin = string != null;
        string = _profile.getValue(DIFF_SECTION, COMMAND_KEY);
        _supportsDiff = string != null;
        string = _profile.getValue(GET_SECTION, COMMAND_KEY);
        _supportsGet = string != null;
        string = _profile.getValue(HISTORY_SECTION, COMMAND_KEY);
        _supportsHistory = string != null;
        string = _profile.getValue(PROPERTIES_SECTION, COMMAND_KEY);
        _supportsProperties = string != null;
        string = _profile.getValue(REMOVE_SECTION, COMMAND_KEY);
        _supportsRemove = string != null;
        string = _profile.getValue(UNCHECKOUT_SECTION, COMMAND_KEY);
        _supportsUncheckout = string != null;
    }

    private String unparameterize(String string, String string2) {
        if (this.containsWhitespace(string2)) {
            string2 = '\"' + string2 + '\"';
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = 0;
        while (true) {
            int n2;
            int n3;
            if ((n3 = stringBuffer.indexOf("[FILENAME]", n)) != -1) {
                stringBuffer.replace(n3, n3 + 10, string2);
                n = n3;
                continue;
            }
            n3 = stringBuffer.indexOf("[$", n);
            if (n3 == -1 || (n2 = stringBuffer.indexOf("]", n3 + 1)) == -1) break;
            String string3 = stringBuffer.substring(n3 + 2, n2);
            if (this.containsWhitespace(string3)) {
                n = n3 + 2;
                continue;
            }
            String string4 = System.getenv(string3);
            if (string4 == null) {
                n = n3 + 2;
                continue;
            }
            stringBuffer.replace(n3, n2 + 1, string4);
            n = n3;
        }
        return stringBuffer.toString();
    }

    private boolean containsWhitespace(String string) {
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            if (!Character.isWhitespace(string.charAt(i))) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private int writeToWindow(int n, String string) {
        int n2;
        if (_textOutput == null) {
            if (_window == null) {
                SCCResourcesBase sCCResourcesBase = SCCResourcesBase.getBundle();
                _window = new STDIOWindow(sCCResourcesBase.get("M1"), 1);
            } else {
                int n3 = _window.getExtendedState();
                if (n3 == 1) {
                    _window.setExtendedState(0);
                }
                _window.setVisible(true);
            }
            _window.writeln(string);
            n2 = 0;
        } else {
            n2 = _textOutput.write(n, string);
        }
        return n2;
    }

    private void runCommand(String string) {
        Process process;
        this.writeToWindow(1, string);
        try {
            process = Runtime.getRuntime().exec(string);
        }
        catch (IOException iOException) {
            this.writeToWindow(3, SCCResourcesBase.getMessage("M3", string, iOException.getLocalizedMessage()));
            return;
        }
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(process.getOutputStream()));
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(process.getErrorStream()));
        while (true) {
            try {
                String string2;
                while (bufferedReader.ready() && (string2 = bufferedReader.readLine()) != null) {
                    this.writeToWindow(1, string2);
                }
                while (bufferedReader2.ready() && (string2 = bufferedReader2.readLine()) != null) {
                    this.writeToWindow(3, string2);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                process.exitValue();
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            break;
        }
        this.writeToWindow(1, "");
    }

    private String convertCommandIDToSectionString(int n) {
        String string;
        switch (n) {
            case 0: {
                string = GET_SECTION;
                break;
            }
            case 1: {
                string = CHECKOUT_SECTION;
                break;
            }
            case 2: {
                string = CHECKIN_SECTION;
                break;
            }
            case 3: {
                string = UNCHECKOUT_SECTION;
                break;
            }
            case 4: {
                string = ADD_SECTION;
                break;
            }
            case 5: {
                string = REMOVE_SECTION;
                break;
            }
            case 6: {
                string = DIFF_SECTION;
                break;
            }
            case 7: {
                string = HISTORY_SECTION;
                break;
            }
            case 8: {
                string = RENAME_SECTION;
                break;
            }
            case 9: {
                string = PROPERTIES_SECTION;
                break;
            }
            case 10: {
                string = OPTIONS_SECTION;
                break;
            }
            default: {
                string = null;
            }
        }
        return string;
    }

    String getCommandLine(int n) {
        return this.getCommandLine(_profile, n);
    }

    String getCommandLine(Profile profile, int n) {
        String string = this.convertCommandIDToSectionString(n);
        String string2 = profile.getValue(string, COMMAND_KEY);
        return string2;
    }

    void setCommandLine(int n, String string) {
        String string2 = this.convertCommandIDToSectionString(n);
        if (string != null && string.length() == 0) {
            string = null;
        }
        if (string != null) {
            _profile.addValue(string2, COMMAND_KEY, string);
        } else {
            _profile.removeValue(string2, COMMAND_KEY);
        }
        this.updateSupportedCommandsFlags();
    }

    void save() throws IOException {
        _profile.save();
    }

    void export(String string) throws IOException {
        _profile.export(string);
    }

    private void runParameterizedCommand(String string, String[] stringArray) {
        String string2 = _profile.getValue(string, COMMAND_KEY);
        if (string2 != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string3 = this.unparameterize(string2, stringArray[i]);
                this.runCommand(string3);
            }
        }
    }

    @Override
    public void add(String[] stringArray, String string, long[] lArray, long l) throws SCCException {
        if (!_supportsCheckin) {
            throw new SCCException(-14);
        }
        this.runParameterizedCommand(ADD_SECTION, stringArray);
    }

    @Override
    public void checkin(String[] stringArray, String string, long l, long l2) throws SCCException {
        if (!_supportsCheckin) {
            throw new SCCException(-14);
        }
        this.runParameterizedCommand(CHECKIN_SECTION, stringArray);
    }

    @Override
    public void checkout(String[] stringArray, String string, long l, long l2) throws SCCException {
        if (!_supportsCheckout) {
            throw new SCCException(-14);
        }
        this.runParameterizedCommand(CHECKOUT_SECTION, stringArray);
    }

    @Override
    public void closeProject() throws SCCException {
    }

    @Override
    public void diff(String string, long l, long l2) throws SCCException {
        if (!_supportsDiff) {
            throw new SCCException(-14);
        }
        this.runParameterizedCommand(DIFF_SECTION, new String[]{string});
    }

    @Override
    public void destroy() {
        if (_window != null) {
            _window.setVisible(false);
            _window = null;
        }
    }

    @Override
    public void get(String[] stringArray, long l, long l2) throws SCCException {
        if (!_supportsGet) {
            throw new SCCException(-14);
        }
        this.runParameterizedCommand(GET_SECTION, stringArray);
    }

    @Override
    public String getAuxProjectPathDescription() {
        return "";
    }

    @Override
    public int getCapabilities() {
        return 0;
    }

    @Override
    public boolean supportsCommand(int n) {
        return n == 4 && _supportsAdd || n == 2 && _supportsCheckin || n == 1 && _supportsCheckout || n == 6 && _supportsDiff || n == 0 && _supportsGet || n == 7 && _supportsHistory || n == 10 || n == 9 && _supportsProperties || n == 5 && _supportsRemove || n == 3 && _supportsUncheckout;
    }

    static Frame getParentFrame() {
        Frame frame = null;
        Frame[] frameArray = Frame.getFrames();
        frame = frameArray != null && frameArray.length > 0 ? frameArray[0] : null;
        return frame;
    }

    @Override
    public long getCommandOptions(int n, Window window, int[] nArray) throws SCCException {
        Frame frame = null;
        Dialog dialog = null;
        if (n == 10) {
            ConfigurationDialog configurationDialog;
            if (window != null) {
                if (window instanceof Frame) {
                    frame = (Frame)window;
                } else if (window instanceof Dialog) {
                    dialog = (Dialog)window;
                }
            }
            if (dialog != null) {
                configurationDialog = new ConfigurationDialog(dialog, this, nArray);
            } else {
                if (dialog == null) {
                    frame = BatchSCC.getParentFrame();
                }
                configurationDialog = new ConfigurationDialog(frame, this, nArray);
            }
            configurationDialog.setVisible(true);
            configurationDialog.destroy();
        }
        return 0L;
    }

    @Override
    public int getMaximumCheckoutCommentLength() {
        return 128;
    }

    @Override
    public int getMaximumCommentLength() {
        return 128;
    }

    @Override
    public String getName() {
        SCCResourcesBase sCCResourcesBase = SCCResourcesBase.getBundle();
        String string = sCCResourcesBase.get("M2");
        return string;
    }

    @Override
    public String[] getNewSCCFiles() throws SCCException {
        throw new SCCException(-14);
    }

    @Override
    public boolean getProjectPath(String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4, boolean bl, boolean bl2, boolean[] blArray) throws SCCException {
        throw new SCCException(-14);
    }

    @Override
    public int getVersion() throws SCCException {
        throw new SCCException(-14);
    }

    @Override
    public boolean hasCommandOptions(int n) throws SCCException {
        return n == 10;
    }

    @Override
    public void history(String[] stringArray, long l, long l2) throws SCCException {
        if (!_supportsHistory) {
            throw new SCCException(-14);
        }
        this.runParameterizedCommand(HISTORY_SECTION, stringArray);
    }

    @Override
    public void openProject(String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4, String string, SCCTextOutput sCCTextOutput, long l) throws SCCException {
        _textOutput = sCCTextOutput;
        stringArray[0] = "";
        stringArray2[0] = "";
        stringArray3[0] = "";
        stringArray4[0] = "";
    }

    @Override
    public String[] populateList(int n, String[] stringArray, long l) throws SCCException {
        return stringArray;
    }

    @Override
    public int[] getStatus(String[] stringArray) throws SCCException {
        throw new SCCException(-14);
    }

    @Override
    public void remove(String[] stringArray, String string, long l, long l2) throws SCCException {
        if (!_supportsRemove) {
            throw new SCCException(-14);
        }
        this.runParameterizedCommand(REMOVE_SECTION, stringArray);
    }

    @Override
    public void rename(String string, String string2) throws SCCException {
        throw new SCCException(-14);
    }

    @Override
    public void runSCC(String[] stringArray) throws SCCException {
        throw new SCCException(-14);
    }

    @Override
    public void setSCCOption(int n, int n2) throws SCCException {
        throw new SCCException(-14);
    }

    @Override
    public void showProperties(String string) throws SCCException {
        if (!_supportsProperties) {
            throw new SCCException(-14);
        }
        this.runParameterizedCommand(PROPERTIES_SECTION, new String[]{string});
    }

    @Override
    public void uncheckout(String[] stringArray, long l, long l2) throws SCCException {
        if (!_supportsUncheckout) {
            throw new SCCException(-14);
        }
        this.runParameterizedCommand(UNCHECKOUT_SECTION, stringArray);
    }

    private static boolean dbgEnabled() {
        return false;
    }
}

