/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Chart
extends JPanel {
    private static final Color[] PLOT_COLORS = new Color[]{Color.CYAN, Color.BLUE, Color.GRAY, Color.GREEN, Color.LIGHT_GRAY, Color.MAGENTA, Color.ORANGE, Color.PINK, Color.RED, Color.WHITE, Color.YELLOW};
    private static final int NUM_PLOT_COLORS = 11;
    private static final DecimalFormat FORMATTER = new DecimalFormat("#########");
    private static final int POINT_SIZE = 6;
    private static final String EMPTY_STRING = "";
    private static final String SPACE_STRING = " ";
    private static final int CHART_COLS = 50;
    public static final Color DEFAULT_COLOR = new Color(46, 139, 87);
    public static final int POINT = 0;
    public static final int LINE = 1;
    public static final int AREA = 2;
    public static final int BAR = 3;
    private boolean _dataIsSet = false;
    private boolean _drawLines = false;
    private boolean _drawXLabels = true;
    private int _drawXLabelFreq = 0;
    private Color _gridColor;
    private Color _labelColor;
    private Font _font;
    private Surface _surf;
    private int _ySpacing = 100;
    private int _xSpacing = 25;
    private int _style = 0;
    private JSlider _slider;
    private JLabel _xAxisLabel;
    private String _yAxisText = " ";
    private String[] _seriesNames = null;
    private String _chartTitle = "";
    private ArrayList<Object> _xPoints = null;
    private ArrayList<ArrayList<Object>> _yPoints = null;
    private ArrayList<Double> _ySeriesScales = null;
    private boolean _useXPointsForColumnLabels = false;
    private ArrayList<Color> _pointColors = new ArrayList();
    private double _smallestX = Double.MAX_VALUE;
    private double _largestX = Double.MIN_VALUE;
    private double _largestY = Double.MIN_VALUE;
    private int _pointCount = 0;
    private GridBagLayout _gbl = new GridBagLayout();
    private GridBagConstraints _gbc = new GridBagConstraints();
    private int _firstX = 0;
    private int _lastX = 0;

    public Chart() {
        this._gridColor = DEFAULT_COLOR;
        this._labelColor = DEFAULT_COLOR;
        this._font = new JLabel().getFont();
        this.setOpaque(true);
        this.putClientProperty("jsyblib.preservecolor", "1");
        this.setBackground(Color.black);
        this._slider = new JSlider(0, 0, 100, 0);
        this._slider.setBackground(Color.black);
        this._slider.setVisible(false);
        this._surf = new Surface();
        this._xAxisLabel = new JLabel();
        this._xAxisLabel.setHorizontalAlignment(0);
        this.setLayout(this._gbl);
        this.add(this._surf);
        this.add(this._xAxisLabel);
        this.add(this._slider);
        this._gbc.gridx = 0;
        this._gbc.gridy = 0;
        this._gbc.anchor = 18;
        this._gbc.fill = 1;
        this._gbc.insets = new Insets(5, 5, 0, 5);
        this._gbc.weightx = 1.0;
        this._gbc.weighty = 1.0;
        this._gbc.gridwidth = 0;
        this._gbl.setConstraints(this._surf, this._gbc);
        this._gbc.gridx = 0;
        this._gbc.gridy = 1;
        this._gbc.anchor = 18;
        this._gbc.fill = 2;
        this._gbc.insets = new Insets(0, 0, 5, 0);
        this._gbc.weightx = 0.0;
        this._gbc.weighty = 0.0;
        this._gbc.gridwidth = 0;
        this._gbl.setConstraints(this._xAxisLabel, this._gbc);
        this._gbc.gridx = 0;
        this._gbc.gridy = 2;
        this._gbc.anchor = 18;
        this._gbc.fill = 2;
        this._gbc.insets = new Insets(0, 40, 10, 40);
        this._gbc.weightx = 1.0;
        this._gbc.weighty = 0.0;
        this._gbc.gridwidth = 0;
        this._gbc.gridheight = 0;
        this._gbl.setConstraints(this._slider, this._gbc);
    }

    public void releaseResources() {
        this.setVisible(false);
        this._gridColor = null;
        this._labelColor = null;
        this._font = null;
        this._surf.releaseResources();
        this._surf = null;
        this._slider = null;
        this._xAxisLabel = null;
        if (this._xPoints != null) {
            this._xPoints.clear();
            this._xPoints = null;
        }
        if (this._yPoints != null) {
            this._yPoints.clear();
            this._yPoints = null;
        }
        if (this._ySeriesScales != null) {
            this._ySeriesScales.clear();
            this._ySeriesScales = null;
        }
        if (this._pointColors != null) {
            this._pointColors.clear();
            this._pointColors = null;
        }
        this._gbl = null;
        this._gbc = null;
        this._seriesNames = null;
    }

    public void clear() {
        this._surf.clear();
        this._dataIsSet = false;
        if (this._xPoints != null) {
            this._xPoints.clear();
            this._xPoints = null;
        }
        this._firstX = 0;
        this._lastX = 0;
        if (this._yPoints != null) {
            this._yPoints.clear();
            this._yPoints = null;
        }
        if (this._ySeriesScales != null) {
            this._ySeriesScales.clear();
            this._ySeriesScales = null;
        }
        if (this._pointColors != null) {
            this._pointColors.clear();
        }
        this._smallestX = Double.MAX_VALUE;
        this._largestX = Double.MIN_VALUE;
        this._largestY = Double.MIN_VALUE;
        this._pointCount = 0;
        this._surf.repaint();
    }

    public void setChartTitle(String string) {
        if (string == null) {
            string = EMPTY_STRING;
        }
        this._chartTitle = string;
        this._surf.repaint();
    }

    public String getChartTitle() {
        return this._chartTitle;
    }

    public void setXAxisText(String string) {
        if (string == null) {
            string = EMPTY_STRING;
        }
        this._xAxisLabel.setText(string);
    }

    public String getXAxisText() {
        return this._xAxisLabel.getText();
    }

    public void setYAxisText(String string) {
        if (string == null || string.length() == 0) {
            string = SPACE_STRING;
        }
        this._yAxisText = string;
        this._surf.repaint();
    }

    public String getYAxisText() {
        return this._yAxisText;
    }

    public void setSeriesNames(String[] stringArray) {
        this._seriesNames = stringArray;
    }

    public String[] getSeriesNames() {
        return this._seriesNames;
    }

    public void setSeriesData(ArrayList<Object> arrayList, ArrayList<ArrayList<Object>> arrayList2) {
        int n;
        int n2 = 0;
        int n3 = -1;
        int n4 = -1;
        if (arrayList2 == null) {
            this._dataIsSet = false;
            return;
        }
        if (arrayList != null) {
            this._xPoints = new ArrayList<Object>(arrayList);
        }
        this._yPoints = new ArrayList<ArrayList<Object>>(arrayList2);
        if (this._xPoints != null && this._xPoints.size() > 0 && this._yPoints.size() > 0 && this._xPoints.size() != this._yPoints.get(0).size()) {
            this._dataIsSet = false;
            return;
        }
        if (this._xPoints == null && this._pointColors.size() < this._yPoints.size()) {
            this._pointColors.clear();
            for (n = 0; n < this._yPoints.size(); ++n) {
                if (++n3 >= 11) {
                    n3 = 0;
                }
                this._pointColors.add(PLOT_COLORS[n3]);
            }
        }
        this._useXPointsForColumnLabels = false;
        this._smallestX = Double.MAX_VALUE;
        this._largestX = Double.MIN_VALUE;
        if (this._xPoints != null) {
            Number number;
            for (n = 0; n < this._xPoints.size(); ++n) {
                number = this.getNumberFromObject(this._xPoints.get(n));
                if (number == null) {
                    this._useXPointsForColumnLabels = true;
                    break;
                }
                if (number.doubleValue() < this._smallestX) {
                    this._smallestX = number.doubleValue();
                    continue;
                }
                if (!(number.doubleValue() > this._largestX)) continue;
                this._largestX = number.doubleValue();
            }
            this._pointColors.clear();
            this._largestY = Double.MIN_VALUE;
            n2 = this._xPoints.size();
            for (n = 0; n < this._yPoints.size(); ++n) {
                if (++n3 >= 11) {
                    n3 = 0;
                }
                this._pointColors.add(PLOT_COLORS[n3]);
                ArrayList<Object> arrayList3 = this._yPoints.get(n);
                if (arrayList3 instanceof ArrayList) {
                    if (n4 >= 0 && n4 != arrayList3.size()) {
                        this._dataIsSet = false;
                        return;
                    }
                    n4 = arrayList3.size();
                    if (n4 != n2) {
                        this._dataIsSet = false;
                        return;
                    }
                } else {
                    this._dataIsSet = false;
                    return;
                }
                this._pointCount = n4;
                for (int i = 0; i < arrayList3.size(); ++i) {
                    number = this.getNumberFromObject(arrayList3.get(i));
                    if (number == null) {
                        this._dataIsSet = false;
                        return;
                    }
                    if (!(number.doubleValue() > this._largestY)) continue;
                    this._largestY = number.doubleValue();
                }
            }
        }
        this._dataIsSet = true;
        if (this._xPoints == null) {
            this.setShowSlider(false);
            this._drawXLabels = false;
        } else {
            this.setShowSlider(true);
            this._drawXLabels = true;
        }
        this._surf.repaint();
        this._surf.repaint();
    }

    public ArrayList[] getSeriesData() {
        if (this._yPoints != null) {
            return new ArrayList[]{this._xPoints, this._yPoints};
        }
        return null;
    }

    public void setGridLinesDrawn(boolean bl) {
        this._drawLines = bl;
        this._surf.repaint();
    }

    public boolean areGridLinesDrawn() {
        return this._drawLines;
    }

    public void setXLabelsDrawn(boolean bl) {
        this._drawXLabels = this._xPoints != null ? bl : false;
        this._surf.repaint();
    }

    public boolean areXLabelsDrawn() {
        return this._drawXLabels;
    }

    public void setXLabelDrawFrequency(int n) {
        this._drawXLabelFreq = n >= 0 ? n : 0;
        this._surf.repaint();
    }

    public int getXLabelDrawFrequency() {
        return this._drawXLabelFreq;
    }

    public void setGridColor(Color color) {
        this._gridColor = color;
        this._surf.repaint();
    }

    public Color getGridColor() {
        return this._gridColor;
    }

    public void setLabelColor(Color color) {
        this._labelColor = color;
        this._surf.repaint();
    }

    public Color getLabelColor() {
        return this._labelColor;
    }

    public void setShowSlider(boolean bl) {
        if (this._xPoints != null) {
            this._slider.setVisible(bl);
        } else {
            this._slider.setVisible(false);
        }
    }

    public boolean isSliderShown() {
        return this._slider.isVisible();
    }

    @Override
    public void setFont(Font font) {
        this._font = font;
        if (this._surf != null) {
            this._surf.repaint();
        }
    }

    @Override
    public Font getFont() {
        return this._font;
    }

    public void setStyle(int n) {
        if (n == 0 || n == 1 || n == 2 || n == 3) {
            this._style = n;
            this._surf.repaint();
        }
    }

    public int getStyle() {
        return this._style;
    }

    public void setXSpacing(int n) {
        if (n < 1001 && n > 0) {
            this._xSpacing = n;
            this._surf.repaint();
        }
    }

    public int getXSpacing() {
        return this._xSpacing;
    }

    public Color getSeriesColor(int n) {
        if (n < this._pointColors.size()) {
            return this._pointColors.get(n);
        }
        if (n < 11) {
            return PLOT_COLORS[n];
        }
        return PLOT_COLORS[n % 11];
    }

    public void setSeriesColor(int n, Color color) {
        if (n < this._pointColors.size()) {
            this._pointColors.set(n, color);
            this._surf.repaint();
        }
    }

    public ArrayList<Double> getYSeriesScales() {
        return this._ySeriesScales;
    }

    public void setYSeriesScales(ArrayList<Double> arrayList) {
        this._ySeriesScales = new ArrayList<Double>(arrayList);
    }

    public int[] getXIndexRangeCurrentlyPlotted() {
        return new int[]{this._firstX, this._lastX};
    }

    private Number getNumberFromObject(Object object) {
        if (object instanceof Number) {
            return (Number)object;
        }
        if (object instanceof String) {
            try {
                return new Double((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public static double getDoubleFromObject(Object object) {
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        if (object instanceof String) {
            try {
                return Double.parseDouble((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0.0;
    }

    public static void main(String[] stringArray) {
        final Chart chart = new Chart();
        JFrame jFrame = new JFrame();
        WindowAdapter windowAdapter = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                chart.releaseResources();
                System.exit(0);
            }
        };
        jFrame.addWindowListener(windowAdapter);
        jFrame.getContentPane().add((Component)chart, "Center");
        chart.setPreferredSize(new Dimension(400, 400));
        chart.setXSpacing(30);
        chart.setStyle(0);
        chart.setLabelColor(Color.yellow);
        chart.setChartTitle("Memory Usage Chart");
        chart.setXAxisText("X-Axis Label");
        chart.setYAxisText("Bytes");
        ArrayList<Object> arrayList = null;
        ArrayList<ArrayList<Object>> arrayList2 = new ArrayList<ArrayList<Object>>();
        arrayList2.add(Chart.makeYPoints(1));
        arrayList2.add(Chart.makeYPoints(2));
        arrayList2.add(Chart.makeYPoints(3));
        arrayList2.add(Chart.makeYPoints(4));
        chart.setSeriesData(arrayList, arrayList2);
        jFrame.setVisible(true);
        jFrame.pack();
    }

    private static ArrayList<String> makeNumericXPoints() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("1");
        arrayList.add("2");
        arrayList.add("3");
        arrayList.add("4");
        arrayList.add("5");
        arrayList.add("6");
        arrayList.add("7");
        arrayList.add("8");
        arrayList.add("9");
        arrayList.add("10");
        arrayList.add("11");
        arrayList.add("12");
        arrayList.add("13");
        arrayList.add("14");
        arrayList.add("15");
        arrayList.add("16");
        arrayList.add("17");
        arrayList.add("18");
        arrayList.add("19");
        arrayList.add("20");
        arrayList.add("210");
        arrayList.add("220");
        arrayList.add("230");
        arrayList.add("240");
        arrayList.add("250");
        arrayList.add("260");
        arrayList.add("270");
        arrayList.add("280");
        arrayList.add("290");
        arrayList.add("300");
        arrayList.add("310");
        arrayList.add("320");
        arrayList.add("330");
        arrayList.add("340");
        arrayList.add("350");
        arrayList.add("360");
        arrayList.add("370");
        arrayList.add("380");
        arrayList.add("390");
        arrayList.add("999");
        return arrayList;
    }

    private static ArrayList<String> makeAlphaXPoints() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("A");
        arrayList.add("B");
        arrayList.add("C");
        arrayList.add("D");
        arrayList.add("E");
        arrayList.add("F");
        arrayList.add("G");
        arrayList.add("H");
        arrayList.add("I");
        arrayList.add("J");
        arrayList.add("K");
        arrayList.add("L");
        arrayList.add("M");
        arrayList.add("N");
        arrayList.add("O");
        arrayList.add("P");
        arrayList.add("Q");
        arrayList.add("R");
        arrayList.add("S");
        arrayList.add("T");
        arrayList.add("U");
        arrayList.add("V");
        arrayList.add("W");
        arrayList.add("X");
        arrayList.add("Y");
        arrayList.add("Z");
        arrayList.add("AA");
        arrayList.add("AB");
        arrayList.add("AC");
        arrayList.add("AD");
        arrayList.add("AE");
        arrayList.add("AF");
        arrayList.add("AG");
        arrayList.add("AH");
        arrayList.add("AI");
        arrayList.add("AJ");
        arrayList.add("AK");
        arrayList.add("AL");
        arrayList.add("AM");
        arrayList.add("AN");
        return arrayList;
    }

    private static ArrayList<Object> makeYPoints(int n) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Runtime runtime = Runtime.getRuntime();
        arrayList.add(runtime.freeMemory() * (long)n);
        arrayList.add(runtime.freeMemory() / 3L * (long)n);
        arrayList.add(runtime.freeMemory() / 5L * (long)n);
        arrayList.add(runtime.freeMemory() / 10L * (long)n);
        arrayList.add(runtime.freeMemory() * (long)n);
        arrayList.add(runtime.freeMemory() / 3L * (long)n);
        arrayList.add(runtime.freeMemory() / 5L * (long)n);
        arrayList.add(runtime.freeMemory() / 10L * (long)n);
        arrayList.add(runtime.freeMemory() * (long)n);
        arrayList.add(runtime.freeMemory() / 3L * (long)n);
        arrayList.add(runtime.freeMemory() / 5L * (long)n);
        arrayList.add(runtime.freeMemory() / 10L * (long)n);
        arrayList.add(runtime.freeMemory() * (long)n);
        arrayList.add(runtime.freeMemory() / 3L * (long)n);
        arrayList.add(runtime.freeMemory() / 5L * (long)n);
        arrayList.add(runtime.freeMemory() / 10L * (long)n);
        arrayList.add(runtime.freeMemory() * (long)n);
        arrayList.add(runtime.freeMemory() / 3L * (long)n);
        arrayList.add(runtime.freeMemory() / 5L * (long)n);
        arrayList.add(runtime.freeMemory() / 10L * (long)n);
        arrayList.add(runtime.freeMemory() * (long)n);
        arrayList.add(runtime.freeMemory() / 3L * (long)n);
        arrayList.add(runtime.freeMemory() / 5L * (long)n);
        arrayList.add(runtime.freeMemory() / 10L * (long)n);
        arrayList.add(runtime.freeMemory() * (long)n);
        arrayList.add(runtime.freeMemory() / 3L * (long)n);
        arrayList.add(runtime.freeMemory() / 5L * (long)n);
        arrayList.add(runtime.freeMemory() / 10L * (long)n);
        arrayList.add(runtime.freeMemory() * (long)n);
        arrayList.add(runtime.freeMemory() / 3L * (long)n);
        arrayList.add(runtime.freeMemory() / 5L * (long)n);
        arrayList.add(runtime.freeMemory() / 10L * (long)n);
        arrayList.add(runtime.freeMemory() * (long)n);
        arrayList.add(runtime.freeMemory() / 3L * (long)n);
        arrayList.add(runtime.freeMemory() / 5L * (long)n);
        arrayList.add(runtime.freeMemory() / 10L * (long)n);
        arrayList.add(runtime.freeMemory() * (long)n);
        arrayList.add(runtime.freeMemory() / 3L * (long)n);
        arrayList.add(runtime.freeMemory() / 5L * (long)n);
        arrayList.add(runtime.freeMemory() / 10L * (long)n);
        return arrayList;
    }

    class Surface
    extends JPanel
    implements ChangeListener,
    MouseMotionListener {
        private static final String ZERO = "0";
        private FontMetrics _fm = null;
        private static final int DEFAULT_MARGIN_SIZE = 70;
        private int _topMarginSize = 70;
        private int _xMarginSize = 70;
        private int _width;
        private int _height;
        private int _ascent;
        private float _fontH;
        private BufferedImage _bImage = null;
        private Graphics2D _graphics2d = null;
        private Rectangle _chartOutlineRect = null;
        private Line2D _chartLine = null;
        private AffineTransform _afft = null;
        private int _currentPoint = 0;
        private double _xLabelIncrement = 1.0;
        private double _yScale = 1.0;
        private TextLayout _leftLabel = null;
        private AffineTransform _textAt = null;
        private Shape _shape = null;
        private AffineTransform _saveXForm = null;
        private AffineTransform _toCenterAt = null;
        private Rectangle _rect = null;
        private Dimension _dim = null;
        private int _depthLimit;
        private int _mouseXVal = -1;

        Surface() {
            this.setOpaque(true);
            this.setBackground(Color.black);
            this.initializeChart();
            Chart.this._slider.setMinimum(0);
            Chart.this._slider.setValue(0);
            Chart.this._slider.addChangeListener(this);
            this.addMouseMotionListener(this);
            ToolTipManager.sharedInstance().registerComponent(this);
        }

        void releaseResources() {
            Chart.this._slider.removeChangeListener(this);
            this.removeMouseMotionListener(this);
            ToolTipManager.sharedInstance().unregisterComponent(this);
            this._fm = null;
            if (this._bImage != null) {
                this._bImage.flush();
            }
            this._bImage = null;
            if (this._graphics2d != null) {
                this._graphics2d.dispose();
            }
            this._graphics2d = null;
            this._chartOutlineRect = null;
            this._chartLine = null;
            this._afft = null;
            this._shape = null;
            this._leftLabel = null;
            this._textAt = null;
            this._saveXForm = null;
            this._toCenterAt = null;
            this._rect = null;
            this._dim = null;
        }

        public void clear() {
            this._currentPoint = 0;
            this._yScale = 1.0;
        }

        private void initializeChart() {
            this._chartOutlineRect = new Rectangle();
            this._chartLine = new Line2D.Float();
            this._afft = new AffineTransform();
            this._afft.rotate(Math.toRadians(-90.0));
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            this._currentPoint = Chart.this._slider.getValue();
            if (this._currentPoint < 0) {
                this._currentPoint = 0;
            }
            this.repaint();
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            if (Chart.this._xPoints != null) {
                final int n = ToolTipManager.sharedInstance().getDismissDelay();
                ToolTipManager.sharedInstance().setDismissDelay(0);
                if (n != 0) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ToolTipManager.sharedInstance().setDismissDelay(n);
                        }
                    });
                }
                if (mouseEvent.getX() >= this._xMarginSize && mouseEvent.getX() <= this._width - this._xMarginSize && mouseEvent.getY() >= this._topMarginSize && (float)mouseEvent.getY() <= (float)this._height - this._fontH * 3.0f - 0.5f) {
                    this._mouseXVal = (int)((double)((float)(mouseEvent.getX() - this._xMarginSize) / (float)Chart.this._xSpacing) + 0.5);
                    if (this._currentPoint + this._mouseXVal >= Chart.this._xPoints.size()) {
                        this._mouseXVal = -1;
                    }
                } else {
                    this._mouseXVal = -1;
                }
                this.repaint();
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
        }

        @Override
        public String getToolTipText(MouseEvent mouseEvent) {
            return this.getToolTipString(mouseEvent.getX(), mouseEvent.getY());
        }

        private String getToolTipString(int n, int n2) {
            StringBuilder stringBuilder = new StringBuilder();
            double d = 1.0;
            double d2 = 0.0;
            if (Chart.this._xPoints != null && this._mouseXVal >= 0) {
                stringBuilder.append("<html>");
                if (Chart.this._seriesNames != null) {
                    for (int i = 0; i < Chart.this._seriesNames.length && i < Chart.this._yPoints.size(); ++i) {
                        ArrayList arrayList = (ArrayList)Chart.this._yPoints.get(i);
                        if (Chart.this._ySeriesScales != null && Chart.this._ySeriesScales.size() > i) {
                            d = (Double)Chart.this._ySeriesScales.get(i);
                        }
                        d2 = Chart.getDoubleFromObject(arrayList.get(this._currentPoint + this._mouseXVal));
                        stringBuilder.append("<p>");
                        stringBuilder.append(Chart.this._seriesNames[i]);
                        stringBuilder.append(':');
                        stringBuilder.append(' ');
                        stringBuilder.append(String.valueOf(d2 * d));
                        stringBuilder.append("</p>");
                    }
                }
                stringBuilder.append("<p>");
                stringBuilder.append(Chart.this.getXAxisText());
                stringBuilder.append(':');
                stringBuilder.append(' ');
                stringBuilder.append(Chart.this._xPoints.get(this._currentPoint + this._mouseXVal));
                stringBuilder.append("</p>");
                stringBuilder.append("</html>");
                return stringBuilder.toString();
            }
            return null;
        }

        @Override
        public void paint(Graphics graphics) {
            double d = 0.0;
            double d2 = Double.MIN_VALUE;
            int n = 0;
            int n2 = 0;
            boolean bl = false;
            String string = Chart.EMPTY_STRING;
            int n3 = this._currentPoint;
            this._dim = this.getSize();
            if (this._dim.width != this._width || this._dim.height != this._height) {
                this._width = this._dim.width;
                this._height = this._dim.height;
                if (this._bImage != null) {
                    this._bImage.flush();
                    this._graphics2d.dispose();
                }
                this._bImage = (BufferedImage)this.createImage(this._width, this._height);
                this._graphics2d = this._bImage.createGraphics();
                this._graphics2d.setFont(Chart.this._font);
                this._graphics2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                this._fm = this._graphics2d.getFontMetrics(Chart.this._font);
                this._ascent = this._fm.getAscent();
                int n4 = this._fm.getDescent();
                this._fontH = this._ascent + n4;
                this._leftLabel = new TextLayout(Chart.this._yAxisText, Chart.this._font, new FontRenderContext(null, false, false));
                this._textAt = new AffineTransform();
                this._textAt.translate(0.0, (float)this._leftLabel.getBounds().getHeight());
                this._shape = this._leftLabel.getOutline(this._textAt);
            }
            if (Chart.this._largestY > 0.0 && Chart.this._largestY != Double.MIN_VALUE) {
                int n5 = String.valueOf(Math.round(Math.abs(Chart.this._largestY))).length();
                d = Math.pow(10.0, n5);
                this._xMarginSize = 30 + this._fm.stringWidth(String.valueOf(FORMATTER.format(d)));
                if (this._xMarginSize < 70) {
                    this._xMarginSize = 70;
                }
            } else {
                this._xMarginSize = 70;
                d = 10.0;
            }
            this._topMarginSize = Chart.this._chartTitle.length() > 0 ? this._xMarginSize : 10 + (int)(this._fontH / 2.0f);
            if (Chart.this._slider.isVisible()) {
                Chart.this._gbc = Chart.this._gbl.getConstraints(Chart.this._slider);
                ((Chart)Chart.this)._gbc.insets = new Insets(0, this._xMarginSize, 10, this._xMarginSize);
                Chart.this._gbl.setConstraints(Chart.this._slider, Chart.this._gbc);
                if (Chart.this._style == 3 && n3 == Chart.this._slider.getMaximum()) {
                    ++n3;
                }
            }
            int n6 = this._xMarginSize;
            int n7 = this._topMarginSize;
            int n8 = this._width - n6 - this._xMarginSize;
            int n9 = (int)((float)this._height - this._fontH * 3.0f - 0.5f) - this._topMarginSize;
            this._yScale = Chart.this._largestY > 0.0 && Chart.this._largestY != Double.MIN_VALUE ? d / (double)n9 : 1.0;
            this._xLabelIncrement = Chart.this._useXPointsForColumnLabels ? 1.0 : Math.pow(10.0, String.valueOf((int)Chart.this._largestX).length() - 1);
            this._depthLimit = (int)((double)(n9 / Chart.this._ySpacing) / 1.5);
            this._graphics2d.setBackground(Color.black);
            this._graphics2d.clearRect(0, 0, this._width, this._height);
            if (Chart.this._chartTitle.length() > 0) {
                this._graphics2d.setColor(Chart.this._labelColor);
                this._graphics2d.drawString(Chart.this._chartTitle, this._xMarginSize + (n8 / 2 - this._fm.stringWidth(Chart.this._chartTitle) / 2), (int)((float)(this._topMarginSize / 2) + this._fontH / 2.0f));
            }
            this._graphics2d.setColor(Chart.this._labelColor);
            this._saveXForm = this._graphics2d.getTransform();
            this._toCenterAt = new AffineTransform();
            this._toCenterAt.concatenate(this._afft);
            this._rect = this._shape.getBounds();
            this._toCenterAt.translate(-(this._rect.width / 2) - (this._topMarginSize + n9 / 2), this._rect.height / 2);
            this._graphics2d.transform(this._toCenterAt);
            this._graphics2d.fill(this._shape);
            this._graphics2d.setTransform(this._saveXForm);
            Chart.this._xAxisLabel.setForeground(Chart.this._labelColor);
            this._graphics2d.setColor(Chart.this._gridColor);
            this._chartOutlineRect.setRect(n6, n7, n8, n9);
            this._graphics2d.draw(this._chartOutlineRect);
            int n10 = n7;
            if (!Chart.this._drawLines) {
                this._chartLine.setLine(n6 - 10, n10, n6, n10);
                this._graphics2d.draw(this._chartLine);
                this._chartLine.setLine(n6 + n8, n10, n6 + n8 + 10, n10);
                this._graphics2d.draw(this._chartLine);
            } else {
                this._chartLine.setLine(n6 - 10, n10, n6 + n8 + 10, n10);
                this._graphics2d.draw(this._chartLine);
            }
            n10 = n7 + n9;
            if (!Chart.this._drawLines) {
                this._chartLine.setLine(n6 - 10, n10, n6, n10);
                this._graphics2d.draw(this._chartLine);
                this._chartLine.setLine(n6 + n8, n10, n6 + n8 + 10, n10);
                this._graphics2d.draw(this._chartLine);
            } else {
                this._chartLine.setLine(n6 - 10, n10, n6 + n8 + 10, n10);
                this._graphics2d.draw(this._chartLine);
            }
            this._graphics2d.setColor(Chart.this._labelColor);
            string = String.valueOf(FORMATTER.format(d));
            this._graphics2d.drawString(string, this._xMarginSize - 15 - this._fm.stringWidth(string), n7 + this._ascent / 2);
            this._graphics2d.drawString(string, n8 + this._xMarginSize + 15, n7 + this._ascent / 2);
            this._graphics2d.setColor(Chart.this._labelColor);
            this._graphics2d.drawString(ZERO, this._xMarginSize - 15 - this._fm.stringWidth(ZERO), n7 + n9 + this._ascent / 2);
            this._graphics2d.drawString(ZERO, n8 + this._xMarginSize + 15, n7 + n9 + this._ascent / 2);
            this.drawRow(1, n6, n8, n7, n9, d, 0.0);
            int n11 = 0;
            this._graphics2d.setColor(Chart.this._gridColor);
            if (Chart.this._xPoints != null) {
                for (int i = n6; i <= n6 + n8; i += Chart.this._xSpacing) {
                    int n12 = i == n6 || ++n2 > Chart.this._drawXLabelFreq ? (bl ? 15 : 10) : 5;
                    if (Chart.this._drawLines) {
                        this._chartLine.setLine(i, n7, i, n7 + n9 + n12);
                        this._graphics2d.draw(this._chartLine);
                    } else {
                        this._chartLine.setLine(i, n7 + n9, i, n7 + n9 + n12);
                        this._graphics2d.draw(this._chartLine);
                    }
                    if (Chart.this._drawXLabels && (i == n6 || n2 > Chart.this._drawXLabelFreq)) {
                        n2 = 0;
                        string = Chart.this._useXPointsForColumnLabels ? (Chart.this._xPoints.size() >= n11 + n3 ? (n11 + n3 < Chart.this._xPoints.size() ? (String)Chart.this._xPoints.get(n11 + n3) : Chart.EMPTY_STRING) : Chart.EMPTY_STRING) : String.valueOf(FORMATTER.format((double)(n11 + n3) * this._xLabelIncrement));
                        this._graphics2d.setColor(Chart.this._labelColor);
                        if (bl) {
                            this._graphics2d.drawString(string, n6 + n11 * Chart.this._xSpacing - this._fm.stringWidth(string) / 2, n7 + n9 + 20 + (int)((double)this._ascent * 1.5));
                        } else {
                            this._graphics2d.drawString(string, n6 + n11 * Chart.this._xSpacing - this._fm.stringWidth(string) / 2, n7 + n9 + 20 + this._ascent / 2);
                        }
                        bl = !bl;
                        this._graphics2d.setColor(Chart.this._gridColor);
                    }
                    ++n11;
                }
                if (Chart.this._dataIsSet) {
                    Chart.this._firstX = n3;
                    Chart.this._lastX = Math.min(n3 + n11 - 1, ((ArrayList)Chart.this._yPoints.get(0)).size() - 1);
                }
            } else {
                for (int i = n6 + n8; i >= n6; i -= Chart.this._xSpacing) {
                    if (Chart.this._drawLines) {
                        this._chartLine.setLine(i, n7, i, n7 + n9 + 5);
                        this._graphics2d.draw(this._chartLine);
                        continue;
                    }
                    this._chartLine.setLine(i, n7 + n9, i, n7 + n9 + 5);
                    this._graphics2d.draw(this._chartLine);
                }
            }
            int n13 = n8 / 50;
            if (n == 0) {
                n = n13;
            }
            --n;
            this._graphics2d.setClip(n6 + 1, n7 + 1, n8 - 1, n9);
            if (Chart.this._dataIsSet) {
                d2 = this.plotPoints(n3, n6, n7, n8, n9);
            }
            if (d2 != Double.MIN_VALUE) {
                if (Chart.this._largestY < d2) {
                    Chart.this._largestY = d2;
                }
                if (Chart.this._largestY > d2 * 4.0) {
                    Chart.this._largestY = d2;
                }
            }
            this._dim = this.getSize();
            this._graphics2d.setClip(0, 0, this._dim.width, this._dim.height);
            if (Chart.this._xPoints != null && this._mouseXVal >= 0) {
                this._graphics2d.setColor(Color.white);
                this._chartLine.setLine(this._xMarginSize + this._mouseXVal * Chart.this._xSpacing, this._topMarginSize + 1, this._xMarginSize + this._mouseXVal * Chart.this._xSpacing, this._topMarginSize + n9 - 1);
                this._graphics2d.draw(this._chartLine);
            }
            graphics.drawImage(this._bImage, 0, 0, this);
        }

        private double plotPoints(int n, int n2, int n3, int n4, int n5) {
            ArrayList arrayList = null;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            int n10 = 0;
            float f = 0.0f;
            int n11 = 0;
            int n12 = 0;
            double d = Double.MIN_VALUE;
            int[] nArray = null;
            int[] nArray2 = null;
            int[] nArray3 = null;
            int[] nArray4 = null;
            block0: for (int i = 0; i < Chart.this._yPoints.size(); ++i) {
                int n13;
                double d2;
                int n14;
                arrayList = (ArrayList)Chart.this._yPoints.get(i);
                this._graphics2d.setColor((Color)Chart.this._pointColors.get(++n7 - 1));
                if (Chart.this._useXPointsForColumnLabels) {
                    n8 = n4 / Chart.this._xSpacing + 2;
                    if (Chart.this._slider.isVisible()) {
                        Chart.this._slider.setMaximum(Chart.this._pointCount - n8 + 2);
                        Chart.this._slider.setEnabled(Chart.this._pointCount + 2 > n8);
                    }
                } else {
                    n8 = n4 / Chart.this._xSpacing;
                    if (Chart.this._slider.isVisible()) {
                        Chart.this._slider.setEnabled(n8 < Math.round((float)(Chart.this._largestX / this._xLabelIncrement)));
                        Chart.this._slider.setMaximum(Math.round((float)(Chart.this._largestX / this._xLabelIncrement)) - n8);
                    }
                }
                if (Chart.this._style == 2) {
                    if (arrayList.size() <= 1) continue;
                    nArray2 = new int[arrayList.size() + 2];
                    nArray = new int[arrayList.size() + 2];
                    if (Chart.this._xPoints != null) {
                        if (!Chart.this._useXPointsForColumnLabels) {
                            f = (float)((double)Chart.this._xSpacing / this._xLabelIncrement);
                            for (n14 = 0; n14 < arrayList.size(); ++n14) {
                                d2 = Chart.getDoubleFromObject(arrayList.get(n14));
                                if (d2 > d) {
                                    d = d2;
                                }
                                n9 = n2;
                                n9 += (int)(Chart.getDoubleFromObject(Chart.this._xPoints.get(n14)) * (double)f);
                                n11 = n3 + n5 - (int)(d2 / this._yScale);
                                nArray2[n14] = n9 -= (int)((double)n * this._xLabelIncrement * (double)f);
                                nArray[n14] = n11;
                            }
                            nArray2[nArray2.length - 2] = nArray2[nArray2.length - 3];
                            nArray[nArray.length - 2] = n3 + n5;
                            nArray2[nArray2.length - 1] = nArray2[0];
                            nArray[nArray.length - 1] = n3 + n5;
                        } else {
                            for (n14 = 0; n14 < n8 && n14 + n < arrayList.size(); ++n14) {
                                n13 = n2 + n14 * Chart.this._xSpacing;
                                d2 = Chart.getDoubleFromObject(arrayList.get(n14 + n));
                                if (d2 > d) {
                                    d = d2;
                                }
                                n9 = n13;
                                n11 = n3 + n5 - (int)(d2 / this._yScale);
                                nArray2[n14] = n9;
                                nArray[n14] = n11;
                            }
                            if (n + n8 > arrayList.size()) {
                                nArray2[arrayList.size() - n] = nArray2[arrayList.size() - n - 1];
                                nArray[arrayList.size() - n] = n3 + n5;
                                nArray2[arrayList.size() - n + 1] = nArray2[0];
                                nArray[arrayList.size() - n + 1] = n3 + n5;
                            } else if (n8 < arrayList.size()) {
                                nArray2[n8] = nArray2[n8 - 1];
                                nArray[n8] = n3 + n5;
                                nArray2[n8 + 1] = nArray2[0];
                                nArray[n8 + 1] = n3 + n5;
                            } else {
                                nArray2[arrayList.size()] = nArray2[arrayList.size() - 1];
                                nArray[arrayList.size()] = n3 + n5;
                                nArray2[arrayList.size() + 1] = nArray2[0];
                                nArray[arrayList.size() + 1] = n3 + n5;
                            }
                        }
                        this._graphics2d.fillPolygon(nArray2, nArray, nArray2.length);
                    } else {
                        n14 = 0;
                        while (n14 + n < arrayList.size()) {
                            n13 = n2 + n4 - n14 * Chart.this._xSpacing;
                            d2 = Chart.getDoubleFromObject(arrayList.get(n14 + n));
                            if (d2 > d) {
                                d = d2;
                            }
                            n9 = n13;
                            n11 = n3 + n5 - (int)(d2 / this._yScale);
                            nArray2[n14] = n9;
                            nArray[n14] = n11;
                            if (n9 < n2 || n9 > n2 + n4) {
                                nArray4 = new int[n14 + 3];
                                nArray3 = new int[n14 + 3];
                                System.arraycopy(nArray2, 0, nArray4, 0, n14 + 1);
                                System.arraycopy(nArray, 0, nArray3, 0, n14 + 1);
                                nArray2 = nArray4;
                                nArray = nArray3;
                                break;
                            }
                            ++n14;
                        }
                        nArray2[nArray2.length - 2] = nArray2[nArray2.length - 3];
                        nArray[nArray.length - 2] = n3 + n5;
                        nArray2[nArray2.length - 1] = nArray2[0];
                        nArray[nArray.length - 1] = n3 + n5;
                    }
                    this._graphics2d.fillPolygon(nArray2, nArray, nArray2.length);
                    continue;
                }
                if (Chart.this._style == 1) {
                    double d3;
                    if (Chart.this._xPoints != null) {
                        if (Chart.this._useXPointsForColumnLabels) {
                            n14 = 0;
                            while (n14 + n < arrayList.size()) {
                                n13 = n2 + n14 * Chart.this._xSpacing;
                                d3 = d2 = Chart.getDoubleFromObject(arrayList.get(n14 + n));
                                if (d2 > d) {
                                    d = d2;
                                }
                                n9 = n13;
                                n11 = n3 + n5 - (int)(d2 / this._yScale);
                                if (Chart.this._xSpacing >= 10 && n9 >= n2 && n9 <= n2 + n4) {
                                    this._graphics2d.fillOval(n9 - 3, n11 - 3, 6, 6);
                                }
                                n10 = n9 = n13;
                                if (n14 > 0) {
                                    d3 = Chart.getDoubleFromObject(arrayList.get(n14 - 1 + n));
                                    n9 = n13 - Chart.this._xSpacing;
                                }
                                n11 = n3 + n5 - (int)(d3 / this._yScale);
                                n12 = n3 + n5 - (int)(d2 / this._yScale);
                                if ((n9 < n2 || n9 > n2 + n4) && (n10 < n2 || n10 > n2 + n4)) continue block0;
                                this._graphics2d.drawLine(n9, n11, n10, n12);
                                ++n14;
                            }
                            continue;
                        }
                        f = (float)((double)Chart.this._xSpacing / this._xLabelIncrement);
                        for (n14 = 0; n14 < arrayList.size(); ++n14) {
                            d2 = Chart.getDoubleFromObject(arrayList.get(n14));
                            if (d2 > d) {
                                d = d2;
                            }
                            n9 = n2;
                            n9 += (int)(Chart.getDoubleFromObject(Chart.this._xPoints.get(n14)) * (double)f);
                            n11 = n3 + n5 - (int)(d2 / this._yScale);
                            if ((n9 -= (int)((double)n * this._xLabelIncrement * (double)f)) >= n2 && n9 <= n2 + n4) {
                                this._graphics2d.fillOval(n9 - 3, n11 - 3, 6, 6);
                            }
                            n9 = n10;
                            n10 = n2;
                            n10 += (int)(Chart.getDoubleFromObject(Chart.this._xPoints.get(n14)) * (double)f);
                            n10 -= (int)((double)n * this._xLabelIncrement * (double)f);
                            n11 = n12;
                            n12 = n3 + n5 - (int)(d2 / this._yScale);
                            if (n14 == 0) {
                                n9 = n10;
                                n11 = n12;
                            }
                            if ((n9 < n2 || n9 > n2 + n4) && (n10 < n2 || n10 > n2 + n4)) continue;
                            this._graphics2d.drawLine(n9, n11, n10, n12);
                        }
                        continue;
                    }
                    for (n14 = 0; n14 < arrayList.size(); ++n14) {
                        n13 = n2 + n4 - n14 * Chart.this._xSpacing;
                        d3 = d2 = Chart.getDoubleFromObject(arrayList.get(n14 + n));
                        if (d2 > d) {
                            d = d2;
                        }
                        n9 = n13;
                        n11 = n3 + n5 - (int)(d2 / this._yScale);
                        if (n9 >= n2 && n9 <= n2 + n4) {
                            this._graphics2d.fillOval(n9 - 3, n11 - 3, 6, 6);
                        }
                        n10 = n9 = n13;
                        if (n14 > 0) {
                            d3 = Chart.getDoubleFromObject(arrayList.get(n14 - 1 + n));
                            n9 = n13 + Chart.this._xSpacing;
                        }
                        n11 = n3 + n5 - (int)(d3 / this._yScale);
                        n12 = n3 + n5 - (int)(d2 / this._yScale);
                        if ((n9 < n2 || n9 > n2 + n4) && (n10 < n2 || n10 > n2 + n4)) continue block0;
                        this._graphics2d.drawLine(n9, n11, n10, n12);
                    }
                    continue;
                }
                if (Chart.this._style == 0) {
                    if (Chart.this._xPoints != null) {
                        if (Chart.this._useXPointsForColumnLabels) {
                            n14 = 0;
                            while (n14 + n < arrayList.size()) {
                                n13 = n2 + n14 * Chart.this._xSpacing;
                                d2 = Chart.getDoubleFromObject(arrayList.get(n14 + n));
                                if (d2 > d) {
                                    d = d2;
                                }
                                n9 = n13;
                                n11 = n3 + n5 - (int)(d2 / this._yScale);
                                if (n9 < n2 || n9 > n2 + n4) continue block0;
                                this._graphics2d.fillOval(n9 - 3, n11 - 3, 6, 6);
                                ++n14;
                            }
                            continue;
                        }
                        f = (float)((double)Chart.this._xSpacing / this._xLabelIncrement);
                        for (n14 = 0; n14 < arrayList.size(); ++n14) {
                            d2 = Chart.getDoubleFromObject(arrayList.get(n14));
                            if (d2 > d) {
                                d = d2;
                            }
                            n9 = n2;
                            n9 += (int)(Chart.getDoubleFromObject(Chart.this._xPoints.get(n14)) * (double)f);
                            n11 = n3 + n5 - (int)(d2 / this._yScale);
                            if ((n9 -= (int)((double)n * this._xLabelIncrement * (double)f)) < n2 || n9 > n2 + n4) continue;
                            this._graphics2d.fillOval(n9 - 3, n11 - 3, 6, 6);
                        }
                        continue;
                    }
                    n14 = 0;
                    while (n14 + n < arrayList.size()) {
                        n13 = n2 + n4 - n14 * Chart.this._xSpacing;
                        d2 = Chart.getDoubleFromObject(arrayList.get(n14 + n));
                        if (d2 > d) {
                            d = d2;
                        }
                        n9 = n13;
                        n11 = n3 + n5 - (int)(d2 / this._yScale);
                        if (n9 < n2 || n9 > n2 + n4) continue block0;
                        this._graphics2d.fillOval(n9 - 3, n11 - 3, 6, 6);
                        ++n14;
                    }
                    continue;
                }
                if (Chart.this._style != 3) continue;
                if (Chart.this._yPoints.size() > 0) {
                    n6 = Chart.this._xSpacing / Chart.this._yPoints.size();
                }
                if (Chart.this._xPoints != null) {
                    if (Chart.this._useXPointsForColumnLabels) {
                        n14 = 0;
                        while (n14 + n < arrayList.size()) {
                            n13 = n2 + n14 * Chart.this._xSpacing;
                            d2 = Chart.getDoubleFromObject(arrayList.get(n14 + n));
                            if (d2 > d) {
                                d = d2;
                            }
                            n9 = n13 + n6 * (n7 - 1);
                            n11 = n3 + n5 - (int)(d2 / this._yScale);
                            if (n9 < n2 || n9 > n2 + n4) continue block0;
                            this._graphics2d.fillRect(n9, n11, n6, n3 + n5 - n11);
                            ++n14;
                        }
                        continue;
                    }
                    f = (float)((double)Chart.this._xSpacing / this._xLabelIncrement);
                    for (n14 = 0; n14 < arrayList.size(); ++n14) {
                        d2 = Chart.getDoubleFromObject(arrayList.get(n14));
                        if (d2 > d) {
                            d = d2;
                        }
                        n9 = n2 + n6 * (n7 - 1);
                        n9 += (int)(Chart.getDoubleFromObject(Chart.this._xPoints.get(n14)) * (double)f);
                        n11 = n3 + n5 - (int)(d2 / this._yScale);
                        if ((n9 -= (int)((double)n * this._xLabelIncrement * (double)f)) < n2 || n9 > n2 + n4) continue;
                        this._graphics2d.fillRect(n9, n11, n6, n3 + n5 - n11);
                    }
                    continue;
                }
                n14 = 0;
                while (n14 + n < arrayList.size()) {
                    n13 = n2 + n4 - n14 * Chart.this._xSpacing;
                    d2 = Chart.getDoubleFromObject(arrayList.get(n14 + n));
                    if (d2 > d) {
                        d = d2;
                    }
                    n9 = n13 - n6 * n7;
                    n11 = n3 + n5 - (int)(d2 / this._yScale);
                    if (n9 < n2 || n9 > n2 + n4) continue block0;
                    this._graphics2d.fillRect(n9, n11, n6, n3 + n5 - n11);
                    ++n14;
                }
            }
            return d;
        }

        private void drawRow(int n, int n2, int n3, int n4, int n5, double d, double d2) {
            int n6 = n4 + n5 / 2;
            int n7 = n < this._depthLimit ? 10 : 5;
            this._graphics2d.setColor(Chart.this._gridColor);
            if (!Chart.this._drawLines) {
                this._chartLine.setLine(n2 - n7, n6, n2, n6);
                this._graphics2d.draw(this._chartLine);
                this._chartLine.setLine(n2 + n3, n6, n2 + n3 + n7, n6);
                this._graphics2d.draw(this._chartLine);
            } else {
                this._chartLine.setLine(n2 - n7, n6, n2 + n3 + n7, n6);
                this._graphics2d.draw(this._chartLine);
            }
            double d3 = (d - d2) / 2.0 + d2;
            if (n < this._depthLimit) {
                this._graphics2d.setColor(Chart.this._labelColor);
                String string = String.valueOf(FORMATTER.format(d3));
                this._graphics2d.drawString(string, this._xMarginSize - 15 - this._fm.stringWidth(string), n6 + this._ascent / 2);
                this._graphics2d.drawString(string, n3 + this._xMarginSize + 15, n6 + this._ascent / 2);
                ++n;
            }
            if (n4 + Chart.this._ySpacing < n4 + n5) {
                this.drawRow(n, n2, n3, n4, n5 / 2, d, d3);
                this.drawRow(n, n2, n3, n4 + n5 / 2, n5 / 2, d3, d2);
            }
        }
    }
}

