/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util;

import com.sybase.util.HypertextButton;
import com.sybase.util.UIUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.event.EventListenerList;

public class CollapsiblePanel
extends JPanel
implements ActionListener {
    private String _title;
    private String _titleToolTip;
    private TitleButton _titleButton;
    private JPanel _titlePanel;
    private JPanel _listPanel;
    private Dimension _expandedSize;
    private boolean _expanded = true;
    private EventListenerList _listenerList = new EventListenerList();
    private static ImageIcon COLLAPSE_IMAGE = null;
    private static ImageIcon EXPAND_IMAGE = null;
    private static Insets EMPTY_INSETS = new Insets(0, 0, 0, 0);
    public static final String ACTION_EXPAND_COMMAND = "expand";
    public static final String ACTION_COLLAPSE_COMMAND = "collapse";

    public CollapsiblePanel(String string, String string2) {
        GridBagLayout gridBagLayout = new GridBagLayout();
        Font font = null;
        if (COLLAPSE_IMAGE == null) {
            COLLAPSE_IMAGE = UIUtils.getExplorerBarGroupCollapseButton();
        }
        if (EXPAND_IMAGE == null) {
            EXPAND_IMAGE = UIUtils.getExplorerBarGroupExpandButton();
        }
        this._title = string;
        this._titleToolTip = string2;
        this.setLayout(gridBagLayout);
        this.setOpaque(false);
        this._titlePanel = UIUtils.createExplorerBarHeader();
        this._titlePanel.setLayout(new GridBagLayout());
        Color color = UIUtils.getExplorerBarHeaderTextColor();
        this._titleButton = new TitleButton(this._title, this._titleToolTip, color);
        font = UIManager.getDefaults().getFont("InternalFrame.titleFont");
        if (font != null) {
            this._titleButton.setFont(font);
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 17, 2, EMPTY_INSETS, 0, 0);
        super.add((Component)this._titlePanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 21, 2, EMPTY_INSETS, 0, 0);
        this._titlePanel.add((Component)this._titleButton, gridBagConstraints);
        this._listPanel = UIUtils.createExplorerBarGroup();
        this._listPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints(0, 500, 0, 0, 1.0, 1.0, 18, 0, EMPTY_INSETS, 0, 0);
        this._listPanel.add(Box.createGlue(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 1, 0, 0, 1.0, 0.0, 17, 2, EMPTY_INSETS, 0, 0);
        super.add((Component)this._listPanel, gridBagConstraints);
        this._titleButton.addActionListener(this);
    }

    public void add(JComponent jComponent) {
        GridBagConstraints gridBagConstraints = null;
        gridBagConstraints = new GridBagConstraints(0, this._listPanel.getComponentCount() - 1, 0, 1, 1.0, 0.0, 17, 2, EMPTY_INSETS, 0, 0);
        this._listPanel.add((Component)jComponent, gridBagConstraints);
        this._expandedSize = this.getPreferredSize();
        this._titlePanel.setPreferredSize(new Dimension(this._expandedSize.width, this._titlePanel.getPreferredSize().height));
    }

    public void remove(JComponent jComponent) {
        this._listPanel.remove(jComponent);
        this._expandedSize = this.getPreferredSize();
    }

    public void setTitleBackground(Color color) {
        if (this._titlePanel != null) {
            this._titlePanel.setBackground(color);
            this._titleButton.setBackground(color);
        }
    }

    public Color getTitleBackground() {
        return this._titlePanel.getBackground();
    }

    @Override
    public void setBackground(Color color) {
        if (this._listPanel != null) {
            this._listPanel.setBackground(color);
        }
    }

    public void releaseResources() {
        this._titleButton.removeActionListener(this);
        this._title = null;
        this._titleToolTip = null;
        this._listPanel = null;
        this._titlePanel = null;
        this._titleButton = null;
        this._expandedSize = null;
        this._listenerList = null;
    }

    public String getTitle() {
        return this._title;
    }

    public void setTitle(String string) {
        this._title = string;
    }

    public String getTitleToolTip() {
        return this._titleToolTip;
    }

    public void setTitleToolTip(String string) {
        this._titleToolTip = string;
        this._titleButton.setToolTipText(string);
    }

    public void setExpanded(boolean bl) {
        if (this._expanded != bl) {
            this._expanded = bl;
            this._listPanel.setVisible(this._expanded);
            this.repaint();
        }
    }

    public boolean isExpanded() {
        return this._expanded;
    }

    public void addActionListener(ActionListener actionListener) {
        this._listenerList.add(ActionListener.class, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this._listenerList.remove(ActionListener.class, actionListener);
    }

    protected void fireActionPerformed(ActionEvent actionEvent) {
        ActionEvent actionEvent2 = null;
        Object[] objectArray = this._listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ActionListener.class) continue;
            if (actionEvent2 == null) {
                String string = actionEvent.getActionCommand();
                if (string == null) {
                    string = this.isExpanded() ? ACTION_EXPAND_COMMAND : ACTION_COLLAPSE_COMMAND;
                }
                actionEvent2 = new ActionEvent(this, 1001, string, actionEvent.getWhen(), actionEvent.getModifiers());
            }
            ((ActionListener)objectArray[i + 1]).actionPerformed(actionEvent2);
        }
    }

    private void expandAndCollapsePressed() {
        this._expanded = !this._expanded;
        this._listPanel.setVisible(this._expanded);
        this.repaint();
        this.fireActionPerformed(new ActionEvent(this, 0, null));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._titleButton) {
            this.expandAndCollapsePressed();
        }
    }

    class TitleButton
    extends HypertextButton {
        TitleButton(String string, String string2, Color color) {
            super(string, string2, null, 10, false, color);
        }

        @Override
        public void paint(Graphics graphics) {
            Dimension dimension = this.getSize();
            int n = dimension.width - EXPAND_IMAGE.getIconWidth();
            int n2 = (dimension.height - EXPAND_IMAGE.getIconHeight()) / 2;
            super.paint(graphics);
            if (CollapsiblePanel.this.isExpanded()) {
                COLLAPSE_IMAGE.paintIcon(this, graphics, n, n2);
            } else {
                EXPAND_IMAGE.paintIcon(this, graphics, n, n2);
            }
        }
    }
}

