/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util;

import com.sybase.util.CommandLineResourcesBase;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Stack;

class CommandFileReader
extends BufferedReader {
    private String _filename;
    private int _lineNumber = 0;
    private String _toolName;
    private Stack<Block> _stack = new Stack();

    CommandFileReader(String string, String string2, byte[] byArray) {
        super(new InputStreamReader(new ByteArrayInputStream(byArray)));
        this._filename = string;
        this._toolName = string2;
    }

    @Override
    public String readLine() throws IOException {
        String string;
        while ((string = super.readLine()) != null) {
            State state;
            Block block;
            ++this._lineNumber;
            if ((string = string.trim()).length() <= 0) continue;
            if (string.charAt(0) == '#') {
                String[] stringArray = string.split("\\s");
                if (stringArray[0].equalsIgnoreCase("#if")) {
                    if (stringArray.length != 2) {
                        this.throwException("M7", new Object[0]);
                    }
                    if (!this._stack.empty()) {
                        block = this._stack.peek();
                        state = block.getState();
                    } else {
                        state = State.IN_MAIN_CLAUSE;
                    }
                    Block block2 = new Block();
                    this._stack.add(block2);
                    if (state == State.IN_MAIN_CLAUSE) {
                        if (this.conditionPasses(stringArray[1])) {
                            block2.setState(State.IN_MAIN_CLAUSE);
                            continue;
                        }
                        block2.setState(State.AWAITING_ELSE_CLAUSE);
                        continue;
                    }
                    block2.setState(State.SKIPPING_TO_END);
                    continue;
                }
                if (stringArray[0].equalsIgnoreCase("#elif")) {
                    if (this._stack.empty()) {
                        this.throwException("M8", new Object[0]);
                    }
                    if (stringArray.length != 2) {
                        this.throwException("M7", new Object[0]);
                    }
                    if ((state = (block = this._stack.peek()).getState()) == State.IN_MAIN_CLAUSE) {
                        block.setState(State.SKIPPING_TO_END);
                        continue;
                    }
                    if (state != State.AWAITING_ELSE_CLAUSE) continue;
                    if (this.conditionPasses(stringArray[1])) {
                        block.setState(State.IN_MAIN_CLAUSE);
                        continue;
                    }
                    block.setState(State.AWAITING_ELSE_CLAUSE);
                    continue;
                }
                if (stringArray[0].equalsIgnoreCase("#else")) {
                    if (this._stack.empty()) {
                        this.throwException("M9", new Object[0]);
                    }
                    if ((state = (block = this._stack.peek()).getState()) == State.SKIPPING_TO_END) continue;
                    if (state == State.IN_MAIN_CLAUSE) {
                        block.setState(State.SKIPPING_TO_END);
                        continue;
                    }
                    block.setState(State.IN_MAIN_CLAUSE);
                    continue;
                }
                if (!stringArray[0].equalsIgnoreCase("#endif")) continue;
                if (this._stack.empty()) {
                    this.throwException("M10", new Object[0]);
                }
                this._stack.pop();
                continue;
            }
            if (!this._stack.empty() && ((state = (block = this._stack.peek()).getState()) == State.SKIPPING_TO_END || state == State.AWAITING_ELSE_CLAUSE)) continue;
        }
        return string;
    }

    private boolean conditionPasses(String string) {
        int n;
        boolean bl = string.equalsIgnoreCase(this._toolName);
        if (!bl && (n = string.indexOf(61)) != -1) {
            String string2 = string.substring(0, n);
            if (string2.equalsIgnoreCase("tool")) {
                String[] stringArray = string.substring(n + 1).split(",");
                for (int i = 0; i < stringArray.length && !(bl = stringArray[i].equalsIgnoreCase(this._toolName)); ++i) {
                }
            } else {
                this.throwException("M11", string2);
            }
        }
        return bl;
    }

    private void throwException(String string, Object ... objectArray) {
        CommandLineResourcesBase commandLineResourcesBase = CommandLineResourcesBase.getBundle();
        string = commandLineResourcesBase.get(string, objectArray);
        String string2 = commandLineResourcesBase.get("M12", this._filename, Integer.toString(this._lineNumber), string);
        throw new IllegalArgumentException(string2);
    }

    private static boolean dbgEnabled() {
        return false;
    }

    static class Block {
        State _state;

        Block() {
        }

        void setState(State state) {
            this._state = state;
        }

        State getState() {
            return this._state;
        }
    }

    static enum State {
        IN_MAIN_CLAUSE,
        AWAITING_ELSE_CLAUSE,
        SKIPPING_TO_END;

    }
}

