/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util;

import com.sybase.util.BatchSCC;
import com.sybase.util.DialogUtils;
import com.sybase.util.Profile;
import com.sybase.util.SCCResourcesBase;
import com.sybase.util.SCCTemplatesDialog;
import com.sybase.util.SybButton;
import com.sybase.util.SybFileChooser;
import com.sybase.util.SybFileFilter;
import com.sybase.util.SybLabel;
import com.sybase.util.SybModalDialog;
import com.sybase.util.SybOptionPane;
import com.sybase.util.SybTextArea;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class ConfigurationDialog
extends SybModalDialog
implements ActionListener,
DocumentListener,
ListSelectionListener {
    private static File _initialBrowsingFolder = null;
    private BatchSCC _scc = null;
    private int _applicationSupportedVerbs;
    private JList _verbList = null;
    private SybTextArea _commandLine = null;
    private SybButton _import = null;
    private SybButton _export = null;
    private SybButton _reset = null;
    private SybButton _ok = null;
    private SybButton _cancel = null;
    static final Font BOLD_LABEL_FONT = UIManager.getDefaults().getFont("InternalFrame.titleFont");
    static final Font LABEL_FONT = UIManager.getDefaults().getFont("Label.font");
    private static final String ESCAPE_KEY_COMMAND = "EscapeKey";
    private static final String ENTER_KEY_COMMAND = "EnterKey";

    ConfigurationDialog(Frame frame, BatchSCC batchSCC, int[] nArray) {
        super(frame);
        this.init(frame, batchSCC, nArray);
    }

    ConfigurationDialog(Dialog dialog, BatchSCC batchSCC, int[] nArray) {
        super(dialog);
        this.init(dialog, batchSCC, nArray);
    }

    private void init(Window window, BatchSCC batchSCC, int[] nArray) {
        Object[] objectArray;
        this._scc = batchSCC;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        if (nArray == null) {
            objectArray = new Object[]{new Verb(0, "CMD0"), new Verb(1, "CMD1"), new Verb(2, "CMD2"), new Verb(3, "CMD3"), new Verb(4, "CMD4"), new Verb(5, "CMD5"), new Verb(6, "CMD6"), new Verb(7, "CMD7"), new Verb(8, "CMD8"), new Verb(9, "CMD9"), new Verb(10, "CMD10")};
        } else {
            ArrayList<Verb> arrayList = new ArrayList<Verb>();
            block13: for (int i = 0; i < nArray.length; ++i) {
                switch (nArray[i]) {
                    case 0: {
                        arrayList.add(new Verb(0, "CMD0"));
                        continue block13;
                    }
                    case 1: {
                        arrayList.add(new Verb(1, "CMD1"));
                        continue block13;
                    }
                    case 2: {
                        arrayList.add(new Verb(2, "CMD2"));
                        continue block13;
                    }
                    case 3: {
                        arrayList.add(new Verb(3, "CMD3"));
                        continue block13;
                    }
                    case 4: {
                        arrayList.add(new Verb(4, "CMD4"));
                        continue block13;
                    }
                    case 5: {
                        arrayList.add(new Verb(5, "CMD5"));
                        continue block13;
                    }
                    case 6: {
                        arrayList.add(new Verb(6, "CMD6"));
                        continue block13;
                    }
                    case 7: {
                        arrayList.add(new Verb(7, "CMD7"));
                        continue block13;
                    }
                    case 8: {
                        arrayList.add(new Verb(8, "CMD8"));
                        continue block13;
                    }
                    case 9: {
                        arrayList.add(new Verb(9, "CMD9"));
                        continue block13;
                    }
                    case 10: {
                        arrayList.add(new Verb(10, "CMD10"));
                        continue block13;
                    }
                }
            }
            objectArray = new Object[arrayList.size()];
            arrayList.toArray(objectArray);
        }
        Arrays.sort(objectArray);
        this._verbList = new JList<Object>(objectArray);
        this._verbList.setCellRenderer(new VerbRenderer());
        JScrollPane jScrollPane = new JScrollPane(this._verbList);
        gridBagConstraints.anchor = 19;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        SybLabel sybLabel = new SybLabel(SCCResourcesBase.getMessage("BSCC02", new Object[0]));
        gridBagConstraints.anchor = 19;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 10);
        jPanel.add((Component)sybLabel, gridBagConstraints);
        sybLabel.setLabelFor(this._verbList);
        this._commandLine = new SybTextArea();
        this._commandLine.setTabMovesFocus(true);
        this._commandLine.setLineWrap(true);
        this._commandLine.setWrapStyleWord(true);
        gridBagConstraints.anchor = 19;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)new JScrollPane(this._commandLine), gridBagConstraints);
        sybLabel = new SybLabel(SCCResourcesBase.getMessage("BSCC03", new Object[0]));
        gridBagConstraints.anchor = 19;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        jPanel.add((Component)sybLabel, gridBagConstraints);
        sybLabel.setLabelFor(this._commandLine);
        this._import = new SybButton(SCCResourcesBase.getMessage("BSCC04", new Object[0]));
        this._export = new SybButton(SCCResourcesBase.getMessage("BSCC05", new Object[0]));
        this._reset = new SybButton(SCCResourcesBase.getMessage("BSCC06", new Object[0]));
        this._ok = new SybButton(SCCResourcesBase.getMessage("BSCC07", new Object[0]));
        this._cancel = new SybButton(SCCResourcesBase.getMessage("BSCC08", new Object[0]));
        DialogUtils.makeComponentsSameWidth(this._ok, this._cancel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.add(this._import);
        jPanel2.add(Box.createHorizontalStrut(5));
        jPanel2.add(this._export);
        jPanel2.add(Box.createHorizontalStrut(5));
        jPanel2.add(this._reset);
        jPanel2.add(Box.createHorizontalStrut(5));
        jPanel2.add(this._ok);
        jPanel2.add(Box.createHorizontalStrut(5));
        jPanel2.add(this._cancel);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel3.add((Component)jPanel, "Center");
        jPanel3.add((Component)jPanel2, "South");
        this.getRootPane().getContentPane().add(jPanel3);
        this.getRootPane().setDefaultButton(this._ok);
        this.getRootPane().registerKeyboardAction(this, ESCAPE_KEY_COMMAND, KeyStroke.getKeyStroke(27, 0, false), 1);
        this._commandLine.registerKeyboardAction(this, ENTER_KEY_COMMAND, KeyStroke.getKeyStroke(10, 0, false), 0);
        this.setTitle(SCCResourcesBase.getMessage("BSCC01", new Object[0]));
        this.pack();
        if (window != null) {
            this.setLocationRelativeTo(window);
        }
        this._verbList.addListSelectionListener(this);
        this._commandLine.getDocument().addDocumentListener(this);
        this._ok.addActionListener(this);
        this._cancel.addActionListener(this);
        this._import.addActionListener(this);
        this._export.addActionListener(this);
        this._reset.addActionListener(this);
        this._verbList.requestFocusInWindow();
        this._verbList.setSelectedIndex(0);
    }

    void destroy() {
        this._scc = null;
        this.getRootPane().setDefaultButton(null);
        this.getRootPane().unregisterKeyboardAction(KeyStroke.getKeyStroke(27, 0, false));
        this._commandLine.unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0, false));
        this._verbList.removeListSelectionListener(this);
        this._ok.removeActionListener(this);
        this._cancel.removeActionListener(this);
        this._import.removeActionListener(this);
        this._export.removeActionListener(this);
        this._reset.removeActionListener(this);
        this._verbList = null;
        this._commandLine = null;
        this._import = null;
        this._export = null;
        this._reset = null;
        this._ok = null;
        this._cancel = null;
        DialogUtils.removeComponents(this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._ok) {
            this.handleOK();
        } else if (object == this._cancel) {
            this.handleCancel();
        } else if (object == this._import) {
            this.handleImport();
        } else if (object == this._export) {
            this.handleExport();
        } else if (object == this._reset) {
            this.handleReset();
        } else {
            String string = actionEvent.getActionCommand();
            if (string != null) {
                if (string.equals(ESCAPE_KEY_COMMAND)) {
                    this.handleCancel();
                } else if (string.equals(ENTER_KEY_COMMAND)) {
                    this.handleOK();
                }
            }
        }
    }

    private void handleReset() {
        SCCTemplatesDialog sCCTemplatesDialog = new SCCTemplatesDialog(this);
        sCCTemplatesDialog.setVisible(true);
        String string = sCCTemplatesDialog.getProfileFile();
        sCCTemplatesDialog.destroy();
        if (string != null) {
            try {
                Profile profile = new Profile();
                profile.open(string);
                this.loadCommandLinesFromProfile(profile);
                profile.close();
                this._verbList.repaint();
                this.updateCommandLineField();
                this._verbList.requestFocusInWindow();
            }
            catch (IOException iOException) {
                SybOptionPane.showMessageDialog(BatchSCC.getParentFrame(), SCCResourcesBase.getMessage("M4", iOException.getLocalizedMessage()), SCCResourcesBase.getMessage("M1", new Object[0]), 0);
            }
        }
    }

    private void handleImport() {
        this.enableButtons(false);
        String string = SCCResourcesBase.getMessage("BSCC11", new Object[0]);
        SybFileChooser sybFileChooser = new SybFileChooser(17);
        sybFileChooser.setTitle(string);
        sybFileChooser.setDefaultExtension("cfg");
        sybFileChooser.setFilters(new SybFileFilter[]{new SybFileFilter("cfg", SCCResourcesBase.getMessage("BSCC10", new Object[0]))}, 0);
        if (sybFileChooser.showDialog(this, _initialBrowsingFolder, null)) {
            File file = sybFileChooser.getSelectedFile();
            try {
                Profile profile = new Profile();
                profile.open(file.getAbsolutePath());
                this.loadCommandLinesFromProfile(profile);
                profile.close();
                this._verbList.repaint();
                this.updateCommandLineField();
                this._verbList.requestFocusInWindow();
                _initialBrowsingFolder = file.getParentFile();
            }
            catch (IOException iOException) {
                SybOptionPane.showMessageDialog(this, SCCResourcesBase.getMessage("BSCC13", iOException.getLocalizedMessage()), string, 0);
            }
        }
        this.enableButtons(true);
    }

    private void loadCommandLinesFromProfile(Profile profile) {
        ListModel listModel = this._verbList.getModel();
        int n = listModel.getSize();
        for (int i = 0; i < n; ++i) {
            Verb verb = (Verb)listModel.getElementAt(i);
            int n2 = verb.getID();
            verb.setCommandLine(this._scc.getCommandLine(profile, n2));
        }
    }

    private void handleExport() {
        this.enableButtons(false);
        String string = SCCResourcesBase.getMessage("BSCC09", new Object[0]);
        SybFileChooser sybFileChooser = new SybFileChooser(18);
        sybFileChooser.setTitle(string);
        sybFileChooser.setDefaultExtension("cfg");
        sybFileChooser.setFilters(new SybFileFilter[]{new SybFileFilter("cfg", SCCResourcesBase.getMessage("BSCC10", new Object[0]))}, 0);
        if (sybFileChooser.showDialog(this, _initialBrowsingFolder, null)) {
            File file = sybFileChooser.getSelectedFile();
            try {
                this.saveCommandLinesToSCC(true);
                this._scc.export(file.getAbsolutePath());
                this.saveCommandLinesToSCC(false);
                _initialBrowsingFolder = file.getParentFile();
            }
            catch (IOException iOException) {
                SybOptionPane.showMessageDialog(this, SCCResourcesBase.getMessage("BSCC12", iOException.getLocalizedMessage()), string, 0);
            }
        }
        this.enableButtons(true);
    }

    private void handleCancel() {
        this.setVisible(false);
    }

    private void enableButtons(boolean bl) {
        this._ok.setEnabled(bl);
        this._cancel.setEnabled(bl);
        this._reset.setEnabled(bl);
        this._import.setEnabled(bl);
        this._export.setEnabled(bl);
    }

    private void saveCommandLinesToSCC(boolean bl) {
        ListModel listModel = this._verbList.getModel();
        int n = listModel.getSize();
        for (int i = 0; i < n; ++i) {
            Verb verb = (Verb)listModel.getElementAt(i);
            String string = bl ? verb.getCommandLine() : verb.getOriginalCommandLine();
            int n2 = verb.getID();
            this._scc.setCommandLine(n2, string);
        }
        try {
            this._scc.save();
        }
        catch (IOException iOException) {
            SybOptionPane.showMessageDialog(BatchSCC.getParentFrame(), SCCResourcesBase.getMessage("M5", iOException.getLocalizedMessage()), SCCResourcesBase.getMessage("M1", new Object[0]), 0);
        }
    }

    private void handleOK() {
        this.enableButtons(false);
        this.saveCommandLinesToSCC(true);
        this.setVisible(false);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            this.updateCommandLineField();
        }
    }

    private void updateCommandLineField() {
        Object e = this._verbList.getSelectedValue();
        if (e != null) {
            Verb verb = (Verb)e;
            String string = verb.getCommandLine();
            this._commandLine.setText(string);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.saveCommandLine();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.saveCommandLine();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.saveCommandLine();
    }

    private void saveCommandLine() {
        String string = this._commandLine.getText();
        Verb verb = (Verb)this._verbList.getSelectedValue();
        if (verb != null) {
            int n;
            Rectangle rectangle;
            String string2 = verb.getCommandLine();
            boolean bl = string2 == null || string2.length() != string.length();
            verb.setCommandLine(string);
            if (bl && (rectangle = this._verbList.getCellBounds(n = this._verbList.getSelectedIndex(), n)) != null) {
                this._verbList.repaint(rectangle);
            }
        }
    }

    static class Verb
    implements Comparable {
        private static Collator _collator = null;
        int _sccCommandID;
        String _name;
        String _originalCommandLine;
        String _commandLine;

        Verb(int n, String string) {
            this._sccCommandID = n;
            this._name = SCCResourcesBase.getMessage(string, new Object[0]);
            _collator = Collator.getInstance();
            BatchSCC batchSCC = (BatchSCC)BatchSCC.getSourceControl();
            this._commandLine = this._originalCommandLine = batchSCC.getCommandLine(n);
        }

        int getID() {
            return this._sccCommandID;
        }

        String getCommandLine() {
            return this._commandLine;
        }

        String getOriginalCommandLine() {
            return this._originalCommandLine;
        }

        void setCommandLine(String string) {
            this._commandLine = string;
        }

        public String toString() {
            return this._name;
        }

        public int compareTo(Object object) {
            return _collator.compare(this._name, ((Verb)object)._name);
        }
    }

    static class VerbRenderer
    extends DefaultListCellRenderer {
        VerbRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            Verb verb = (Verb)object;
            String string = verb.getCommandLine();
            if (string == null || string.length() == 0) {
                if (LABEL_FONT != null) {
                    this.setFont(LABEL_FONT);
                }
            } else if (BOLD_LABEL_FONT != null) {
                this.setFont(BOLD_LABEL_FONT);
            }
            return component;
        }
    }
}

