/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util;

import com.sybase.util.Platform;
import com.sybase.util.SybDropDownButton;
import com.sybase.util.UIUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.SystemColor;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.basic.BasicButtonUI;

class DDBUI
extends BasicButtonUI {
    static final int SEPARATOR_WIDTH = 1;
    static final int BORDER_WIDTH = 3;
    static final int ARROW_WIDTH = 7;
    static final int ARROW_HEIGHT = 4;
    static final int DROP_DOWN_BUTTON_WIDTH = 14;
    private ButtonUI _encapsulatedUI;
    private SybDropDownButton _button;
    private boolean _isMotifLAF;

    DDBUI(ButtonUI buttonUI, SybDropDownButton sybDropDownButton) {
        this._encapsulatedUI = buttonUI;
        this._button = sybDropDownButton;
        String string = System.getProperty("swing.defaultlaf");
        if (string == null) {
            string = UIManager.getSystemLookAndFeelClassName();
        }
        this._isMotifLAF = string.indexOf("MotifLookAndFeel") != -1;
        this._button.setRolloverEnabled(true);
        this._button.setMinimumSize(null);
        this._button.setPreferredSize(null);
    }

    @Override
    public Dimension getMaximumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    @Override
    public Dimension getMinimumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        Dimension dimension = this._encapsulatedUI.getPreferredSize(jComponent);
        dimension.width = this._isMotifLAF ? (dimension.width += 28) : (dimension.width += 14);
        return dimension;
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        this._encapsulatedUI.update(graphics, jComponent);
        DDBUI.static_paint(graphics, jComponent);
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        this._encapsulatedUI.paint(graphics, jComponent);
        DDBUI.static_paint(graphics, jComponent);
    }

    static void static_paint(Graphics graphics, JComponent jComponent) {
        Color color;
        int n;
        int n2;
        Insets insets = ((AbstractButton)jComponent).getMargin();
        Insets insets2 = ((AbstractButton)jComponent).getInsets();
        int n3 = Platform.isMacOS() ? jComponent.getInsets().right - 2 : jComponent.getInsets().right - insets.right;
        int n4 = jComponent.getWidth() - n3 - 14;
        if (UIUtils.isWindowsLAF()) {
            n2 = insets.top;
            n = jComponent.getHeight() - insets.top - insets.bottom;
        } else if (Platform.isMacOS()) {
            int n5 = 2;
            n2 = insets2.top + n5;
            n = jComponent.getHeight() - 2 * n5 - insets2.bottom - insets2.top;
        } else {
            n2 = insets2.top;
            n = jComponent.getHeight() - insets2.bottom - insets2.top;
        }
        ButtonModel buttonModel = ((AbstractButton)jComponent).getModel();
        if (!((AbstractButton)jComponent).isRolloverEnabled() || buttonModel.isRollover()) {
            color = SystemColor.controlShadow;
            graphics.setColor(color);
            graphics.fillRect(n4, n2, 1, n);
        }
        ++n4;
        n4 += 3;
        if (buttonModel.isEnabled()) {
            color = jComponent.getForeground();
        } else {
            color = UIManager.getColor("Button.disabledForeground");
            if (color == null) {
                color = SystemColor.textInactiveText;
            }
        }
        graphics.setColor(color);
        int[] nArray = new int[3];
        int[] nArray2 = new int[3];
        nArray[0] = n4;
        nArray[1] = n4 + 7;
        nArray[2] = n4 + 3;
        nArray2[0] = (n - 4) / 2 + n2;
        nArray2[1] = nArray2[0];
        nArray2[2] = nArray2[0] + 4;
        graphics.fillPolygon(nArray, nArray2, 3);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this._encapsulatedUI.uninstallUI(jComponent);
        this._encapsulatedUI = null;
        this._button = null;
    }
}

