/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util;

import com.sybase.util.DLLLoaderResourcesBase;
import com.sybase.util.Platform;
import com.sybase.util.SybOptionPane;
import com.sybase.util.UIUtils;
import java.io.File;
import java.util.StringTokenizer;

public class DLLLoader {
    private static boolean _installed = false;
    private static String _baseLibraryName = "jsyblib600";
    private static final String JSYBLIB_DLL_LOCATION = "sybase.jsyblib.dll.location";

    private static void loadSyblibNativeLibrary() {
        StringBuilder stringBuilder;
        String string = System.mapLibraryName(_baseLibraryName);
        String string2 = System.getProperty(JSYBLIB_DLL_LOCATION);
        if (string2 != null && !string2.isEmpty()) {
            stringBuilder = new StringBuilder(string2);
            if (!string2.endsWith(File.separator)) {
                stringBuilder.append(File.separator);
            }
            stringBuilder.append(string);
            try {
                System.load(stringBuilder.toString());
                _installed = true;
                return;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        String string3 = System.getProperty("java.library.path");
        stringBuilder = new StringBuilder();
        StringTokenizer stringTokenizer = new StringTokenizer(string3, File.pathSeparator);
        while (stringTokenizer.hasMoreElements()) {
            stringBuilder.setLength(0);
            stringBuilder.append(stringTokenizer.nextElement().toString());
            stringBuilder.append(File.separator);
            stringBuilder.append(string);
            try {
                System.load(stringBuilder.toString());
                _installed = true;
                return;
            }
            catch (Throwable throwable) {
            }
        }
        _installed = false;
        SybOptionPane.showMessageDialog(null, DLLLoaderResourcesBase.getBundle().getFormatted("CANNOT_FIND_DLL", System.mapLibraryName(_baseLibraryName), string3.replace(File.pathSeparator, File.pathSeparator + "\n")), DLLLoaderResourcesBase.getBundle().get("CANNOT_FIND_DLL_TITLE"), 0);
    }

    public static void loadLibrary(String string, String string2) throws Throwable {
        String string3 = null;
        StringBuffer stringBuffer = null;
        File file = null;
        StringBuffer stringBuffer2 = null;
        try {
            System.loadLibrary(string);
        }
        catch (Throwable throwable) {
            if (string2 != null) {
                string3 = System.getProperties().getProperty(string2);
                if (string3 != null) {
                    stringBuffer = new StringBuffer(string3);
                    if (!string3.endsWith(File.separator)) {
                        stringBuffer.append(File.separator);
                    }
                    stringBuffer2 = new StringBuffer();
                    if (Platform.isWindows()) {
                        stringBuffer2.append(string).append(".dll");
                    } else if (Platform.isMacOS()) {
                        stringBuffer2.append("lib").append(string).append(".jnilib");
                    } else {
                        stringBuffer2.append("lib").append(string).append(".so");
                    }
                    stringBuffer.append(stringBuffer2);
                    file = new File(stringBuffer.toString());
                    if (file.exists() && file.isFile()) {
                        System.load(stringBuffer.toString());
                    }
                    throw throwable;
                }
                throw throwable;
            }
            throw throwable;
        }
    }

    public static boolean isInstalled() {
        return _installed;
    }

    private static boolean dbgEnabled() {
        return false;
    }

    static {
        if (Platform.isHP()) {
            UIUtils.installLookAndFeel();
        }
        if (!Platform.isWindows()) {
            _baseLibraryName = _baseLibraryName + "_r";
        }
        DLLLoader.loadSyblibNativeLibrary();
    }
}

