/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util;

import com.sybase.util.DbgEnable;
import com.sybase.util.STDIORedirector;
import com.sybase.util.StackFrame;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;

public class Dbg
implements DbgEnable {
    public static final String PRINTLN_TIMESTAMP = "+Timestamp";
    public static final String PRINTLN_NO_TIMESTAMP = "-Timestamp";
    public static final String PRINTLN_PACKAGE = "+Package";
    public static final String PRINTLN_NO_PACKAGE = "-Package";
    public static final String PRINTLN_CLASS = "+Class";
    public static final String PRINTLN_NO_CLASS = "-Class";
    public static final String PRINTLN_FUNCTION = "+Function";
    public static final String PRINTLN_NO_FUNCTION = "-Function";
    public static final String PRINTLN_FILE = "+File";
    public static final String PRINTLN_NO_FILE = "-File";
    public static final String PRINTLN_FORMATTED = "+Formatted";
    public static final String PRINTLN_NOT_FORMATTED = "-Formatted";
    public static final String PRINTLN_SILENT = "+Silent";
    public static final String PRINTLN_THREAD = "+Thread";
    public static final String PRINTLN_NO_THREAD = "-Thread";
    protected static boolean _printTimestamp = false;
    protected static boolean _printPackage = false;
    protected static boolean _printClass = true;
    protected static boolean _printFunction = true;
    protected static boolean _printFile = true;
    protected static boolean _printThread = false;
    protected static boolean _printFormatted = true;
    protected static boolean _suppressPrintlnExOutput = false;
    protected static boolean _printlnExFlagsSet = false;
    private static String[] _kinds;
    private static boolean[] _enabled;
    private static ArrayList<String> _messageTypes;
    static int _brkCount;
    private static StringBuffer _buffer;

    public static void enableSTDIOWindow() {
        String string = System.getProperty("com.sybase.util.Dbg.noconsole");
        if (string == null || string.equals("0")) {
            STDIORedirector.initialize();
        }
    }

    protected Dbg() {
    }

    public static void wassert(boolean bl) {
    }

    public static void wassert(boolean bl, String string) {
    }

    public static void brkOn(int n) {
        if (n == ++_brkCount) {
            System.out.println("break count reaches " + n);
        }
    }

    public static final boolean enabled(String string) {
        return false;
    }

    public static final void setEnabled(String string, boolean bl) {
    }

    public static void print(String string) {
    }

    public static void println(String string) {
    }

    public static void println(String string, String string2) {
    }

    public static void println(String string, String string2, String string3) {
    }

    public static void setPrintlnExFlags(String string) {
        System.setProperty("com.sybase.util.Dbg.printlnEx", string);
        _printlnExFlagsSet = false;
    }

    public static void printlnEx(String string) {
    }

    public static void printlnEx(Throwable throwable, String string) {
    }

    private static void printlnExInternal(Throwable throwable, String string) {
        StackFrame stackFrame;
        Object object;
        if (!_printlnExFlagsSet) {
            object = System.getProperty("com.sybase.util.Dbg.printlnEx");
            if (object != null && ((String)object).length() != 0) {
                if (((String)object).indexOf(PRINTLN_TIMESTAMP) != -1) {
                    _printTimestamp = true;
                }
                if (((String)object).indexOf(PRINTLN_PACKAGE) != -1) {
                    _printPackage = true;
                }
                if (((String)object).indexOf(PRINTLN_CLASS) != -1) {
                    _printClass = true;
                }
                if (((String)object).indexOf(PRINTLN_FUNCTION) != -1) {
                    _printFunction = true;
                }
                if (((String)object).indexOf(PRINTLN_FILE) != -1) {
                    _printFile = true;
                }
                if (((String)object).indexOf(PRINTLN_THREAD) != -1) {
                    _printThread = true;
                }
                if (((String)object).indexOf(PRINTLN_FORMATTED) != -1) {
                    _printFormatted = true;
                }
                if (((String)object).indexOf(PRINTLN_NO_TIMESTAMP) != -1) {
                    _printTimestamp = false;
                }
                if (((String)object).indexOf(PRINTLN_NO_PACKAGE) != -1) {
                    _printPackage = false;
                }
                if (((String)object).indexOf(PRINTLN_NO_CLASS) != -1) {
                    _printClass = false;
                }
                if (((String)object).indexOf(PRINTLN_NO_FUNCTION) != -1) {
                    _printFunction = false;
                }
                if (((String)object).indexOf(PRINTLN_NO_FILE) != -1) {
                    _printFile = false;
                }
                if (((String)object).indexOf(PRINTLN_NO_THREAD) != -1) {
                    _printThread = false;
                }
                if (((String)object).indexOf(PRINTLN_NOT_FORMATTED) != -1) {
                    _printFormatted = false;
                }
                if (((String)object).indexOf(PRINTLN_SILENT) != -1) {
                    _suppressPrintlnExOutput = true;
                }
            }
            _printlnExFlagsSet = true;
        }
        if (_suppressPrintlnExOutput) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer(160);
        if (_printTimestamp) {
            object = Calendar.getInstance().getTime();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
            stringBuffer.append(simpleDateFormat.format((Date)object));
        }
        if ((stackFrame = StackFrame.getStackFrame(3)) != null) {
            if (_printPackage) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(" ");
                }
                stringBuffer.append(stackFrame.packageName);
            }
            if (_printClass) {
                if (_printPackage) {
                    stringBuffer.append(".");
                } else if (_printTimestamp) {
                    stringBuffer.append(" ");
                }
                stringBuffer.append(stackFrame.className);
            }
            if (_printFunction) {
                if (_printClass) {
                    stringBuffer.append(".");
                } else if (stringBuffer.length() > 0) {
                    stringBuffer.append(" ");
                }
                stringBuffer.append(stackFrame.functionName);
            }
            if (_printFile) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(" ");
                }
                if (_printPackage || _printClass || _printFunction) {
                    stringBuffer.append("(");
                    stringBuffer.append(stackFrame.fileName);
                    stringBuffer.append(":");
                    stringBuffer.append(stackFrame.lineNumber);
                    stringBuffer.append(")");
                } else if (stringBuffer.length() > 0) {
                    stringBuffer.append(stackFrame.fileName);
                    stringBuffer.append(":");
                    stringBuffer.append(stackFrame.lineNumber);
                }
            }
            if (_printThread) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append("\n  Thread=\"");
                }
                stringBuffer.append(Thread.currentThread().getName());
                stringBuffer.append("\" (");
                stringBuffer.append(Integer.toHexString(Thread.currentThread().hashCode()));
                stringBuffer.append(")");
            }
        }
        if (_printFormatted) {
            Dbg.formatMessage(stringBuffer, string);
        } else {
            if (stringBuffer.length() > 0) {
                stringBuffer.append("  ");
            }
            stringBuffer.append(string);
        }
        if (throwable != null) {
            Dbg.formatException(stringBuffer, throwable);
            if (_printFormatted) {
                stringBuffer.append("\n");
            }
        }
        System.out.println(stringBuffer);
    }

    private static void formatException(StringBuffer stringBuffer, Throwable throwable) {
        StringWriter stringWriter = null;
        PrintWriter printWriter = null;
        BufferedReader bufferedReader = null;
        stringBuffer.append("\n  Exception: " + throwable.getClass().getName());
        stringBuffer.append("\n    " + throwable.getLocalizedMessage());
        if (throwable instanceof SQLException) {
            stringBuffer.append("\n    SQLState=" + ((SQLException)throwable).getSQLState() + ", ErrorCode=" + ((SQLException)throwable).getErrorCode());
        }
        stringWriter = new StringWriter(4096);
        printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        printWriter.flush();
        StringBuffer stringBuffer2 = stringWriter.getBuffer();
        bufferedReader = new BufferedReader(new StringReader(stringBuffer2.toString()));
        try {
            String string = bufferedReader.readLine();
            while ((string = bufferedReader.readLine()) != null) {
                stringBuffer.append("\n    ");
                int n = string.indexOf("at ");
                if (n != -1) {
                    stringBuffer.append(string.substring(n + 3));
                    continue;
                }
                stringBuffer.append(string);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            stringWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        printWriter.close();
        Throwable throwable2 = throwable.getCause();
        if (throwable2 != null) {
            stringBuffer.append("\n\n  This exception was originally caused by:");
            Dbg.formatException(stringBuffer, throwable2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private static void formatMessage(StringBuffer var0, String var1_1) {
        var2_2 = null;
        try {
            var2_2 = new BufferedReader(new StringReader(var1_1));
            block11: while (true) {
                if ((var3_3 = var2_2.readLine()) == null) {
                    var0.append("\n");
                    break;
                }
                var8_8 = false;
                while (true) {
                    var0.append("\n  ");
                    var4_4 = var3_3.length();
                    if (var4_4 < 78) {
                        if (var8_8) {
                            var0.append("  ");
                        }
                        var0.append(var3_3);
                        continue block11;
                    }
                    var6_6 = -1;
                    for (var5_5 = 76 - (var8_8 != false ? 2 : 0); var5_5 >= 0; --var5_5) {
                        var7_7 = var3_3.charAt(var5_5);
                        if (!Character.isWhitespace(var7_7) && var7_7 != ',' && var7_7 != ';') continue;
                        var6_6 = var5_5;
                        break;
                    }
                    if (var6_6 == -1) {
                        var0.append(var3_3);
                        continue block11;
                    }
                    if (var8_8) {
                        var0.append("  ");
                    }
                    var0.append(var3_3.substring(0, var6_6 + 1));
                    var3_3 = var3_3.substring(var6_6 + 1);
                    if (var3_3.length() != 0) ** break;
                    continue block11;
                    var8_8 = true;
                }
                break;
            }
        }
        catch (IOException var9_10) {
            var0.append("\n*** Internal error formatting message:\n");
            var0.append(var1_1);
            var0.append("\n");
        }
        finally {
            if (var2_2 != null) {
                try {
                    var2_2.close();
                }
                catch (IOException var9_11) {}
            }
        }
    }

    public static void setKinds(String[] stringArray) {
    }

    public static void appendKinds(String[] stringArray) {
    }

    public static String[] getKinds() {
        return _kinds;
    }

    private static void setupBuffer() {
    }

    public static void printEol() {
    }

    public static void printString(String string) {
    }

    private static String[] readConfigFile(String string) {
        String[] stringArray = null;
        return stringArray;
    }

    public static void enableMessageType(String string) {
        if (string != null) {
            Dbg.enableMessageTypes(new String[]{string});
        } else {
            Dbg.enableMessageTypes(null);
        }
    }

    public static void enableMessageTypes(String[] stringArray) {
    }

    private static void enableMessageTypes2(String[] stringArray) {
        if (_messageTypes == null) {
            _messageTypes = new ArrayList(stringArray.length);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (Dbg.isMessageTypeEnabled(stringArray[i])) continue;
            _messageTypes.add(stringArray[i]);
        }
    }

    public static boolean isMessageTypeEnabled(String string) {
        boolean bl = false;
        return bl;
    }

    public static String[] setEnables(String[] stringArray) {
        return stringArray;
    }

    private static String[] setEnables2(String[] stringArray) {
        return stringArray;
    }

    public static void throwExc() {
    }

    public static void throwExc(String string) {
    }

    private static void trap() {
    }

    public static void diagnose(Throwable throwable) {
    }

    public static void printStackTrace() {
    }

    public static String getDefaultStringRepresentation(Object object) {
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append(object.getClass().getName());
        stringBuffer.append("@");
        stringBuffer.append(Integer.toHexString(object.hashCode()));
        stringBuffer.append("[");
        Field[] fieldArray = object.getClass().getDeclaredFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            try {
                int n = fieldArray[i].getModifiers();
                if ((n & 0x10) != 0 && (n & 8) != 0) continue;
                Object object2 = fieldArray[i].get(object);
                if (bl) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(fieldArray[i].getName());
                stringBuffer.append("=");
                if (object2 == null) {
                    stringBuffer.append("(null)");
                } else {
                    if (object2 instanceof String) {
                        stringBuffer.append("\"");
                    } else if (object2 instanceof Character) {
                        stringBuffer.append("'");
                    }
                    stringBuffer.append(object2.toString());
                    if (object2 instanceof String) {
                        stringBuffer.append("\"");
                    } else if (object2 instanceof Character) {
                        stringBuffer.append("'");
                    }
                }
                bl = true;
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public static String getSignature(Object object) {
        if (object == null) {
            return "NULL";
        }
        return object.getClass().getName() + "@" + Integer.toHexString(object.hashCode());
    }

    static class AssertionException
    extends RuntimeException {
        AssertionException(String string) {
            super(string);
            Dbg.trap();
        }

        AssertionException() {
            this("Dbg assertion failure");
        }
    }
}

