/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util;

import com.sybase.util.DetailsDialogHelpListener;
import com.sybase.util.DetailsDlgResConstants;
import com.sybase.util.DialogUtils;
import com.sybase.util.MessageTextArea;
import com.sybase.util.Platform;
import com.sybase.util.SybButton;
import com.sybase.util.SybLabel;
import com.sybase.util.SybModalDialog;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;

public class DetailsDialog
extends SybModalDialog
implements WindowListener,
ActionListener,
DetailsDlgResConstants {
    private DetailsDialogHelpListener _helpListener = null;
    private JLabel _jlabel_icon = new SybLabel();
    private MessageTextArea _jtexta_message = new MessageTextArea();
    private JScrollPane _jscrollp_detailsMessage = new JScrollPane();
    private MessageTextArea _jtexta_detailsMessage = new MessageTextArea();
    private JPanel _jpanel = new JPanel();
    private JButton _jcb_details = new SybButton();
    private JButton _jcb_copyToClipboard = new SybButton();
    private JButton _jcb_ok = new SybButton();
    private JButton _jcb_help = new SybButton();
    private JLabel _filler = new SybLabel();
    private Container _parent = null;
    private String _message = null;
    private String _detailsMessage = null;
    private Icon _icon = null;
    private String _showDetailsBtnString = null;
    private String _hideDetailsBtnString = null;
    private static final String BUNDLE_NAME = "com.sybase.util.DetailsDlgResources";
    private static final String ESCAPE_KEY_PRESS = "ESCAPE_KEY_PRESS";
    private static final String F1_KEY_PRESS = "F1_KEY_PRESS";

    DetailsDialog() {
    }

    DetailsDialog(Frame frame, String string, String string2, String string3, DetailsDialogHelpListener detailsDialogHelpListener) {
        super(frame, string);
        this._parent = frame;
        this._message = string2;
        this._detailsMessage = string3;
        this._helpListener = detailsDialogHelpListener;
        this.create();
    }

    DetailsDialog(Dialog dialog, String string, String string2, String string3, DetailsDialogHelpListener detailsDialogHelpListener) {
        super(dialog, string);
        this._parent = dialog;
        this._message = string2;
        this._detailsMessage = string3;
        this._helpListener = detailsDialogHelpListener;
        this.create();
    }

    DetailsDialog(Frame frame, String string, String string2, Throwable throwable, DetailsDialogHelpListener detailsDialogHelpListener) {
        super(frame, string);
        this._parent = frame;
        this._message = string2;
        this._detailsMessage = this.getStackTraceString(throwable);
        this._helpListener = detailsDialogHelpListener;
        this.create();
    }

    DetailsDialog(Dialog dialog, String string, String string2, Throwable throwable, DetailsDialogHelpListener detailsDialogHelpListener) {
        super(dialog, string);
        this._parent = dialog;
        this._message = string2;
        this._detailsMessage = this.getStackTraceString(throwable);
        this._helpListener = detailsDialogHelpListener;
        this.create();
    }

    void setIcon(Icon icon) {
        this._icon = icon;
        this._jlabel_icon.setIcon(icon);
    }

    String getStackTraceString(Throwable throwable) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8192);
            PrintStream printStream = new PrintStream(byteArrayOutputStream);
            throwable.printStackTrace(printStream);
            printStream.flush();
            printStream.close();
            byteArrayOutputStream.flush();
            return byteArrayOutputStream.toString();
        }
        catch (IOException iOException) {
            return "";
        }
    }

    private void create() {
        this.getRootPane().registerKeyboardAction(this, ESCAPE_KEY_PRESS, KeyStroke.getKeyStroke(27, 0, false), 2);
        this.setButtonStrings();
        this.setResizable(true);
        GridBagLayout gridBagLayout = new GridBagLayout();
        Container container = this.getContentPane();
        container.setLayout(gridBagLayout);
        container.add(this._jlabel_icon);
        container.add(this._jtexta_message);
        container.add(this._filler);
        container.add(this._jscrollp_detailsMessage);
        this._jscrollp_detailsMessage.getViewport().add(this._jtexta_detailsMessage);
        FlowLayout flowLayout = new FlowLayout();
        this._jpanel.setLayout(flowLayout);
        flowLayout.setAlignment(2);
        flowLayout.setHgap(5);
        flowLayout.setVgap(5);
        container.add(this._jpanel);
        this._jpanel.add(this._jcb_details);
        this._jpanel.add(this._jcb_copyToClipboard);
        this._jpanel.add(this._jcb_ok);
        this._jcb_details.addActionListener(this);
        this._jcb_copyToClipboard.addActionListener(this);
        this._jcb_ok.addActionListener(this);
        this._jcb_help.addActionListener(this);
        this.addWindowListener(this);
        if (this._icon == null) {
            this._jlabel_icon.setIcon(UIManager.getIcon("OptionPane.errorIcon"));
        } else {
            this._jlabel_icon.setIcon(this._icon);
        }
        this._jtexta_message.setText(this._message);
        this._jtexta_message.setColumns(48);
        this._jtexta_message.setBackground(SystemColor.control);
        this._jtexta_message.setDisabledTextColor(SystemColor.windowText);
        this._jtexta_message.setEnabled(false);
        if (Platform.isMacOS()) {
            this._jscrollp_detailsMessage.setVerticalScrollBarPolicy(22);
        } else {
            this._jscrollp_detailsMessage.setVerticalScrollBarPolicy(20);
        }
        this._jscrollp_detailsMessage.setVisible(false);
        this._jtexta_detailsMessage.setTabSize(4);
        this._jtexta_detailsMessage.setRows(10);
        this._jtexta_detailsMessage.setText(this._detailsMessage);
        this._jtexta_detailsMessage.setEditable(false);
        this._jcb_details.setText(this._showDetailsBtnString);
        this.getRootPane().setDefaultButton(this._jcb_ok);
        if (this._helpListener != null) {
            this._jpanel.add(this._jcb_help);
            this.getRootPane().registerKeyboardAction(this, F1_KEY_PRESS, KeyStroke.getKeyStroke(112, 0, false), 2);
        }
        JComponent[] jComponentArray = new JComponent[]{this._jcb_details, this._jcb_copyToClipboard, this._jcb_ok, this._jcb_help};
        if (this._jcb_details.getFontMetrics(this._jcb_details.getFont()).stringWidth(this._hideDetailsBtnString) > this._jcb_details.getFontMetrics(this._jcb_details.getFont()).stringWidth(this._showDetailsBtnString)) {
            this._jcb_details.setText(this._hideDetailsBtnString);
            DialogUtils.makeComponentsSameWidth(jComponentArray);
            this._jcb_details.setText(this._showDetailsBtnString);
        } else {
            DialogUtils.makeComponentsSameWidth(jComponentArray);
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagLayout.setConstraints(this._jlabel_icon, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagLayout.setConstraints(this._jtexta_message, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagLayout.setConstraints(this._filler, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this._jpanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagLayout.setConstraints(this._jscrollp_detailsMessage, gridBagConstraints);
        this.pack();
        this.pack();
        this.setLocationRelativeTo(this._parent);
    }

    private void setButtonStrings() {
        ResourceBundle resourceBundle = ResourceBundle.getBundle(BUNDLE_NAME);
        this._jcb_copyToClipboard.setText(resourceBundle.getString("COPY_TO_CLIPBOARD_BTN"));
        this._jcb_ok.setText(resourceBundle.getString("OK_BTN"));
        this._jcb_help.setText(resourceBundle.getString("HELP_BTN"));
        this._showDetailsBtnString = resourceBundle.getString("SHOW_DETAILS_BTN");
        this._hideDetailsBtnString = resourceBundle.getString("HIDE_DETAILS_BTN");
    }

    private void close() {
        this.getRootPane().unregisterKeyboardAction(KeyStroke.getKeyStroke(27, 0, false));
        if (this._helpListener != null) {
            this.getRootPane().unregisterKeyboardAction(KeyStroke.getKeyStroke(112, 0, false));
        }
        this.dispose();
        this.setVisible(false);
        this._jcb_details.removeActionListener(this);
        this._jcb_copyToClipboard.removeActionListener(this);
        this._jcb_ok.removeActionListener(this);
        this._jcb_help.removeActionListener(this);
        this.removeWindowListener(this);
        this._helpListener = null;
        this._jlabel_icon = null;
        this._jtexta_message = null;
        this._jscrollp_detailsMessage = null;
        this._jtexta_detailsMessage = null;
        this._jpanel = null;
        this._jcb_details = null;
        this._jcb_copyToClipboard = null;
        this._jcb_ok = null;
        this._jcb_help = null;
        this._filler = null;
        this._message = null;
        this._detailsMessage = null;
        this._icon = null;
        this._showDetailsBtnString = null;
        this._hideDetailsBtnString = null;
        DialogUtils.removeComponents(this);
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.close();
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
        this._jcb_ok.requestFocus();
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        StringSelection stringSelection = null;
        if (actionEvent.getSource() == this._jcb_details) {
            GridBagLayout gridBagLayout = (GridBagLayout)this.getContentPane().getLayout();
            if (!this._jscrollp_detailsMessage.isVisible()) {
                this._jcb_details.setText(this._hideDetailsBtnString);
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.fill = 2;
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.gridwidth = 0;
                gridBagConstraints.insets = new Insets(5, 5, 5, 5);
                gridBagLayout.setConstraints(this._filler, gridBagConstraints);
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.fill = 1;
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 2;
                gridBagConstraints.gridwidth = 0;
                gridBagLayout.setConstraints(this._jpanel, gridBagConstraints);
            } else {
                this._jcb_details.setText(this._showDetailsBtnString);
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.fill = 2;
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.gridwidth = 0;
                gridBagConstraints.insets = new Insets(5, 5, 5, 5);
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 1.0;
                gridBagLayout.setConstraints(this._filler, gridBagConstraints);
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.fill = 1;
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 2;
                gridBagConstraints.gridheight = 0;
                gridBagConstraints.gridwidth = 0;
                gridBagLayout.setConstraints(this._jpanel, gridBagConstraints);
            }
            this._jscrollp_detailsMessage.setVisible(!this._jscrollp_detailsMessage.isVisible());
            this.pack();
        } else if (actionEvent.getSource() == this._jcb_copyToClipboard) {
            stringSelection = new StringSelection(this._jtexta_message.getText() + "\n" + this._jtexta_detailsMessage.getText());
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, null);
        } else if (actionEvent.getSource() == this._jcb_ok || actionEvent.getActionCommand().equals(ESCAPE_KEY_PRESS)) {
            this.close();
        } else if ((actionEvent.getSource() == this._jcb_help || actionEvent.getActionCommand().equals(F1_KEY_PRESS)) && this._helpListener != null) {
            this._helpListener.helpButtonPressed();
        }
    }

    String getMessage() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this._message != null) {
            stringBuilder.append(this._message);
        }
        if (this._detailsMessage != null) {
            stringBuilder.append("\n");
            stringBuilder.append(this._detailsMessage);
        }
        return stringBuilder.toString();
    }
}

