/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Window;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPopupMenu;
import javax.swing.JWindow;

public class DialogUtils {
    public static Object disableControls(Container container) {
        DisabledControlList disabledControlList = new DisabledControlList();
        DialogUtils.enumerateComponents(disabledControlList.list, container);
        int n = disabledControlList.list.size();
        for (int i = 0; i < n; ++i) {
            Component component = disabledControlList.list.get(i);
            if (component.hasFocus() && component.isFocusable() && disabledControlList.focusOwner == null) {
                disabledControlList.focusOwner = component;
            }
            component.setEnabled(false);
        }
        return disabledControlList;
    }

    public static void enumerateComponents(ArrayList<Component> arrayList, Container container) {
        if (container.isEnabled()) {
            arrayList.add(container);
        }
        int n = container.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = container.getComponent(i);
            if (component instanceof Container) {
                DialogUtils.enumerateComponents(arrayList, (Container)component);
                continue;
            }
            if (!component.isEnabled()) continue;
            arrayList.add(component);
        }
    }

    public static void enableControls(Object object) {
        DisabledControlList disabledControlList = (DisabledControlList)object;
        int n = disabledControlList.list.size();
        for (int i = n - 1; i >= 0; --i) {
            Component component = disabledControlList.list.get(i);
            component.setEnabled(true);
        }
        if (disabledControlList.focusOwner != null) {
            disabledControlList.focusOwner.requestFocus();
        }
    }

    private static void closeMenus(Container container) {
        Component[] componentArray = container.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (componentArray[i] instanceof JMenu) {
                JMenu jMenu = (JMenu)componentArray[i];
                if (jMenu.isPopupMenuVisible()) {
                    jMenu.setPopupMenuVisible(false);
                }
            } else if (componentArray[i] instanceof JPopupMenu) {
                ((JPopupMenu)componentArray[i]).setVisible(false);
            }
            if (!(componentArray[i] instanceof Container)) continue;
            DialogUtils.closeMenus((Container)componentArray[i]);
        }
    }

    public static void removeComponents(Container container) {
        if (container instanceof JFrame) {
            DialogUtils.closeMenus(container);
        }
        Component[] componentArray = container.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof Container)) continue;
            DialogUtils.removeComponents((Container)componentArray[i]);
        }
        if (container instanceof JFrame) {
            ((JFrame)container).getContentPane().removeAll();
            ((JFrame)container).getContentPane().setLayout(null);
        } else if (container instanceof JWindow) {
            ((JWindow)container).getContentPane().removeAll();
            ((JWindow)container).getContentPane().setLayout(null);
        } else if (container instanceof JApplet) {
            ((JApplet)container).getContentPane().removeAll();
            ((JApplet)container).getContentPane().setLayout(null);
        } else if (container instanceof JInternalFrame) {
            ((JInternalFrame)container).getContentPane().removeAll();
            ((JInternalFrame)container).getContentPane().setLayout(null);
        } else if (container instanceof JDialog) {
            ((JDialog)container).getContentPane().removeAll();
            ((JDialog)container).getContentPane().setLayout(null);
        } else if (container instanceof Box) {
            ((Box)container).removeAll();
        } else {
            if (container instanceof JMenuBar) {
                JMenuBar jMenuBar = (JMenuBar)container;
                jMenuBar.setVisible(false);
            }
            if (container instanceof JPopupMenu) {
                JPopupMenu jPopupMenu = (JPopupMenu)container;
                jPopupMenu.setVisible(false);
            }
            container.removeAll();
            container.setLayout(null);
        }
        if (container instanceof Window) {
            ((Window)container).dispose();
        }
    }

    public static void makeComponentsSameWidth(JComponent ... jComponentArray) {
        int n;
        int n2 = jComponentArray.length;
        Dimension[] dimensionArray = new Dimension[n2];
        for (n = 0; n < n2; ++n) {
            dimensionArray[n] = jComponentArray[n].getPreferredSize();
        }
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            if (dimensionArray[n].width <= n3) continue;
            n3 = dimensionArray[n].width;
        }
        for (n = 0; n < n2; ++n) {
            dimensionArray[n].width = n3;
            jComponentArray[n].setMinimumSize(dimensionArray[n]);
            jComponentArray[n].setPreferredSize(dimensionArray[n]);
            jComponentArray[n].setMaximumSize(dimensionArray[n]);
        }
    }

    public static String getWidestString(Component component, String ... stringArray) {
        FontMetrics fontMetrics = component.getFontMetrics(component.getFont());
        String string = null;
        int n = 0;
        for (String string2 : stringArray) {
            int n2;
            if (string2 == null || (n2 = fontMetrics.stringWidth(string2)) <= n) continue;
            n = n2;
            string = string2;
        }
        return string;
    }

    static class DisabledControlList {
        ArrayList<Component> list = new ArrayList();
        Component focusOwner = null;

        DisabledControlList() {
        }
    }
}

