/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class EmbeddedMnemonic {
    private static final Pattern PATTERN = Pattern.compile("\\A(.*\\S)(?:\\s*)(?:\\(&.\\))(?:\\s*)(?:\\.\\.\\.)?\\z");
    char c;
    int index;
    String textWithoutMnemonic;
    String rawText;
    String originalText;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append("Original text=\"");
        stringBuffer.append(this.originalText);
        stringBuffer.append("\", Text without mnemonic=\"");
        stringBuffer.append(this.textWithoutMnemonic);
        stringBuffer.append("\"");
        if (this.c != '\u0000') {
            stringBuffer.append(", Mnemonic character=\"");
            stringBuffer.append(this.c);
            stringBuffer.append("\"");
        }
        if (this.index != -1) {
            stringBuffer.append(", Mnemonic index=");
            stringBuffer.append(Integer.toString(this.index));
        }
        return stringBuffer.toString();
    }

    private EmbeddedMnemonic(char c, int n, String string, String string2) {
        this.c = c;
        this.index = n;
        this.textWithoutMnemonic = string;
        this.originalText = string2;
    }

    public static EmbeddedMnemonic getEmbeddedMnemonic(String string) {
        int n = -1;
        char c = '\u0000';
        if (string == null) {
            return new EmbeddedMnemonic(c, -1, null, null);
        }
        int n2 = string.length();
        StringBuffer stringBuffer = new StringBuffer(n2);
        for (int i = 0; i < n2; ++i) {
            char c2 = string.charAt(i);
            if (c2 == '&' && i + 1 < n2) {
                c2 = string.charAt(i + 1);
                if (c2 == '&') {
                    stringBuffer.append(c2);
                    ++i;
                    continue;
                }
                c = c2;
                n = i;
                continue;
            }
            stringBuffer.append(c2);
        }
        EmbeddedMnemonic embeddedMnemonic = new EmbeddedMnemonic(c, n, stringBuffer.toString(), string);
        return embeddedMnemonic;
    }

    public String getOriginalText() {
        return this.originalText;
    }

    public void setMnemonic(int n) {
        this.index = this.originalText != null ? this.originalText.indexOf(n) : -1;
        if (this.index > -1) {
            this.c = (char)n;
        }
        this.textWithoutMnemonic = this.originalText;
    }

    public String getTextWithoutMnemonic() {
        return this.textWithoutMnemonic;
    }

    public String getRawText() {
        if (this.rawText == null) {
            Matcher matcher = PATTERN.matcher(this.originalText);
            this.rawText = matcher.find() ? matcher.group(1) : (this.textWithoutMnemonic.endsWith("...") ? this.textWithoutMnemonic.substring(0, this.textWithoutMnemonic.length() - 3) : this.textWithoutMnemonic);
        }
        return this.rawText;
    }

    public char getMnemonic() {
        return this.c;
    }

    public int getIndex() {
        return this.index;
    }

    public static Dimension getPreferredButtonSize(AbstractButton abstractButton, int n, EmbeddedMnemonic embeddedMnemonic) {
        if (embeddedMnemonic == null) {
            return BasicGraphicsUtils.getPreferredButtonSize(abstractButton, n);
        }
        if (abstractButton.getComponentCount() > 0) {
            return null;
        }
        Icon icon = abstractButton.getIcon();
        String string = embeddedMnemonic.textWithoutMnemonic;
        Font font = abstractButton.getFont();
        FontMetrics fontMetrics = abstractButton.getFontMetrics(font);
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE);
        SwingUtilities.layoutCompoundLabel(abstractButton, fontMetrics, string, icon, abstractButton.getVerticalAlignment(), abstractButton.getHorizontalAlignment(), abstractButton.getVerticalTextPosition(), abstractButton.getHorizontalTextPosition(), rectangle3, rectangle, rectangle2, string == null ? 0 : n);
        Rectangle rectangle4 = rectangle.union(rectangle2);
        Insets insets = abstractButton.getInsets();
        rectangle4.width += insets.left + insets.right;
        rectangle4.height += insets.top + insets.bottom;
        if (rectangle4.width % 2 == 0) {
            ++rectangle4.width;
        }
        if (rectangle4.height % 2 == 0) {
            ++rectangle4.height;
        }
        return rectangle4.getSize();
    }
}

