/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util;

import com.sybase.util.DetailsErrorDialog;
import com.sybase.util.SplashScreen;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class EventMonitor
extends EventQueue {
    static int _queueSize = 100;
    static EventList _eventList = null;
    static EventMonitor _this = null;
    static EventInfo _previousEvent = null;
    static boolean _paused = false;

    static void install() {
        if (_this == null) {
            _this = new EventMonitor();
            _eventList = new EventList(_queueSize);
            Toolkit.getDefaultToolkit().getSystemEventQueue().push(_this);
        }
    }

    static void uninstall() {
        if (_this != null) {
            _this.pop();
            _this = null;
        }
    }

    public static void pause() {
        _paused = true;
    }

    public static void resume() {
        _paused = false;
    }

    static void addUserEvent(String string) {
        if (_previousEvent != null) {
            _eventList.add(_previousEvent);
            _previousEvent = null;
        }
        _eventList.add(new UserEventInfo(string));
    }

    public static void printEvents(PrintStream printStream) {
        if (_this == null) {
            return;
        }
        if (_previousEvent != null) {
            _eventList.add(_previousEvent);
            _previousEvent = null;
        }
        EventInfo[] eventInfoArray = _eventList.getEvents();
        for (int i = 0; i < eventInfoArray.length; ++i) {
            eventInfoArray[i].print(printStream);
        }
    }

    public static String getEvents() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8192);
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        EventMonitor.printEvents(printStream);
        return byteArrayOutputStream.toString();
    }

    @Override
    protected void dispatchEvent(AWTEvent aWTEvent) {
        if (_paused) {
            super.dispatchEvent(aWTEvent);
            return;
        }
        int n = aWTEvent.getID();
        if (n == 501 || n == 502) {
            Component component;
            Point point = ((MouseEvent)aWTEvent).getPoint();
            Object object = aWTEvent.getSource();
            if (object instanceof Container) {
                component = ((Container)object).findComponentAt(point);
                if (component == null) {
                    component = (Component)object;
                }
            } else {
                component = (Component)object;
            }
            if (n == 502 && _previousEvent != null && _previousEvent.isEventForComponent(component)) {
                EventMonitor._previousEvent.id = 500;
                _eventList.add(_previousEvent);
                _previousEvent = null;
            } else {
                if (component != object && object instanceof Component) {
                    point = SwingUtilities.convertPoint((Component)object, point, component);
                }
                EventInfo eventInfo = new EventInfo(n, component, this.getComponentDescription(component, point), ((InputEvent)aWTEvent).getModifiersEx());
                if (_previousEvent != null) {
                    _eventList.add(_previousEvent);
                }
                _previousEvent = eventInfo;
            }
        } else if (n == 401) {
            boolean bl;
            KeyEvent keyEvent = (KeyEvent)aWTEvent;
            Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            Component component2 = component != null ? component : keyEvent.getComponent();
            boolean bl2 = bl = keyEvent.getKeyCode() == 10 || keyEvent.getKeyCode() == 9 || keyEvent.isActionKey() || !(component2 instanceof JPasswordField);
            if (bl) {
                if (_previousEvent != null && EventMonitor._previousEvent.id == n && _previousEvent.isEventForComponent(component2)) {
                    _previousEvent.addKeyStroke(keyEvent.getKeyCode(), keyEvent.getModifiers());
                } else {
                    EventInfo eventInfo = new EventInfo(n, component2, this.getComponentDescription(component2, null), keyEvent.getKeyCode(), keyEvent.getModifiers());
                    if (_previousEvent != null) {
                        _eventList.add(_previousEvent);
                    }
                    _previousEvent = eventInfo;
                }
            }
        } else if (n == 205 || n == 202) {
            String string;
            Window window;
            if (_previousEvent != null) {
                _eventList.add(_previousEvent);
                _previousEvent = null;
            }
            if ((window = (Window)aWTEvent.getSource()) instanceof SplashScreen) {
                string = "(Splash screen)";
            } else if (window instanceof DetailsErrorDialog) {
                String string2 = ((DetailsErrorDialog)window).getMessage();
                if (string2 != null && string2.length() > 0) {
                    string2 = string2.replaceAll("\\s", " ");
                }
                string = "(Error dialog: \"" + string2 + "\")";
            } else {
                string = this.getWindowTitle(window);
                string = string + " (" + window.getClass().getName() + ")";
            }
            EventInfo eventInfo = new EventInfo(n, window, string);
            _eventList.add(eventInfo);
        }
        super.dispatchEvent(aWTEvent);
    }

    private String getComponentDescription(Component component, Point point) {
        JComponent jComponent;
        int n;
        Container container;
        String string;
        StringBuffer stringBuffer = new StringBuffer(64);
        if (component instanceof JButton) {
            Object object;
            Action action;
            string = ((JButton)component).getText();
            if ((string == null || string.length() == 0) && (action = ((JButton)component).getAction()) != null && (object = action.getValue("Name")) != null) {
                string = object.toString();
            }
            if (string == null) {
                string = ((JButton)component).getToolTipText();
            }
            if (string != null && string.length() > 0) {
                stringBuffer.append("\"");
                stringBuffer.append(string);
                stringBuffer.append("\" button");
            }
        } else if (component instanceof JCheckBox) {
            string = ((JCheckBox)component).getText();
            stringBuffer.append("\"");
            stringBuffer.append(string);
            stringBuffer.append("\" checkbox");
        } else if (component instanceof JRadioButton) {
            string = ((JRadioButton)component).getText();
            stringBuffer.append("\"");
            stringBuffer.append(string);
            stringBuffer.append("\" radio button");
        } else if (component instanceof JMenuItem) {
            string = ((JMenuItem)component).getText();
            stringBuffer.append("\"");
            stringBuffer.append(string);
            stringBuffer.append("\" menu item");
        } else if (component instanceof JTextComponent) {
            string = this.getLabelForComponent((JComponent)component);
            if (string != null) {
                stringBuffer.append(string);
            }
            if (component instanceof JPasswordField) {
                stringBuffer.append(" [Password characters were not logged]");
            }
        } else if (point != null && component.getClass().getName().equals("javax.swing.plaf.basic.BasicTabbedPaneUI$ScrollableTabPanel")) {
            container = component.getParent();
            if (container != null) {
                container = container.getParent();
            }
            if (container != null && container instanceof JTabbedPane) {
                point = SwingUtilities.convertPoint(component, point, container);
                n = ((JTabbedPane)container).indexAtLocation(point.x, point.y);
                if (n >= 0) {
                    stringBuffer.append('\"');
                    stringBuffer.append(((JTabbedPane)container).getTitleAt(n));
                    stringBuffer.append("\" tab");
                } else {
                    stringBuffer.append("a tab control");
                }
            } else {
                stringBuffer.append("a tab control");
            }
        } else if (point != null && component instanceof JTabbedPane) {
            n = ((JTabbedPane)component).indexAtLocation(point.x, point.y);
            if (n >= 0) {
                stringBuffer.append('\"');
                stringBuffer.append(((JTabbedPane)component).getTitleAt(n));
                stringBuffer.append("\" tab");
            }
        } else if (point != null && component instanceof JTree) {
            jComponent = (JTree)component;
            TreePath treePath = ((JTree)jComponent).getPathForLocation(point.x, point.y);
            if (treePath != null) {
                TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
                stringBuffer.append('\"');
                stringBuffer.append(treeNode.toString());
                stringBuffer.append("\" tree item");
            }
        } else if (point != null && component instanceof JList) {
            jComponent = (JList)component;
            n = ((JList)jComponent).locationToIndex(point);
            if (n >= 0) {
                Object e = ((JList)jComponent).getModel().getElementAt(n);
                string = e == null ? "(null)" : e.toString();
                stringBuffer.append('\"');
                stringBuffer.append(string);
                stringBuffer.append("\" list item");
            }
            if ((string = this.getLabelForComponent((JComponent)component)) != null) {
                stringBuffer.append(" in ");
                stringBuffer.append(string);
            }
        }
        if (stringBuffer.length() == 0) {
            string = null;
            if (component instanceof JComponent) {
                string = this.getLabelForComponent((JComponent)component);
            }
            if (string != null) {
                stringBuffer.append(string);
            } else {
                stringBuffer.append("a ");
                stringBuffer.append(this.getSimpleClassName(component));
                if (component instanceof JComponent) {
                    string = ((JComponent)component).getName();
                    if (string != null && string.length() > 0) {
                        stringBuffer.append(" with name \"");
                        stringBuffer.append(string);
                        stringBuffer.append("\"");
                    }
                    if ((string = ((JComponent)component).getToolTipText()) != null && string.length() > 0) {
                        stringBuffer.append(" with tooltip \"");
                        stringBuffer.append(string);
                        stringBuffer.append("\"");
                    }
                }
                if (component.getClass() == JPanel.class) {
                    int n2;
                    container = component.getParent();
                    if (container != null) {
                        stringBuffer.append(", parents: ");
                        while (true) {
                            stringBuffer.append(this.getSimpleClassName(container));
                            container = container.getParent();
                            if (container == null || container instanceof Window) break;
                            stringBuffer.append("<");
                        }
                    }
                    if (component instanceof Container && (n2 = ((Container)component).getComponentCount()) > 0) {
                        stringBuffer.append(", ");
                        stringBuffer.append(n2);
                        stringBuffer.append(" children");
                    }
                }
            }
        }
        return stringBuffer.toString();
    }

    private String getSimpleClassName(Object object) {
        String string = object.getClass().getName();
        int n = string.lastIndexOf(".");
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        return string;
    }

    private String getLabelForComponent(JComponent jComponent) {
        StringBuffer stringBuffer = null;
        Object object = jComponent.getClientProperty("labeledBy");
        if (object != null && object instanceof JLabel) {
            stringBuffer = new StringBuffer(40);
            stringBuffer.append('\"');
            String string = ((JLabel)object).getText();
            if (string.length() > 32) {
                stringBuffer.append(string.substring(0, 32));
                stringBuffer.append("...");
            } else {
                stringBuffer.append(string);
            }
            stringBuffer.append('\"');
        }
        return stringBuffer == null ? null : stringBuffer.toString();
    }

    private String getWindowTitle(Window window) {
        StringBuffer stringBuffer = new StringBuffer(64);
        if (window != null) {
            if (window instanceof Dialog) {
                stringBuffer.append("\"");
                stringBuffer.append(((Dialog)window).getTitle());
                stringBuffer.append("\"");
            } else if (window instanceof Frame) {
                stringBuffer.append("\"");
                stringBuffer.append(((Frame)window).getTitle());
                stringBuffer.append("\"");
            } else {
                stringBuffer.append(window.getClass().getName());
            }
        }
        return stringBuffer.toString();
    }

    public long getMostRecentEventTimeEx() {
        long l;
        try {
            Method method = EventQueue.class.getDeclaredMethod("getMostRecentEventTimeEx", new Class[0]);
            method.setAccessible(true);
            l = (Long)method.invoke((Object)this, new Object[0]);
        }
        catch (Exception exception) {
            l = 0L;
        }
        return l;
    }

    static class EventList {
        private int _capacity;
        private EventInfo[] _elements;
        private boolean _isFull;
        private int _writeIndex = 0;

        EventList(int n) {
            this._capacity = n;
            this._elements = new EventInfo[n];
        }

        void add(EventInfo eventInfo) {
            this._elements[this._writeIndex++] = eventInfo;
            if (this._writeIndex == this._capacity) {
                this._isFull = true;
                this._writeIndex = 0;
            }
        }

        EventInfo[] getEvents() {
            EventInfo[] eventInfoArray;
            if (this._isFull) {
                eventInfoArray = new EventInfo[this._capacity];
                int n = this._capacity - this._writeIndex;
                System.arraycopy(this._elements, this._writeIndex, eventInfoArray, 0, n);
                System.arraycopy(this._elements, 0, eventInfoArray, n, this._writeIndex);
            } else {
                eventInfoArray = new EventInfo[this._writeIndex];
                System.arraycopy(this._elements, 0, eventInfoArray, 0, this._writeIndex);
            }
            return eventInfoArray;
        }
    }

    static class UserEventInfo
    extends EventInfo {
        String _text;

        UserEventInfo(String string) {
            this._text = string;
        }

        @Override
        void print(PrintStream printStream) {
            printStream.println("User Event: " + this._text);
        }
    }

    static class EventInfo {
        int id;
        String label;
        ArrayList<Point> _keyCodesAndModifiers;
        int modifiers;
        long timestamp = System.currentTimeMillis();
        private static SimpleDateFormat _formatter = new SimpleDateFormat("HH:mm:ss");
        private int _targetHashCode;
        private String _targetClassName;

        EventInfo() {
            this.id = 1999;
            this.saveTargetInformation(null);
        }

        EventInfo(int n, Component component, String string) {
            this.id = n;
            this.label = string;
            this.saveTargetInformation(component);
        }

        EventInfo(int n, Component component, String string, int n2) {
            this.id = n;
            this.label = string;
            this.modifiers = n2;
            this.saveTargetInformation(component);
        }

        EventInfo(int n, Component component, String string, int n2, int n3) {
            this.id = n;
            this.label = string;
            this.saveTargetInformation(component);
            this._keyCodesAndModifiers = new ArrayList();
            this._keyCodesAndModifiers.add(new Point(n2, n3));
        }

        private void saveTargetInformation(Component component) {
            if (component != null) {
                this._targetClassName = component.getClass().getName();
                this._targetHashCode = component.hashCode();
            } else {
                this._targetClassName = null;
                this._targetHashCode = 0;
            }
        }

        boolean isEventForComponent(Component component) {
            boolean bl = component != null && this._targetClassName != null && this._targetHashCode == component.hashCode() && this._targetClassName.equals(component.getClass().getName());
            return bl;
        }

        void addKeyStroke(int n, int n2) {
            this._keyCodesAndModifiers.add(new Point(n, n2));
        }

        void print(PrintStream printStream) {
            printStream.print(_formatter.format(new Date(this.timestamp)));
            printStream.print(" ");
            if (this.id == 501) {
                printStream.println("Mouse press over " + this.label + this.getModifiersText());
            } else if (this.id == 502) {
                printStream.println("Mouse release over " + this.label + this.getModifiersText());
            } else if (this.id == 500) {
                printStream.println("Click " + this.label + this.getModifiersText());
            } else if (this.id == 205) {
                printStream.println("Activate window " + this.label);
            } else if (this.id == 202) {
                printStream.println("Close window " + this.label);
            } else if (this.id == 401) {
                printStream.println("Type " + this.getKeystrokeString() + " in " + this.label);
            }
        }

        private String getModifiersText() {
            if (this.modifiers != 0) {
                return " (" + InputEvent.getModifiersExText(this.modifiers) + ")";
            }
            return "";
        }

        private String getKeystrokeString() {
            boolean bl = false;
            StringBuffer stringBuffer = new StringBuffer(32);
            for (int i = 0; i < this._keyCodesAndModifiers.size(); ++i) {
                Point point = this._keyCodesAndModifiers.get(i);
                int n = point.x;
                int n2 = point.y;
                String string = KeyEvent.getKeyText(n);
                if (string.length() == 1) {
                    if (!bl) {
                        if (stringBuffer.length() > 0) {
                            stringBuffer.append(",");
                        }
                        stringBuffer.append("\"");
                        bl = true;
                    }
                } else {
                    if (bl) {
                        stringBuffer.append("\"");
                        bl = false;
                    }
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(",");
                    }
                }
                stringBuffer.append(string);
            }
            if (bl) {
                stringBuffer.append("\"");
            }
            return stringBuffer.toString();
        }
    }
}

