/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util;

import com.sybase.util.EventMonitor;
import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class EventQueuePumper
extends EventQueue {
    public void start() {
        Toolkit.getDefaultToolkit().getSystemEventQueue().push(this);
    }

    @Override
    protected void dispatchEvent(AWTEvent aWTEvent) {
        super.dispatchEvent(aWTEvent);
    }

    public void stop() {
        super.pop();
    }

    public static void pump(Condition condition) {
        Toolkit.getDefaultToolkit().getSystemEventQueue();
        if (EventQueue.isDispatchThread()) {
            try {
                EventQueue eventQueue;
                AWTEvent aWTEvent;
                while ((condition == null || condition.keepGoing()) && (aWTEvent = (eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue()).peekEvent()) != null) {
                    aWTEvent = eventQueue.getNextEvent();
                    if (eventQueue instanceof EventMonitor) {
                        ((EventMonitor)eventQueue).dispatchEvent(aWTEvent);
                        continue;
                    }
                    EventQueuePumper.rDispatchEvent(eventQueue, aWTEvent);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    static boolean pumpOneEvent() {
        boolean bl = false;
        EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        if (eventQueue.isDispatchThread()) {
            try {
                AWTEvent aWTEvent = eventQueue.getNextEvent();
                if (eventQueue instanceof EventMonitor) {
                    ((EventMonitor)eventQueue).dispatchEvent(aWTEvent);
                } else {
                    EventQueuePumper.rDispatchEvent(eventQueue, aWTEvent);
                }
                bl = true;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return bl;
    }

    private static void rDispatchEvent(EventQueue eventQueue, AWTEvent aWTEvent) {
        try {
            Method method = eventQueue.getClass().getDeclaredMethod("dispatchEvent", AWTEvent.class);
            method.setAccessible(true);
            method.invoke((Object)eventQueue, aWTEvent);
        }
        catch (InvocationTargetException invocationTargetException) {
            EventQueuePumper.callUncaughtExceptionHandler(invocationTargetException.getCause());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void callUncaughtExceptionHandler(Throwable throwable) {
        Thread thread;
        Thread.UncaughtExceptionHandler uncaughtExceptionHandler;
        boolean bl = false;
        String string = System.getProperty("sun.awt.exception.handler");
        if (string != null && string.length() > 0) {
            try {
                Class<?> clazz = Class.forName(string);
                Object obj = clazz.newInstance();
                Method method = clazz.getMethod("handle", Throwable.class);
                method.invoke(obj, throwable);
                bl = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!bl && (uncaughtExceptionHandler = (thread = Thread.currentThread()).getUncaughtExceptionHandler()) != null) {
            uncaughtExceptionHandler.uncaughtException(thread, throwable);
            bl = true;
        }
        if (!bl) {
            throwable.printStackTrace();
        }
    }

    public static interface Condition {
        public boolean keepGoing();
    }
}

