/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util;

import com.sybase.util.ClipboardManager;
import com.sybase.util.DialogUtils;
import com.sybase.util.EventMonitor;
import com.sybase.util.ExceptionHandlerClient;
import com.sybase.util.SybFileChooser;
import com.sybase.util.SybFileFilter;
import com.sybase.util.SybModalDialog;
import com.sybase.util.SybOptionPane;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;

@Deprecated
public class ExceptionHandler {
    @Deprecated
    static final String DEFAULT_FILENAME = "errors.txt";
    private static ExceptionHandlerClient _client = null;
    private static boolean _handlingException = false;

    @Deprecated
    public ExceptionHandler() {
    }

    @Deprecated
    public static void install() {
        System.setProperty("sun.awt.exception.handler", "com.sybase.util.ExceptionHandler");
    }

    @Deprecated
    public static void init(ExceptionHandlerClient exceptionHandlerClient) {
        if (_client == null) {
            _client = exceptionHandlerClient;
        }
    }

    @Deprecated
    public void handle(Throwable throwable) {
        if (!_handlingException) {
            _handlingException = true;
            ExceptionHandler.handleException(throwable);
            _handlingException = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static void handleException(Throwable throwable) {
        boolean bl = _client == null ? true : _client.useGUI();
        ExceptionHandler.showException(throwable);
        if (bl) {
            try {
                EventMonitor.pause();
                ExceptionHandler.showExceptionWithGUI(throwable);
            }
            catch (Throwable throwable2) {
            }
            finally {
                EventMonitor.resume();
            }
        }
        System.exit(-1);
    }

    @Deprecated
    public static void printBox(PrintStream printStream, String string, int n) {
        int n2;
        int n3 = string.length() + 4 + 4;
        int n4 = n > 0 ? (n - n3) / 2 : 0;
        StringBuffer stringBuffer = new StringBuffer(n3);
        for (n2 = 0; n2 < n4; ++n2) {
            stringBuffer.append(' ');
        }
        for (n2 = 0; n2 < n3; ++n2) {
            if (n2 == 0 || n2 == n3 - 1) {
                stringBuffer.append('+');
                continue;
            }
            stringBuffer.append('-');
        }
        StringBuffer stringBuffer2 = new StringBuffer(n3 + n4);
        for (n2 = 0; n2 < n4; ++n2) {
            stringBuffer2.append(' ');
        }
        stringBuffer2.append("|   " + string + "   |");
        printStream.println(stringBuffer.toString());
        printStream.println(stringBuffer2);
        printStream.println(stringBuffer.toString());
        printStream.println();
    }

    @Deprecated
    static void gatherInformation(PrintStream printStream, Throwable throwable) throws IOException, ExceptionIgnored {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8192);
        PrintStream printStream2 = new PrintStream(byteArrayOutputStream);
        throwable.printStackTrace(printStream2);
        printStream2.flush();
        printStream2.close();
        byteArrayOutputStream.flush();
        String string = byteArrayOutputStream.toString();
        if (throwable instanceof NullPointerException && string.indexOf("sybase.") == -1 && string.indexOf("ianywhere.") == -1) {
            throw new ExceptionIgnored();
        }
        ExceptionHandler.printBox(printStream, "Stack Trace", 80);
        printStream.println("Current thread: " + Thread.currentThread().getName());
        printStream.println(string);
        printStream.println();
        printStream.println();
        ExceptionHandler.printBox(printStream, "UI Trace", 80);
        EventMonitor.printEvents(printStream);
        printStream.println();
        printStream.println();
        if (_client != null) {
            try {
                _client.printApplicationInformation(printStream);
            }
            catch (Throwable throwable2) {
                printStream.println("\n*** A " + throwable2.getClass().getName() + " exception was caught while gathering application information");
                printStream.println("  " + throwable2.getLocalizedMessage());
            }
            printStream.println();
            printStream.println();
        }
        ExceptionHandler.printBox(printStream, "Classpath", 80);
        ExceptionHandler.printClasspath(printStream);
        printStream.println();
        printStream.println();
        ExceptionHandler.printBox(printStream, "Java VM", 80);
        printStream.println("Total memory: " + Runtime.getRuntime().totalMemory());
        printStream.println("Free memory: " + Runtime.getRuntime().freeMemory());
        ExceptionHandler.printProperties(printStream, System.getProperties());
        printStream.println();
        printStream.println();
        ExceptionHandler.printBox(printStream, "Look and Feel", 80);
        ExceptionHandler.printLAFInfo(printStream);
        printStream.println();
        printStream.println();
        ExceptionHandler.printBox(printStream, "Java Packages", 80);
        ExceptionHandler.printPackages(printStream);
        printStream.println();
        printStream.println();
    }

    static void printLAFInfo(PrintStream printStream) {
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        printStream.println("LAF name:" + lookAndFeel.getName());
        printStream.println("LAF description:" + lookAndFeel.getDescription());
        printStream.println("LAF isNative:" + lookAndFeel.isNativeLookAndFeel());
        printStream.println("LAF isSupported:" + lookAndFeel.isSupportedLookAndFeel());
        printStream.println("LAF ID:" + lookAndFeel.getID());
        printStream.println("LAF class:" + lookAndFeel.getClass().getName());
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        String[] stringArray = (String[])toolkit.getDesktopProperty("win.propNames");
        if (stringArray != null) {
            Arrays.sort(stringArray);
            printStream.println("Desktop Properties:");
            for (int i = 0; i < stringArray.length; ++i) {
                printStream.println("  " + stringArray[i] + "=" + toolkit.getDesktopProperty(stringArray[i]).toString());
            }
        } else {
            printStream.println("\nNo desktop properties.\n");
        }
    }

    private static void printClasspath(PrintStream printStream) {
        try {
            String string = System.getProperty("java.class.path");
            String string2 = System.getProperty("path.separator");
            StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
            while (stringTokenizer.hasMoreElements()) {
                File file = new File(stringTokenizer.nextToken());
                printStream.println(file.getCanonicalPath());
                if (file.exists()) {
                    printStream.println("    Timestamp=" + new Timestamp(file.lastModified()));
                    printStream.println("    Length=" + file.length());
                } else {
                    printStream.println(file + "**** File does not exist");
                }
                printStream.println();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void printProperties(PrintStream printStream, Properties properties) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            Object obj = enumeration.nextElement();
            arrayList.add(obj.toString());
        }
        Collections.sort(arrayList);
        printStream.println("System properties:");
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            String string = (String)arrayList.get(i);
            printStream.println("    " + string + "=" + properties.getProperty(string));
        }
    }

    @Deprecated
    static void printPackages(PrintStream printStream) {
        Package[] packageArray = Package.getPackages();
        Arrays.sort(packageArray, new Comparator<Package>(){

            @Override
            public int compare(Package package_, Package package_2) {
                return package_.getName().compareTo(package_2.getName());
            }
        });
        int n = packageArray.length;
        for (int i = 0; i < n; ++i) {
            printStream.println("Package: " + packageArray[i].getName());
            printStream.println("    Implementation title: " + packageArray[i].getImplementationTitle());
            printStream.println("    Implementation vendor: " + packageArray[i].getImplementationVendor());
            printStream.println("    Implementation version: " + packageArray[i].getImplementationVersion());
            printStream.println("    Specification title: " + packageArray[i].getSpecificationTitle());
            printStream.println("    Specification vendor: " + packageArray[i].getSpecificationVendor());
            printStream.println("    Specification version: " + packageArray[i].getSpecificationVersion());
            printStream.println("");
        }
    }

    @Deprecated
    static void showException(Throwable throwable) {
        File file;
        String string;
        String string2;
        int n;
        String string3 = null;
        if (_client != null) {
            string3 = _client.getDefaultFileName();
        }
        if (string3 == null) {
            string3 = DEFAULT_FILENAME;
        }
        if ((n = string3.lastIndexOf(".")) == -1) {
            string2 = string3;
            string = null;
        } else {
            string = string3.substring(n);
            string2 = string3.substring(0, n);
        }
        string3 = string2;
        if (string != null) {
            string3 = string3.concat(string);
        }
        int n2 = 2;
        while ((file = new File(string3)).exists()) {
            string3 = string2.concat("-");
            string3 = string3.concat(Integer.toString(n2));
            if (string != null) {
                string3 = string3.concat(string);
            }
            ++n2;
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string3);
            PrintStream printStream = new PrintStream(fileOutputStream);
            ExceptionHandler.gatherInformation(printStream, throwable);
            printStream.flush();
            fileOutputStream.flush();
            printStream.close();
            fileOutputStream.close();
            System.err.println("Error! This program has encountered an internal error.");
            System.err.println("Details have been logged to " + string3);
        }
        catch (IOException iOException) {
        }
        catch (ExceptionIgnored exceptionIgnored) {
            // empty catch block
        }
    }

    @Deprecated
    static void showExceptionWithGUI(Throwable throwable) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8192);
            PrintStream printStream = new PrintStream(byteArrayOutputStream);
            ExceptionHandler.gatherInformation(printStream, throwable);
            printStream.flush();
            byteArrayOutputStream.flush();
            printStream.close();
            byteArrayOutputStream.close();
            JFrame jFrame = _client != null ? _client.getParent() : null;
            ExceptionDialog.create(jFrame, _client, byteArrayOutputStream.toString());
        }
        catch (IOException iOException) {
        }
        catch (ExceptionIgnored exceptionIgnored) {
            // empty catch block
        }
    }

    static class ExceptionDialog
    extends SybModalDialog
    implements ActionListener {
        private JButton _ok;
        private JButton _save;
        private JButton _copyToClipboard;
        private JButton _exit;
        private JTextArea _textField;
        private String _defaultFileName;

        public static void create(JFrame jFrame, ExceptionHandlerClient exceptionHandlerClient, String string) {
            String string2 = null;
            if (exceptionHandlerClient != null) {
                string2 = exceptionHandlerClient.getDialogTitle();
            }
            if (string2 == null) {
                string2 = "Internal Error";
            }
            ExceptionDialog exceptionDialog = new ExceptionDialog(exceptionHandlerClient, jFrame, string2, string);
            exceptionDialog.setVisible(true);
        }

        private ExceptionDialog(ExceptionHandlerClient exceptionHandlerClient, JFrame jFrame, String string, String string2) {
            super((Frame)jFrame, string);
            String string3;
            if (exceptionHandlerClient != null) {
                this._defaultFileName = exceptionHandlerClient.getDefaultFileName();
            }
            if (this._defaultFileName == null) {
                this._defaultFileName = ExceptionHandler.DEFAULT_FILENAME;
            }
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            JLabel jLabel = new JLabel("This program encountered an internal error. Details are in the text field below.");
            jPanel.add(jLabel);
            jPanel.add(Box.createRigidArea(new Dimension(0, 5)));
            if (exceptionHandlerClient != null && (string3 = exceptionHandlerClient.getContactInformation()) != null) {
                jLabel = new JLabel(string3);
                Font font = jLabel.getFont();
                jLabel.setFont(new Font(font.getFontName(), font.getStyle() | 1, font.getSize()));
                jLabel.setForeground(Color.red.darker());
                jPanel.add(jLabel);
                jPanel.add(Box.createRigidArea(new Dimension(0, 5)));
            }
            this._textField = new JTextArea(string2, 15, 80);
            this._textField.setEditable(false);
            this._textField.setFont(new Font("Monospaced", 0, 12));
            this._textField.setCaretPosition(0);
            JScrollPane jScrollPane = new JScrollPane(this._textField);
            jScrollPane.setAlignmentX(0.0f);
            jPanel.add(jScrollPane);
            jPanel.add(Box.createRigidArea(new Dimension(0, 5)));
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BoxLayout(jPanel2, 0));
            jPanel2.add(Box.createHorizontalGlue());
            this._ok = new JButton("OK");
            this._ok.setMnemonic('O');
            this._ok.addActionListener(this);
            jPanel2.add(this._ok);
            this._save = new JButton("Save To File...");
            this._save.setMnemonic('S');
            this._save.addActionListener(this);
            jPanel2.add(Box.createRigidArea(new Dimension(5, 0)));
            jPanel2.add(this._save);
            jPanel2.setAlignmentX(0.0f);
            this._copyToClipboard = new JButton("Copy To Clipboard");
            this._copyToClipboard.setMnemonic('C');
            this._copyToClipboard.addActionListener(this);
            jPanel2.add(Box.createRigidArea(new Dimension(5, 0)));
            jPanel2.add(this._copyToClipboard);
            this._exit = new JButton("Exit");
            this._exit.setMnemonic('E');
            this._exit.addActionListener(this);
            jPanel2.add(Box.createRigidArea(new Dimension(5, 0)));
            jPanel2.add(this._exit);
            DialogUtils.makeComponentsSameWidth(this._ok, this._save, this._copyToClipboard, this._exit);
            jPanel2.setAlignmentX(0.0f);
            jPanel.add(jPanel2);
            Container container = this.getContentPane();
            container.add(jPanel);
            this.pack();
            this.setLocationRelativeTo(jFrame);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this._ok) {
                this.setVisible(false);
            } else if (object == this._save) {
                this.handleSave();
            } else if (object == this._copyToClipboard) {
                ClipboardManager.setContents(Toolkit.getDefaultToolkit().getSystemClipboard(), new StringSelection(this._textField.getText().replaceAll("\r\n", "\n")), null);
            } else if (object == this._exit) {
                System.exit(-1);
            }
        }

        private void handleSave() {
            String string = this.getFileName();
            if (string != null) {
                try {
                    FileOutputStream fileOutputStream = new FileOutputStream(string);
                    OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fileOutputStream);
                    outputStreamWriter.write(this._textField.getText());
                    outputStreamWriter.write("\n");
                    outputStreamWriter.flush();
                    outputStreamWriter.close();
                }
                catch (IOException iOException) {
                    String string2 = "Could not save file.\n" + iOException.getMessage();
                    SybOptionPane.showMessageDialog(this, string2, this.getTitle(), 0);
                }
            }
        }

        private String getFileName() {
            String string = null;
            SybFileChooser sybFileChooser = new SybFileChooser(18);
            sybFileChooser.setFilters(new SybFileFilter[]{new SybFileFilter("txt", "Text Files")}, 0);
            sybFileChooser.setDefaultExtension("txt");
            File file = new File(this._defaultFileName);
            if (sybFileChooser.showDialog(this, null, file)) {
                File file2 = sybFileChooser.getSelectedFile();
                string = file2.getAbsolutePath();
            }
            return string;
        }
    }

    @Deprecated
    static class ExceptionIgnored
    extends Throwable {
        ExceptionIgnored() {
        }
    }
}

