/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util;

import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JToolTip;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.JTextComponent;

public class FontHelper
implements ActionListener,
DocumentListener,
PropertyChangeListener {
    private static Font[] _fontList = null;
    private static int _unicodeFontCount = 0;
    private Font _defaultFont;
    private JTextComponent _textComponent = null;

    public FontHelper(JLabel jLabel) {
        this._defaultFont = jLabel.getFont();
        jLabel.addPropertyChangeListener(this);
        String string = jLabel.getText();
        if (string != null && string.length() != 0) {
            FontHelper.setFontForString(jLabel, this._defaultFont, string);
        }
    }

    public FontHelper(JToolTip jToolTip) {
        this._defaultFont = jToolTip.getFont();
        jToolTip.addPropertyChangeListener(this);
        String string = jToolTip.getTipText();
        if (string != null && string.length() != 0) {
            FontHelper.setFontForString(jToolTip, this._defaultFont, string);
        }
    }

    public FontHelper(JTextComponent jTextComponent) {
        this.init(jTextComponent);
    }

    private void init(JTextComponent jTextComponent) {
        this._textComponent = jTextComponent;
        this._defaultFont = jTextComponent.getFont();
        jTextComponent.getDocument().addDocumentListener(this);
        String string = jTextComponent.getText();
        if (string != null && string.length() != 0) {
            FontHelper.setFontForString(jTextComponent, this._defaultFont, string);
        }
    }

    public FontHelper(JComboBox jComboBox) {
        this.setComboBoxFont(jComboBox);
        jComboBox.addActionListener(this);
        Component component = jComboBox.getEditor().getEditorComponent();
        if (component instanceof JTextComponent) {
            this.init((JTextComponent)component);
        }
    }

    public static ListCellRenderer getListCellRenderer() {
        return new FHListCellRenderer();
    }

    public static TableCellRenderer getTableCellRenderer() {
        return new FHTableCellRenderer();
    }

    private void setComboBoxFont(JComboBox jComboBox) {
        String string;
        Object object;
        if (!jComboBox.isEditable() && (object = jComboBox.getSelectedItem()) != null && (string = object.toString()) != null && !string.isEmpty()) {
            if (this._defaultFont == null) {
                this._defaultFont = jComboBox.getFont();
            }
            FontHelper.setFontForString(jComboBox, this._defaultFont, string);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof JComboBox) {
            this.setComboBoxFont((JComboBox)object);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateTextComponentFont();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateTextComponentFont();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
    }

    private void updateTextComponentFont() {
        String string = this._textComponent.getText();
        if (!string.isEmpty()) {
            FontHelper.setFontForString(this._textComponent, this._defaultFont, string);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string != null) {
            Object object = propertyChangeEvent.getSource();
            String string2 = null;
            if (string.equals("text")) {
                if (object instanceof JLabel) {
                    string2 = ((JLabel)object).getText();
                }
            } else if (string.equals("tiptext") && object instanceof JToolTip) {
                string2 = ((JToolTip)object).getTipText();
            }
            if (string2 != null) {
                FontHelper.setFontForString((Component)object, this._defaultFont, string2);
            }
        }
    }

    public static void setFontForString(Component component, Font font, String string) {
        int n;
        Font font2 = null;
        if (font.canDisplayUpTo(string) == -1) {
            component.setFont(font);
            return;
        }
        if (_fontList == null) {
            String string2;
            _fontList = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
            int n2 = 0;
            for (n = 0; n < _fontList.length; ++n) {
                string2 = _fontList[n].getName();
                if (string2.indexOf("Unicode") == -1) continue;
                ++n2;
                FontHelper.moveFontToStartOfList(n);
            }
            _unicodeFontCount = n2;
            ArrayList<Font> arrayList = new ArrayList<Font>(_fontList.length);
            for (n = 0; n < _fontList.length; ++n) {
                string2 = _fontList[n].getName();
                if (string2.startsWith("Dialog") || string2.startsWith("Monospaced.") || string2.startsWith("SansSerif.") || string2.startsWith("Serif.")) continue;
                arrayList.add(_fontList[n]);
            }
            _fontList = new Font[arrayList.size()];
            arrayList.toArray(_fontList);
        }
        int n3 = -1;
        int n4 = 0;
        for (n = 0; n < _fontList.length; ++n) {
            int n5 = _fontList[n].canDisplayUpTo(string);
            if (n5 == -1) {
                font2 = _fontList[n];
                FontHelper.moveFontToStartOfList(n);
                break;
            }
            if (n5 <= n4) continue;
            n3 = n;
            n4 = n5;
        }
        if (font2 == null && n3 >= 0) {
            font2 = _fontList[n3];
            FontHelper.moveFontToStartOfList(n3);
        }
        if (font2 != null) {
            int n6 = font.getStyle();
            int n7 = font.getSize();
            font2 = font2.deriveFont(n6, n7);
            Font font3 = component.getFont();
            if (!font3.equals(font2)) {
                component.setFont(font2);
            }
        }
    }

    private static void moveFontToStartOfList(int n) {
        if (n > _unicodeFontCount) {
            Font font = _fontList[n];
            System.arraycopy(_fontList, _unicodeFontCount, _fontList, _unicodeFontCount + 1, n - _unicodeFontCount);
            FontHelper._fontList[FontHelper._unicodeFontCount] = font;
        }
    }

    static class FHTableCellRenderer
    extends DefaultTableCellRenderer {
        private Font _defaultFont = null;

        FHTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            String string;
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (object != null && (string = object.toString()).length() > 0) {
                if (this._defaultFont == null) {
                    this._defaultFont = component.getFont();
                }
                if (this._defaultFont.canDisplayUpTo(string) == -1) {
                    component.setFont(this._defaultFont);
                } else {
                    FontHelper.setFontForString(component, this._defaultFont, string);
                }
            }
            return component;
        }
    }

    static class FHListCellRenderer
    extends DefaultListCellRenderer {
        private Font _defaultFont = null;

        FHListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            String string;
            Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (object != null && (string = object.toString()).length() > 0) {
                if (this._defaultFont == null) {
                    this._defaultFont = component.getFont();
                }
                if (this._defaultFont.canDisplayUpTo(string) == -1) {
                    component.setFont(this._defaultFont);
                } else {
                    FontHelper.setFontForString(component, this._defaultFont, string);
                }
            }
            return component;
        }
    }
}

