/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util;

import com.sybase.util.Platform;
import com.sybase.util.win32.Registry;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import java.net.URL;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class HTMLWindow
extends JFrame
implements HyperlinkListener {
    private static final int UNKNOWN = 0;
    private static final int YES = 1;
    private static final int NO = 2;
    private static int _canUseNative = 0;
    private static String _cmdLine;

    public static void open(String string, String string2, Image image, int n, int n2) {
        if (HTMLWindow.isBrowserSupported()) {
            HTMLWindow.openNativeBrowser(string, string2, image, n, n2);
        } else {
            HTMLWindow.openJavaBrowser(string, string2, image, n, n2);
        }
    }

    public static boolean isBrowserSupported() {
        File file;
        if (_canUseNative == 1) {
            return true;
        }
        if (_canUseNative == 2) {
            return false;
        }
        _canUseNative = 2;
        if (Platform.isWindows()) {
            try {
                Class.forName("com.sybase.util.win32.Registry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                return false;
            }
            if (!Registry.isInstalled()) {
                return false;
            }
            String string = Registry.getValue(2, ".htm", null);
            if (!(string != null && string.length() != 0 || (string = Registry.getValue(2, ".html", null)) != null && string.length() != 0)) {
                return false;
            }
            _cmdLine = Registry.getValue(2, string + "\\shell\\open\\command", null);
            if (_cmdLine == null || _cmdLine.length() == 0) {
                return false;
            }
            _canUseNative = 1;
            return true;
        }
        if (Platform.isMacOS()) {
            _cmdLine = "open";
            _canUseNative = 1;
            return true;
        }
        String[] stringArray = new String[]{"firefox", "mozilla", "safari", "opera", "netscape", "epiphany", "galeon", "kfmclient", "konqueror"};
        String string = System.getenv("PATH");
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
            while (stringTokenizer.hasMoreElements()) {
                String string2 = stringTokenizer.nextElement().toString();
                for (int i = 0; i < stringArray.length; ++i) {
                    file = new File(string2, stringArray[i]);
                    if (!file.exists() || !file.isFile() || !file.canExecute()) continue;
                    _cmdLine = file.getAbsolutePath();
                    _canUseNative = 1;
                    return true;
                }
            }
        }
        if ((file = new File("/usr/sfw/bin/mozilla")).exists() && file.isFile() && file.canExecute()) {
            _cmdLine = file.getAbsolutePath();
            _canUseNative = 1;
            return true;
        }
        return false;
    }

    private static void openNativeBrowser(String string, String string2, Image image, int n, int n2) {
        int n3;
        String string3 = null;
        string3 = Platform.isWindows() ? ((n3 = _cmdLine.indexOf("%1")) != -1 ? _cmdLine.substring(0, n3) + string + _cmdLine.substring(n3 + 2) : _cmdLine + " " + string) : _cmdLine + " " + string;
        try {
            Runtime.getRuntime().exec(string3);
        }
        catch (Exception exception) {
            HTMLWindow.openJavaBrowser(string, string2, image, n, n2);
        }
    }

    private static void openJavaBrowser(String string, String string2, Image image, int n, int n2) {
        new HTMLWindow(string, string2, image, n, n2);
    }

    private HTMLWindow(String string, String string2, Image image, int n, int n2) {
        JEditorPane jEditorPane = new JEditorPane();
        jEditorPane.setEditable(false);
        jEditorPane.addHyperlinkListener(this);
        if (Locale.getDefault().getLanguage().equals("ja")) {
            jEditorPane.setContentType("text/html; charset=SJIS");
        } else {
            jEditorPane.setContentType("text/html");
        }
        JScrollPane jScrollPane = new JScrollPane(jEditorPane);
        Container container = this.getContentPane();
        container.add(jScrollPane);
        if (image != null) {
            this.setIconImage(image);
        }
        this.setTitle(string2);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize(n, n2);
        this.setLocation((dimension.width - n) / 2, (dimension.height - n2) / 2);
        this.setVisible(true);
        jEditorPane.paintImmediately(0, 0, jEditorPane.getWidth(), jEditorPane.getHeight());
        this.repaint();
        SwingUtilities.invokeLater(new PageFetcher(string, jEditorPane));
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            HTMLWindow.setPage((JEditorPane)hyperlinkEvent.getSource(), null, hyperlinkEvent.getURL());
        }
    }

    private static void setPage(JEditorPane jEditorPane, String string, URL uRL) {
        Cursor cursor = jEditorPane.getCursor();
        jEditorPane.setCursor(Cursor.getPredefinedCursor(3));
        try {
            if (uRL != null) {
                jEditorPane.setPage(uRL);
            } else {
                jEditorPane.setPage(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        jEditorPane.setCursor(cursor);
    }

    static class PageFetcher
    implements Runnable {
        private String _url;
        private JEditorPane _editor;

        PageFetcher(String string, JEditorPane jEditorPane) {
            this._url = string;
            this._editor = jEditorPane;
        }

        @Override
        public void run() {
            try {
                HTMLWindow.setPage(this._editor, this._url, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this._url = null;
            this._editor = null;
        }
    }
}

