/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util;

import com.sybase.util.LineSplitter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.EventListenerList;

public class HypertextButton
extends JPanel
implements MouseListener,
FocusListener {
    private UnderlineLabel _iconLabel = new UnderlineLabel();
    private ArrayList<UnderlineLabel> _uLabels = new ArrayList();
    private EventListenerList _listenerList = new EventListenerList();
    private AbstractAction _clickAction = null;
    private Boolean _drawUnderline = Boolean.FALSE;
    private boolean _focusable = true;
    private Border _focusBorder = new CompoundBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1), new CompoundBorder(UIManager.getBorder("List.focusCellHighlightBorder"), BorderFactory.createEmptyBorder(1, 1, 1, 1)));
    private Border _noFocusBorder = BorderFactory.createEmptyBorder(3, 3, 3, 3);
    private String _text = null;
    private static Insets EMPTY_INSETS = new Insets(0, 0, 0, 0);
    private static String ACTION_COMMAND = "click";

    public HypertextButton(String string) {
        this(string, null);
    }

    public HypertextButton(String string, String string2) {
        this(string, string2, null);
    }

    public HypertextButton(String string, String string2, Icon icon) {
        this(string, string2, icon, 11, true);
    }

    public HypertextButton(String string, String string2, Icon icon, int n) {
        this(string, string2, icon, n, true);
    }

    public HypertextButton(String string, String string2, Icon icon, int n, boolean bl) {
        this(string, string2, icon, n, bl, null);
    }

    public HypertextButton(String string, String string2, Icon icon, int n, boolean bl, Color color) {
        this(string, string2, icon, n, bl, color, 0);
    }

    public HypertextButton(String string, String string2, Icon icon, int n, boolean bl, Color color, int n2) {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = null;
        LineSplitter lineSplitter = null;
        UnderlineLabel underlineLabel = null;
        Insets insets = null;
        Object var14_13 = null;
        this._text = string;
        this.getAccessibleContext().setAccessibleName(string);
        this.getAccessibleContext().setAccessibleDescription(string);
        this.setOpaque(false);
        this.setLayout(gridBagLayout);
        if (n2 > 0) {
            lineSplitter = new LineSplitter(this._text, n2, this._iconLabel);
            this._iconLabel.setText(lineSplitter.nextLine());
        } else {
            this._iconLabel.setText(this._text);
        }
        this._iconLabel.setIcon(icon);
        this._iconLabel.setHorizontalTextPosition(n);
        int n3 = 0;
        gridBagConstraints = new GridBagConstraints(0, n3, 0, 1, 1.0, 0.0, 18, 0, EMPTY_INSETS, 0, 0);
        this.add((Component)this._iconLabel, gridBagConstraints);
        if (n2 > 0) {
            insets = lineSplitter.hasMoreLines() && this._iconLabel.getIcon() != null && this._iconLabel.getHorizontalTextPosition() == 11 ? new Insets(0, this._iconLabel.getIcon().getIconWidth() + this._iconLabel.getIconTextGap(), 0, 0) : EMPTY_INSETS;
            while (lineSplitter.hasMoreLines()) {
                gridBagConstraints = new GridBagConstraints(0, ++n3, 0, 1, 1.0, 0.0, 18, 0, insets, 0, 0);
                underlineLabel = new UnderlineLabel(lineSplitter.nextLine());
                this._uLabels.add(underlineLabel);
                this.add((Component)underlineLabel, gridBagConstraints);
            }
        }
        gridBagConstraints = new GridBagConstraints(0, 500, 0, 0, 1.0, 1.0, 18, 0, EMPTY_INSETS, 0, 0);
        this.add(Box.createGlue(), gridBagConstraints);
        if (!bl) {
            this._drawUnderline = null;
        }
        this._iconLabel.setToolTipText(string2);
        for (int i = 0; i < this._uLabels.size(); ++i) {
            this._uLabels.get(i).setToolTipText(string2);
        }
        if (color != null) {
            this.setForeground(color);
        }
        this.setBorder(this._noFocusBorder);
        this.addListeners(true);
    }

    public void setIconTextGap(int n) {
        this._iconLabel.setIconTextGap(n);
        this.repaint();
    }

    public int getIconTextGap() {
        return this._iconLabel.getIconTextGap();
    }

    @Override
    public void setFont(Font font) {
        if (this._iconLabel != null) {
            this._iconLabel.setFont(font);
            for (int i = 0; i < this._uLabels.size(); ++i) {
                this._uLabels.get(i).setFont(font);
            }
        } else {
            super.setFont(font);
        }
    }

    @Override
    public Font getFont() {
        if (this._iconLabel != null) {
            return this._iconLabel.getFont();
        }
        return super.getFont();
    }

    public void setIcon(Icon icon) {
        this._iconLabel.setIcon(icon);
    }

    public Icon getIcon() {
        return this._iconLabel.getIcon();
    }

    @Override
    public void setForeground(Color color) {
        if (this._iconLabel != null) {
            this._iconLabel.setForeground(color);
            for (int i = 0; i < this._uLabels.size(); ++i) {
                this._uLabels.get(i).setForeground(color);
            }
        }
        super.setForeground(color);
    }

    public String getText() {
        return this._text;
    }

    public boolean isUnderlined() {
        return this._drawUnderline != null;
    }

    public void addActionListener(ActionListener actionListener) {
        this._listenerList.add(ActionListener.class, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this._listenerList.remove(ActionListener.class, actionListener);
    }

    public void doClick() {
        this.fireActionPerformed(new ActionEvent(this, 0, null));
    }

    public void releaseResources() {
        this.addListeners(false);
        this._text = null;
        this._iconLabel = null;
        this._uLabels.clear();
        this._listenerList = null;
        this._clickAction = null;
        this._focusBorder = null;
        this._noFocusBorder = null;
    }

    private void addListeners(boolean bl) {
        if (bl) {
            this.addMouseListener(this);
            this.addFocusListener(this);
            this._iconLabel.addMouseListener(this);
            for (int i = 0; i < this._uLabels.size(); ++i) {
                this._uLabels.get(i).addMouseListener(this);
            }
            this.getInputMap().put(KeyStroke.getKeyStroke(10, 0), ACTION_COMMAND);
            this.getInputMap().put(KeyStroke.getKeyStroke(32, 0), ACTION_COMMAND);
            this._clickAction = new ClickAction();
            this.getActionMap().put(ACTION_COMMAND, this._clickAction);
        } else {
            this.removeMouseListener(this);
            this.removeFocusListener(this);
            this._iconLabel.removeMouseListener(this);
            for (int i = 0; i < this._uLabels.size(); ++i) {
                this._uLabels.get(i).removeMouseListener(this);
            }
            this.getInputMap().remove(KeyStroke.getKeyStroke(10, 0));
            this.getInputMap().remove(KeyStroke.getKeyStroke(32, 0));
            this.getActionMap().remove(ACTION_COMMAND);
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        if (this.isEnabled() != bl) {
            this.addListeners(bl);
            super.setEnabled(bl);
        }
    }

    @Override
    public boolean isFocusable() {
        return this._focusable;
    }

    @Override
    public void setFocusable(boolean bl) {
        this._focusable = bl;
    }

    protected void fireActionPerformed(ActionEvent actionEvent) {
        ActionEvent actionEvent2 = null;
        Object[] objectArray = this._listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ActionListener.class) continue;
            if (actionEvent2 == null) {
                String string = actionEvent.getActionCommand();
                if (string == null) {
                    string = ACTION_COMMAND;
                }
                actionEvent2 = new ActionEvent(this, 1001, string, actionEvent.getWhen(), actionEvent.getModifiers());
            }
            ((ActionListener)objectArray[i + 1]).actionPerformed(actionEvent2);
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        if (this._drawUnderline != null) {
            this._drawUnderline = Boolean.TRUE;
            this.repaint();
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (this._drawUnderline != null) {
            this._drawUnderline = Boolean.FALSE;
            this.repaint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.getX() >= 0 && mouseEvent.getX() <= this.getSize().width && mouseEvent.getY() >= 0 && mouseEvent.getY() <= this.getSize().height) {
            this.requestFocus();
            this.fireActionPerformed(new ActionEvent(mouseEvent.getSource(), mouseEvent.getID(), ACTION_COMMAND));
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        this.setBorder(this._focusBorder);
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.setBorder(this._noFocusBorder);
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleHyperTextButton();
        }
        return this.accessibleContext;
    }

    protected class AccessibleHyperTextButton
    extends JComponent.AccessibleJComponent {
        protected AccessibleHyperTextButton() {
            super(HypertextButton.this);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PUSH_BUTTON;
        }

        @Override
        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (HypertextButton.this.isFocusOwner()) {
                accessibleStateSet.add(AccessibleState.FOCUSED);
            }
            return accessibleStateSet;
        }
    }

    class UnderlineLabel
    extends JLabel {
        UnderlineLabel() {
        }

        UnderlineLabel(String string) {
            super(string);
        }

        @Override
        public void setText(String string) {
            super.setText(string);
        }

        @Override
        public void paint(Graphics graphics) {
            Dimension dimension = this.getPreferredSize();
            super.paint(graphics);
            if (this.isEnabled() && HypertextButton.this._drawUnderline != null && HypertextButton.this._drawUnderline.booleanValue()) {
                if (this.getIcon() == null) {
                    graphics.drawLine(0, (this.getSize().height - dimension.height) / 2 + dimension.height - 1, dimension.width, (this.getSize().height - dimension.height) / 2 + dimension.height - 1);
                } else if (this.getHorizontalTextPosition() == 11) {
                    graphics.drawLine(this.getIcon().getIconWidth() + this.getIconTextGap(), (this.getSize().height - dimension.height) / 2 + dimension.height - 2, dimension.width, (this.getSize().height - dimension.height) / 2 + dimension.height - 2);
                } else if (this.getHorizontalTextPosition() == 10) {
                    graphics.drawLine(0, (this.getSize().height - dimension.height) / 2 + dimension.height - 2, dimension.width - (this.getIcon().getIconWidth() + this.getIconTextGap()), (this.getSize().height - dimension.height) / 2 + dimension.height - 2);
                }
            }
        }
    }

    class ClickAction
    extends AbstractAction {
        ClickAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            HypertextButton.this.fireActionPerformed(new ActionEvent(actionEvent.getSource(), actionEvent.getID(), actionEvent.getActionCommand()));
        }
    }
}

