/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util;

import com.sybase.util.Dbg;
import com.sybase.util.ImageUtils;
import com.sybase.util.Platform;
import com.sybase.util.win32.Win32Util;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.lang.reflect.Field;
import java.util.Hashtable;
import java.util.MissingResourceException;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class ImageLoader {
    public static final int TYPE_TOOLBAR = 1000;
    public static final int TYPE_PUSH_BUTTON = 1001;
    public static final int TYPE_PROPERTY_SHEET = 1002;
    public static final int TYPE_MESSAGE_DIALOG = 1003;
    public static final int TYPE_MENU = 1004;
    public static final int TYPE_WIZARD_PAGE_TITLE = 1005;
    public static final int TYPE_MISC = 1006;
    public static final int TYPE_TASK_LIST = 1001;
    public static final String BACK = "back";
    public static final String BLANK = "blank";
    public static final String CLOSE = "close";
    public static final String EXPAND = "expand";
    public static final String COLLAPSE = "collapse";
    public static final String CONNECT = "connect";
    public static final String CONNECTION_PROFILE = "connprofile";
    public static final String COPY = "copy";
    public static final String CUT = "cut";
    public static final String DELETE = "delete";
    public static final String DISCONNECT = "disconnect";
    public static final String ERROR = "error";
    public static final String FIND = "find";
    public static final String FIND_IN_FILES = "findinfiles";
    public static final String FIND_IN_TEXT = "findintext";
    public static final String FORWARD = "forward";
    public static final String INFORM = "inform";
    public static final String NEW = "new";
    public static final String OPEN = "open";
    public static final String PASTE = "paste";
    public static final String PRINT = "print";
    public static final String PRINT_ANIMATION1 = "printanimation1_";
    public static final String PRINT_ANIMATION2 = "printanimation2_";
    public static final String PROPERTIES = "properties";
    public static final String QUESTION = "question";
    public static final String REDO = "redo";
    public static final String REFRESH_FOLDER = "refreshfolder";
    public static final String SAVE = "save";
    public static final String SAVE_ALL = "saveall";
    public static final String UNDO = "undo";
    public static final String UP = "up";
    public static final String WARN = "warn";
    public static final String WINDOWS = "windows";
    public static final String VISTASHIELD = "vistashield";
    public static final String ODBCADMIN = "ODBCADMIN";
    static Hashtable<String, ImageIcon> cachedImageIcons = new Hashtable();

    public static ImageIcon getImageIcon(Class clazz, String string, int n) {
        ImageIcon imageIcon = null;
        Icon icon = null;
        BufferedImage bufferedImage = null;
        Graphics2D graphics2D = null;
        Image image = null;
        imageIcon = cachedImageIcons.get(clazz.getName() + string + String.valueOf(n));
        if (imageIcon != null) {
            return imageIcon;
        }
        if (string.equals(VISTASHIELD) || string.equals(ODBCADMIN)) {
            if (Win32Util.isInstalled()) {
                switch (n) {
                    case 1002: 
                    case 1003: {
                        if (!string.equals(VISTASHIELD) || !Platform.isVista()) break;
                        imageIcon = Win32Util.getVistaShieldIcon(32);
                        break;
                    }
                    case 1000: 
                    case 1001: 
                    case 1004: {
                        if (string.equals(VISTASHIELD) && Platform.isVista()) {
                            imageIcon = Win32Util.getVistaShieldIcon(16);
                            break;
                        }
                        if (!string.equals(ODBCADMIN)) break;
                        icon = Win32Util.getODBCAdministratorIcon();
                        bufferedImage = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
                        graphics2D = bufferedImage.createGraphics();
                        icon.paintIcon(null, graphics2D, 0, 0);
                        graphics2D.dispose();
                        imageIcon = new ImageIcon(bufferedImage);
                        break;
                    }
                }
            }
            if (imageIcon != null) {
                cachedImageIcons.put(clazz.getName() + string + String.valueOf(n), imageIcon);
            }
            return imageIcon;
        }
        image = ImageLoader.getImage(clazz, string, n);
        if (image != null) {
            imageIcon = new ImageIcon(image);
            if (imageIcon.getIconHeight() <= 32 && imageIcon.getIconWidth() <= 32) {
                cachedImageIcons.put(clazz.getName() + string + String.valueOf(n), imageIcon);
            }
            return imageIcon;
        }
        return null;
    }

    public static Image getImage(Class clazz, String string, int n) {
        Image image = null;
        if (clazz == null) {
            return null;
        }
        if (string.equals(INFORM) || string.equals(QUESTION) || string.equals(WARN) || string.equals(ERROR)) {
            return ImageLoader.getUIManagerImage(string, n);
        }
        image = ImageLoader.loadImage(clazz, string, n);
        if (image == null) {
            while ((clazz = clazz.getSuperclass()) != Object.class && clazz != null) {
                image = ImageLoader.loadImage(clazz, string, n);
                if (image == null) continue;
                return image;
            }
        }
        return image;
    }

    private static Image getUIManagerImage(String string, int n) {
        Icon icon = null;
        BufferedImage bufferedImage = null;
        Graphics2D graphics2D = null;
        Image image = null;
        if (string.equals(INFORM)) {
            icon = UIManager.getIcon("OptionPane.informationIcon");
        } else if (string.equals(QUESTION)) {
            icon = UIManager.getIcon("OptionPane.questionIcon");
        } else if (string.equals(WARN)) {
            icon = UIManager.getIcon("OptionPane.warningIcon");
        } else if (string.equals(ERROR)) {
            icon = UIManager.getIcon("OptionPane.errorIcon");
        }
        if (icon != null) {
            bufferedImage = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
            graphics2D = bufferedImage.createGraphics();
            icon.paintIcon(new JPanel(), graphics2D, 0, 0);
            graphics2D.dispose();
            switch (n) {
                case 1002: 
                case 1003: {
                    image = bufferedImage;
                    break;
                }
                case 1001: {
                    image = bufferedImage.getScaledInstance(16, 16, 4);
                    break;
                }
                default: {
                    return null;
                }
            }
            if (image == null) {
                // empty if block
            }
        }
        return image;
    }

    private static Image loadImage(Class clazz, String string, int n) {
        int n2;
        Image image = null;
        String string2 = string;
        if (Platform.isMacOS()) {
            switch (n) {
                case 1000: 
                case 1002: 
                case 1003: {
                    string2 = string + "32.png";
                    image = ImageUtils.loadImage(clazz, string2);
                    if (image != null) break;
                    string2 = string + "32.gif";
                    image = ImageUtils.loadImage(clazz, string2);
                    break;
                }
                case 1005: {
                    string2 = string + "64.png";
                    image = ImageUtils.loadImage(clazz, string2);
                    break;
                }
                case 1001: {
                    string2 = string + "16.png";
                    image = ImageUtils.loadImage(clazz, string2);
                    if (image != null) break;
                    string2 = string + "16.gif";
                    image = ImageUtils.loadImage(clazz, string2);
                    break;
                }
                case 1006: {
                    n2 = string.indexOf(".");
                    string2 = n2 == -1 ? string + ".png" : string;
                    image = ImageUtils.loadImage(clazz, string2);
                    if (image != null || n2 != -1) break;
                    string2 = string + ".gif";
                    image = ImageUtils.loadImage(clazz, string2);
                    break;
                }
                case 1004: {
                    return null;
                }
                default: {
                    return null;
                }
            }
            if (image == null) {
                // empty if block
            }
        }
        if (image == null) {
            switch (n) {
                case 1000: 
                case 1001: 
                case 1004: {
                    string2 = string + "16.png";
                    image = ImageUtils.loadImage(clazz, string2);
                    if (image == null) {
                        string2 = string + "16.gif";
                        image = ImageUtils.loadImage(clazz, string2);
                    }
                    if (image == null) {
                        image = ImageUtils.loadImage(clazz, string + "16.png");
                    }
                    if (image != null) break;
                    image = ImageUtils.loadImage(clazz, string + "16.gif");
                    break;
                }
                case 1002: 
                case 1003: {
                    image = ImageUtils.loadImage(clazz, string + "32.png");
                    if (image != null) break;
                    image = ImageUtils.loadImage(clazz, string + "32.gif");
                    break;
                }
                case 1005: {
                    image = ImageUtils.loadImage(clazz, string + "64.png");
                    break;
                }
                case 1006: {
                    n2 = string.indexOf(".");
                    string2 = n2 == -1 ? string + ".png" : string;
                    image = ImageUtils.loadImage(clazz, string2);
                    if (image != null || n2 != -1) break;
                    image = ImageUtils.loadImage(clazz, string + ".gif");
                    break;
                }
                default: {
                    image = null;
                }
            }
        }
        if (image == null) {
            // empty if block
        }
        return image;
    }

    public static void validateImages(Class clazz) {
        StringBuffer stringBuffer = new StringBuffer(256);
        do {
            ImageLoader.validateImages2(clazz, stringBuffer);
        } while ((clazz = clazz.getSuperclass()) != Object.class && clazz != null);
        if (stringBuffer.length() > 0) {
            stringBuffer.insert(0, "The following image files could not be loaded:\n");
            Dbg.printlnEx(stringBuffer.toString());
            throw new MissingResourceException(stringBuffer.toString(), clazz.getName(), "");
        }
    }

    private static void validateImages2(Class clazz, StringBuffer stringBuffer) {
        try {
            int n = 25;
            Field[] fieldArray = clazz.getDeclaredFields();
            for (int i = 0; i < fieldArray.length; ++i) {
                Object object;
                int n2 = fieldArray[i].getModifiers();
                if (n2 != n || fieldArray[i].getType() != String.class || (object = fieldArray[i].get(null)).toString().equals(INFORM) || object.toString().equals(QUESTION) || object.toString().equals(WARN) || object.toString().equals(ERROR) || object.toString().equals(VISTASHIELD) || object.toString().equals(ODBCADMIN)) continue;
                Image image = ImageLoader.getImage(clazz, object.toString(), 1000);
                if (image == null) {
                    image = ImageLoader.getImage(clazz, object.toString(), 1002);
                }
                if (image == null) {
                    image = ImageLoader.getImage(clazz, object.toString(), 1005);
                }
                if (image == null) {
                    image = ImageLoader.getImage(clazz, object.toString(), 1006);
                }
                if (image != null) continue;
                if (stringBuffer.length() > 0) {
                    stringBuffer.append("\n");
                }
                stringBuffer.append("  Could not load image ");
                stringBuffer.append(clazz.getName());
                stringBuffer.append(".");
                stringBuffer.append(fieldArray[i].getName());
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    private static boolean dbgEnabled() {
        return false;
    }
}

