/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import javax.swing.JPanel;

class ImagePanel
extends JPanel
implements ImageObserver {
    private BufferedImage _image;
    private int _imageWidth;
    private int _imageHeight;
    private Insets _sizingMargins;

    ImagePanel(BufferedImage bufferedImage, Insets insets) {
        this._image = bufferedImage;
        this._imageWidth = this._image.getWidth(this);
        this._imageHeight = this._image.getHeight(this);
        if (insets != null && insets.top == 0 && insets.bottom == 0 && insets.left == 0 && insets.right == 0) {
            insets = null;
        }
        this._sizingMargins = insets;
        this.setOpaque(false);
    }

    @Override
    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        this._imageWidth = n4;
        this._imageHeight = n5;
        return false;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        if (this._imageWidth > 0) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            int n = this.getWidth();
            int n2 = this.getHeight();
            if (this._sizingMargins == null) {
                double d = (double)n / (double)this._imageWidth;
                double d2 = (double)n2 / (double)this._imageHeight;
                AffineTransform affineTransform = AffineTransform.getScaleInstance(d, d2);
                graphics2D.drawImage(this._image, affineTransform, null);
            } else {
                if (this._sizingMargins.top > 0 && this._sizingMargins.left > 0) {
                    graphics.drawImage(this._image, 0, 0, this._sizingMargins.left, this._sizingMargins.top, 0, 0, this._sizingMargins.left, this._sizingMargins.top, null);
                }
                if (this._sizingMargins.top > 0 && this._sizingMargins.right > 0) {
                    graphics.drawImage(this._image, n - this._sizingMargins.right, 0, n, this._sizingMargins.top, this._imageWidth - this._sizingMargins.right, 0, this._imageWidth, this._sizingMargins.top, null);
                }
                if (this._sizingMargins.bottom > 0 && this._sizingMargins.left > 0) {
                    graphics.drawImage(this._image, 0, n2 - this._sizingMargins.bottom, this._sizingMargins.left, n2, 0, this._imageHeight - this._sizingMargins.bottom, this._sizingMargins.left, this._imageHeight, null);
                }
                if (this._sizingMargins.bottom > 0 && this._sizingMargins.right > 0) {
                    graphics.drawImage(this._image, n - this._sizingMargins.right, n2 - this._sizingMargins.bottom, n, n2, this._imageWidth - this._sizingMargins.right, this._imageHeight - this._sizingMargins.bottom, this._imageWidth, this._imageHeight, null);
                }
                if (this._sizingMargins.top > 0) {
                    graphics.drawImage(this._image, this._sizingMargins.left, 0, n - this._sizingMargins.right, this._sizingMargins.top, this._sizingMargins.left, 0, this._imageWidth - this._sizingMargins.right, this._sizingMargins.top, null);
                }
                if (this._sizingMargins.bottom > 0) {
                    graphics.drawImage(this._image, this._sizingMargins.left, n2 - this._sizingMargins.bottom, n - this._sizingMargins.right, n2, this._sizingMargins.left, this._imageHeight - this._sizingMargins.bottom, this._imageWidth - this._sizingMargins.right, this._imageHeight, null);
                }
                if (this._sizingMargins.left > 0) {
                    graphics.drawImage(this._image, 0, this._sizingMargins.top, this._sizingMargins.left, n2 - this._sizingMargins.bottom, 0, this._sizingMargins.top, this._sizingMargins.left, this._imageHeight - this._sizingMargins.bottom, null);
                }
                if (this._sizingMargins.right > 0) {
                    graphics.drawImage(this._image, n - this._sizingMargins.right, this._sizingMargins.top, n, n2 - this._sizingMargins.bottom, this._imageWidth - this._sizingMargins.right, this._sizingMargins.top, this._imageWidth, this._imageHeight - this._sizingMargins.bottom, null);
                }
                graphics.drawImage(this._image, this._sizingMargins.left, this._sizingMargins.top, n - this._sizingMargins.right, n2 - this._sizingMargins.bottom, this._sizingMargins.left, this._sizingMargins.top, this._imageWidth - this._sizingMargins.right, this._imageHeight - this._sizingMargins.bottom, null);
            }
        }
    }
}

