/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util;

import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.text.Position;
import javax.swing.tree.TreePath;

public class KeySelectionHelper
implements KeyListener {
    private static long TIME_WINDOW = 750L;
    private String _prefix = "";
    private String _typedString = "";
    private long _lastTime = 0L;
    private JComponent _component;
    private AbstractComponent _ac;

    public KeySelectionHelper(JComponent jComponent) {
        this._component = jComponent;
        this._component.addKeyListener(this);
        if (jComponent instanceof JTable) {
            this._ac = new TableComponent((JTable)jComponent);
        } else if (jComponent instanceof JTree) {
            this._ac = new TreeComponent((JTree)jComponent);
        } else if (jComponent instanceof JList) {
            this._ac = new ListComponent((JList)jComponent);
        } else {
            throw new IllegalArgumentException(jComponent.getClass().getName() + " components are not supported.");
        }
    }

    public void destroy() {
        this._component.removeKeyListener(this);
        this._component = null;
        this._ac.destroy();
        this._ac = null;
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        int n;
        int n2 = this._ac.getRowCount();
        if (n2 == 0 || keyEvent.isAltDown() || keyEvent.isControlDown() || keyEvent.isMetaDown() || this.isNavigationKey(keyEvent) || !this._component.isEnabled() || this._ac.ignoreKeyEvent(keyEvent)) {
            return;
        }
        boolean bl = true;
        char c = keyEvent.getKeyChar();
        long l = keyEvent.getWhen();
        int n3 = this._ac.getSelectedRow();
        if (l - this._lastTime < TIME_WINDOW) {
            this._typedString = this._typedString + c;
            if (this._prefix.length() == 1 && c == this._prefix.charAt(0)) {
                ++n3;
            } else {
                this._prefix = this._typedString;
            }
        } else {
            ++n3;
            this._prefix = this._typedString = "" + c;
        }
        this._lastTime = l;
        if (n3 < 0 || n3 >= n2) {
            bl = false;
            n3 = 0;
        }
        if ((n = this._ac.getNextMatch(this._prefix, n3, Position.Bias.Forward)) >= 0) {
            this._ac.setSelectedRow(n);
        } else if (bl && (n = this._ac.getNextMatch(this._prefix, 0, Position.Bias.Forward)) >= 0) {
            this._ac.setSelectedRow(n);
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (this.isNavigationKey(keyEvent)) {
            this._prefix = "";
            this._typedString = "";
            this._lastTime = 0L;
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    private boolean isNavigationKey(KeyEvent keyEvent) {
        KeyStroke keyStroke;
        InputMap inputMap = this._component.getInputMap(1);
        return inputMap != null && inputMap.get(keyStroke = KeyStroke.getKeyStrokeForEvent(keyEvent)) != null;
    }

    static class ListComponent
    implements AbstractComponent {
        private JList _list;

        ListComponent(JList jList) {
            this._list = jList;
        }

        @Override
        public void destroy() {
            this._list = null;
        }

        @Override
        public int getRowCount() {
            return this._list.getModel().getSize();
        }

        @Override
        public int getSelectedRow() {
            return this._list.getLeadSelectionIndex();
        }

        @Override
        public void setSelectedRow(int n) {
            this._list.setSelectedIndex(n);
            this._list.ensureIndexIsVisible(n);
        }

        @Override
        public int getNextMatch(String string, int n, Position.Bias bias) {
            return this._list.getNextMatch(string, n, bias);
        }

        @Override
        public boolean ignoreKeyEvent(KeyEvent keyEvent) {
            return false;
        }
    }

    static class TreeComponent
    implements AbstractComponent {
        private JTree _tree;

        TreeComponent(JTree jTree) {
            this._tree = jTree;
        }

        @Override
        public void destroy() {
            this._tree = null;
        }

        @Override
        public int getRowCount() {
            return this._tree.getRowCount();
        }

        @Override
        public int getSelectedRow() {
            return this._tree.getLeadSelectionRow();
        }

        @Override
        public void setSelectedRow(int n) {
            this._tree.setSelectionRow(n);
            Rectangle rectangle = this._tree.getRowBounds(n);
            this._tree.scrollRectToVisible(rectangle);
        }

        @Override
        public int getNextMatch(String string, int n, Position.Bias bias) {
            int n2 = -1;
            TreePath treePath = this._tree.getNextMatch(string, n, bias);
            if (treePath != null) {
                n2 = this._tree.getRowForPath(treePath);
            }
            return n2;
        }

        @Override
        public boolean ignoreKeyEvent(KeyEvent keyEvent) {
            return false;
        }
    }

    static class TableComponent
    implements AbstractComponent {
        private JTable _table;

        TableComponent(JTable jTable) {
            this._table = jTable;
        }

        @Override
        public void destroy() {
            this._table = null;
        }

        @Override
        public int getRowCount() {
            return this._table.getRowCount();
        }

        @Override
        public int getSelectedRow() {
            return this._table.getSelectedRow();
        }

        @Override
        public void setSelectedRow(int n) {
            this._table.setRowSelectionInterval(n, n);
            this._table.scrollRectToVisible(this._table.getCellRect(n, 0, true));
        }

        @Override
        public int getNextMatch(String string, int n, Position.Bias bias) {
            int n2 = -1;
            int n3 = this._table.getRowCount();
            int n4 = n;
            while (n4 >= 0 && n4 < n3) {
                String string2;
                Object object = this._table.getValueAt(n4, 0);
                if (object != null && (string2 = object.toString()).length() != 0 && string2.regionMatches(true, 0, string, 0, string.length())) {
                    n2 = n4;
                    break;
                }
                if (bias == Position.Bias.Forward) {
                    ++n4;
                    continue;
                }
                --n4;
            }
            return n2;
        }

        @Override
        public boolean ignoreKeyEvent(KeyEvent keyEvent) {
            boolean bl = false;
            if (this._table.isEditing()) {
                bl = true;
            } else if (this._table.getSurrendersFocusOnKeystroke()) {
                int n = this._table.getSelectedRow();
                int n2 = this._table.getSelectedColumn();
                if (n != -1 && n2 != -1 && this._table.isCellEditable(n, n2)) {
                    bl = true;
                }
            }
            return bl;
        }
    }

    static interface AbstractComponent {
        public void destroy();

        public int getRowCount();

        public int getSelectedRow();

        public int getNextMatch(String var1, int var2, Position.Bias var3);

        public void setSelectedRow(int var1);

        public boolean ignoreKeyEvent(KeyEvent var1);
    }
}

