/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util;

import com.sybase.util.SybLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;

public class LabelBar
extends JPanel {
    private Color _activeFGColor;
    private Color _activeBGColor;
    private Color _inactiveFGColor;
    private Color _inactiveBGColor;
    private SybLabel _label;

    public LabelBar() {
        this.init(null);
    }

    public LabelBar(String string) {
        this.init(string);
    }

    private void init(String string) {
        int n;
        UIDefaults uIDefaults = UIManager.getDefaults();
        this._activeFGColor = uIDefaults.getColor("InternalFrame.activeTitleForeground");
        this._activeBGColor = uIDefaults.getColor("InternalFrame.activeTitleBackground");
        this._inactiveFGColor = uIDefaults.getColor("InternalFrame.inactiveTitleForeground");
        this._inactiveBGColor = uIDefaults.getColor("InternalFrame.inactiveTitleBackground");
        this.setLayout(new BoxLayout(this, 0));
        this._label = string == null ? new SybLabel() : new SybLabel(string);
        Font font = uIDefaults.getFont("InternalFrame.titleFont");
        if (font == null) {
            font = this._label.getFont();
            font = font.deriveFont(font.getStyle(), font.getSize() + 4);
        }
        this._label.setFont(font);
        int n2 = this._label.getPreferredSize().height;
        if (n2 != 0) {
            int n3 = uIDefaults.getInt("InternalFrame.titlePaneHeight");
            if (n3 > 0) {
                n = n3 - n2;
                if (n > 1) {
                    n /= 2;
                }
            } else {
                n = 2;
            }
        } else {
            n = 2;
        }
        this.setBorder(BorderFactory.createEmptyBorder(n, 5, n, 5));
        this._label.setAlignmentX(0.0f);
        this.setAlignmentX(0.0f);
        this.add(this._label);
        this.add(Box.createHorizontalGlue());
        this.setActive(true);
    }

    public void setText(String string) {
        this._label.setText(string);
    }

    @Override
    public boolean isFocusable() {
        return false;
    }

    @Override
    public void requestFocus() {
    }

    public void setActive(boolean bl) {
        if (bl) {
            this._setForeground(this._activeFGColor);
            this.setBackground(this._activeBGColor);
        } else {
            this._setForeground(this._inactiveFGColor);
            this.setBackground(this._inactiveBGColor);
        }
    }

    public boolean isActive() {
        return this.getBackground() == this._activeBGColor;
    }

    private void _setForeground(Color color) {
        Component component;
        super.setForeground(color);
        if (this.getComponentCount() > 0 && (component = this.getComponent(0)) != null) {
            component.setForeground(color);
        }
    }
}

