/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util;

import com.sybase.util.Loader;
import com.sybase.util.Platform;
import com.sybase.util.win32.Win32Util;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;

public class Launcher
implements Runnable {
    public static final String FAST_LOADER_PROPERTY_NAME = "com.sybase.util.FastLoader";
    static final char LAUNCH = 'L';
    static final char SHUTDOWN = 'S';
    static final char PING = 'P';
    static final char QUIT = 'Q';
    static final int CLIENT_TCPIP_TIMEOUT = 100;
    private ServerSocket _socket = null;
    private String _mainClassName;
    private String _preloadClassListFilename;
    private Thread _thread = null;
    private static ArrayList<Launcher> _launcherList = new ArrayList();
    private static String _pidString = null;
    private ArrayList<Class> _classList = new ArrayList();
    private ClassWarmer _classWarmer = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Launcher() {
        ArrayList<Launcher> arrayList = _launcherList;
        synchronized (arrayList) {
            _launcherList.add(this);
        }
        _pidString = Win32Util.isInstalled() ? Long.toString(Win32Util.getCurrentProcessID()) : "";
    }

    private boolean create(String string, int n, int n2, String string2, String string3) {
        boolean bl;
        this._mainClassName = string2;
        this._preloadClassListFilename = string3;
        this._thread = new Thread((Runnable)this, string + " loader");
        try {
            InetAddress inetAddress = InetAddress.getByAddress(new byte[]{127, 0, 0, 1});
            this._socket = new ServerSocket(n, 1, inetAddress);
            if (n2 != 0) {
                this._socket.setSoTimeout(n2 * 60 * 1000);
            }
            this._thread.start();
            bl = true;
        }
        catch (IOException iOException) {
            bl = false;
        }
        return bl;
    }

    private static void call(String string, String[] stringArray) {
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Class<?> clazz = Class.forName(string, true, classLoader);
            Class[] classArray = new Class[]{String[].class};
            Method method = clazz.getMethod("main", classArray);
            method.invoke(clazz, new Object[]{stringArray});
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static boolean isRunning(String string) {
        boolean bl = true;
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Class<?> clazz = Class.forName(string, true, classLoader);
            Method method = clazz.getMethod("isRunning", null);
            Object object = method.invoke(clazz, new Object[0]);
            if (object instanceof Boolean) {
                bl = (Boolean)object;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isFastLauncherRunningInProcess(int n) {
        boolean bl = false;
        ArrayList<Launcher> arrayList = _launcherList;
        synchronized (arrayList) {
            for (int i = 0; i < _launcherList.size(); ++i) {
                ServerSocket serverSocket = Launcher._launcherList.get((int)i)._socket;
                if (serverSocket == null || serverSocket.getLocalPort() != n) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    static boolean ping(int n) {
        long l = Launcher.getServerProcessID(n);
        return l != -1L;
    }

    public static boolean startLauncher(String string, int n, int n2, String string2, String string3) {
        Launcher launcher;
        boolean bl = Launcher.ping(n);
        if (!bl && (bl = (launcher = new Launcher()).create(string, n, n2, string2, string3))) {
            System.setProperty(FAST_LOADER_PROPERTY_NAME, "1");
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopLauncher(int n) {
        Launcher launcher = null;
        ArrayList<Launcher> arrayList = _launcherList;
        synchronized (arrayList) {
            for (int i = 0; i < _launcherList.size(); ++i) {
                launcher = _launcherList.get(i);
                if (launcher._socket.getLocalPort() == n) break;
                launcher = null;
            }
        }
        if (launcher != null) {
            Loader.terminate(n, 'Q');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getServerProcessID(int n) {
        long l = -1L;
        Socket socket = null;
        try {
            socket = new Socket();
            socket.connect(new InetSocketAddress(InetAddress.getLocalHost(), n), 100);
            l = Launcher.getServerProcessID(socket);
        }
        catch (SocketTimeoutException socketTimeoutException) {
        }
        catch (IOException iOException) {
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
            }
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getServerProcessID(Socket socket) {
        long l = -1L;
        OutputStream outputStream = null;
        BufferedReader bufferedReader = null;
        try {
            outputStream = socket.getOutputStream();
            bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            outputStream.write(80);
            outputStream.flush();
            String string = bufferedReader.readLine();
            if (string != null && string.length() > 0) {
                l = Long.parseLong(string);
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroy(char c) {
        int n;
        if (this._socket == null) {
            throw new IllegalStateException();
        }
        ArrayList<Launcher> arrayList = _launcherList;
        synchronized (arrayList) {
            int n2 = _launcherList.indexOf(this);
            if (n2 >= 0) {
                _launcherList.remove(n2);
            }
            n = _launcherList.size();
        }
        this._thread = null;
        if (this._socket != null) {
            try {
                this._socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this._socket = null;
        }
        if (n == 0 && c == 'S') {
            System.exit(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        InetAddress inetAddress;
        Socket socket = null;
        char c = 'S';
        this.preloadClasses(this._preloadClassListFilename);
        this._preloadClassListFilename = null;
        this._classWarmer = new ClassWarmer();
        this._classWarmer.start();
        try {
            inetAddress = InetAddress.getByAddress(new byte[]{127, 0, 0, 1});
        }
        catch (UnknownHostException unknownHostException) {
            inetAddress = null;
        }
        while (true) {
            try {
                socket = this._socket.accept();
                InetAddress inetAddress2 = socket.getInetAddress();
                if (!inetAddress2.equals(inetAddress) || (c = this.talkToClient(socket)) != 'S' && c != 81) continue;
            }
            catch (InterruptedIOException interruptedIOException) {
                if (this.isApplicationRunning()) continue;
            }
            catch (IOException iOException) {
                if (socket == null) break;
                try {
                    socket.close();
                }
                catch (IOException iOException2) {
                }
                finally {
                    socket = null;
                }
            }
            finally {
                if (socket == null) continue;
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
                continue;
                finally {
                    socket = null;
                }
                continue;
            }
            break;
        }
        if (this._classWarmer != null) {
            this._classWarmer.quit();
        }
        this.destroy(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private char talkToClient(Socket socket) {
        char c;
        block40: {
            boolean bl = false;
            c = '\u0000';
            BufferedReader bufferedReader = null;
            BufferedWriter bufferedWriter = null;
            try {
                bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                bufferedWriter = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream()));
                while (true) {
                    if ((c = (char)bufferedReader.read()) == '\uffff') {
                        break block40;
                    }
                    if (c == 'L') {
                        this.handleLaunch(bufferedReader);
                        continue;
                    }
                    if (c != 80) break;
                    bufferedWriter.write(_pidString);
                    bufferedWriter.newLine();
                    bufferedWriter.write(Platform.getSessionID());
                    bufferedWriter.newLine();
                    bufferedWriter.flush();
                }
                if (c != 'S' && c == 'Q') {
                    // empty if block
                }
            }
            catch (IOException iOException) {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException2) {
                    }
                    finally {
                        bufferedReader = null;
                    }
                }
                if (bufferedWriter == null) break block40;
                try {
                    bufferedWriter.close();
                }
                catch (IOException iOException3) {
                }
                finally {
                    bufferedWriter = null;
                }
            }
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {
                    }
                    finally {
                        bufferedReader = null;
                    }
                }
                if (bufferedWriter != null) {
                    try {
                        bufferedWriter.close();
                    }
                    catch (IOException iOException) {
                    }
                    finally {
                        bufferedWriter = null;
                    }
                }
            }
        }
        return c;
    }

    private String readString(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        byte[] byArray = new byte[n];
        inputStream.read(byArray);
        String string = new String(byArray);
        return string;
    }

    private void handleLaunch(BufferedReader bufferedReader) throws IOException {
        String string = bufferedReader.readLine();
        if (string != null && string.length() > 0) {
            System.setProperty("user.dir", string);
            if (Win32Util.isInstalled()) {
                Win32Util.setCurrentWorkingDirectory(string);
            }
        }
        String string2 = bufferedReader.readLine();
        int n = Integer.parseInt(string2);
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = bufferedReader.readLine();
        }
        Launcher.call(this._mainClassName, stringArray);
    }

    private boolean isApplicationRunning() {
        boolean bl = this._mainClassName != null && Launcher.isRunning(this._mainClassName);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void preloadClasses(String string) {
        String string2;
        BufferedReader bufferedReader = null;
        int n = 0;
        ArrayList<String> arrayList = new ArrayList<String>();
        InputStream inputStream = null;
        try {
            String string3;
            inputStream = Launcher.class.getClassLoader().getResourceAsStream(string);
            if (inputStream == null) {
                return;
            }
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            while ((string3 = bufferedReader.readLine()) != null) {
                ++n;
                if (string3.trim().length() == 0) continue;
                int n2 = string3.indexOf("[Loaded ");
                if (n2 != -1) {
                    int n3 = string3.indexOf(32, n2 += "[Loaded ".length());
                    if (n3 == -1) {
                        n3 = string3.indexOf(93, n2);
                    }
                    if (n3 == -1) continue;
                    string2 = string3.substring(n2, n3);
                    arrayList.add(string2);
                    continue;
                }
                if (string3.indexOf(32) != -1) continue;
                arrayList.add(string3);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        int n4 = arrayList.size();
        if (n4 > 0) {
            long l = System.currentTimeMillis();
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            for (int i = 0; i < n4; ++i) {
                string2 = (String)arrayList.get(i);
                try {
                    this._classList.add(Class.forName(string2, true, classLoader));
                    continue;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    continue;
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    // empty catch block
                }
            }
            long l2 = System.currentTimeMillis();
        }
    }

    protected static boolean dbgEnabled() {
        return false;
    }

    class ClassWarmer
    extends Thread {
        private boolean _quit;

        ClassWarmer() {
            super("Class warmer");
            this._quit = false;
            this.setPriority(4);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void quit() {
            this._quit = true;
            ClassWarmer classWarmer = this;
            synchronized (classWarmer) {
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int n = Launcher.this._classList.size();
            int n2 = 0;
            do {
                this.touchClass((Class)Launcher.this._classList.get(n2));
                if (++n2 == n) {
                    n2 = 0;
                }
                if (this._quit) break;
                ClassWarmer classWarmer = this;
                synchronized (classWarmer) {
                    try {
                        this.wait(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        break;
                    }
                }
            } while (!this._quit);
        }

        private void touchClass(Class clazz) {
            try {
                clazz.getName();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

