/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util;

import java.awt.Component;
import java.awt.FontMetrics;
import java.util.ArrayList;
import java.util.Locale;

public class LineSplitter {
    private static final char[] JA_ZH_START_OF_QUOTE_CHARS = new char[]{'\u2018', '\u201c', '\uff08', '\u3014', '\uff3b', '\uff5b', '\u3008', '\u300a', '\u300c', '\u300e', '\u3010'};
    private static final char[] JA_ZH_END_OF_QUOTE_CHARS = new char[]{'\u2019', '\u201d', '\uff09', '\u3015', '\uff3c', '\uff5c', '\u3009', '\u300b', '\u300d', '\u300f', '\u3011'};
    private static final char[] JA_ZH_END_OF_SENTENCE_CHARS = new char[]{'\u3001', '\u3002', '\uff0c', '\u30fb', '\uff1a', '\uff1b', '\uff1f', '\uff01'};
    private static final char[] ENGLISH_START_OF_QUOTE_CHARS = new char[]{'{', '(', '[', '<', '\"', '\''};
    private static final char[] ENGLISH_END_OF_QUOTE_CHARS = new char[]{'}', ')', ']', '>', '\"', '\''};
    private static final char[] ENGLISH_END_OF_SENTENCE_CHARS = new char[]{';', ':', '.', ',', '!', '?'};
    protected ArrayList<String> _list;
    protected int _index;

    public LineSplitter(String string, int n) {
        this._list = new ArrayList();
        this.burstString(string, n);
        this._index = 0;
    }

    public LineSplitter(String string, int n, Component component) {
        if (component == null) {
            throw new IllegalArgumentException("Component cannot be null");
        }
        FontMetrics fontMetrics = component.getFontMetrics(component.getFont());
        this._list = new ArrayList();
        this.burstString(string, n, fontMetrics);
        this._index = 0;
    }

    public boolean hasMoreLines() {
        return this._index < this._list.size();
    }

    public String nextLine() {
        String string;
        if (this._index < this._list.size()) {
            string = this._list.get(this._index);
            ++this._index;
        } else {
            string = null;
        }
        return string;
    }

    protected void burstString(String string, int n) {
        if (string == null) {
            return;
        }
        int n2 = string.length();
        if (n2 == 0) {
            return;
        }
        if (n2 > n) {
            String string2 = Locale.getDefault().getLanguage();
            if (!string2.equals(Locale.JAPAN.getLanguage()) && !string2.equals(Locale.CHINA.getLanguage())) {
                int n3 = string.lastIndexOf(32, n);
                if (n3 <= 0) {
                    n3 = string.indexOf(32, n);
                }
                if (n3 > 0 && n3 < n2) {
                    this.burstString(string.substring(0, n3), n);
                    this.burstString(string.substring(n3 + 1), n);
                    return;
                }
            } else {
                int n4 = n;
                char c = string.charAt(n4 - 1);
                char c2 = string.charAt(n4);
                boolean bl = false;
                while (!bl) {
                    if (this.isOpenChar(c) || this.isCloseChar(c2) || this.isEnglishChar(c) && this.isEnglishChar(c2)) {
                        if (--n4 == 0) {
                            this._list.add(string.trim());
                            return;
                        }
                        c = string.charAt(n4 - 1);
                        c2 = string.charAt(n4);
                        continue;
                    }
                    bl = true;
                }
                this.burstString(string.substring(0, n4), n4);
                this.burstString(string.substring(n4), n);
                return;
            }
        }
        this._list.add(string.trim());
    }

    protected void burstString(String string, int n, FontMetrics fontMetrics) {
        String string2;
        int n2 = 0;
        int n3 = -1;
        int n4 = 0;
        if (string == null) {
            return;
        }
        int n5 = string.length();
        if (n5 == 0) {
            return;
        }
        String string3 = Locale.getDefault().getLanguage();
        boolean bl = string3.equals(Locale.JAPAN.getLanguage()) || string3.equals(Locale.CHINA.getLanguage());
        for (int i = 0; i < n5; ++i) {
            char c = string.charAt(i);
            int n6 = fontMetrics.charWidth(c);
            if (n6 + n2 > n && n3 != -1) {
                string2 = string.substring(n4, n3);
                this._list.add(string2);
                n4 = n3;
                n3 = -1;
                n2 = fontMetrics.charsWidth(string.toCharArray(), n4, i - n4 + 1);
                continue;
            }
            n2 += n6;
            if (bl) {
                if (i >= n5 - 1) continue;
                char c2 = string.charAt(i + 1);
                if (!(this.isOpenChar(c) || this.isCloseChar(c2) || this.isEnglishChar(c) || this.isEnglishChar(c2))) {
                    n3 = i;
                    continue;
                }
                if (c != '\n') continue;
                string2 = string.substring(n4, i);
                this._list.add(string2);
                n4 = i + 1;
                n3 = -1;
                n2 = 0;
                continue;
            }
            if (c == '\n') {
                string2 = string.substring(n4, i);
                this._list.add(string2);
                n4 = i + 1;
                n3 = -1;
                n2 = 0;
                continue;
            }
            if (c != ' ') continue;
            n3 = i;
        }
        if (n2 > 0) {
            string2 = string.substring(n4);
            this._list.add(string2);
        }
    }

    private boolean isOpenChar(char c) {
        int n;
        for (n = 0; n < JA_ZH_START_OF_QUOTE_CHARS.length; ++n) {
            if (c != JA_ZH_START_OF_QUOTE_CHARS[n]) continue;
            return true;
        }
        for (n = 0; n < ENGLISH_START_OF_QUOTE_CHARS.length; ++n) {
            if (c != ENGLISH_START_OF_QUOTE_CHARS[n]) continue;
            return true;
        }
        return false;
    }

    private boolean isCloseChar(char c) {
        int n;
        for (n = 0; n < JA_ZH_END_OF_QUOTE_CHARS.length; ++n) {
            if (c != JA_ZH_END_OF_QUOTE_CHARS[n]) continue;
            return true;
        }
        for (n = 0; n < ENGLISH_END_OF_QUOTE_CHARS.length; ++n) {
            if (c != ENGLISH_END_OF_QUOTE_CHARS[n]) continue;
            return true;
        }
        for (n = 0; n < JA_ZH_END_OF_SENTENCE_CHARS.length; ++n) {
            if (c != JA_ZH_END_OF_SENTENCE_CHARS[n]) continue;
            return true;
        }
        for (n = 0; n < ENGLISH_END_OF_SENTENCE_CHARS.length; ++n) {
            if (c != ENGLISH_END_OF_SENTENCE_CHARS[n]) continue;
            return true;
        }
        return false;
    }

    private boolean isEnglishChar(char c) {
        return c > '/' && c < ':' || c > '@' && c < '[' || c > '`' && c < '{';
    }
}

